/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpoint;
import org.apache.activemq.artemis.api.core.JGroupsPropertiesBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimpleJNDIClientTest
extends ActiveMQTestBase {
    private final String groupAddress = SimpleJNDIClientTest.getUDPDiscoveryAddress();
    private final int groupPort = SimpleJNDIClientTest.getUDPDiscoveryPort();
    private ActiveMQServer liveService;
    private TransportConfiguration liveTC;

    @Test
    public void testMultipleConnectionFactories() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.VmConnectionFactory", "vm://0");
        props.put("connectionFactory.TCPConnectionFactory", "tcp://localhost:61616");
        props.put("connectionFactory.UDPConnectionFactory", "udp://" + SimpleJNDIClientTest.getUDPDiscoveryAddress() + ":" + SimpleJNDIClientTest.getUDPDiscoveryPort());
        props.put("connectionFactory.JGroupsConnectionFactory", "jgroups://mychannelid?file=test-jgroups-file_ping.xml");
        InitialContext ctx = new InitialContext(props);
        ctx.lookup("VmConnectionFactory");
        ctx.lookup("TCPConnectionFactory");
        ctx.lookup("UDPConnectionFactory");
        ctx.lookup("JGroupsConnectionFactory");
    }

    @Test
    public void testVMCF0() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://0");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        connectionFactory.createConnection().close();
    }

    @Test
    public void testEmptyConnectionFactoryString() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://0");
        props.put("java.naming.provider.url", "");
        new InitialContext(props);
    }

    @Test
    public void testConnectionFactoryStringWithInvalidParameter() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "tcp://localhost:61616?foo=too");
        AssertionLoggerHandler.startCapture();
        try {
            new InitialContext(props);
            SimpleJNDIClientTest.assertTrue((String)"Expected to find AMQ212078", (boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ212078"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    @Test
    public void testVMCF1() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://1");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        connectionFactory.createConnection().close();
    }

    @Test
    public void testXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "vm://0?type=XA_CF");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assert.assertEquals((long)JMSFactoryType.XA_CF.intValue(), (long)connectionFactory.getFactoryType());
    }

    @Test
    public void testQueueCF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "vm://0?type=QUEUE_CF");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assert.assertEquals((long)JMSFactoryType.QUEUE_CF.intValue(), (long)connectionFactory.getFactoryType());
    }

    @Test
    public void testQueueXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "vm://0?type=QUEUE_XA_CF");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assert.assertEquals((long)JMSFactoryType.QUEUE_XA_CF.intValue(), (long)connectionFactory.getFactoryType());
    }

    @Test
    public void testTopicCF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "vm://0?type=TOPIC_CF");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assert.assertEquals((long)JMSFactoryType.TOPIC_CF.intValue(), (long)connectionFactory.getFactoryType());
    }

    @Test
    public void testTopicXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "vm://0?type=TOPIC_XA_CF");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assert.assertEquals((long)JMSFactoryType.TOPIC_XA_CF.intValue(), (long)connectionFactory.getFactoryType());
    }

    @Test
    public void testRemoteCFWithTCP() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "tcp://127.0.0.1:61616");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("myConnectionFactory");
        connectionFactory.createConnection().close();
    }

    @Test
    public void testRemoteCFWithTCPandHA() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "tcp://127.0.0.1:61616?ha=true");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assert.assertEquals((Object)true, (Object)cf.isHA());
    }

    @Test
    public void testRemoteCFWithJGroups() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "jgroups://mychannelid?file=test-jgroups-file_ping.xml");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        connectionFactory.getDiscoveryGroupConfiguration().getBroadcastEndpointFactory().createBroadcastEndpoint().close(false);
    }

    @Test
    public void testRemoteCFWithJgroupsWithTransportConfigFile() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", ActiveMQInitialContextFactory.class.getCanonicalName());
        props.put("connectionFactory.myConnectionFactory", "jgroups://testChannelName?file=test-jgroups-file_ping.xml&refreshTimeout=5000&discoveryInitialWaitTimeout=6000");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        DiscoveryGroupConfiguration discoveryGroupConfiguration = cf.getDiscoveryGroupConfiguration();
        Assert.assertEquals((long)5000L, (long)discoveryGroupConfiguration.getRefreshTimeout());
        Assert.assertEquals((long)6000L, (long)discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout());
        BroadcastEndpoint broadcastEndpoint = cf.getDiscoveryGroupConfiguration().getBroadcastEndpointFactory().createBroadcastEndpoint();
        Assert.assertTrue((boolean)(broadcastEndpoint instanceof JGroupsFileBroadcastEndpoint));
        broadcastEndpoint.close(false);
    }

    @Test
    public void testRemoteCFWithJgroupsWithTransportConfigProps() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", ActiveMQInitialContextFactory.class.getCanonicalName());
        props.put("connectionFactory.ConnectionFactory", "jgroups://testChannelName?properties=param=value&refreshTimeout=5000&discoveryInitialWaitTimeout=6000");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)ctx.lookup("ConnectionFactory");
        DiscoveryGroupConfiguration discoveryGroupConfiguration = cf.getDiscoveryGroupConfiguration();
        Assert.assertEquals((long)5000L, (long)discoveryGroupConfiguration.getRefreshTimeout());
        Assert.assertEquals((long)6000L, (long)discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout());
        BroadcastEndpointFactory broadcastEndpointFactory = cf.getDiscoveryGroupConfiguration().getBroadcastEndpointFactory();
        Assert.assertTrue((boolean)(broadcastEndpointFactory instanceof JGroupsPropertiesBroadcastEndpointFactory));
        JGroupsPropertiesBroadcastEndpointFactory endpointFactory = (JGroupsPropertiesBroadcastEndpointFactory)broadcastEndpointFactory;
        Assert.assertEquals((Object)endpointFactory.getProperties(), (Object)"param=value");
        Assert.assertEquals((Object)endpointFactory.getChannelName(), (Object)"testChannelName");
    }

    @Test
    public void testRemoteCFWithJgroupsWithTransportConfigNullProps() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", ActiveMQInitialContextFactory.class.getCanonicalName());
        props.put("connectionFactory.ConnectionFactory", "jgroups://testChannelName?refreshTimeout=5000&discoveryInitialWaitTimeout=6000");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)ctx.lookup("ConnectionFactory");
        DiscoveryGroupConfiguration discoveryGroupConfiguration = cf.getDiscoveryGroupConfiguration();
        Assert.assertEquals((long)5000L, (long)discoveryGroupConfiguration.getRefreshTimeout());
        Assert.assertEquals((long)6000L, (long)discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout());
        BroadcastEndpointFactory broadcastEndpointFactory = cf.getDiscoveryGroupConfiguration().getBroadcastEndpointFactory();
        Assert.assertTrue((boolean)(broadcastEndpointFactory instanceof JGroupsPropertiesBroadcastEndpointFactory));
        JGroupsPropertiesBroadcastEndpointFactory endpointFactory = (JGroupsPropertiesBroadcastEndpointFactory)broadcastEndpointFactory;
        Assert.assertEquals((Object)endpointFactory.getProperties(), null);
        Assert.assertEquals((Object)endpointFactory.getChannelName(), (Object)"testChannelName");
    }

    @Test
    public void testRemoteCFWithUDP() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "udp://" + SimpleJNDIClientTest.getUDPDiscoveryAddress() + ":" + SimpleJNDIClientTest.getUDPDiscoveryPort());
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("myConnectionFactory");
        connectionFactory.createConnection().close();
    }

    @Test
    public void testRemoteCFWithUDPWithTransportConfig() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", ActiveMQInitialContextFactory.class.getCanonicalName());
        props.put("connectionFactory.myConnectionFactory", "udp://" + SimpleJNDIClientTest.getUDPDiscoveryAddress() + ":" + SimpleJNDIClientTest.getUDPDiscoveryPort() + "?" + "localAddress" + "=Server1&" + "localPort" + "=1198&" + "refreshTimeout" + "=5000&" + "discoveryInitialWaitTimeout" + "=6000");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        DiscoveryGroupConfiguration discoveryGroupConfiguration = cf.getDiscoveryGroupConfiguration();
        Assert.assertEquals((long)5000L, (long)discoveryGroupConfiguration.getRefreshTimeout());
        Assert.assertEquals((long)6000L, (long)discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout());
        UDPBroadcastEndpointFactory udpBroadcastEndpointFactory = (UDPBroadcastEndpointFactory)discoveryGroupConfiguration.getBroadcastEndpointFactory();
        Assert.assertNotEquals((Object)"Server1", (Object)udpBroadcastEndpointFactory.getLocalBindAddress());
        Assert.assertNotEquals((long)1198L, (long)udpBroadcastEndpointFactory.getLocalBindPort());
        Assert.assertEquals((Object)SimpleJNDIClientTest.getUDPDiscoveryAddress(), (Object)udpBroadcastEndpointFactory.getGroupAddress());
        Assert.assertEquals((long)SimpleJNDIClientTest.getUDPDiscoveryPort(), (long)udpBroadcastEndpointFactory.getGroupPort());
    }

    @Test
    public void testRemoteCFWithMultipleHosts() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "tcp://127.0.0.1:61616/httpEnabled=true&foo=bar,tcp://127.0.0.2:61617?httpEnabled=false?clientID=myClientID");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("myConnectionFactory");
        connectionFactory.createConnection().close();
    }

    @Test
    public void testRemoteCFWithTransportConfig() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "tcp://127.0.0.1:61616?sslEnabled=mySSLEnabledPropValue&httpEnabled=myHTTPEnabledPropValue&httpClientIdleTime=myHTTPClientIdlePropValue&httpClientIdleScanPeriod=myHTTPClientIdleScanPeriodValue&httpRequiresSessionId=myHTTPRequiresSessionIDValue&httpUpgradeEnabled=myHTTPUpgradeEnabledPropValue&httpUpgradeEndpoint=myHTTPUpgradeEndpointPropValue&useServlet=myUseServletPropValue&servletPath=myServletPathValue&useNio=myUseNIOPropValue&useNioGlobalWorkerPool=myUseNIOGlobalWorkerPoolPropValue&localAddress=myLocalAddressPropValue&localPort=myLocalPortPropValue&keyStoreProvider=myKeystoreProviderPropValue&keyStoreType=myKeystoreTypePropValue&keyStorePath=myKeystorePathPropValue&keyStorePassword=myKeystorePasswordPropValue&trustStoreProvider=myTruststoreProviderPropValue&trustStoreType=myTruststoreTypePropValue&trustStorePath=myTruststorePathPropValue&trustStorePassword=myTruststorePasswordPropValue&enabledCipherSuites=myEnabledCipherSuitesPropValue&enabledProtocols=myEnabledProtocolsPropValue&tcpNoDelay=myTCPNoDelayPropValue&tcpSendBufferSize=myTCPSendbufferSizePropValue&tcpReceiveBufferSize=myTCPReceivebufferSizePropValue&nioRemotingThreads=myNIORemotingThreadsPropValue&batchDelay=myBatchDelay&" + ActiveMQDefaultConfiguration.getPropMaskPassword() + "=myPropMaskPassword&" + ActiveMQDefaultConfiguration.getPropPasswordCodec() + "=myPropPasswordCodec&" + "connect-timeout-millis" + "=myNettyConnectTimeout&");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Map parametersFromJNDI = cf.getServerLocator().getStaticTransportConfigurations()[0].getParams();
        Assert.assertEquals(parametersFromJNDI.get("sslEnabled"), (Object)"mySSLEnabledPropValue");
        Assert.assertEquals(parametersFromJNDI.get("httpEnabled"), (Object)"myHTTPEnabledPropValue");
        Assert.assertEquals(parametersFromJNDI.get("httpClientIdleTime"), (Object)"myHTTPClientIdlePropValue");
        Assert.assertEquals(parametersFromJNDI.get("httpClientIdleScanPeriod"), (Object)"myHTTPClientIdleScanPeriodValue");
        Assert.assertEquals(parametersFromJNDI.get("httpRequiresSessionId"), (Object)"myHTTPRequiresSessionIDValue");
        Assert.assertEquals(parametersFromJNDI.get("httpUpgradeEnabled"), (Object)"myHTTPUpgradeEnabledPropValue");
        Assert.assertEquals(parametersFromJNDI.get("httpUpgradeEndpoint"), (Object)"myHTTPUpgradeEndpointPropValue");
        Assert.assertEquals(parametersFromJNDI.get("useServlet"), (Object)"myUseServletPropValue");
        Assert.assertEquals(parametersFromJNDI.get("servletPath"), (Object)"myServletPathValue");
        Assert.assertEquals(parametersFromJNDI.get("useNio"), (Object)"myUseNIOPropValue");
        Assert.assertEquals(parametersFromJNDI.get("useNioGlobalWorkerPool"), (Object)"myUseNIOGlobalWorkerPoolPropValue");
        Assert.assertEquals(parametersFromJNDI.get("localAddress"), (Object)"myLocalAddressPropValue");
        Assert.assertEquals(parametersFromJNDI.get("localPort"), (Object)"myLocalPortPropValue");
        Assert.assertEquals(parametersFromJNDI.get("keyStoreProvider"), (Object)"myKeystoreProviderPropValue");
        Assert.assertEquals(parametersFromJNDI.get("keyStoreType"), (Object)"myKeystoreTypePropValue");
        Assert.assertEquals(parametersFromJNDI.get("keyStorePath"), (Object)"myKeystorePathPropValue");
        Assert.assertEquals(parametersFromJNDI.get("keyStorePassword"), (Object)"myKeystorePasswordPropValue");
        Assert.assertEquals(parametersFromJNDI.get("trustStoreProvider"), (Object)"myTruststoreProviderPropValue");
        Assert.assertEquals(parametersFromJNDI.get("trustStoreType"), (Object)"myTruststoreTypePropValue");
        Assert.assertEquals(parametersFromJNDI.get("trustStorePath"), (Object)"myTruststorePathPropValue");
        Assert.assertEquals(parametersFromJNDI.get("trustStorePassword"), (Object)"myTruststorePasswordPropValue");
        Assert.assertEquals(parametersFromJNDI.get("enabledCipherSuites"), (Object)"myEnabledCipherSuitesPropValue");
        Assert.assertEquals(parametersFromJNDI.get("enabledProtocols"), (Object)"myEnabledProtocolsPropValue");
        Assert.assertEquals(parametersFromJNDI.get("tcpNoDelay"), (Object)"myTCPNoDelayPropValue");
        Assert.assertEquals(parametersFromJNDI.get("tcpSendBufferSize"), (Object)"myTCPSendbufferSizePropValue");
        Assert.assertEquals(parametersFromJNDI.get("tcpReceiveBufferSize"), (Object)"myTCPReceivebufferSizePropValue");
        Assert.assertEquals(parametersFromJNDI.get("nioRemotingThreads"), (Object)"myNIORemotingThreadsPropValue");
        Assert.assertEquals(parametersFromJNDI.get("batchDelay"), (Object)"myBatchDelay");
        Assert.assertEquals(parametersFromJNDI.get(ActiveMQDefaultConfiguration.getPropMaskPassword()), (Object)"myPropMaskPassword");
        Assert.assertEquals(parametersFromJNDI.get(ActiveMQDefaultConfiguration.getPropPasswordCodec()), (Object)"myPropPasswordCodec");
        Assert.assertEquals(parametersFromJNDI.get("connect-timeout-millis"), (Object)"myNettyConnectTimeout");
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.startServer();
    }

    private void startServer() throws Exception {
        this.liveTC = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
        connectors.put(this.liveTC.getName(), this.liveTC);
        ArrayList<String> connectorNames = new ArrayList<String>();
        connectorNames.add(this.liveTC.getName());
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("serverId", 1);
        ConfigurationImpl liveConf = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY)).addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY, params)).addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY)).setConnectorConfigurations(connectors).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).setSecurityEnabled(true);
        long broadcastPeriod = 250L;
        String bcGroupName = "bc1";
        int localBindPort = 5432;
        BroadcastGroupConfiguration bcConfig1 = new BroadcastGroupConfiguration().setName("bc1").setBroadcastPeriod(250L).setConnectorInfos(connectorNames).setEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(this.groupAddress).setGroupPort(this.groupPort).setLocalBindPort(5432));
        ArrayList<BroadcastGroupConfiguration> bcConfigs1 = new ArrayList<BroadcastGroupConfiguration>();
        bcConfigs1.add(bcConfig1);
        liveConf.setBroadcastGroupConfigurations(bcConfigs1);
        this.liveService = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConf, (boolean)false));
        ((ActiveMQJAASSecurityManager)this.liveService.getSecurityManager()).getConfiguration().addUser("guest", "guest");
        ((ActiveMQJAASSecurityManager)this.liveService.getSecurityManager()).getConfiguration().setDefaultUser("guest");
        this.liveService.start();
    }

    @Test
    public void testQueue() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("queue.myQueue", "myQueue");
        props.put("queue.queues/myQueue", "myQueue");
        InitialContext ctx = new InitialContext(props);
        Destination destination = (Destination)ctx.lookup("myQueue");
        Assert.assertTrue((boolean)(destination instanceof Queue));
        destination = (Destination)ctx.lookup("queues/myQueue");
        Assert.assertTrue((boolean)(destination instanceof Queue));
    }

    @Test
    public void testQueueFQQN() throws Exception {
        String QUEUE = "myQueue";
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("queue.myQueue", "myAddress::myQueue");
        InitialContext ctx = new InitialContext(props);
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Destination destination = (Destination)ctx.lookup("myQueue");
        Assert.assertTrue((boolean)(destination instanceof Queue));
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession();
            MessageProducer producer = session.createProducer(destination);
            producer.send(session.createMessage());
            Wait.assertTrue(() -> this.liveService.locateQueue("myQueue").getMessageCount() == 1L, (long)2000L, (long)100L);
            MessageConsumer consumer = session.createConsumer(destination);
            connection.start();
            SimpleJNDIClientTest.assertNotNull((Object)consumer.receiveNoWait());
        }
    }

    @Test
    public void testDynamicQueue() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        InitialContext ctx = new InitialContext(props);
        Destination destination = (Destination)ctx.lookup("dynamicQueues/myQueue");
        Assert.assertTrue((boolean)(destination instanceof Queue));
    }

    @Test
    public void testDynamicQueueFQQN() throws Exception {
        String QUEUE = "myQueue";
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        InitialContext ctx = new InitialContext(props);
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Destination destination = (Destination)ctx.lookup("dynamicQueues/myAddress::myQueue");
        Assert.assertTrue((boolean)(destination instanceof Queue));
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession();
            MessageProducer producer = session.createProducer(destination);
            producer.send(session.createMessage());
            Wait.assertTrue(() -> this.liveService.locateQueue("myQueue").getMessageCount() == 1L, (long)2000L, (long)100L);
            MessageConsumer consumer = session.createConsumer(destination);
            connection.start();
            SimpleJNDIClientTest.assertNotNull((Object)consumer.receiveNoWait());
        }
    }

    @Test
    public void testTopic() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("topic.myTopic", "myTopic");
        props.put("topic.topics/myTopic", "myTopic");
        InitialContext ctx = new InitialContext(props);
        Destination destination = (Destination)ctx.lookup("myTopic");
        Assert.assertTrue((boolean)(destination instanceof Topic));
        destination = (Destination)ctx.lookup("topics/myTopic");
        Assert.assertTrue((boolean)(destination instanceof Topic));
    }

    @Test
    public void testTopicFQQN() throws Exception {
        String SUBSCRIPTION = "mySubsription";
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("topic.myTopic", "myTopic::mySubsription");
        InitialContext ctx = new InitialContext(props);
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Destination destination = (Destination)ctx.lookup("myTopic");
        Assert.assertTrue((boolean)(destination instanceof Topic));
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession();
        MessageProducer producer = session.createProducer(destination);
        producer.send(session.createMessage());
        Wait.assertTrue(() -> this.liveService.locateQueue("mySubsription").getMessageCount() == 1L, (long)2000L, (long)100L);
        MessageConsumer consumer = session.createConsumer(destination);
        connection.start();
        SimpleJNDIClientTest.assertNotNull((Object)consumer.receiveNoWait());
    }

    @Test
    public void testDynamicTopic() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        InitialContext ctx = new InitialContext(props);
        Destination destination = (Destination)ctx.lookup("dynamicTopics/myTopic");
        Assert.assertTrue((boolean)(destination instanceof Topic));
    }

    @Test
    public void testDynamicTopicFQQN() throws Exception {
        String SUBSCRIPTION = "mySubsription";
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("topic.myTopic", "myTopic::mySubsription");
        InitialContext ctx = new InitialContext(props);
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Destination destination = (Destination)ctx.lookup("dynamicTopics/myTopic::mySubsription");
        Assert.assertTrue((boolean)(destination instanceof Topic));
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession();
        MessageProducer producer = session.createProducer(destination);
        producer.send(session.createMessage());
        Wait.assertTrue(() -> this.liveService.locateQueue("mySubsription").getMessageCount() == 1L, (long)2000L, (long)100L);
        MessageConsumer consumer = session.createConsumer(destination);
        connection.start();
        SimpleJNDIClientTest.assertNotNull((Object)consumer.receiveNoWait());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteCFWithTCPUserPassword() throws Exception {
        ((ActiveMQJAASSecurityManager)this.liveService.getSecurityManager()).getConfiguration().addUser("myUser", "myPassword");
        ((ActiveMQJAASSecurityManager)this.liveService.getSecurityManager()).getConfiguration().addRole("myUser", "consumeCreateRole");
        Role consumeCreateRole = new Role("consumeCreateRole", false, true, true, true, true, true, true, true, true, true);
        HashSet<Role> consumerCreateRoles = new HashSet<Role>();
        consumerCreateRoles.add(consumeCreateRole);
        this.liveService.getSecurityRepository().addMatch("test.queue", consumerCreateRoles);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "tcp://127.0.0.1:61616?user=myUser&password=myPassword");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assert.assertEquals((String)"ensure user is set", (Object)"myUser", (Object)connectionFactory.getUser());
        Assert.assertEquals((String)"ensure password is set", (Object)"myPassword", (Object)connectionFactory.getPassword());
        Connection connection = connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("test.queue");
        try {
            try {
                MessageProducer producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage("test Msg"));
                Assert.fail((String)"Sending message should throw a JMSSecurityException");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        }
        finally {
            connection.close();
        }
    }

    public void testContext(Context ctx, String jndiName, JMSFactoryType expectedFactoryType) {
        try {
            ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup(jndiName);
            if (expectedFactoryType == null) {
                Assert.fail((String)"expected no factory, should have thrown NamingException");
            } else {
                Assert.assertEquals((long)expectedFactoryType.intValue(), (long)connectionFactory.getFactoryType());
            }
        }
        catch (NamingException namingException) {
            Assert.assertNull((String)"NamingException should only occur when no ExpectedFactoryType, but one existed", (Object)expectedFactoryType);
        }
    }

    @Test
    public void testProviderUrlDefault() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", JMSFactoryType.CF);
        this.testContext(ctx, "QueueConnectionFactory", JMSFactoryType.QUEUE_CF);
        this.testContext(ctx, "TopicConnectionFactory", JMSFactoryType.TOPIC_CF);
        this.testContext(ctx, "XAConnectionFactory", JMSFactoryType.XA_CF);
        this.testContext(ctx, "XAQueueConnectionFactory", JMSFactoryType.QUEUE_XA_CF);
        this.testContext(ctx, "XATopicConnectionFactory", JMSFactoryType.TOPIC_XA_CF);
    }

    @Test
    public void testProviderUrlCF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", JMSFactoryType.CF);
        this.testContext(ctx, "QueueConnectionFactory", null);
        this.testContext(ctx, "TopicConnectionFactory", null);
        this.testContext(ctx, "XAConnectionFactory", null);
        this.testContext(ctx, "XAQueueConnectionFactory", null);
        this.testContext(ctx, "XATopicConnectionFactory", null);
    }

    @Test
    public void testProviderUrlXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=XA_CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", null);
        this.testContext(ctx, "QueueConnectionFactory", null);
        this.testContext(ctx, "TopicConnectionFactory", null);
        this.testContext(ctx, "XAConnectionFactory", JMSFactoryType.XA_CF);
        this.testContext(ctx, "XAQueueConnectionFactory", null);
        this.testContext(ctx, "XATopicConnectionFactory", null);
    }

    @Test
    public void testProviderUrlQueueCF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=QUEUE_CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", null);
        this.testContext(ctx, "QueueConnectionFactory", JMSFactoryType.QUEUE_CF);
        this.testContext(ctx, "TopicConnectionFactory", null);
        this.testContext(ctx, "XAConnectionFactory", null);
        this.testContext(ctx, "XAQueueConnectionFactory", null);
        this.testContext(ctx, "XATopicConnectionFactory", null);
    }

    @Test
    public void testProviderUrlQueueXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=QUEUE_XA_CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", null);
        this.testContext(ctx, "QueueConnectionFactory", null);
        this.testContext(ctx, "TopicConnectionFactory", null);
        this.testContext(ctx, "XAConnectionFactory", null);
        this.testContext(ctx, "XAQueueConnectionFactory", JMSFactoryType.QUEUE_XA_CF);
        this.testContext(ctx, "XATopicConnectionFactory", null);
    }

    @Test
    public void testProviderUrlTopicCF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=TOPIC_CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", null);
        this.testContext(ctx, "QueueConnectionFactory", null);
        this.testContext(ctx, "TopicConnectionFactory", JMSFactoryType.TOPIC_CF);
        this.testContext(ctx, "XAConnectionFactory", null);
        this.testContext(ctx, "XAQueueConnectionFactory", null);
        this.testContext(ctx, "XATopicConnectionFactory", null);
    }

    @Test
    public void testProviderUrlTopicXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=TOPIC_XA_CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", null);
        this.testContext(ctx, "QueueConnectionFactory", null);
        this.testContext(ctx, "TopicConnectionFactory", null);
        this.testContext(ctx, "XAConnectionFactory", null);
        this.testContext(ctx, "XAQueueConnectionFactory", null);
        this.testContext(ctx, "XATopicConnectionFactory", JMSFactoryType.TOPIC_XA_CF);
    }

    @Test
    public void testProviderUrlDefaultAndCustom() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0");
        props.put("connectionFactory.myConnectionFactory", "vm://0");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", JMSFactoryType.CF);
        this.testContext(ctx, "QueueConnectionFactory", JMSFactoryType.QUEUE_CF);
        this.testContext(ctx, "TopicConnectionFactory", JMSFactoryType.TOPIC_CF);
        this.testContext(ctx, "XAConnectionFactory", JMSFactoryType.XA_CF);
        this.testContext(ctx, "XAQueueConnectionFactory", JMSFactoryType.QUEUE_XA_CF);
        this.testContext(ctx, "XATopicConnectionFactory", JMSFactoryType.TOPIC_XA_CF);
        this.testContext(ctx, "myConnectionFactory", JMSFactoryType.CF);
    }

    @Test
    public void test1xNaming() throws NamingException, JMSException {
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://0?enable1xPrefixes=true");
        props.put("connectionFactory.ConnectionFactory2", "vm://0");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession();
        SimpleJNDIClientTest.assertTrue((boolean)((ActiveMQDestination)session.createQueue("testQueue")).getSimpleAddress().startsWith(PacketImpl.OLD_QUEUE_PREFIX));
        SimpleJNDIClientTest.assertTrue((boolean)((ActiveMQDestination)session.createTemporaryQueue()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX));
        SimpleJNDIClientTest.assertTrue((boolean)((ActiveMQDestination)session.createTopic("testTopic")).getSimpleAddress().startsWith(PacketImpl.OLD_TOPIC_PREFIX));
        SimpleJNDIClientTest.assertTrue((boolean)((ActiveMQDestination)session.createTemporaryTopic()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX));
        SimpleJNDIClientTest.assertFalse((boolean)session.createQueue("testQueue").getQueueName().startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString()));
        SimpleJNDIClientTest.assertFalse((boolean)session.createTemporaryQueue().getQueueName().startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString()));
        SimpleJNDIClientTest.assertFalse((boolean)session.createTopic("testTopic").getTopicName().startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString()));
        SimpleJNDIClientTest.assertFalse((boolean)session.createTemporaryTopic().getTopicName().startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString()));
        connection.close();
        connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory2");
        ((ActiveMQConnectionFactory)connectionFactory).setEnable1xPrefixes(true);
        connection = connectionFactory.createConnection();
        session = connection.createSession();
        SimpleJNDIClientTest.assertTrue((boolean)((ActiveMQDestination)session.createQueue("testQueue")).getSimpleAddress().startsWith(PacketImpl.OLD_QUEUE_PREFIX));
        SimpleJNDIClientTest.assertTrue((boolean)((ActiveMQDestination)session.createTemporaryQueue()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX));
        SimpleJNDIClientTest.assertTrue((boolean)((ActiveMQDestination)session.createTopic("testTopic")).getSimpleAddress().startsWith(PacketImpl.OLD_TOPIC_PREFIX));
        SimpleJNDIClientTest.assertTrue((boolean)((ActiveMQDestination)session.createTemporaryTopic()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX));
        SimpleJNDIClientTest.assertFalse((boolean)session.createQueue("testQueue").getQueueName().startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString()));
        SimpleJNDIClientTest.assertFalse((boolean)session.createTemporaryQueue().getQueueName().startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString()));
        SimpleJNDIClientTest.assertFalse((boolean)session.createTopic("testTopic").getTopicName().startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString()));
        SimpleJNDIClientTest.assertFalse((boolean)session.createTemporaryTopic().getTopicName().startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString()));
        connection.close();
    }

    @Test
    public void test1xNamingNegative() throws NamingException, JMSException {
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://0");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession();
        SimpleJNDIClientTest.assertFalse((boolean)((ActiveMQDestination)session.createQueue("testQueue")).getSimpleAddress().startsWith(PacketImpl.OLD_QUEUE_PREFIX));
        SimpleJNDIClientTest.assertFalse((boolean)((ActiveMQDestination)session.createTemporaryQueue()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX));
        SimpleJNDIClientTest.assertFalse((boolean)((ActiveMQDestination)session.createTopic("testTopic")).getSimpleAddress().startsWith(PacketImpl.OLD_TOPIC_PREFIX));
        SimpleJNDIClientTest.assertFalse((boolean)((ActiveMQDestination)session.createTemporaryTopic()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX));
        connection.close();
    }

    @Test
    public void testUseTopologyForLoadBalancing() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://0?useTopologyForLoadBalancing=false");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        SimpleJNDIClientTest.assertFalse((boolean)((ActiveMQConnectionFactory)connectionFactory).getServerLocator().getUseTopologyForLoadBalancing());
    }
}

