/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScaleDown3NodeTest
extends ClusterTestBase {
    private static final Logger log = Logger.getLogger(ScaleDown3NodeTest.class);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupLiveServer(0, this.isFileStorage(), ClusterTestBase.HAType.SharedNothingReplication, this.isNetty(), true);
        this.servers[0].getConfiguration().setSecurityEnabled(true);
        this.setupLiveServer(1, this.isFileStorage(), ClusterTestBase.HAType.SharedNothingReplication, this.isNetty(), true);
        this.servers[1].getConfiguration().setSecurityEnabled(true);
        this.setupLiveServer(2, this.isFileStorage(), ClusterTestBase.HAType.SharedNothingReplication, this.isNetty(), true);
        this.servers[2].getConfiguration().setSecurityEnabled(true);
        LiveOnlyPolicyConfiguration haPolicyConfiguration0 = (LiveOnlyPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration();
        ScaleDownConfiguration scaleDownConfiguration0 = new ScaleDownConfiguration();
        haPolicyConfiguration0.setScaleDownConfiguration(scaleDownConfiguration0);
        LiveOnlyPolicyConfiguration haPolicyConfiguration1 = (LiveOnlyPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration();
        ScaleDownConfiguration scaleDownConfiguration1 = new ScaleDownConfiguration();
        haPolicyConfiguration1.setScaleDownConfiguration(scaleDownConfiguration1);
        scaleDownConfiguration0.setGroupName("bill");
        scaleDownConfiguration1.setGroupName("bill");
        scaleDownConfiguration1.setEnabled(false);
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        String scaleDownConnector = (String)((ClusterConnectionConfiguration)this.servers[0].getConfiguration().getClusterConfigurations().get(0)).getStaticConnectors().get(0);
        Assert.assertEquals((Object)61617, ((TransportConfiguration)this.servers[0].getConfiguration().getConnectorConfigurations().get(scaleDownConnector)).getParams().get("port"));
        scaleDownConfiguration0.getConnectors().add(scaleDownConnector);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty(), false, this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword());
        this.setupSessionFactory(1, this.isNetty(), false, this.servers[1].getConfiguration().getClusterUser(), this.servers[1].getConfiguration().getClusterPassword());
        this.setupSessionFactory(2, this.isNetty(), false, this.servers[2].getConfiguration().getClusterUser(), this.servers[2].getConfiguration().getClusterPassword());
        log.debug((Object)"===============================");
        log.debug((Object)("Node 0: " + this.servers[0].getClusterManager().getNodeId()));
        log.debug((Object)("Node 1: " + this.servers[1].getClusterManager().getNodeId()));
        log.debug((Object)("Node 2: " + this.servers[2].getClusterManager().getNodeId()));
        log.debug((Object)"===============================");
        this.servers[0].setIdentity("Node0");
        this.servers[1].setIdentity("Node1");
        this.servers[2].setIdentity("Node2");
    }

    protected boolean isNetty() {
        return true;
    }

    @Test
    public void testBasicScaleDownWithDefaultReconnectAttempts() throws Exception {
        this.testBasicScaleDownInternal(ActiveMQDefaultConfiguration.getDefaultBridgeReconnectAttempts(), false);
    }

    @Test
    public void testBasicScaleDownWithoutBridgeReconnect() throws Exception {
        this.testBasicScaleDownInternal(0, false);
    }

    @Test
    public void testBasicScaleDownWithDefaultReconnectAttemptsAndLargeMessages() throws Exception {
        this.testBasicScaleDownInternal(ActiveMQDefaultConfiguration.getDefaultBridgeReconnectAttempts(), true);
    }

    private void testBasicScaleDownInternal(int reconnectAttempts, boolean large) throws Exception {
        ClientMessage message;
        AddressSettings addressSettings = new AddressSettings().setRedistributionDelay(0L);
        this.servers[0].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.servers[1].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.servers[2].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        ((ClusterConnectionConfiguration)this.servers[0].getConfiguration().getClusterConfigurations().get(0)).setReconnectAttempts(reconnectAttempts);
        ((ClusterConnectionConfiguration)this.servers[1].getConfiguration().getClusterConfigurations().get(0)).setReconnectAttempts(reconnectAttempts);
        ((ClusterConnectionConfiguration)this.servers[2].getConfiguration().getClusterConfigurations().get(0)).setReconnectAttempts(reconnectAttempts);
        int TEST_SIZE = 10;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        this.createQueue(0, "testAddress", "testQueue1", null, false, this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword());
        this.createQueue(1, "testAddress", "testQueue1", null, false, this.servers[1].getConfiguration().getClusterUser(), this.servers[1].getConfiguration().getClusterPassword());
        this.createQueue(2, "testAddress", "testQueue1", null, false, this.servers[2].getConfiguration().getClusterUser(), this.servers[2].getConfiguration().getClusterPassword());
        String snfAddress = this.servers[0].getInternalNamingPrefix() + "sf.cluster0." + this.servers[0].getNodeID().toString();
        Queue snfQueue = ((LocalQueueBinding)this.servers[2].getPostOffice().getBinding(SimpleString.toSimpleString((String)snfAddress))).getQueue();
        snfQueue.pause();
        ClientSession session = this.sfs[2].createSession(this.servers[2].getConfiguration().getClusterUser(), this.servers[2].getConfiguration().getClusterPassword(), false, true, false, false, 0);
        if (large) {
            LargeServerMessageImpl fileMessage = new LargeServerMessageImpl((StorageManager)((JournalStorageManager)this.servers[2].getStorageManager()));
            fileMessage.setMessageID(1005L);
            fileMessage.setDurable(true);
            for (int i = 0; i < 204800; ++i) {
                fileMessage.addBytes(new byte[]{ActiveMQTestBase.getSamplebyte((long)i)});
            }
            fileMessage.putLongProperty(Message.HDR_LARGE_BODY_SIZE, 204800L);
            fileMessage.releaseResources(false, false);
            message = fileMessage;
        } else {
            message = session.createMessage(false);
        }
        for (int i = 0; i < 10; ++i) {
            ClientProducer producer = session.createProducer("testAddress");
            producer.send((Message)message);
        }
        if (large) {
            ((LargeServerMessageImpl)message).deleteFile();
        }
        this.addConsumer(0, 0, "testQueue1", null, true, this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword());
        Wait.assertEquals((long)10L, () -> ((Queue)snfQueue).getMessageCount());
        Assert.assertEquals((long)10L, (long)this.getMessageCount(snfQueue));
        log.debug((Object)("============ Stopping " + this.servers[0].getNodeID()));
        this.removeConsumer(0);
        this.servers[0].stop();
        Queue queueServer2 = ((LocalQueueBinding)this.servers[2].getPostOffice().getBinding(new SimpleString("testQueue1"))).getQueue();
        Wait.assertEquals((long)0L, () -> ((Queue)queueServer2).getMessageCount());
        this.addConsumer(0, 1, "testQueue1", null, true, this.servers[1].getConfiguration().getClusterUser(), this.servers[1].getConfiguration().getClusterPassword());
        Queue queueServer1 = ((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue1"))).getQueue();
        Wait.assertEquals((long)10L, () -> ((Queue)queueServer1).getMessageCount());
        for (int i = 0; i < 10; ++i) {
            ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
            Assert.assertNotNull((Object)clientMessage);
            if (large) {
                Assert.assertEquals((long)204800L, (long)clientMessage.getBodySize());
                for (int j = 0; j < 204800; ++j) {
                    Assert.assertEquals((long)ActiveMQTestBase.getSamplebyte((long)j), (long)clientMessage.getBodyBuffer().readByte());
                }
            }
            log.debug((Object)("Received: " + clientMessage));
            clientMessage.acknowledge();
        }
        ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        Wait.assertTrue(() -> this.servers[2].getPostOffice().getBinding(SimpleString.toSimpleString((String)snfAddress)) == null);
        Wait.assertTrue(() -> this.servers[1].getPostOffice().getBinding(SimpleString.toSimpleString((String)snfAddress)) == null);
        Assert.assertFalse((boolean)this.servers[1].queueQuery(SimpleString.toSimpleString((String)snfAddress)).isExists());
        Assert.assertFalse((boolean)this.servers[1].addressQuery(SimpleString.toSimpleString((String)snfAddress)).isExists());
    }

    @Test
    public void testScaleDownWithMultipleQueues() throws Exception {
        int i;
        AddressSettings addressSettings = new AddressSettings().setRedistributionDelay(0L);
        this.servers[0].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.servers[1].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.servers[2].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        int TEST_SIZE = 10;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        String queueName3 = "testQueue3";
        this.createQueue(0, "testAddress", "testQueue1", null, false, this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword());
        this.createQueue(1, "testAddress", "testQueue1", null, false, this.servers[1].getConfiguration().getClusterUser(), this.servers[1].getConfiguration().getClusterPassword());
        this.createQueue(2, "testAddress", "testQueue1", null, false, this.servers[2].getConfiguration().getClusterUser(), this.servers[2].getConfiguration().getClusterPassword());
        this.createQueue(0, "testAddress", "testQueue2", null, false, this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword());
        this.createQueue(1, "testAddress", "testQueue2", null, false, this.servers[1].getConfiguration().getClusterUser(), this.servers[1].getConfiguration().getClusterPassword());
        this.createQueue(2, "testAddress", "testQueue2", null, false, this.servers[2].getConfiguration().getClusterUser(), this.servers[2].getConfiguration().getClusterPassword());
        this.createQueue(0, "testAddress", "testQueue3", null, false, this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword());
        this.createQueue(1, "testAddress", "testQueue3", null, false, this.servers[1].getConfiguration().getClusterUser(), this.servers[1].getConfiguration().getClusterPassword());
        this.createQueue(2, "testAddress", "testQueue3", null, false, this.servers[2].getConfiguration().getClusterUser(), this.servers[2].getConfiguration().getClusterPassword());
        String snfAddress = this.servers[0].getInternalNamingPrefix() + "sf.cluster0." + this.servers[0].getNodeID().toString();
        Queue snfQueue = ((LocalQueueBinding)this.servers[2].getPostOffice().getBinding(SimpleString.toSimpleString((String)snfAddress))).getQueue();
        snfQueue.pause();
        ClientSession session = this.sfs[2].createSession(this.servers[2].getConfiguration().getClusterUser(), this.servers[2].getConfiguration().getClusterPassword(), false, true, false, false, 0);
        ClientMessage message = session.createMessage(false);
        for (i = 0; i < 10; ++i) {
            ClientProducer producer = session.createProducer("testAddress");
            producer.send((Message)message);
        }
        this.addConsumer(0, 0, "testQueue1", null, true, this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword());
        this.addConsumer(1, 0, "testQueue3", null, true, this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword());
        Wait.assertEquals((long)20L, () -> ((Queue)snfQueue).getMessageCount());
        log.debug((Object)("============ Stopping " + this.servers[0].getNodeID()));
        this.removeConsumer(0);
        this.removeConsumer(1);
        this.servers[0].stop();
        Wait.assertEquals((int)0, () -> this.getMessageCount(((LocalQueueBinding)this.servers[2].getPostOffice().getBinding(new SimpleString("testQueue1"))).getQueue()) + this.getMessageCount(((LocalQueueBinding)this.servers[2].getPostOffice().getBinding(new SimpleString("testQueue3"))).getQueue()));
        Assert.assertEquals((long)10L, (long)this.getMessageCount(((LocalQueueBinding)this.servers[2].getPostOffice().getBinding(new SimpleString("testQueue2"))).getQueue()));
        this.addConsumer(0, 1, "testQueue1", null, true, this.servers[1].getConfiguration().getClusterUser(), this.servers[1].getConfiguration().getClusterPassword());
        this.addConsumer(1, 1, "testQueue3", null, true, this.servers[1].getConfiguration().getClusterUser(), this.servers[1].getConfiguration().getClusterPassword());
        Wait.assertEquals((int)20, () -> this.getMessageCount(((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue1"))).getQueue()) + this.getMessageCount(((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue3"))).getQueue()));
        for (i = 0; i < 10; ++i) {
            ClientMessage clientMessage = this.consumers[0].getConsumer().receive(1000L);
            Assert.assertNotNull((Object)clientMessage);
            log.debug((Object)("Received: " + clientMessage));
            clientMessage.acknowledge();
            clientMessage = this.consumers[1].getConsumer().receive(1000L);
            Assert.assertNotNull((Object)clientMessage);
            log.debug((Object)("Received: " + clientMessage));
            clientMessage.acknowledge();
        }
        ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        clientMessage = this.consumers[1].getConsumer().receive(250L);
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(1);
    }
}

