/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.git;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.internal.transport.sshd.CachingKeyPairProvider;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.IdentityPasswordProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.SshdSession;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.eclipse.jgit.util.FS;
import org.jboss.as.server.logging.ServerLogger;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.ElytronXmlParser;
import org.wildfly.security.credential.KeyPairCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SSHCredential;
import org.wildfly.security.password.interfaces.ClearPassword;

class ElytronClientSshdSessionFactory
extends SshdSessionFactory {
    private static AuthenticationContextConfigurationClient CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final AuthenticationContext context;
    private final Map<Tuple, Iterable<KeyPair>> defaultKeys;
    private String[] defaultIdentities;
    private KeyPair keyPair;
    private URI uri;
    private String knownHostsFile;

    ElytronClientSshdSessionFactory(URI authenticationConfig) throws ConfigXMLParseException, GeneralSecurityException {
        this.context = authenticationConfig != null ? (AuthenticationContext)ElytronXmlParser.parseAuthenticationClientConfiguration((URI)authenticationConfig).create() : null;
        this.defaultKeys = new ConcurrentHashMap<Tuple, Iterable<KeyPair>>();
        this.setSshDirectory(SSHCredential.DEFAULT_SSH_DIRECTORY);
        this.defaultIdentities = SSHCredential.DEFAULT_PRIVATE_KEYS;
        this.keyPair = null;
        this.knownHostsFile = SSHCredential.DEFAULT_KNOWN_HOSTS;
    }

    @NonNull
    protected List<Path> getDefaultIdentities(@NonNull File sshDir) {
        return Stream.of(this.defaultIdentities).map(s -> sshDir.toPath().resolve((String)s)).filter(path -> Files.exists(path, new LinkOption[0])).collect(Collectors.toList());
    }

    public SshdSession getSession(URIish urIish, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        if (this.context == null) {
            return super.getSession(urIish, credentialsProvider, fs, tms);
        }
        try {
            this.uri = this.urIishToUri(urIish);
            AuthenticationConfiguration config = CLIENT.getAuthenticationConfiguration(this.uri, this.context);
            CredentialCallback locationCallback = new CredentialCallback(SSHCredential.class, null);
            CredentialCallback keyPairCallback = new CredentialCallback(KeyPairCredential.class, null);
            Callback[] callbacks = new Callback[]{locationCallback, keyPairCallback};
            CLIENT.getCallbackHandler(config).handle(callbacks);
            if (locationCallback.getCredential() != null) {
                SSHCredential sshCredential = (SSHCredential)locationCallback.getCredential().castAs(SSHCredential.class);
                this.setSshDirectory(sshCredential.getSshDirectory());
                this.defaultIdentities = sshCredential.getPrivateKeyIdentities();
                this.knownHostsFile = sshCredential.getKnownHostsFile();
            }
            if (keyPairCallback.getCredential() != null) {
                KeyPairCredential keyPairCredential = (KeyPairCredential)keyPairCallback.getCredential().castAs(KeyPairCredential.class);
                this.keyPair = keyPairCredential.getKeyPair();
            }
        }
        catch (IOException | URISyntaxException | UnsupportedCallbackException ex) {
            throw ServerLogger.ROOT_LOGGER.failedToLoadSSHCredentials(ex, ex.getMessage());
        }
        return super.getSession(urIish, credentialsProvider, fs, tms);
    }

    protected KeyPasswordProvider createKeyPasswordProvider(CredentialsProvider provider) {
        if (this.context == null) {
            return super.createKeyPasswordProvider(provider);
        }
        final URI uri = this.uri;
        return new IdentityPasswordProvider(new CredentialsProvider(){

            public boolean isInteractive() {
                return false;
            }

            public boolean supports(CredentialItem ... credentialItems) {
                for (CredentialItem i : credentialItems) {
                    if (i instanceof CredentialItem.Password) continue;
                    return false;
                }
                return true;
            }

            public boolean get(URIish urIish, CredentialItem ... credentialItems) throws UnsupportedCredentialItem {
                try {
                    AuthenticationConfiguration config = CLIENT.getAuthenticationConfiguration(uri, ElytronClientSshdSessionFactory.this.context);
                    for (CredentialItem i : credentialItems) {
                        if (!(i instanceof CredentialItem.Password)) continue;
                        CredentialCallback callback = new CredentialCallback(SSHCredential.class, null);
                        Callback[] callbacks = new Callback[]{callback};
                        CLIENT.getCallbackHandler(config).handle(callbacks);
                        SSHCredential credential = null;
                        if (callback == null || callback.getCredential() == null) continue;
                        credential = (SSHCredential)callback.getCredential().castAs(SSHCredential.class);
                        char[] password = (char[])credential.getPassphrase().castAndApply(PasswordCredential.class, c -> (char[])c.getPassword().castAndApply(ClearPassword.class, ClearPassword::getPassword));
                        ((CredentialItem.Password)i).setValue(password);
                    }
                }
                catch (IOException | UnsupportedCallbackException ex) {
                    throw new UnsupportedCredentialItem(urIish, ex.getMessage());
                }
                return true;
            }
        });
    }

    @NonNull
    protected List<Path> getDefaultKnownHostsFiles(@NonNull File sshDir) {
        return Collections.singletonList(sshDir.toPath().resolve(this.knownHostsFile));
    }

    @NonNull
    protected Iterable<KeyPair> getDefaultKeys(@NonNull File sshDir) {
        if (this.keyPair == null) {
            List<Path> defaultIdentities = this.getDefaultIdentities(sshDir);
            return this.defaultKeys.computeIfAbsent(new Tuple(defaultIdentities.toArray(new Path[0])), t -> new CachingKeyPairProvider(defaultIdentities, this.getKeyCache()));
        }
        return Collections.singletonList(this.keyPair);
    }

    private URI urIishToUri(URIish urIish) throws URISyntaxException {
        String scheme = "ssh";
        String user = urIish.getUser();
        String host = urIish.getHost();
        int port = urIish.getPort();
        String path = null;
        path = user.equals("git") ? "/" + urIish.getPath() : urIish.getPath();
        return new URI(scheme, user, host, port, path, null, null);
    }

    private static final class Tuple {
        private final Object[] objects;

        public Tuple(Object[] objects) {
            this.objects = objects;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == Tuple.class) {
                Tuple other = (Tuple)obj;
                return Arrays.equals(this.objects, other.objects);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.objects);
        }
    }
}

