/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import jakarta.enterprise.inject.spi.Extension;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.wildfly.extension.micrometer.MicrometerDeploymentService;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.api.MicrometerCdiExtension;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

class MicrometerSubsystemDeploymentProcessor
implements DeploymentUnitProcessor {
    private final boolean exposeAnySubsystem;
    private final List<String> exposedSubsystems;
    private final Supplier<WildFlyRegistry> registrySupplier;

    MicrometerSubsystemDeploymentProcessor(boolean exposeAnySubsystem, List<String> exposedSubsystems, Supplier<WildFlyRegistry> registrySupplier) {
        this.exposeAnySubsystem = exposeAnySubsystem;
        this.exposedSubsystems = exposedSubsystems;
        this.registrySupplier = registrySupplier;
    }

    public void deploy(DeploymentPhaseContext deploymentPhaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        MicrometerDeploymentService.install(deploymentPhaseContext.getServiceTarget(), deploymentPhaseContext, (Resource)deploymentUnit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE), (ManagementResourceRegistration)deploymentUnit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT), this.exposeAnySubsystem, this.exposedSubsystems);
        this.registerCdiExtension(deploymentUnit);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void registerCdiExtension(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        try {
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            WeldCapability weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
            if (!weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
                MicrometerExtensionLogger.MICROMETER_LOGGER.noCdiDeployment();
                return;
            }
            WildFlyRegistry registry = this.registrySupplier.get();
            if (registry == null) {
                throw new DeploymentUnitProcessingException((Throwable)new IllegalStateException());
            }
            weldCapability.registerExtensionInstance((Extension)new MicrometerCdiExtension((MeterRegistry)registry), deploymentUnit);
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            MicrometerExtensionLogger.MICROMETER_LOGGER.deploymentRequiresCapability(deploymentUnit.getName(), "org.wildfly.weld");
        }
    }
}

