/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.jmx;

import java.util.List;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.wildfly.extension.micrometer.metrics.MetricID;
import org.wildfly.extension.micrometer.metrics.MetricMetadata;

class JmxMetricMetadata
implements MetricMetadata {
    private final String name;
    private final String description;
    private final MeasurementUnit unit;
    private final MetricMetadata.Type type;
    private final String mbean;
    private final MetricID metricID;
    private List<String> tagsToFill;
    private List<MetricMetadata.MetricTag> tags;

    JmxMetricMetadata(String name, String description, MeasurementUnit unit, MetricMetadata.Type type, String mbean, List<String> tagsToFill, List<MetricMetadata.MetricTag> tags) {
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.type = type;
        this.mbean = mbean;
        this.tagsToFill = tagsToFill;
        this.tags = tags;
        this.metricID = new MetricID(name, tags.toArray(new MetricMetadata.MetricTag[0]));
    }

    String getMBean() {
        return this.mbean;
    }

    List<String> getTagsToFill() {
        return this.tagsToFill;
    }

    @Override
    public MetricID getMetricID() {
        return this.metricID;
    }

    @Override
    public String getMetricName() {
        return this.name;
    }

    @Override
    public MetricMetadata.MetricTag[] getTags() {
        return this.tags.toArray(new MetricMetadata.MetricTag[0]);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public MetricMetadata.Type getType() {
        return this.type;
    }

    @Override
    public MeasurementUnit getMeasurementUnit() {
        return this.unit;
    }
}

