/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.metrics.MetricMetadata;
import org.wildfly.extension.micrometer.metrics.WildFlyMetric;

public class WildFlyRegistry
extends PrometheusMeterRegistry {
    public WildFlyRegistry() {
        super(PrometheusConfig.DEFAULT);
        this.throwExceptionOnRegistrationFailure();
    }

    public Meter addMeter(WildFlyMetric metric, MetricMetadata metadata) {
        switch (metadata.getType()) {
            case GAUGE: {
                return this.addGauge(metric, metadata);
            }
            case COUNTER: {
                return this.addCounter(metric, metadata);
            }
        }
        throw MicrometerExtensionLogger.MICROMETER_LOGGER.unsupportedMetricType(metadata.getType().name());
    }

    private Meter addCounter(WildFlyMetric metric, MetricMetadata metadata) {
        MeasurementUnit measurementUnit = metadata.getMeasurementUnit();
        return this.newFunctionCounter(this.generateMetricId(metadata, Meter.Type.COUNTER), metric, value -> this.getMetricValue(metric, measurementUnit));
    }

    private Meter addGauge(WildFlyMetric metric, MetricMetadata metadata) {
        MeasurementUnit measurementUnit = metadata.getMeasurementUnit();
        return this.newGauge(this.generateMetricId(metadata, Meter.Type.GAUGE), metric, value -> this.getMetricValue(metric, measurementUnit));
    }

    private Meter.Id generateMetricId(MetricMetadata metadata, Meter.Type gauge) {
        return new Meter.Id(metadata.getMetricName(), Tags.of(this.getTags(metadata)), this.getBaseUnit(metadata), metadata.getDescription(), gauge);
    }

    private double getMetricValue(WildFlyMetric metric, MeasurementUnit unit) {
        OptionalDouble metricValue = metric.getValue();
        return metricValue.isPresent() ? this.scaleToBaseUnit(metricValue.getAsDouble(), unit) : 0.0;
    }

    private List<Tag> getTags(MetricMetadata metadata) {
        return Arrays.stream(metadata.getTags()).map(t -> Tag.of((String)t.getKey(), (String)t.getValue())).collect(Collectors.toList());
    }

    private String getBaseUnit(MetricMetadata metadata) {
        String measurementUnit = metadata.getBaseMetricUnit();
        return "none".equalsIgnoreCase(measurementUnit) ? null : measurementUnit.toLowerCase();
    }

    private double scaleToBaseUnit(double value, MeasurementUnit unit) {
        return value * MeasurementUnit.calculateOffset((MeasurementUnit)unit, (MeasurementUnit)unit.getBaseUnits());
    }
}

