/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingFailureHandler;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingMonitor;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingBatchCoordinator;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingDelegatingFailureHandler;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingFailSafeFailureHandlerWrapper;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingLoggingMonitor;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingNotifier;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingTypeContextProvider;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexer;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingMappingContext;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;
import org.hibernate.search.util.common.impl.Futures;

public class PojoDefaultMassIndexer
implements PojoMassIndexer {
    private final PojoMassIndexingContext indexingContext;
    private final PojoMassIndexingMappingContext mappingContext;
    private final PojoMassIndexingTypeContextProvider typeContextProvider;
    private final Set<? extends PojoMassIndexingIndexedTypeContext<?>> targetedIndexedTypes;
    private final PojoScopeSchemaManager scopeSchemaManager;
    private final DetachedBackendSessionContext detachedSession;
    private final PojoScopeWorkspace scopeWorkspace;
    private int typesToIndexInParallel = 1;
    private int documentBuilderThreads = 6;
    private boolean mergeSegmentsOnFinish = false;
    private boolean dropAndCreateSchemaOnStart = false;
    private boolean purgeAtStart = true;
    private boolean mergeSegmentsAfterPurge = true;
    private MassIndexingFailureHandler failureHandler;
    private MassIndexingMonitor monitor;

    public PojoDefaultMassIndexer(PojoMassIndexingContext indexingContext, PojoMassIndexingMappingContext mappingContext, PojoMassIndexingTypeContextProvider typeContextProvider, Set<? extends PojoMassIndexingIndexedTypeContext<?>> targetedIndexedTypes, PojoScopeSchemaManager scopeSchemaManager, DetachedBackendSessionContext detachedSession, PojoScopeWorkspace scopeWorkspace) {
        this.indexingContext = indexingContext;
        this.mappingContext = mappingContext;
        this.typeContextProvider = typeContextProvider;
        this.targetedIndexedTypes = targetedIndexedTypes;
        this.scopeSchemaManager = scopeSchemaManager;
        this.detachedSession = detachedSession;
        this.scopeWorkspace = scopeWorkspace;
    }

    @Override
    public PojoDefaultMassIndexer typesToIndexInParallel(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.typesToIndexInParallel = numberOfThreads;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer threadsToLoadObjects(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.documentBuilderThreads = numberOfThreads;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer mergeSegmentsOnFinish(boolean enable) {
        this.mergeSegmentsOnFinish = enable;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer mergeSegmentsAfterPurge(boolean enable) {
        this.mergeSegmentsAfterPurge = enable;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer dropAndCreateSchemaOnStart(boolean enable) {
        this.dropAndCreateSchemaOnStart = enable;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer purgeAllOnStart(boolean enable) {
        this.purgeAtStart = enable;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer monitor(MassIndexingMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> start() {
        PojoMassIndexingBatchCoordinator coordinator = this.createCoordinator();
        ThreadPoolExecutor executor = this.mappingContext.threadPoolProvider().newFixedThreadPool(1, "Mass indexing - Coordinator");
        try {
            CompletableFuture completableFuture = Futures.runAsync((Runnable)coordinator, (ExecutorService)executor);
            return completableFuture;
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public void startAndWait() throws InterruptedException {
        PojoMassIndexingBatchCoordinator coordinator = this.createCoordinator();
        try {
            coordinator.run();
        }
        catch (Throwable t) {
            if (Thread.interrupted()) {
                InterruptedException exception = new InterruptedException();
                exception.addSuppressed(t);
                throw exception;
            }
            throw t;
        }
    }

    private PojoMassIndexingBatchCoordinator createCoordinator() {
        List<PojoMassIndexingIndexedTypeGroup<?>> typeGroupsToIndex = PojoMassIndexingIndexedTypeGroup.disjoint(this.indexingContext, this.mappingContext, this.typeContextProvider, this.targetedIndexedTypes);
        this.typesToIndexInParallel = Math.min(this.typesToIndexInParallel, typeGroupsToIndex.size());
        PojoMassIndexingNotifier notifier = new PojoMassIndexingNotifier(this.getOrCreateFailureHandler(), this.getOrCreateMonitor());
        return new PojoMassIndexingBatchCoordinator(this.mappingContext, notifier, typeGroupsToIndex, this.scopeSchemaManager, this.detachedSession, this.scopeWorkspace, this.typesToIndexInParallel, this.documentBuilderThreads, this.mergeSegmentsOnFinish, this.dropAndCreateSchemaOnStart, this.purgeAtStart, this.mergeSegmentsAfterPurge);
    }

    @Override
    public PojoDefaultMassIndexer failureHandler(MassIndexingFailureHandler failureHandler) {
        this.failureHandler = failureHandler;
        return this;
    }

    private MassIndexingFailureHandler getOrCreateFailureHandler() {
        MassIndexingFailureHandler result = this.failureHandler;
        if (result == null) {
            result = new PojoMassIndexingDelegatingFailureHandler(this.mappingContext.failureHandler());
        }
        result = new PojoMassIndexingFailSafeFailureHandlerWrapper(result);
        return result;
    }

    private MassIndexingMonitor getOrCreateMonitor() {
        if (this.monitor != null) {
            return this.monitor;
        }
        return new PojoMassIndexingLoggingMonitor();
    }
}

