/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.DocumentRouter;
import org.hibernate.search.mapper.pojo.route.DocumentRouteDescriptor;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoLoadingPlanProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexingPlanDelegate;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

public class PojoIndexedTypeIndexingPlan<I, E>
extends AbstractPojoTypeIndexingPlan<I, E, IndexedEntityState> {
    private final PojoWorkIndexedTypeContext<I, E> typeContext;

    public PojoIndexedTypeIndexingPlan(PojoWorkIndexedTypeContext<I, E> typeContext, PojoWorkSessionContext sessionContext, PojoTypeIndexingPlanDelegate<I, E> delegate) {
        super(sessionContext, delegate);
        this.typeContext = typeContext;
    }

    void updateBecauseOfContained(Object entity) {
        Supplier entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        Object identifier = this.typeContext.identifierMapping().getIdentifier(null, entitySupplier);
        ((IndexedEntityState)this.getState(identifier)).updateBecauseOfContained(entitySupplier);
    }

    @Override
    void resolveDirty(PojoLoadingPlanProvider loadingPlanProvider, PojoReindexingCollector collector, boolean deleteOnly) {
        ArrayList frozenIndexingPlansPerId = new ArrayList(this.statesPerId.values());
        for (IndexedEntityState state : frozenIndexingPlansPerId) {
            state.resolveDirty(loadingPlanProvider, collector, deleteOnly);
        }
    }

    @Override
    PojoWorkIndexedTypeContext<I, E> typeContext() {
        return this.typeContext;
    }

    @Override
    DocumentRouter<? super E> router() {
        return this.typeContext.router();
    }

    @Override
    protected IndexedEntityState createState(I identifier) {
        return new IndexedEntityState(identifier);
    }

    class IndexedEntityState
    extends AbstractPojoTypeIndexingPlan.AbstractEntityState {
        private DocumentRoutesDescriptor providedRoutes;

        private IndexedEntityState(I identifier) {
            super(PojoIndexedTypeIndexingPlan.this, identifier);
        }

        @Override
        void providedRoutes(DocumentRoutesDescriptor routes) {
            if (routes == null) {
                return;
            }
            if (this.providedRoutes == null) {
                this.providedRoutes = routes;
            } else {
                LinkedHashSet<DocumentRouteDescriptor> mergedPrevious = new LinkedHashSet<DocumentRouteDescriptor>(this.providedRoutes.previousRoutes());
                mergedPrevious.addAll(routes.previousRoutes());
                this.providedRoutes = DocumentRoutesDescriptor.of(routes.currentRoute(), mergedPrevious);
            }
        }

        @Override
        DocumentRoutesDescriptor providedRoutes() {
            return this.providedRoutes;
        }
    }
}

