/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl;

import java.util.Optional;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.EntityIdHashRangeOutboxEventPredicate;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEventFinder;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEventFinderProvider;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEventPredicate;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.impl.Murmur3HashFunction;
import org.hibernate.search.util.common.data.impl.RangeCompatibleHashFunction;
import org.hibernate.search.util.common.data.impl.RangeHashTable;

final class ShardAssignment {
    public static final RangeCompatibleHashFunction HASH_FUNCTION = Murmur3HashFunction.INSTANCE;
    final ShardAssignmentDescriptor descriptor;
    final OutboxEventFinder eventFinder;

    public static ShardAssignment of(ShardAssignmentDescriptor descriptor, OutboxEventFinderProvider finderProvider) {
        Optional<OutboxEventPredicate> predicate;
        if (descriptor.totalShardCount == 1) {
            predicate = Optional.empty();
        } else {
            RangeHashTable hashTable = new RangeHashTable(HASH_FUNCTION, descriptor.totalShardCount);
            Range entityIdHashRange = hashTable.rangeForBucket(descriptor.assignedShardIndex);
            predicate = Optional.of(new EntityIdHashRangeOutboxEventPredicate((Range<Integer>)entityIdHashRange));
        }
        return new ShardAssignment(descriptor, finderProvider.create(predicate));
    }

    ShardAssignment(ShardAssignmentDescriptor descriptor, OutboxEventFinder eventFinder) {
        this.descriptor = descriptor;
        this.eventFinder = eventFinder;
    }

    public String toString() {
        return this.descriptor.toString();
    }
}

