/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.DynamicNameMappers;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.security.CredentialReferenceWriteAttributeHandler;
import org.wildfly.extension.messaging.activemq.AbstractTransportDefinition;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryRemove;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryService;

public class PooledConnectionFactoryDefinition
extends PersistentResourceDefinition {
    static final String CAPABILITY_NAME = "org.wildfly.messaging.activemq.server.pooled-connection-factory";
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.messaging.activemq.server.pooled-connection-factory", (boolean)true, PooledConnectionFactoryService.class).setDynamicNameMapper(DynamicNameMappers.PARENT).build();
    public static final ConnectionFactoryAttribute[] ATTRIBUTES = PooledConnectionFactoryDefinition.define(ConnectionFactoryAttributes.Pooled.ATTRIBUTES, ConnectionFactoryAttributes.Common.ATTRIBUTES);
    private final boolean deployed;
    private final boolean external;
    public static final PooledConnectionFactoryDefinition INSTANCE = new PooledConnectionFactoryDefinition(false);
    public static final PooledConnectionFactoryDefinition DEPLOYMENT_INSTANCE = new PooledConnectionFactoryDefinition(true);

    private static ConnectionFactoryAttribute[] define(ConnectionFactoryAttribute[] specific, ConnectionFactoryAttribute ... common) {
        int size = common.length + specific.length;
        ConnectionFactoryAttribute[] result = new ConnectionFactoryAttribute[size];
        System.arraycopy(specific, 0, result, 0, specific.length);
        for (int i = 0; i < common.length; ++i) {
            ConnectionFactoryAttribute newAttr;
            AttributeDefinition copy;
            ConnectionFactoryAttribute attr = common[i];
            AttributeDefinition definition = attr.getDefinition();
            if (definition == ConnectionFactoryAttributes.Common.RECONNECT_ATTEMPTS) {
                copy = PooledConnectionFactoryDefinition.copy(ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS, AttributeAccess.Flag.RESTART_ALL_SERVICES);
                newAttr = ConnectionFactoryAttribute.create(copy, "reconnectAttempts", true);
            } else if (definition == ConnectionFactoryAttributes.Common.CONNECTORS) {
                copy = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(ConnectionFactoryAttributes.Common.CONNECTORS).setAlternatives(new String[]{"discovery-group"})).setRequired(true)).setAttributeParser(AttributeParser.STRING_LIST)).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setCapabilityReference((CapabilityReferenceRecorder)new AbstractTransportDefinition.TransportCapabilityReferenceRecorder(CAPABILITY_NAME, "org.wildfly.messaging.activemq.connector", false))).setRestartAllServices()).build();
                newAttr = ConnectionFactoryAttribute.create(copy, attr.getPropertyName(), attr.isResourceAdapterProperty(), attr.getConfigType());
            } else {
                copy = PooledConnectionFactoryDefinition.copy(definition, AttributeAccess.Flag.RESTART_ALL_SERVICES);
                newAttr = ConnectionFactoryAttribute.create(copy, attr.getPropertyName(), attr.isResourceAdapterProperty(), attr.getConfigType());
            }
            result[specific.length + i] = newAttr;
        }
        return result;
    }

    private static AttributeDefinition copy(AttributeDefinition attribute, AttributeAccess.Flag flag) {
        Object builder = attribute instanceof SimpleListAttributeDefinition ? new SimpleListAttributeDefinition.Builder((SimpleListAttributeDefinition)attribute) : (attribute instanceof SimpleMapAttributeDefinition ? new SimpleMapAttributeDefinition.Builder((SimpleMapAttributeDefinition)attribute) : (attribute instanceof PrimitiveListAttributeDefinition ? new PrimitiveListAttributeDefinition.Builder((PrimitiveListAttributeDefinition)attribute) : new SimpleAttributeDefinitionBuilder((SimpleAttributeDefinition)attribute)));
        builder.setFlags(new AttributeAccess.Flag[]{flag});
        return builder.build();
    }

    public static Map<String, ConnectionFactoryAttribute> getAttributesMap() {
        HashMap<String, ConnectionFactoryAttribute> attrs = new HashMap<String, ConnectionFactoryAttribute>(ATTRIBUTES.length);
        for (ConnectionFactoryAttribute attribute : ATTRIBUTES) {
            attrs.put(attribute.getDefinition().getName(), attribute);
        }
        return attrs;
    }

    public PooledConnectionFactoryDefinition(boolean deployed) {
        this(new SimpleResourceDefinition.Parameters(MessagingExtension.POOLED_CONNECTION_FACTORY_PATH, MessagingExtension.getResourceDescriptionResolver("pooled-connection-factory")).setAddHandler((OperationStepHandler)PooledConnectionFactoryAdd.INSTANCE).setRemoveHandler((OperationStepHandler)PooledConnectionFactoryRemove.INSTANCE).setCapabilities(new RuntimeCapability[]{CAPABILITY}), deployed);
    }

    protected PooledConnectionFactoryDefinition(SimpleResourceDefinition.Parameters parameters, boolean deployed) {
        this(parameters, deployed, false);
    }

    protected PooledConnectionFactoryDefinition(SimpleResourceDefinition.Parameters parameters, boolean deployed, boolean external) {
        super(parameters);
        this.deployed = deployed;
        this.external = external;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ConnectionFactoryAttribute.getDefinitions(ATTRIBUTES));
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        Collection<AttributeDefinition> definitions = this.getAttributes();
        ReloadRequiredWriteAttributeHandler reloadRequiredWriteAttributeHandler = new ReloadRequiredWriteAttributeHandler(definitions);
        CredentialReferenceWriteAttributeHandler credentialReferenceWriteAttributeHandler = new CredentialReferenceWriteAttributeHandler((AttributeDefinition)ConnectionFactoryAttributes.Pooled.CREDENTIAL_REFERENCE);
        for (AttributeDefinition attr : definitions) {
            if (attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            if (this.deployed) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)(this.external ? PooledConnectionFactoryConfigurationRuntimeHandler.EXTERNAL_INSTANCE : PooledConnectionFactoryConfigurationRuntimeHandler.INSTANCE));
                continue;
            }
            if (ConnectionFactoryAttributes.Pooled.CREDENTIAL_REFERENCE.equals(attr)) {
                registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)credentialReferenceWriteAttributeHandler);
                continue;
            }
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)reloadRequiredWriteAttributeHandler);
        }
        ConnectionFactoryAttributes.registerAliasAttribute(registry, this.deployed, ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST, ConnectionFactoryAttributes.Common.DESERIALIZATION_ALLOWLIST.getName());
        ConnectionFactoryAttributes.registerAliasAttribute(registry, this.deployed, ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST, ConnectionFactoryAttributes.Common.DESERIALIZATION_BLOCKLIST.getName());
    }
}

