/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.dataconversion;

import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.commons.dataconversion.MediaType;
import org.jboss.modules.Module;

public enum MediaTypeFactory implements Function<ClassLoader, Map.Entry<MediaType, MediaType>>
{
    INSTANCE;

    private static final String MEDIA_TYPE_PATTERN = "application/%s; type=%s";
    private static final Map.Entry<MediaType, MediaType> DEFAULT_MEDIA_TYPES;

    @Override
    public Map.Entry<MediaType, MediaType> apply(ClassLoader loader) {
        Module module = Module.forClassLoader((ClassLoader)loader, (boolean)false);
        if (module == null || !module.getName().startsWith("deployment.")) {
            return DEFAULT_MEDIA_TYPES;
        }
        String moduleName = module.getName().replaceAll("/", "|");
        MediaType keyMediaType = MediaType.fromString((String)String.format(Locale.ROOT, MEDIA_TYPE_PATTERN, moduleName, "key"));
        MediaType valueMediaType = MediaType.fromString((String)String.format(Locale.ROOT, MEDIA_TYPE_PATTERN, moduleName, "value"));
        return Map.entry(keyMediaType, valueMediaType);
    }

    static {
        DEFAULT_MEDIA_TYPES = Map.entry(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OBJECT);
    }
}

