/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.group.impl;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.group.Group;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.distribution.group.impl.CacheEntryGroupPredicate;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.distribution.group.impl.GroupingPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class GroupManagerImpl
implements GroupManager {
    private static final Log log = LogFactory.getLog(GroupManagerImpl.class);
    @Inject
    ComponentRegistry componentRegistry;
    @Inject
    ComponentRef<EntryFactory> entryFactory;
    @Inject
    ComponentRef<VersionGenerator> versionGenerator;
    private final ConcurrentMap<Class<?>, GroupMetadata> groupMetadataCache = new ConcurrentHashMap();
    private final List<Grouper<?>> groupers;

    public GroupManagerImpl(Configuration configuration) {
        this.groupers = configuration.clustering().hash().groups().groupers() != null ? configuration.clustering().hash().groups().groupers() : Collections.emptyList();
    }

    @Override
    public Object getGroup(Object key) {
        GroupMetadata metadata = this.getMetadata(key);
        if (metadata != null) {
            return this.applyGroupers(metadata.getGroup(key), key);
        }
        return this.applyGroupers(null, key);
    }

    @Override
    public <K, V> Map<K, V> collect(CacheStream<? extends CacheEntry<K, V>> stream, InvocationContext ctx, String groupName) {
        CacheEntryGroupPredicate predicate = new CacheEntryGroupPredicate(groupName);
        predicate.inject(this.componentRegistry);
        List list = (List)stream.filterKeySegments(IntSets.immutableSet((int)this.groupSegment(groupName))).filter(predicate).collect(Collectors::toList);
        return ctx.isInTxScope() ? this.handleTxGetGroup((TxInvocationContext)ctx, list, groupName) : this.handleNoTxGetGroup(list, groupName);
    }

    private <V, K> Map<K, V> handleNoTxGetGroup(List<? extends CacheEntry<K, V>> entries, String groupName) {
        boolean trace = log.isTraceEnabled();
        HashMap group = new HashMap();
        entries.forEach(e -> {
            if (trace) {
                log.tracef("Found entry belonging to group %s: %s", groupName, e);
            }
            group.put(e.getKey(), e.getValue());
        });
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V, K> Map<K, V> handleTxGetGroup(TxInvocationContext<?> ctx, List<? extends CacheEntry<K, V>> entries, String groupName) {
        boolean trace = log.isTraceEnabled();
        TxInvocationContext<?> txInvocationContext = ctx;
        synchronized (txInvocationContext) {
            HashMap group = new HashMap();
            entries.forEach(e -> {
                if (ctx.lookupEntry(e.getKey()) == null) {
                    this.entryFactory.running().wrapExternalEntry(ctx, e.getKey(), (CacheEntry)e, true, false);
                    WriteSkewHelper.addVersionRead(ctx, e, e.getKey(), this.versionGenerator.running(), log);
                }
                if (trace) {
                    log.tracef("Found entry belonging to group %s: %s", groupName, e);
                }
                group.put(e.getKey(), e.getValue());
            });
            return group;
        }
    }

    private int groupSegment(String groupName) {
        KeyPartitioner keyPartitioner = this.componentRegistry.getComponent(KeyPartitioner.class);
        if (keyPartitioner instanceof GroupingPartitioner) {
            return ((GroupingPartitioner)keyPartitioner).unwrap().getSegment(groupName);
        }
        return keyPartitioner.getSegment(groupName);
    }

    private static GroupMetadata createGroupMetadata(Class<?> clazz) {
        Collection possibleMethods = System.getSecurityManager() == null ? ReflectionUtil.getAllMethods(clazz, Group.class) : (Collection)AccessController.doPrivileged(() -> ReflectionUtil.getAllMethods((Class)clazz, Group.class));
        if (possibleMethods.isEmpty()) {
            return GroupMetadata.NONE;
        }
        if (possibleMethods.size() == 1) {
            return new GroupMetadataImpl((Method)possibleMethods.iterator().next());
        }
        throw new IllegalStateException(Util.formatString((Object)"Cannot define more that one @Group method for class hierarchy rooted at %s", (Object[])new Object[]{clazz.getName()}));
    }

    private Object applyGroupers(Object group, Object key) {
        for (Grouper<?> grouper : this.groupers) {
            if (!grouper.getKeyType().isAssignableFrom(key.getClass())) continue;
            group = grouper.computeGroup(key, group);
        }
        return group;
    }

    private GroupMetadata getMetadata(Object key) {
        GroupMetadata previous;
        Class<?> keyClass = key.getClass();
        GroupMetadata groupMetadata = (GroupMetadata)this.groupMetadataCache.get(keyClass);
        if (groupMetadata == null && (previous = this.groupMetadataCache.putIfAbsent(keyClass, groupMetadata = GroupManagerImpl.createGroupMetadata(keyClass))) != null) {
            return previous;
        }
        return groupMetadata;
    }

    private static class GroupMetadataImpl
    implements GroupMetadata {
        private final Method method;

        GroupMetadataImpl(Method method) {
            if (method.getParameterCount() > 0) {
                throw new IllegalArgumentException(Util.formatString((Object)"@Group method %s must have zero arguments", (Object[])new Object[]{method}));
            }
            this.method = method;
        }

        @Override
        public Object getGroup(Object instance) {
            if (System.getSecurityManager() == null) {
                this.method.setAccessible(true);
            } else {
                AccessController.doPrivileged(() -> {
                    this.method.setAccessible(true);
                    return null;
                });
            }
            return ReflectionUtil.invokeMethod((Object)instance, (Method)this.method, (Object[])Util.EMPTY_OBJECT_ARRAY);
        }
    }

    @FunctionalInterface
    private static interface GroupMetadata {
        public static final GroupMetadata NONE = instance -> null;

        public Object getGroup(Object var1);
    }
}

