/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.metrics.MetricsProvider;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@Singleton
public class MicroProfileMetricsProvider
implements MetricsProvider {
    static final Metadata TIMEOUT_EXECUTION_DURATION_METADATA = Metadata.builder().withName("ft.timeout.executionDuration").withType(MetricType.HISTOGRAM).withUnit("nanoseconds").build();
    static final Metadata BULKHEAD_RUNNING_DURATION_METADATA = Metadata.builder().withName("ft.bulkhead.runningDuration").withType(MetricType.HISTOGRAM).withUnit("nanoseconds").build();
    static final Metadata BULKHEAD_WAITING_DURATION_METADATA = Metadata.builder().withName("ft.bulkhead.waitingDuration").withType(MetricType.HISTOGRAM).withUnit("nanoseconds").build();
    static final Tag RESULT_VALUE_RETURNED = new Tag("result", "valueReturned");
    static final Tag RESULT_EXCEPTION_THROWN = new Tag("result", "exceptionThrown");
    static final Tag FALLBACK_APPLIED = new Tag("fallback", "applied");
    static final Tag FALLBACK_NOT_APPLIED = new Tag("fallback", "notApplied");
    static final Tag FALLBACK_NOT_DEFINED = new Tag("fallback", "notDefined");
    static final Tag RETRIED_TRUE = new Tag("retried", "true");
    static final Tag RETRIED_FALSE = new Tag("retried", "false");
    static final Tag RETRY_RESULT_VALUE_RETURNED = new Tag("retryResult", "valueReturned");
    static final Tag RETRY_RESULT_EXCEPTION_NOT_RETRYABLE = new Tag("retryResult", "exceptionNotRetryable");
    static final Tag RETRY_RESULT_MAX_RETRIES_REACHED = new Tag("retryResult", "maxRetriesReached");
    static final Tag RETRY_RESULT_MAX_DURATION_REACHED = new Tag("retryResult", "maxDurationReached");
    static final Tag TIMED_OUT_TRUE = new Tag("timedOut", "true");
    static final Tag TIMED_OUT_FALSE = new Tag("timedOut", "false");
    static final Tag CIRCUIT_BREAKER_RESULT_SUCCESS = new Tag("circuitBreakerResult", "success");
    static final Tag CIRCUIT_BREAKER_RESULT_FAILURE = new Tag("circuitBreakerResult", "failure");
    static final Tag CIRCUIT_BREAKER_RESULT_CB_OPEN = new Tag("circuitBreakerResult", "circuitBreakerOpen");
    static final Tag CIRCUIT_BREAKER_STATE_CLOSED = new Tag("state", "closed");
    static final Tag CIRCUIT_BREAKER_STATE_OPEN = new Tag("state", "open");
    static final Tag CIRCUIT_BREAKER_STATE_HALF_OPEN = new Tag("state", "halfOpen");
    static final Tag BULKHEAD_RESULT_ACCEPTED = new Tag("bulkheadResult", "accepted");
    static final Tag BULKHEAD_RESULT_REJECTED = new Tag("bulkheadResult", "rejected");
    @Inject
    @RegistryType(type=MetricRegistry.Type.BASE)
    MetricRegistry registry;
    @Inject
    @ConfigProperty(name="MP_Fault_Tolerance_Metrics_Enabled", defaultValue="true")
    boolean metricsEnabled;
    @Inject
    SpecCompatibility specCompatibility;

    @Override
    public MetricsRecorder create(FaultToleranceOperation operation) {
        if (this.metricsEnabled) {
            return new MetricsRecorderImpl(this.registry, this.specCompatibility, operation);
        }
        return MetricsRecorder.NOOP;
    }

    @Override
    public boolean isEnabled() {
        return this.metricsEnabled;
    }

    private static class MetricsRecorderImpl
    implements MetricsRecorder {
        private final MetricRegistry registry;
        private final Tag methodTag;

        MetricsRecorderImpl(MetricRegistry registry, SpecCompatibility specCompatibility, FaultToleranceOperation operation) {
            this.registry = registry;
            this.methodTag = new Tag("method", operation.getName());
            this.registerMetrics(specCompatibility, operation);
        }

        private void registerMetrics(SpecCompatibility specCompatibility, FaultToleranceOperation operation) {
            if (operation.hasFallback()) {
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_VALUE_RETURNED, FALLBACK_NOT_APPLIED}).getCount();
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_VALUE_RETURNED, FALLBACK_APPLIED}).getCount();
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_EXCEPTION_THROWN, FALLBACK_NOT_APPLIED}).getCount();
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_EXCEPTION_THROWN, FALLBACK_APPLIED}).getCount();
            } else {
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_VALUE_RETURNED, FALLBACK_NOT_DEFINED}).getCount();
                this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_EXCEPTION_THROWN, FALLBACK_NOT_DEFINED}).getCount();
            }
            if (operation.hasRetry()) {
                this.registry.counter("ft.retry.retries.total", new Tag[]{this.methodTag}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_FALSE, RETRY_RESULT_VALUE_RETURNED}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_FALSE, RETRY_RESULT_EXCEPTION_NOT_RETRYABLE}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_FALSE, RETRY_RESULT_MAX_RETRIES_REACHED}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_FALSE, RETRY_RESULT_MAX_DURATION_REACHED}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_TRUE, RETRY_RESULT_VALUE_RETURNED}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_TRUE, RETRY_RESULT_EXCEPTION_NOT_RETRYABLE}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_TRUE, RETRY_RESULT_MAX_RETRIES_REACHED}).getCount();
                this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_TRUE, RETRY_RESULT_MAX_DURATION_REACHED}).getCount();
            }
            if (operation.hasTimeout()) {
                this.registry.counter("ft.timeout.calls.total", new Tag[]{this.methodTag, TIMED_OUT_TRUE}).getCount();
                this.registry.counter("ft.timeout.calls.total", new Tag[]{this.methodTag, TIMED_OUT_FALSE}).getCount();
                this.registry.histogram(TIMEOUT_EXECUTION_DURATION_METADATA, new Tag[]{this.methodTag}).getCount();
            }
            if (operation.hasCircuitBreaker()) {
                this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, CIRCUIT_BREAKER_RESULT_SUCCESS}).getCount();
                this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, CIRCUIT_BREAKER_RESULT_FAILURE}).getCount();
                this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, CIRCUIT_BREAKER_RESULT_CB_OPEN}).getCount();
                this.registry.counter("ft.circuitbreaker.opened.total", new Tag[]{this.methodTag}).getCount();
            }
            if (operation.hasBulkhead()) {
                this.registry.counter("ft.bulkhead.calls.total", new Tag[]{this.methodTag, BULKHEAD_RESULT_ACCEPTED}).getCount();
                this.registry.counter("ft.bulkhead.calls.total", new Tag[]{this.methodTag, BULKHEAD_RESULT_REJECTED}).getCount();
                this.registry.histogram(BULKHEAD_RUNNING_DURATION_METADATA, new Tag[]{this.methodTag}).getCount();
                if (specCompatibility.isOperationTrulyOrPseudoAsynchronous(operation)) {
                    this.registry.histogram(BULKHEAD_WAITING_DURATION_METADATA, new Tag[]{this.methodTag}).getCount();
                }
            }
        }

        private void registerGauge(Supplier<Long> supplier, String name, String unit, Tag ... tags) {
            Metadata metadata = Metadata.builder().withName(name).withType(MetricType.GAUGE).withUnit(unit).build();
            this.registry.gauge(metadata, supplier, tags);
        }

        public void executionFinished(boolean succeeded, boolean fallbackDefined, boolean fallbackApplied) {
            Tag resultTag;
            Tag tag = resultTag = succeeded ? RESULT_VALUE_RETURNED : RESULT_EXCEPTION_THROWN;
            Tag fallbackTag = fallbackDefined ? (fallbackApplied ? FALLBACK_APPLIED : FALLBACK_NOT_APPLIED) : FALLBACK_NOT_DEFINED;
            this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, resultTag, fallbackTag}).inc();
        }

        public void retryAttempted() {
            this.registry.counter("ft.retry.retries.total", new Tag[]{this.methodTag}).inc();
        }

        public void retryValueReturned(boolean retried) {
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_VALUE_RETURNED}).inc();
        }

        public void retryExceptionNotRetryable(boolean retried) {
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_EXCEPTION_NOT_RETRYABLE}).inc();
        }

        public void retryMaxRetriesReached(boolean retried) {
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_MAX_RETRIES_REACHED}).inc();
        }

        public void retryMaxDurationReached(boolean retried) {
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_MAX_DURATION_REACHED}).inc();
        }

        public void timeoutFinished(boolean timedOut, long time) {
            this.registry.counter("ft.timeout.calls.total", new Tag[]{this.methodTag, timedOut ? TIMED_OUT_TRUE : TIMED_OUT_FALSE}).inc();
            this.registry.histogram(TIMEOUT_EXECUTION_DURATION_METADATA, new Tag[]{this.methodTag}).update(time);
        }

        public void circuitBreakerFinished(CircuitBreakerEvents.Result result) {
            Tag circuitBreakerResultTag = null;
            switch (result) {
                case SUCCESS: {
                    circuitBreakerResultTag = CIRCUIT_BREAKER_RESULT_SUCCESS;
                    break;
                }
                case FAILURE: {
                    circuitBreakerResultTag = CIRCUIT_BREAKER_RESULT_FAILURE;
                    break;
                }
                case PREVENTED: {
                    circuitBreakerResultTag = CIRCUIT_BREAKER_RESULT_CB_OPEN;
                }
            }
            this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, circuitBreakerResultTag}).inc();
        }

        public void circuitBreakerMovedToOpen() {
            this.registry.counter("ft.circuitbreaker.opened.total", new Tag[]{this.methodTag}).inc();
        }

        public void registerCircuitBreakerTimeSpentInClosed(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, CIRCUIT_BREAKER_STATE_CLOSED);
        }

        public void registerCircuitBreakerTimeSpentInOpen(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, CIRCUIT_BREAKER_STATE_OPEN);
        }

        public void registerCircuitBreakerTimeSpentInHalfOpen(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, CIRCUIT_BREAKER_STATE_HALF_OPEN);
        }

        public void bulkheadDecisionMade(boolean accepted) {
            Tag bulkheadResultTag = accepted ? BULKHEAD_RESULT_ACCEPTED : BULKHEAD_RESULT_REJECTED;
            this.registry.counter("ft.bulkhead.calls.total", new Tag[]{this.methodTag, bulkheadResultTag}).inc();
        }

        public void registerBulkheadExecutionsRunning(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.bulkhead.executionsRunning", "none", this.methodTag);
        }

        public void registerBulkheadExecutionsWaiting(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.bulkhead.executionsWaiting", "none", this.methodTag);
        }

        public void updateBulkheadRunningDuration(long time) {
            this.registry.histogram(BULKHEAD_RUNNING_DURATION_METADATA, new Tag[]{this.methodTag}).update(time);
        }

        public void updateBulkheadWaitingDuration(long time) {
            this.registry.histogram(BULKHEAD_WAITING_DURATION_METADATA, new Tag[]{this.methodTag}).update(time);
        }
    }
}

