/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.activation;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.PrintStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.activation.ActivationSequenceUtils;
import org.apache.activemq.artemis.cli.commands.tools.LockAbstract;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.quorum.DistributedLock;
import org.apache.activemq.artemis.quorum.DistributedPrimitiveManager;
import org.apache.activemq.artemis.quorum.MutableLong;

@Command(name="list", description="list local and/or coordinated activation sequences")
public class ActivationSequenceList
extends LockAbstract {
    private static final int MANAGER_START_TIMEOUT_SECONDS = 60;
    @Option(name={"--node-id"}, description="This can be used just with --remote option. If not set, broker NodeID is used instead")
    public String nodeId = null;
    @Option(name={"--remote"}, description="List just coordinated activation sequence")
    public boolean remote = false;
    @Option(name={"--local"}, description="List just local activation sequence")
    public boolean local = false;

    @Override
    public Object execute(ActionContext context) throws Exception {
        Object output = super.execute(context);
        ActivationSequenceList.execute(this, (Configuration)this.getFileConfiguration(), context.out);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListResult execute(ActivationSequenceList command, Configuration config, PrintStream out) throws Exception {
        DistributedPrimitiveManagerConfiguration managerConfiguration;
        String nodeId = command.nodeId;
        boolean remote = command.remote;
        boolean local = command.local;
        if (remote && local) {
            throw new IllegalArgumentException("--local and --remote cannot be both present: to list both sequences just drop both options");
        }
        if (nodeId != null && !command.remote) {
            throw new IllegalArgumentException("--node-id must be used just with --remote");
        }
        HAPolicyConfiguration policyConfig = config.getHAPolicyConfiguration();
        String coordinationId = null;
        if (policyConfig instanceof ReplicationBackupPolicyConfiguration) {
            ReplicationBackupPolicyConfiguration backupPolicyConfig = (ReplicationBackupPolicyConfiguration)policyConfig;
            managerConfiguration = backupPolicyConfig.getDistributedManagerConfiguration();
        } else if (policyConfig instanceof ReplicationPrimaryPolicyConfiguration) {
            ReplicationPrimaryPolicyConfiguration primaryPolicyConfig = (ReplicationPrimaryPolicyConfiguration)policyConfig;
            managerConfiguration = primaryPolicyConfig.getDistributedManagerConfiguration();
            if (primaryPolicyConfig.getCoordinationId() != null) {
                coordinationId = primaryPolicyConfig.getCoordinationId();
            }
        } else {
            throw new UnsupportedOperationException("This command support just <primary> or <backup> replication configuration");
        }
        Objects.requireNonNull(managerConfiguration);
        FileLockNodeManager nodeManager = null;
        if (nodeId == null) {
            nodeManager = new FileLockNodeManager(config.getNodeManagerLockLocation(), false);
            nodeManager.start();
        }
        try {
            if (!(nodeManager == null || coordinationId == null || nodeManager.getNodeId() != null && nodeManager.getNodeId().toString().equals(coordinationId))) {
                nodeManager = ActivationSequenceUtils.applyCoordinationId(coordinationId, (NodeManager)nodeManager, config.getNodeManagerLockLocation());
            }
            Long localSequence = null;
            if (nodeManager != null) {
                assert (nodeId == null);
                nodeId = nodeManager.getNodeId().toString();
            } else assert (nodeId != null);
            if (!remote && nodeManager != null) {
                long localActivationSequence = nodeManager.getNodeActivationSequence();
                if (localActivationSequence == -1L) {
                    if (out != null) {
                        out.println("No local activation sequence for NodeID=" + nodeId);
                    }
                } else {
                    localSequence = localActivationSequence;
                    if (out != null) {
                        out.println("Local activation sequence for NodeID=" + nodeId + ": " + localActivationSequence);
                    }
                }
            }
            Long coordinatedSequence = null;
            if (!local) {
                try (DistributedPrimitiveManager manager = DistributedPrimitiveManager.newInstanceOf((String)managerConfiguration.getClassName(), (Map)managerConfiguration.getProperties());){
                    if (!manager.start(60L, TimeUnit.SECONDS)) {
                        throw new IllegalStateException("distributed manager isn't started in 60 seconds");
                    }
                    try (MutableLong coordinatedActivationSequence = manager.getMutableLong(nodeId);
                         DistributedLock liveLock = manager.getDistributedLock(nodeId);){
                        if (!liveLock.tryLock()) {
                            throw new IllegalStateException("Cannot safely get the coordinated activation sequence for NodeID=" + nodeId + ": maybe the live lock is still held.");
                        }
                        coordinatedSequence = coordinatedActivationSequence.get();
                        if (out != null) {
                            out.println("Coordinated activation sequence for NodeID=" + nodeId + ": " + coordinatedSequence);
                        }
                    }
                }
            }
            ListResult listResult = new ListResult(nodeId, coordinatedSequence, localSequence);
            return listResult;
        }
        finally {
            if (nodeManager != null) {
                nodeManager.stop();
            }
        }
    }

    public static final class ListResult {
        public final String nodeId;
        public final Long coordinatedActivationSequence;
        public final Long localActivationSequence;

        private ListResult(String nodeId, Long coordinatedActivationSequence, Long localActivationSequence) {
            this.nodeId = nodeId;
            this.coordinatedActivationSequence = coordinatedActivationSequence;
            this.localActivationSequence = localActivationSequence;
        }
    }
}

