/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkBulker;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.BulkResult;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;

class ElasticsearchDefaultWorkBulker
implements ElasticsearchWorkBulker {
    private final ElasticsearchWorkSequenceBuilder sequenceBuilder;
    private final BiFunction<List<? extends BulkableWork<?>>, DocumentRefreshStrategy, NonBulkableWork<BulkResult>> bulkWorkFactory;
    private final int maxBulkSize;
    private final List<BulkableWork<?>> currentBulkItems;
    private DocumentRefreshStrategy currentBulkRefreshStrategy;
    private CompletableFuture<NonBulkableWork<BulkResult>> currentBulkWorkFuture;
    private CompletableFuture<BulkResult> currentBulkResultFuture;

    public ElasticsearchDefaultWorkBulker(ElasticsearchWorkSequenceBuilder sequenceBuilder, BiFunction<List<? extends BulkableWork<?>>, DocumentRefreshStrategy, NonBulkableWork<BulkResult>> bulkWorkFactory, int maxBulkSize) {
        this.sequenceBuilder = sequenceBuilder;
        this.bulkWorkFactory = bulkWorkFactory;
        this.maxBulkSize = maxBulkSize;
        this.currentBulkItems = new ArrayList();
        this.currentBulkWorkFuture = null;
        this.currentBulkResultFuture = null;
    }

    @Override
    public <T> CompletableFuture<T> add(BulkableWork<T> work) {
        DocumentRefreshStrategy workRefreshStrategy = work.getRefreshStrategy();
        if (this.currentBulkItems.isEmpty()) {
            this.currentBulkRefreshStrategy = workRefreshStrategy;
        } else if (this.currentBulkRefreshStrategy != workRefreshStrategy) {
            this.finalizeBulkWork();
            this.currentBulkRefreshStrategy = workRefreshStrategy;
        }
        if (this.currentBulkWorkFuture == null) {
            this.currentBulkWorkFuture = new CompletableFuture();
            this.currentBulkResultFuture = this.sequenceBuilder.addBulkExecution(this.currentBulkWorkFuture);
        }
        int currentBulkWorkIndex = this.currentBulkItems.size();
        this.currentBulkItems.add(work);
        CompletableFuture<T> future = this.sequenceBuilder.addBulkResultExtraction(this.currentBulkResultFuture, work, currentBulkWorkIndex);
        if (this.currentBulkItems.size() >= this.maxBulkSize) {
            this.finalizeBulkWork();
        }
        return future;
    }

    @Override
    public void finalizeBulkWork() {
        if (this.currentBulkWorkFuture == null) {
            return;
        }
        NonBulkableWork<BulkResult> bulkWork = this.bulkWorkFactory.apply(this.currentBulkItems, this.currentBulkRefreshStrategy);
        this.currentBulkWorkFuture.complete(bulkWork);
        this.reset();
    }

    @Override
    public void reset() {
        this.currentBulkItems.clear();
        this.currentBulkRefreshStrategy = null;
        this.currentBulkWorkFuture = null;
        this.currentBulkResultFuture = null;
    }
}

