/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.resource.ClientResourceInfo;
import com.sun.faces.application.resource.FaceletResourceInfo;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ResourceManager;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.Resource;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.MappingMatch;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceImpl
extends Resource
implements Externalizable {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String RFC1123_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private transient ResourceInfo resourceInfo;
    private transient Map<String, String> responseHeaders;
    private long initialTime;
    private long maxAge;
    private URL resolvedUrl = null;

    public ResourceImpl() {
    }

    public ResourceImpl(ResourceInfo resourceInfo, String contentType, long initialTime, long maxAge) {
        this.resourceInfo = resourceInfo;
        super.setResourceName(resourceInfo.getName());
        super.setLibraryName(resourceInfo.getLibraryInfo() != null ? resourceInfo.getLibraryInfo().getName() : null);
        super.setContentType(contentType);
        this.initialTime = initialTime;
        this.maxAge = maxAge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceImpl resource = (ResourceImpl)o;
        return this.resourceInfo.equals(resource.resourceInfo);
    }

    public int hashCode() {
        return this.resourceInfo.hashCode();
    }

    public InputStream getInputStream() throws IOException {
        this.initResourceInfo();
        return this.resourceInfo.getHelper().getInputStream(this.resourceInfo, FacesContext.getCurrentInstance());
    }

    public URL getURL() {
        URL url;
        if (this.resolvedUrl != null) {
            return this.resolvedUrl;
        }
        this.resolvedUrl = url = this.resourceInfo.getHelper().getURL(this.resourceInfo, FacesContext.getCurrentInstance());
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getResponseHeaders() {
        if (this.isResourceRequest()) {
            if (this.responseHeaders == null) {
                this.responseHeaders = new HashMap<String, String>(6, 1.0f);
            }
            if (FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development)) {
                this.responseHeaders.put("Cache-Control", "no-store, must-revalidate");
            } else {
                this.responseHeaders.put("Cache-Control", "max-age=" + this.maxAge / 1000L);
            }
            URL url = this.getURL();
            InputStream in = null;
            try {
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                conn.connect();
                in = conn.getInputStream();
                long lastModified = Util.getLastModified(url);
                long contentLength = conn.getContentLength();
                if (lastModified == 0L) {
                    lastModified = this.initialTime;
                }
                SimpleDateFormat format = new SimpleDateFormat(RFC1123_DATE_PATTERN, Locale.US);
                format.setTimeZone(GMT);
                this.responseHeaders.put("Last-Modified", format.format(new Date(lastModified)));
                if (lastModified != 0L && contentLength != -1L) {
                    this.responseHeaders.put("ETag", "W/\"" + contentLength + "-" + lastModified + "\"");
                }
            }
            catch (IOException ioe) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Closing stream", ioe);
                }
            }
            finally {
                block20: {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block20;
                            LOGGER.log(Level.FINEST, "Closing stream", ioe);
                        }
                    }
                }
            }
            return this.responseHeaders;
        }
        return Collections.emptyMap();
    }

    public String getRequestPath() {
        String contract;
        String localePrefix;
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletMapping mapping = Util.getFacesMapping(context);
        String uri = null;
        if (mapping.getMappingMatch() == MappingMatch.EXACT) {
            String resource = "/jakarta.faces.resource/" + this.getResourceName();
            if (Util.isResourceExactMappedToFacesServlet(context.getExternalContext(), resource)) {
                uri = resource;
            } else {
                mapping = Util.getFirstWildCardMappingToFacesServlet(context.getExternalContext());
                if (mapping == null) {
                    throw new IllegalStateException("No suitable mapping for FacesServlet found. To serve resources FacesServlet should have at least one prefix or suffix mapping.");
                }
            }
        }
        if (uri == null) {
            uri = mapping.getMappingMatch() == MappingMatch.PATH ? mapping.getPattern().replace("/*", "/jakarta.faces.resource") + "/" + this.getResourceName() : "/jakarta.faces.resource/" + mapping.getPattern().replace("*", this.getResourceName());
        }
        boolean queryStarted = false;
        if (this.getLibraryName() != null) {
            queryStarted = true;
            uri = uri + "?ln=" + this.getLibraryName();
        }
        Object version = "";
        this.initResourceInfo();
        if (this.resourceInfo.getLibraryInfo() != null && this.resourceInfo.getLibraryInfo().getVersion() != null) {
            version = (String)version + this.resourceInfo.getLibraryInfo().getVersion().toString();
        }
        if (this.resourceInfo.getVersion() != null) {
            version = (String)version + this.resourceInfo.getVersion().toString();
        }
        if (((String)version).length() > 0) {
            uri = uri + (queryStarted ? "&v=" : "?v=") + (String)version;
            queryStarted = true;
        }
        if ((localePrefix = this.resourceInfo.getLocalePrefix()) != null) {
            uri = uri + (queryStarted ? "&loc=" : "?loc=") + localePrefix;
            queryStarted = true;
        }
        if ((contract = this.resourceInfo.getContract()) != null) {
            uri = uri + (queryStarted ? "&con=" : "?con=") + contract;
            queryStarted = true;
        }
        if ("faces.js".equals(this.getResourceName()) && "jakarta.faces".equals(this.getLibraryName())) {
            ProjectStage stage = context.getApplication().getProjectStage();
            switch (stage) {
                case Development: {
                    uri = uri + (queryStarted ? "&stage=Development" : "?stage=Development");
                    break;
                }
                case SystemTest: {
                    uri = uri + (queryStarted ? "&stage=SystemTest" : "?stage=SystemTest");
                    break;
                }
                case UnitTest: {
                    uri = uri + (queryStarted ? "&stage=UnitTest" : "?stage=UnitTest");
                    break;
                }
                default: {
                    assert (stage.equals((Object)ProjectStage.Production));
                    break;
                }
            }
        }
        return context.getApplication().getViewHandler().getResourceURL(context, uri);
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        if (this.resourceInfo instanceof FaceletResourceInfo) {
            return true;
        }
        Map requestHeaders = context.getExternalContext().getRequestHeaderMap();
        if (requestHeaders.containsKey(IF_MODIFIED_SINCE)) {
            this.initResourceInfo();
            long lastModifiedOfResource = ((ClientResourceInfo)this.resourceInfo).getLastModified(context) / 1000L * 1000L;
            long lastModifiedHeader = this.getIfModifiedHeader(context.getExternalContext());
            if (0L == lastModifiedOfResource) {
                long startupTime = ApplicationAssociate.getInstance(context.getExternalContext()).getTimeOfInstantiation();
                return startupTime > lastModifiedHeader;
            }
            return lastModifiedOfResource > lastModifiedHeader;
        }
        return true;
    }

    private long getIfModifiedHeader(ExternalContext extcontext) {
        Object request = extcontext.getRequest();
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getDateHeader(IF_MODIFIED_SINCE);
        }
        SimpleDateFormat format = new SimpleDateFormat(RFC1123_DATE_PATTERN, Locale.US);
        try {
            Date ifModifiedSinceDate = format.parse((String)extcontext.getRequestHeaderMap().get(IF_MODIFIED_SINCE));
            return ifModifiedSinceDate.getTime();
        }
        catch (ParseException ex) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "faces.application.resource.invalid_if_modified_since_header", new Object[]{extcontext.getRequestHeaderMap().get(IF_MODIFIED_SINCE)});
                if (ex != null) {
                    LOGGER.log(Level.WARNING, "", ex);
                }
            }
            return -1L;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getResourceName());
        out.writeObject(this.getLibraryName());
        out.writeObject(this.getContentType());
        out.writeLong(this.initialTime);
        out.writeLong(this.maxAge);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setResourceName((String)in.readObject());
        this.setLibraryName((String)in.readObject());
        this.setContentType((String)in.readObject());
        this.initialTime = in.readLong();
        this.maxAge = in.readLong();
    }

    private void initResourceInfo() {
        if (this.resourceInfo != null) {
            return;
        }
        ResourceManager manager = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext()).getResourceManager();
        this.resourceInfo = manager.findResource(this.getLibraryName(), this.getResourceName(), this.getContentType(), FacesContext.getCurrentInstance());
    }

    private boolean isResourceRequest() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return ctx.getApplication().getResourceHandler().isResourceRequest(ctx);
    }
}

