/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ee.naming.ContextInjectionSource;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.utils.ClassLoadingUtils;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.CircularDependencyException;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ModuleJndiBindingProcessor
implements DeploymentUnitProcessor {
    private final boolean appclient;
    private final boolean ignoreUnusedResourceBinding = Boolean.valueOf(WildFlySecurityManager.getPropertyPrivileged((String)"jboss.ee.ignore-unused-resource-binding", (String)"false"));

    public ModuleJndiBindingProcessor(boolean appclient) {
        this.appclient = appclient;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        boolean bl;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (moduleConfiguration == null) {
            return;
        }
        List dependencies = deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES);
        HashMap<ServiceName, BindingConfiguration> deploymentDescriptorBindings = new HashMap<ServiceName, BindingConfiguration>();
        List<BindingConfiguration> bindingConfigurations = eeModuleDescription.getBindingConfigurations();
        if (!DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            bindingConfigurations.add(new BindingConfiguration("java:module/env", new ContextInjectionSource("env", "java:module/env")));
        }
        if (deploymentUnit.getParent() == null) {
            bindingConfigurations.add(new BindingConfiguration("java:app/env", new ContextInjectionSource("env", "java:app/env")));
        }
        for (BindingConfiguration bindingConfiguration : bindingConfigurations) {
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)bindingConfiguration.getName());
            deploymentDescriptorBindings.put(bindInfo.getBinderServiceName(), bindingConfiguration);
            this.addJndiBinding(moduleConfiguration, bindingConfiguration, phaseContext, dependencies);
        }
        for (ComponentConfiguration componentConfiguration : moduleConfiguration.getComponentConfigurations()) {
            for (BindingConfiguration binding : componentConfiguration.getComponentDescription().getBindingConfigurations()) {
                boolean compBinding;
                String bindingName = binding.getName();
                boolean bl2 = compBinding = bindingName.startsWith("java:comp") || !bindingName.startsWith("java:");
                if (componentConfiguration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE && compBinding) continue;
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
                deploymentDescriptorBindings.put(bindInfo.getBinderServiceName(), binding);
                this.addJndiBinding(moduleConfiguration, binding, phaseContext, dependencies);
            }
        }
        HashSet<String> handledClasses = new HashSet<String>();
        for (ComponentConfiguration componentConfiguration : moduleConfiguration.getComponentConfigurations()) {
            HashSet classConfigurations = new HashSet();
            classConfigurations.add(componentConfiguration.getComponentClass());
            for (InterceptorDescription interceptor : componentConfiguration.getComponentDescription().getAllInterceptors()) {
                try {
                    classConfigurations.add(ClassLoadingUtils.loadClass(interceptor.getInterceptorClassName(), module));
                }
                catch (ClassNotFoundException e) {
                    throw EeLogger.ROOT_LOGGER.cannotLoadInterceptor(e, interceptor.getInterceptorClassName(), componentConfiguration.getComponentClass());
                }
            }
            this.processClassConfigurations(phaseContext, applicationClasses, moduleConfiguration, deploymentDescriptorBindings, handledClasses, componentConfiguration.getComponentDescription().getNamingMode(), classConfigurations, componentConfiguration.getComponentName(), dependencies);
        }
        boolean bl3 = bl = DeploymentTypeMarker.isType(DeploymentType.APPLICATION_CLIENT, deploymentUnit) || this.appclient;
        if (!(this.ignoreUnusedResourceBinding || MetadataCompleteMarker.isMetadataComplete(phaseContext.getDeploymentUnit()) || bl)) {
            CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
            for (EEModuleClassDescription config : eeModuleDescription.getClassDescriptions()) {
                ClassInfo classInfo;
                HashSet<BindingConfiguration> classLevelBindings;
                if (handledClasses.contains(config.getClassName()) || config.isInvalid() || !(classLevelBindings = new HashSet<BindingConfiguration>(config.getBindingConfigurations())).isEmpty() && !ModuleJndiBindingProcessor.isConcreteClass(classInfo = index.getClassByName(DotName.createSimple((String)config.getClassName()))) && !ModuleJndiBindingProcessor.hasConcreteSubclass(index, classInfo)) continue;
                for (BindingConfiguration binding : classLevelBindings) {
                    ContextNames.BindInfo bindInfo;
                    boolean compBinding;
                    String bindingName = binding.getName();
                    boolean bl4 = compBinding = bindingName.startsWith("java:comp") || !bindingName.startsWith("java:");
                    if (compBinding && !DeploymentTypeMarker.isType(DeploymentType.WAR, deploymentUnit) || deploymentDescriptorBindings.containsKey((bindInfo = ContextNames.bindInfoForEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName())).getBinderServiceName())) continue;
                    EeLogger.ROOT_LOGGER.tracef("Binding %s using service %s", binding.getName(), bindInfo.getBinderServiceName());
                    this.addJndiBinding(moduleConfiguration, binding, phaseContext, dependencies);
                }
            }
        }
    }

    private void processClassConfigurations(final DeploymentPhaseContext phaseContext, EEApplicationClasses applicationClasses, final EEModuleConfiguration moduleConfiguration, final Map<ServiceName, BindingConfiguration> deploymentDescriptorBindings, final Set<String> handledClasses, final ComponentNamingMode namingMode, Set<Class<?>> classes, final String componentName, final List<ServiceName> dependencies) throws DeploymentUnitProcessingException {
        for (Class<?> clazz : classes) {
            new ClassDescriptionTraversal(clazz, applicationClasses){

                @Override
                protected void handle(Class<?> currentClass, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    if (classDescription == null) {
                        return;
                    }
                    if (classDescription.isInvalid()) {
                        throw EeLogger.ROOT_LOGGER.componentClassHasErrors(classDescription.getClassName(), componentName, classDescription.getInvalidMessage());
                    }
                    if (handledClasses.contains(classDescription.getClassName())) {
                        return;
                    }
                    handledClasses.add(classDescription.getClassName());
                    if (!MetadataCompleteMarker.isMetadataComplete(phaseContext.getDeploymentUnit())) {
                        HashSet<BindingConfiguration> classLevelBindings = new HashSet<BindingConfiguration>(classDescription.getBindingConfigurations());
                        for (BindingConfiguration binding : classLevelBindings) {
                            ContextNames.BindInfo bindInfo;
                            boolean compBinding;
                            String bindingName = binding.getName();
                            boolean bl = compBinding = bindingName.startsWith("java:comp") || !bindingName.startsWith("java:");
                            if (namingMode == ComponentNamingMode.CREATE && compBinding || deploymentDescriptorBindings.containsKey((bindInfo = ContextNames.bindInfoForEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName())).getBinderServiceName())) continue;
                            EeLogger.ROOT_LOGGER.tracef("Binding %s using service %s", binding.getName(), bindInfo.getBinderServiceName());
                            ModuleJndiBindingProcessor.this.addJndiBinding(moduleConfiguration, binding, phaseContext, dependencies);
                        }
                    }
                }
            }.run();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addJndiBinding(EEModuleConfiguration module, BindingConfiguration bindingConfiguration, DeploymentPhaseContext phaseContext, List<ServiceName> dependencies) throws DeploymentUnitProcessingException {
        ServiceController controller;
        BinderService service;
        ContextNames.BindInfo bindInfo;
        block11: {
            Object bindingName = bindingConfiguration.getName().startsWith("java:") ? bindingConfiguration.getName() : "java:module/env/" + bindingConfiguration.getName();
            InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(true, module.getModuleName(), module.getModuleName(), module.getApplicationName());
            if (bindingName == null) throw EeLogger.ROOT_LOGGER.nullBindingName(bindingConfiguration);
            bindInfo = ContextNames.bindInfoForEnvEntry((String)module.getApplicationName(), (String)module.getModuleName(), (String)module.getModuleName(), (boolean)false, (String)bindingName);
            dependencies.add(bindInfo.getBinderServiceName());
            if (((String)bindingName).startsWith("java:comp") || ((String)bindingName).startsWith("java:module") || ((String)bindingName).startsWith("java:app")) {
                try {
                    BinderService service2 = new BinderService(bindInfo.getBindName(), (Object)bindingConfiguration.getSource());
                    ServiceBuilder serviceBuilder = phaseContext.getServiceTarget().addService(bindInfo.getBinderServiceName(), (Service)service2);
                    bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service2.getManagedObjectInjector());
                    serviceBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)service2.getNamingStoreInjector());
                    serviceBuilder.install();
                    return;
                }
                catch (DuplicateServiceException e) {
                    ServiceController registered = CurrentServiceContainer.getServiceContainer().getService(bindInfo.getBinderServiceName());
                    if (registered == null) {
                        throw e;
                    }
                    BinderService service3 = (BinderService)registered.getService();
                    if (service3 == null || service3.getSource() == null) {
                        throw e;
                    }
                    if (service3.getSource().equals(bindingConfiguration.getSource())) return;
                    throw EeLogger.ROOT_LOGGER.conflictingBinding((String)bindingName, bindingConfiguration.getSource());
                }
                catch (CircularDependencyException e) {
                    throw EeLogger.ROOT_LOGGER.circularDependency((String)bindingName);
                }
            }
            try {
                service = new BinderService(bindInfo.getBindName(), (Object)bindingConfiguration.getSource(), true);
                ServiceTarget externalServiceTarget = (ServiceTarget)phaseContext.getDeploymentUnit().getAttachment(org.jboss.as.server.deployment.Attachments.EXTERNAL_SERVICE_TARGET);
                ServiceBuilder serviceBuilder = externalServiceTarget.addService(bindInfo.getBinderServiceName(), (Service)service);
                bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
                serviceBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)service.getNamingStoreInjector());
                controller = serviceBuilder.install();
            }
            catch (DuplicateServiceException e) {
                controller = CurrentServiceContainer.getServiceContainer().getService(bindInfo.getBinderServiceName());
                if (controller == null) {
                    throw e;
                }
                service = (BinderService)controller.getService();
                if (ModuleJndiBindingProcessor.equals(service.getSource(), bindingConfiguration.getSource())) break block11;
                throw EeLogger.ROOT_LOGGER.conflictingBinding((String)bindingName, bindingConfiguration.getSource());
            }
        }
        try {
            phaseContext.getServiceTarget().addService(phaseContext.getDeploymentUnit().getServiceName().append(new String[]{"sharedBindingReleaseService"}).append(bindInfo.getBinderServiceName()), (Service)new BinderReleaseService((ServiceController<ManagedReferenceFactory>)controller, service)).install();
            service.acquire();
            return;
        }
        catch (DuplicateServiceException duplicateServiceException) {}
    }

    public static boolean equals(Object one, Object two) {
        return one == two || one != null && one.equals(two);
    }

    private static boolean isConcreteClass(ClassInfo classInfo) {
        return !Modifier.isAbstract(classInfo.flags()) && !Modifier.isInterface(classInfo.flags());
    }

    private static boolean hasConcreteSubclass(CompositeIndex index, ClassInfo classInfo) {
        Set subclasses = Modifier.isInterface(classInfo.flags()) ? index.getAllKnownImplementors(classInfo.name()) : index.getAllKnownSubclasses(classInfo.name());
        for (ClassInfo subclass : subclasses) {
            if (!ModuleJndiBindingProcessor.isConcreteClass(subclass)) continue;
            return true;
        }
        return false;
    }

    private static class BinderReleaseService
    implements Service<BinderReleaseService> {
        private final ServiceController<ManagedReferenceFactory> sharedBindingController;
        private final BinderService binderService;

        private BinderReleaseService(ServiceController<ManagedReferenceFactory> sharedBindingController, BinderService binderService) {
            this.sharedBindingController = sharedBindingController;
            this.binderService = binderService;
        }

        public void start(StartContext context) throws StartException {
        }

        public void stop(final StopContext context) {
            if (this.binderService.release()) {
                context.asynchronous();
                this.sharedBindingController.addListener(new LifecycleListener(){

                    public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                        if (event == LifecycleEvent.REMOVED) {
                            context.complete();
                        }
                    }
                });
            }
        }

        public BinderReleaseService getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }
    }
}

