/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import io.netty.util.collection.ByteObjectHashMap;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQShutdownException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.io.DummyCallback;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.JournalUpdateCallback;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TestableJournal;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.AbstractJournalUpdateTask;
import org.apache.activemq.artemis.core.journal.impl.JournalBase;
import org.apache.activemq.artemis.core.journal.impl.JournalCompactor;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalFileImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalFilesRepository;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalRecord;
import org.apache.activemq.artemis.core.journal.impl.JournalRecordProvider;
import org.apache.activemq.artemis.core.journal.impl.JournalTransaction;
import org.apache.activemq.artemis.core.journal.impl.Reclaimer;
import org.apache.activemq.artemis.core.journal.impl.TransactionCallback;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalAddRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalAddRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalCompleteRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalDeleteRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalDeleteRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalInternalRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalRollbackRecordTX;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.journal.ActiveMQJournalBundle;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.SimpleFuture;
import org.apache.activemq.artemis.utils.SimpleFutureImpl;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashMap;
import org.apache.activemq.artemis.utils.collections.LongHashSet;
import org.apache.activemq.artemis.utils.collections.SparseArrayLinkedList;
import org.jboss.logging.Logger;

public class JournalImpl
extends JournalBase
implements TestableJournal,
JournalRecordProvider {
    private static final Logger logger;
    public static final double UPDATE_FACTOR;
    private static final String BKP_EXTENSION = "bkp";
    public static final String BKP = ".bkp";
    public static final int FORMAT_VERSION = 2;
    private static final int[] COMPATIBLE_VERSIONS;
    public static final int MIN_FILE_SIZE = 1024;
    public static final int SIZE_HEADER = 16;
    private static final int BASIC_SIZE = 9;
    public static final int SIZE_ADD_RECORD = 22;
    public static final byte EVENT_RECORD = 10;
    public static final byte ADD_RECORD = 11;
    public static final byte UPDATE_RECORD = 12;
    public static final int SIZE_ADD_RECORD_TX = 30;
    public static final byte ADD_RECORD_TX = 13;
    public static final byte UPDATE_RECORD_TX = 14;
    public static final int SIZE_DELETE_RECORD_TX = 29;
    public static final byte DELETE_RECORD_TX = 15;
    public static final int SIZE_DELETE_RECORD = 17;
    public static final byte DELETE_RECORD = 16;
    public static final int SIZE_COMPLETE_TRANSACTION_RECORD = 21;
    public static final int SIZE_PREPARE_RECORD = 25;
    public static final byte PREPARE_RECORD = 17;
    public static final int SIZE_COMMIT_RECORD = 21;
    public static final byte COMMIT_RECORD = 18;
    public static final int SIZE_ROLLBACK_RECORD = 17;
    public static final byte ROLLBACK_RECORD = 19;
    protected static final byte FILL_CHARACTER = 74;
    private volatile boolean autoReclaim = true;
    private final int userVersion;
    private final int minFiles;
    private final float compactPercentage;
    private final int compactMinFiles;
    private final SequentialFileFactory fileFactory;
    private final JournalFilesRepository filesRepository;
    private File journalRetentionFolder;
    private long journalRetentionPeriod = -1L;
    private int journalRetentionMaxFiles = -1;
    private final List<JournalFile> historyPendingFiles = Collections.synchronizedList(new LinkedList());
    private final Object processBackupLock = new Object();
    private final ConcurrentLongHashMap<JournalRecord> records = new ConcurrentLongHashMap();
    private final ConcurrentLongHashMap<JournalTransaction> transactions = new ConcurrentLongHashMap();
    private IOCriticalErrorListener criticalErrorListener;
    private volatile JournalCompactor compactor;
    private final AtomicBoolean compactorRunning = new AtomicBoolean();
    private Executor filesExecutor = null;
    private Executor compactorExecutor = null;
    private Executor appendExecutor = null;
    private final ConcurrentHashSet<CountDownLatch> latches = new ConcurrentHashSet();
    private final ExecutorFactory providedIOThreadPool;
    protected ExecutorFactory ioExecutorFactory;
    private ThreadPoolExecutor threadPool;
    ThreadLocal<GregorianCalendar> calendarThreadLocal = ThreadLocal.withInitial(() -> new GregorianCalendar());
    private final ReadWriteLock journalLock = new ReentrantReadWriteLock();
    private final ReadWriteLock compactorLock = new ReentrantReadWriteLock();
    ByteObjectHashMap<Boolean> replaceableRecords;
    private volatile JournalFile currentFile;
    private volatile Journal.JournalState state = Journal.JournalState.STOPPED;
    private volatile int compactCount = 0;
    private static final Comparator<JournalFile> JOURNAL_FILE_COMPARATOR;

    @Override
    public boolean isHistory() {
        return this.journalRetentionFolder != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JournalImpl setHistoryFolder(File historyFolder, long maxBytes, long period) throws Exception {
        block10: {
            if (this.state != Journal.JournalState.STOPPED) {
                throw new IllegalStateException("State = " + this.state);
            }
            this.journalRetentionFolder = historyFolder;
            this.journalRetentionFolder.mkdirs();
            this.journalRetentionMaxFiles = (int)(maxBytes / (long)this.fileSize);
            this.journalRetentionPeriod = period;
            try {
                List<String> files = this.fileFactory.listFiles(BKP_EXTENSION);
                for (String name2 : files) {
                    JournalFileImpl journalFile;
                    try (SequentialFile file = this.fileFactory.createSequentialFile(name2);){
                        file.open();
                        journalFile = this.readFileHeader(file);
                    }
                    this.historyPendingFiles.add(journalFile);
                }
                for (JournalFile file : this.historyPendingFiles) {
                    File[] repeatFiles;
                    for (File f : repeatFiles = historyFolder.listFiles((a, name) -> name.startsWith(this.getFilePrefix()) && name.endsWith(file.getFileID() + "." + this.filesRepository.getFileExtension()))) {
                        logger.warn((Object)("File " + f + " was partially copied before, removing the file"));
                        f.delete();
                    }
                }
                this.processBackup();
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                if (this.criticalErrorListener == null) break block10;
                this.criticalErrorListener.onIOException(e, e.getMessage(), null);
            }
        }
        return this;
    }

    @Override
    public void replaceableRecord(byte recordType) {
        if (this.replaceableRecords == null) {
            this.replaceableRecords = new ByteObjectHashMap();
        }
        this.replaceableRecords.put(recordType, (Object)Boolean.TRUE);
    }

    public float getCompactPercentage() {
        return this.compactPercentage;
    }

    public int getCompactMinFiles() {
        return this.compactMinFiles;
    }

    public JournalFilesRepository getFilesRepository() {
        return this.filesRepository;
    }

    public JournalImpl(int fileSize, int minFiles, int poolSize, int compactMinFiles, int compactPercentage, SequentialFileFactory fileFactory, String filePrefix, String fileExtension, int maxAIO) {
        this(fileSize, minFiles, poolSize, compactMinFiles, compactPercentage, fileFactory, filePrefix, fileExtension, maxAIO, 0);
    }

    public JournalImpl(int fileSize, int minFiles, int poolSize, int compactMinFiles, int compactPercentage, SequentialFileFactory fileFactory, String filePrefix, String fileExtension, int maxAIO, int userVersion) {
        this(null, fileSize, minFiles, poolSize, compactMinFiles, compactPercentage, 5, fileFactory, filePrefix, fileExtension, maxAIO, userVersion);
    }

    public JournalImpl(int fileSize, int minFiles, int poolSize, int compactMinFiles, int compactPercentage, int journalFileOpenTimeout, SequentialFileFactory fileFactory, String filePrefix, String fileExtension, int maxAIO, int userVersion) {
        this(null, fileSize, minFiles, poolSize, compactMinFiles, compactPercentage, journalFileOpenTimeout, fileFactory, filePrefix, fileExtension, maxAIO, userVersion);
    }

    public JournalImpl(ExecutorFactory ioExecutors, int fileSize, int minFiles, int poolSize, int compactMinFiles, int compactPercentage, SequentialFileFactory fileFactory, String filePrefix, String fileExtension, int maxAIO, int userVersion) {
        this(ioExecutors, fileSize, minFiles, poolSize, compactMinFiles, compactPercentage, 5, fileFactory, filePrefix, fileExtension, maxAIO, userVersion);
    }

    public JournalImpl(ExecutorFactory ioExecutors, int fileSize, int minFiles, int poolSize, int compactMinFiles, int compactPercentage, int journalFileOpenTimeout, SequentialFileFactory fileFactory, String filePrefix, String fileExtension, int maxAIO, int userVersion) {
        this(ioExecutors, fileSize, minFiles, poolSize, compactMinFiles, compactPercentage, journalFileOpenTimeout, fileFactory, filePrefix, fileExtension, maxAIO, userVersion, (a, b, c) -> logger.warn((Object)a.getMessage(), a), 0);
    }

    public JournalImpl(ExecutorFactory ioExecutors, int fileSize, int minFiles, int poolSize, int compactMinFiles, int compactPercentage, int journalFileOpenTimeout, SequentialFileFactory fileFactory, String filePrefix, String fileExtension, int maxAIO, int userVersion, IOCriticalErrorListener criticalErrorListener, int maxAtticFiles) {
        super(fileFactory.isSupportsCallbacks(), fileSize);
        this.criticalErrorListener = criticalErrorListener;
        this.providedIOThreadPool = ioExecutors;
        if (fileSize % fileFactory.getAlignment() != 0) {
            throw new IllegalArgumentException("Invalid journal-file-size " + fileSize + ", It should be multiple of " + fileFactory.getAlignment());
        }
        if (minFiles < 2) {
            throw new IllegalArgumentException("minFiles cannot be less than 2");
        }
        if (compactPercentage < 0 || compactPercentage > 100) {
            throw new IllegalArgumentException("Compact Percentage out of range");
        }
        this.compactPercentage = compactPercentage == 0 ? 0.0f : (float)compactPercentage / 100.0f;
        this.compactMinFiles = compactMinFiles;
        this.minFiles = minFiles;
        this.fileFactory = fileFactory;
        this.filesRepository = new JournalFilesRepository(fileFactory, this, filePrefix, fileExtension, userVersion, maxAIO, fileSize, minFiles, poolSize, journalFileOpenTimeout, maxAtticFiles);
        this.userVersion = userVersion;
    }

    public String toString() {
        try {
            return "JournalImpl(state=" + this.state + ", directory=[" + this.fileFactory.getDirectory().toString() + "], hash=" + super.toString() + ")";
        }
        catch (Throwable e) {
            logger.warn((Object)e);
            return super.toString();
        }
    }

    @Override
    public IOCriticalErrorListener getCriticalErrorListener() {
        return this.criticalErrorListener;
    }

    @Override
    public JournalImpl setCriticalErrorListener(IOCriticalErrorListener criticalErrorListener) {
        this.criticalErrorListener = criticalErrorListener;
        return this;
    }

    @Override
    public ConcurrentLongHashMap<JournalRecord> getRecords() {
        return this.records;
    }

    @Override
    public JournalFile getCurrentFile() {
        return this.currentFile;
    }

    @Override
    public JournalCompactor getCompactor() {
        return this.compactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JournalFile> orderFiles() throws Exception {
        List<String> fileNames = this.fileFactory.listFiles(this.filesRepository.getFileExtension());
        ArrayList<JournalFile> orderedFiles = new ArrayList<JournalFile>(fileNames.size());
        for (String fileName : fileNames) {
            SequentialFile file = this.fileFactory.createSequentialFile(fileName);
            if (file.size() >= 16L) {
                file.open();
                try {
                    JournalFileImpl jrnFile = this.readFileHeader(file);
                    orderedFiles.add(jrnFile);
                    continue;
                }
                finally {
                    file.close();
                    continue;
                }
            }
            ActiveMQJournalLogger.LOGGER.ignoringShortFile(fileName);
            file.delete();
        }
        Collections.sort(orderedFiles, JOURNAL_FILE_COMPARATOR);
        return orderedFiles;
    }

    private static ByteBuffer allocateDirectBufferIfNeeded(SequentialFileFactory fileFactory, int requiredCapacity, AtomicReference<ByteBuffer> bufferRef) {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = bufferRef != null ? bufferRef.get() : null;
        if (buffer != null && buffer.capacity() < requiredCapacity) {
            fileFactory.releaseDirectBuffer(buffer);
            buffer = null;
        }
        if (buffer == null) {
            buffer = fileFactory.allocateDirectBuffer(requiredCapacity);
        } else {
            buffer.clear().limit(requiredCapacity);
        }
        if (bufferRef != null) {
            bufferRef.lazySet(buffer);
        }
        return buffer;
    }

    public static int readJournalFile(SequentialFileFactory fileFactory, JournalFile file, JournalReaderCallback reader, AtomicReference<ByteBuffer> wholeFileBufferReference) throws Exception {
        return JournalImpl.readJournalFile(fileFactory, file, reader, wholeFileBufferReference, false);
    }

    public static int readJournalFile(SequentialFileFactory fileFactory, JournalFile file, JournalReaderCallback reader, AtomicReference<ByteBuffer> wholeFileBufferReference, boolean reclaimed) throws Exception {
        return JournalImpl.readJournalFile(fileFactory, file, reader, wholeFileBufferReference, reclaimed, null);
    }

    /*
     * Loose catch block
     */
    public static int readJournalFile(SequentialFileFactory fileFactory, JournalFile file, JournalReaderCallback reader, AtomicReference<ByteBuffer> wholeFileBufferReference, boolean reclaimed, ByteObjectHashMap<Boolean> replaceableRecords) throws Exception {
        int n;
        ByteBuffer wholeFileBuffer;
        block49: {
            int filesize;
            block47: {
                int n2;
                block48: {
                    file.getFile().open(1, false);
                    wholeFileBuffer = null;
                    filesize = (int)file.getFile().size();
                    if (filesize >= 16) break block47;
                    n2 = -1;
                    if (wholeFileBufferReference != null || wholeFileBuffer == null) break block48;
                    fileFactory.releaseDirectBuffer(wholeFileBuffer);
                }
                try {
                    file.getFile().close(false, false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return n2;
            }
            wholeFileBuffer = JournalImpl.allocateDirectBufferIfNeeded(fileFactory, filesize, wholeFileBufferReference);
            int journalFileSize = file.getFile().read(wholeFileBuffer);
            if (journalFileSize != filesize) {
                throw new RuntimeException("Invalid read! The system couldn't read the entire file into memory");
            }
            wholeFileBuffer.position(16);
            int lastDataPos = 16;
            while (wholeFileBuffer.hasRemaining()) {
                int recordSize;
                int pos = wholeFileBuffer.position();
                byte recordType = wholeFileBuffer.get();
                if (recordType < 10 || recordType > 19) continue;
                if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                    reader.markAsDataFile(file);
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                int readFileId = wholeFileBuffer.getInt();
                if (readFileId != file.getRecordID() && !reclaimed) {
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                short compactCount = 0;
                if (file.getJournalVersion() >= 2) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 1)) {
                        reader.markAsDataFile(file);
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    compactCount = wholeFileBuffer.get();
                }
                long transactionID = 0L;
                if (JournalImpl.isTransaction(recordType)) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 8)) {
                        wholeFileBuffer.position(pos + 1);
                        reader.markAsDataFile(file);
                        continue;
                    }
                    transactionID = wholeFileBuffer.getLong();
                }
                long recordID = 0L;
                if (!JournalImpl.isCompleteTransaction(recordType)) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 8)) {
                        wholeFileBuffer.position(pos + 1);
                        reader.markAsDataFile(file);
                        continue;
                    }
                    recordID = wholeFileBuffer.getLong();
                }
                int variableSize = 0;
                int preparedTransactionExtraDataSize = 0;
                byte userRecordType = 0;
                byte[] record = null;
                if (JournalImpl.isContainsBody(recordType)) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                        wholeFileBuffer.position(pos + 1);
                        reader.markAsDataFile(file);
                        continue;
                    }
                    variableSize = wholeFileBuffer.getInt();
                    if (recordType != 15) {
                        if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 1)) {
                            wholeFileBuffer.position(pos + 1);
                            continue;
                        }
                        userRecordType = wholeFileBuffer.get();
                    }
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), variableSize)) {
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    record = new byte[variableSize];
                    wholeFileBuffer.get(record);
                }
                int transactionCheckNumberOfRecords = 0;
                if (recordType == 17 || recordType == 18) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    transactionCheckNumberOfRecords = wholeFileBuffer.getInt();
                    if (recordType == 17) {
                        if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                            wholeFileBuffer.position(pos + 1);
                            continue;
                        }
                        preparedTransactionExtraDataSize = wholeFileBuffer.getInt();
                    }
                    variableSize = 0;
                }
                if (JournalImpl.isInvalidSize(journalFileSize, pos, (recordSize = JournalImpl.getRecordSize(recordType, file.getJournalVersion())) + variableSize + preparedTransactionExtraDataSize)) {
                    logger.trace((Object)("Record at position " + pos + " recordType = " + recordType + " file:" + file.getFile().getFileName() + " recordSize: " + recordSize + " variableSize: " + variableSize + " preparedTransactionExtraDataSize: " + preparedTransactionExtraDataSize + " is corrupted and it is being ignored (II)"));
                    reader.markAsDataFile(file);
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                int oldPos = wholeFileBuffer.position();
                wholeFileBuffer.position(pos + variableSize + recordSize + preparedTransactionExtraDataSize - 4);
                int checkSize = wholeFileBuffer.getInt();
                if (checkSize != variableSize + recordSize + preparedTransactionExtraDataSize) {
                    logger.trace((Object)("Record at position " + pos + " recordType = " + recordType + " possible transactionID = " + transactionID + " possible recordID = " + recordID + " file:" + file.getFile().getFileName() + " is corrupted and it is being ignored (III)"));
                    reader.markAsDataFile(file);
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                wholeFileBuffer.position(oldPos);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("reading " + recordID + ", userRecordType=" + userRecordType + ", compactCount=" + compactCount));
                }
                boolean replaceableUpdate = replaceableRecords != null ? replaceableRecords.containsKey(userRecordType) : false;
                switch (recordType) {
                    case 10: {
                        reader.onReadEventRecord(new RecordInfo(recordID, userRecordType, record, false, replaceableUpdate, compactCount));
                        break;
                    }
                    case 11: {
                        reader.onReadAddRecord(new RecordInfo(recordID, userRecordType, record, false, false, compactCount));
                        break;
                    }
                    case 12: {
                        reader.onReadUpdateRecord(new RecordInfo(recordID, userRecordType, record, true, replaceableUpdate, compactCount));
                        break;
                    }
                    case 16: {
                        reader.onReadDeleteRecord(recordID);
                        break;
                    }
                    case 13: {
                        reader.onReadAddRecordTX(transactionID, new RecordInfo(recordID, userRecordType, record, false, false, compactCount));
                        break;
                    }
                    case 14: {
                        reader.onReadUpdateRecordTX(transactionID, new RecordInfo(recordID, userRecordType, record, true, replaceableUpdate, compactCount));
                        break;
                    }
                    case 15: {
                        reader.onReadDeleteRecordTX(transactionID, new RecordInfo(recordID, 0, record, true, false, compactCount));
                        break;
                    }
                    case 17: {
                        byte[] extraData = new byte[preparedTransactionExtraDataSize];
                        wholeFileBuffer.get(extraData);
                        reader.onReadPrepareRecord(transactionID, extraData, transactionCheckNumberOfRecords);
                        break;
                    }
                    case 18: {
                        reader.onReadCommitRecord(transactionID, transactionCheckNumberOfRecords);
                        break;
                    }
                    case 19: {
                        reader.onReadRollbackRecord(transactionID);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Journal " + file.getFile().getFileName() + " is corrupt, invalid record type " + recordType);
                    }
                }
                checkSize = wholeFileBuffer.getInt();
                if (checkSize != variableSize + recordSize + preparedTransactionExtraDataSize) {
                    throw new IllegalStateException("Internal error on loading file. Position doesn't match with checkSize, file = " + file.getFile() + ", pos = " + pos);
                }
                lastDataPos = wholeFileBuffer.position();
            }
            reader.done();
            n = lastDataPos;
            if (wholeFileBufferReference != null || wholeFileBuffer == null) break block49;
            fileFactory.releaseDirectBuffer(wholeFileBuffer);
        }
        try {
            file.getFile().close(false, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
        catch (Throwable e) {
            try {
                ActiveMQJournalLogger.LOGGER.errorReadingFile(e);
                throw new Exception(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (wholeFileBufferReference == null && wholeFileBuffer != null) {
                    fileFactory.releaseDirectBuffer(wholeFileBuffer);
                }
                try {
                    file.getFile().close(false, false);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static int readJournalFile(SequentialFileFactory fileFactory, JournalFile file, JournalReaderCallback reader) throws Exception {
        return JournalImpl.readJournalFile(fileFactory, file, reader, null, false, null);
    }

    @Override
    public void appendAddRecord(final long id, final byte recordType, Persister persister, final Object record, final boolean sync, final IOCompletion callback) throws Exception {
        this.checkJournalIsLoaded();
        this.lineUpContext(callback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendAddRecord::id=" + id + ", userRecordType=" + recordType + ", record = " + record));
        }
        long maxRecordSize = this.getMaxRecordSize();
        final JournalAddRecord addRecord = new JournalAddRecord(true, id, recordType, persister, record);
        final int addRecordEncodeSize = ((JournalInternalRecord)addRecord).getEncodeSize();
        if ((long)addRecordEncodeSize > maxRecordSize) {
            throw ActiveMQJournalBundle.BUNDLE.recordLargerThanStoreMax(addRecordEncodeSize, maxRecordSize);
        }
        final SimpleFuture result = JournalImpl.newSyncAndCallbackResult(sync, callback);
        this.appendExecutor.execute(new Runnable(){

            @Override
            public void run() {
                JournalImpl.this.journalLock.readLock().lock();
                try {
                    JournalFile usedFile = JournalImpl.this.appendRecord(addRecord, false, sync, null, callback);
                    JournalImpl.this.records.put(id, (Object)new JournalRecord(usedFile, addRecordEncodeSize));
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("appendAddRecord::id=" + id + ", userRecordType=" + recordType + ", record = " + record + ", usedFile = " + usedFile));
                    }
                    result.set((Object)true);
                }
                catch (ActiveMQShutdownException e) {
                    result.fail((Throwable)e);
                    logger.error((Object)("appendAddRecord:" + e), (Throwable)e);
                }
                catch (Throwable e) {
                    result.fail(e);
                    JournalImpl.this.setErrorCondition(callback, null, e);
                    logger.error((Object)("appendAddRecord::" + e), e);
                }
                finally {
                    JournalImpl.this.journalLock.readLock().unlock();
                }
            }
        });
        result.get();
    }

    @Override
    public void appendAddEvent(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion callback) throws Exception {
        this.checkJournalIsLoaded();
        this.lineUpContext(callback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendAddEvent::id=" + id + ", userRecordType=" + recordType + ", record = " + record));
        }
        long maxRecordSize = this.getMaxRecordSize();
        JournalAddRecord addRecord = new JournalAddRecord(10, id, recordType, persister, record);
        int addRecordEncodeSize = ((JournalInternalRecord)addRecord).getEncodeSize();
        if ((long)addRecordEncodeSize > maxRecordSize) {
            throw ActiveMQJournalBundle.BUNDLE.recordLargerThanStoreMax(addRecordEncodeSize, maxRecordSize);
        }
        SimpleFuture result = JournalImpl.newSyncAndCallbackResult(sync, callback);
        this.appendExecutor.execute(() -> {
            this.journalLock.readLock().lock();
            try {
                JournalFile usedFile = this.appendRecord(addRecord, false, sync, null, callback);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("appendAddEvent:id=" + id + ", userRecordType=" + recordType + ", record = " + record + ", usedFile = " + usedFile));
                }
                result.set((Object)true);
            }
            catch (ActiveMQShutdownException e) {
                result.fail((Throwable)e);
                logger.error((Object)("appendAddEvent:" + e), (Throwable)e);
            }
            catch (Throwable e) {
                result.fail(e);
                this.setErrorCondition(callback, null, e);
                logger.error((Object)("appendAddEvent::" + e), e);
            }
            finally {
                this.journalLock.readLock().unlock();
            }
        });
        result.get();
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion callback) throws Exception {
        SimpleFutureImpl onFoundAddInfo;
        this.checkJournalIsLoaded();
        this.lineUpContext(callback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendUpdateRecord::id=" + id + ", userRecordType=" + recordType));
        }
        if ((onFoundAddInfo = !sync && (callback == null || callback == DummyCallback.getInstance()) ? null : new SimpleFutureImpl()) == null) {
            this.internalAppendUpdateRecord(id, recordType, persister, record, false, false, null, callback);
        } else {
            this.internalAppendUpdateRecord(id, recordType, persister, record, sync, false, (arg_0, arg_1) -> JournalImpl.lambda$appendUpdateRecord$4((SimpleFuture)onFoundAddInfo, arg_0, arg_1), callback);
        }
        if (onFoundAddInfo != null && !((Boolean)onFoundAddInfo.get()).booleanValue()) {
            throw new IllegalStateException("Cannot find add info " + id);
        }
    }

    @Override
    public void tryAppendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync, boolean replaceableUpdate, JournalUpdateCallback updateCallback, IOCompletion callback) throws Exception {
        this.checkJournalIsLoaded();
        this.lineUpContext(callback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendUpdateRecord::id=" + id + ", userRecordType=" + recordType));
        }
        this.internalAppendUpdateRecord(id, recordType, persister, record, sync, replaceableUpdate, updateCallback, callback);
    }

    private void internalAppendUpdateRecord(final long id, final byte recordType, final Persister persister, final Object record, final boolean sync, final boolean replaceableUpdate, final JournalUpdateCallback updateCallback, final IOCompletion callback) throws InterruptedException, ExecutionException {
        this.appendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JournalImpl.this.journalLock.readLock().lock();
                try {
                    JournalCompactor compactor = JournalImpl.this.compactor;
                    JournalRecord jrnRecord = (JournalRecord)JournalImpl.this.records.get(id);
                    if (!(jrnRecord != null || compactor != null && compactor.containsRecord(id))) {
                        if (updateCallback != null) {
                            updateCallback.onUpdate(id, false);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Record " + id + " had not been found"));
                        }
                        if (callback != null) {
                            callback.done();
                        }
                        return;
                    }
                    JournalAddRecord updateRecord = new JournalAddRecord(false, id, recordType, persister, record);
                    JournalFile usedFile = JournalImpl.this.appendRecord(updateRecord, false, sync, null, callback);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("appendUpdateRecord::id=" + id + ", userRecordType=" + recordType + ", usedFile = " + usedFile));
                    }
                    if (jrnRecord == null) {
                        if (compactor != null) {
                            compactor.addCommandUpdate(id, usedFile, ((JournalInternalRecord)updateRecord).getEncodeSize(), replaceableUpdate);
                        }
                    } else {
                        jrnRecord.addUpdateFile(usedFile, ((JournalInternalRecord)updateRecord).getEncodeSize(), replaceableUpdate);
                    }
                    if (updateCallback != null) {
                        updateCallback.onUpdate(id, true);
                    }
                }
                catch (ActiveMQShutdownException e) {
                    if (updateCallback != null) {
                        updateCallback.onUpdate(id, false);
                    }
                    logger.error((Object)("appendUpdateRecord:" + e), (Throwable)e);
                }
                catch (Throwable e) {
                    if (updateCallback != null) {
                        updateCallback.onUpdate(id, false);
                    }
                    JournalImpl.this.setErrorCondition(callback, null, e);
                    logger.error((Object)("appendUpdateRecord:" + e), e);
                }
                finally {
                    JournalImpl.this.journalLock.readLock().unlock();
                }
            }
        });
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync, IOCompletion callback) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendDeleteRecord::id=" + id));
        }
        this.checkJournalIsLoaded();
        this.lineUpContext(callback);
        SimpleFutureImpl onFoundAddInfo = !sync && (callback == null || callback == DummyCallback.getInstance()) ? null : new SimpleFutureImpl();
        if (onFoundAddInfo == null) {
            this.internalAppendDeleteRecord(id, false, null, callback);
        } else {
            this.internalAppendDeleteRecord(id, sync, (arg_0, arg_1) -> JournalImpl.lambda$appendDeleteRecord$5((SimpleFuture)onFoundAddInfo, arg_0, arg_1), callback);
        }
        if (onFoundAddInfo != null && !((Boolean)onFoundAddInfo.get()).booleanValue()) {
            throw new IllegalStateException("Cannot find add info " + id);
        }
    }

    @Override
    public void tryAppendDeleteRecord(long id, boolean sync, JournalUpdateCallback updateCallback, IOCompletion callback) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendDeleteRecord::id=" + id));
        }
        this.checkJournalIsLoaded();
        this.lineUpContext(callback);
        this.internalAppendDeleteRecord(id, sync, updateCallback, callback);
    }

    private void internalAppendDeleteRecord(final long id, final boolean sync, final JournalUpdateCallback updateCallback, final IOCompletion callback) {
        this.appendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JournalImpl.this.journalLock.readLock().lock();
                try {
                    JournalCompactor compactor = JournalImpl.this.compactor;
                    JournalRecord record = null;
                    if (compactor == null) {
                        record = (JournalRecord)JournalImpl.this.records.remove(id);
                        if (record == null) {
                            if (updateCallback != null) {
                                updateCallback.onUpdate(id, false);
                            }
                            if (callback != null) {
                                callback.done();
                            }
                            return;
                        }
                    } else if (!JournalImpl.this.records.containsKey(id) && !compactor.containsRecord(id)) {
                        if (updateCallback != null) {
                            updateCallback.onUpdate(id, false);
                        }
                        if (callback != null) {
                            callback.done();
                        }
                        return;
                    }
                    JournalDeleteRecord deleteRecord = new JournalDeleteRecord(id);
                    JournalFile usedFile = JournalImpl.this.appendRecord(deleteRecord, false, sync, null, callback);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("appendDeleteRecord::id=" + id + ", usedFile = " + usedFile));
                    }
                    if (record == null) {
                        compactor.addCommandDelete(id, usedFile);
                    } else {
                        record.delete(usedFile);
                    }
                    if (updateCallback != null) {
                        updateCallback.onUpdate(id, true);
                    }
                }
                catch (ActiveMQShutdownException e) {
                    if (updateCallback != null) {
                        updateCallback.onUpdate(id, false);
                    }
                    logger.error((Object)("appendDeleteRecord:" + e), (Throwable)e);
                }
                catch (Throwable e) {
                    if (updateCallback != null) {
                        updateCallback.onUpdate(id, false);
                    }
                    logger.error((Object)("appendDeleteRecord:" + e), e);
                    JournalImpl.this.setErrorCondition(callback, null, e);
                }
                finally {
                    JournalImpl.this.journalLock.readLock().unlock();
                }
            }
        });
    }

    private static SimpleFuture newSyncAndCallbackResult(boolean sync, IOCompletion callback) {
        return sync && callback == null ? new SimpleFutureImpl() : SimpleFuture.dumb();
    }

    @Override
    public void appendAddRecordTransactional(final long txID, final long id, final byte recordType, final Persister persister, final Object record) throws Exception {
        this.checkJournalIsLoaded();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendAddRecordTransactional:txID=" + txID + ",id=" + id + ", userRecordType=" + recordType + ", record = " + record));
        }
        this.appendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JournalImpl.this.journalLock.readLock().lock();
                JournalTransaction tx = JournalImpl.this.getTransactionInfo(txID);
                try {
                    if (tx != null) {
                        tx.checkErrorCondition();
                    }
                    JournalAddRecordTX addRecord = new JournalAddRecordTX(true, txID, id, recordType, persister, record);
                    int encodeSize = ((JournalInternalRecord)addRecord).getEncodeSize();
                    JournalFile usedFile = JournalImpl.this.appendRecord(addRecord, false, false, tx, null);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("appendAddRecordTransactional:txID=" + txID + ",id=" + id + ", userRecordType=" + recordType + ", record = " + record + ", usedFile = " + usedFile));
                    }
                    tx.addPositive(usedFile, id, encodeSize, false);
                }
                catch (Throwable e) {
                    logger.error((Object)("appendAddRecordTransactional:" + e), e);
                    JournalImpl.this.setErrorCondition(null, tx, e);
                }
                finally {
                    JournalImpl.this.journalLock.readLock().unlock();
                }
            }
        });
    }

    private void checkJournalIsLoaded() throws Exception {
        if (this.state != Journal.JournalState.LOADED && this.state != Journal.JournalState.SYNCING) {
            throw new ActiveMQShutdownException("Journal must be in state=" + Journal.JournalState.LOADED + ", was [" + this.state + "]");
        }
    }

    private void setJournalState(Journal.JournalState newState) {
        this.state = newState;
    }

    @Override
    public void appendUpdateRecordTransactional(final long txID, final long id, final byte recordType, final Persister persister, final Object record) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendUpdateRecordTransactional::txID=" + txID + ",id=" + id + ", userRecordType=" + recordType + ", record = " + record));
        }
        this.checkJournalIsLoaded();
        this.appendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JournalImpl.this.journalLock.readLock().lock();
                JournalTransaction tx = JournalImpl.this.getTransactionInfo(txID);
                try {
                    tx.checkErrorCondition();
                    JournalAddRecordTX updateRecordTX = new JournalAddRecordTX(false, txID, id, recordType, persister, record);
                    JournalFile usedFile = JournalImpl.this.appendRecord(updateRecordTX, false, false, tx, null);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("appendUpdateRecordTransactional::txID=" + txID + ",id=" + id + ", userRecordType=" + recordType + ", record = " + record + ", usedFile = " + usedFile));
                    }
                    tx.addPositive(usedFile, id, ((JournalInternalRecord)updateRecordTX).getEncodeSize(), false);
                }
                catch (Throwable e) {
                    logger.error((Object)("appendUpdateRecordTransactional:" + e.getMessage()), e);
                    JournalImpl.this.setErrorCondition(null, tx, e);
                }
                finally {
                    JournalImpl.this.journalLock.readLock().unlock();
                }
            }
        });
    }

    @Override
    public void appendDeleteRecordTransactional(final long txID, final long id, final EncodingSupport record) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendDeleteRecordTransactional::txID=" + txID + ", id=" + id));
        }
        this.checkJournalIsLoaded();
        this.appendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JournalImpl.this.journalLock.readLock().lock();
                JournalTransaction tx = JournalImpl.this.getTransactionInfo(txID);
                try {
                    if (tx != null) {
                        tx.checkErrorCondition();
                    }
                    JournalDeleteRecordTX deleteRecordTX = new JournalDeleteRecordTX(txID, id, record);
                    JournalFile usedFile = JournalImpl.this.appendRecord(deleteRecordTX, false, false, tx, null);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("appendDeleteRecordTransactional::txID=" + txID + ", id=" + id + ", usedFile = " + usedFile));
                    }
                    tx.addNegative(usedFile, id);
                }
                catch (Throwable e) {
                    logger.error((Object)("appendDeleteRecordTransactional:" + e), e);
                    JournalImpl.this.setErrorCondition(null, tx, e);
                }
                finally {
                    JournalImpl.this.journalLock.readLock().unlock();
                }
            }
        });
    }

    @Override
    public void appendPrepareRecord(final long txID, final EncodingSupport transactionData, final boolean sync, final IOCompletion callback) throws Exception {
        this.checkJournalIsLoaded();
        this.lineUpContext(callback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendPrepareRecord::txID=" + txID));
        }
        final SimpleFuture result = JournalImpl.newSyncAndCallbackResult(sync, callback);
        this.appendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JournalImpl.this.journalLock.readLock().lock();
                JournalTransaction tx = JournalImpl.this.getTransactionInfo(txID);
                try {
                    tx.checkErrorCondition();
                    JournalCompleteRecordTX prepareRecord = new JournalCompleteRecordTX(JournalCompleteRecordTX.TX_RECORD_TYPE.PREPARE, txID, transactionData);
                    JournalFile usedFile = JournalImpl.this.appendRecord(prepareRecord, true, sync, tx, callback);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("appendPrepareRecord::txID=" + txID + ", usedFile = " + usedFile));
                    }
                    tx.prepare(usedFile);
                }
                catch (ActiveMQShutdownException e) {
                    result.fail((Throwable)e);
                    logger.error((Object)("appendPrepareRecord:" + e), (Throwable)e);
                }
                catch (Throwable e) {
                    result.fail(e);
                    logger.error((Object)("appendPrepareRecord:" + e), e);
                    JournalImpl.this.setErrorCondition(callback, tx, e);
                }
                finally {
                    JournalImpl.this.journalLock.readLock().unlock();
                    result.set((Object)tx);
                }
            }
        });
        JournalTransaction tx = (JournalTransaction)result.get();
        if (tx != null) {
            tx.checkErrorCondition();
        }
    }

    @Override
    public void lineUpContext(IOCompletion callback) {
        if (callback != null) {
            callback.storeLineUp();
        }
    }

    private void setErrorCondition(IOCallback otherCallback, JournalTransaction jt, Throwable t) {
        TransactionCallback callback = null;
        if (jt != null && (callback = jt.getCurrentCallback()) != null && callback.getErrorMessage() != null) {
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), t.getMessage());
        }
        if (otherCallback != null && otherCallback != callback) {
            otherCallback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), t.getMessage());
        }
    }

    @Override
    public void appendCommitRecord(final long txID, final boolean sync, final IOCompletion callback, boolean lineUpContext) throws Exception {
        JournalTransaction txcheck;
        this.checkJournalIsLoaded();
        if (lineUpContext) {
            this.lineUpContext(callback);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendCommitRecord::txID=" + txID));
        }
        if ((txcheck = (JournalTransaction)this.transactions.get(txID)) != null) {
            txcheck.checkErrorCondition();
        }
        final SimpleFuture result = JournalImpl.newSyncAndCallbackResult(sync, callback);
        this.appendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JournalImpl.this.journalLock.readLock().lock();
                JournalTransaction tx = (JournalTransaction)JournalImpl.this.transactions.remove(txID);
                try {
                    if (tx == null) {
                        throw new IllegalStateException("Cannot find tx with id " + txID);
                    }
                    JournalCompleteRecordTX commitRecord = new JournalCompleteRecordTX(JournalCompleteRecordTX.TX_RECORD_TYPE.COMMIT, txID, null);
                    JournalFile usedFile = JournalImpl.this.appendRecord(commitRecord, true, sync, tx, callback);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("appendCommitRecord::txID=" + txID + ", usedFile = " + usedFile));
                    }
                    tx.commit(usedFile);
                }
                catch (ActiveMQShutdownException e) {
                    result.fail((Throwable)e);
                    logger.error((Object)("appendCommitRecord:" + e), (Throwable)e);
                }
                catch (Throwable e) {
                    result.fail(e);
                    logger.error((Object)("appendCommitRecord:" + e), e);
                    JournalImpl.this.setErrorCondition(callback, tx, e);
                }
                finally {
                    JournalImpl.this.journalLock.readLock().unlock();
                    result.set((Object)tx);
                }
            }
        });
        JournalTransaction tx = (JournalTransaction)result.get();
        if (tx != null) {
            tx.checkErrorCondition();
        }
    }

    @Override
    public void appendRollbackRecord(final long txID, final boolean sync, final IOCompletion callback) throws Exception {
        this.checkJournalIsLoaded();
        this.lineUpContext(callback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scheduling appendRollbackRecord::txID=" + txID));
        }
        final SimpleFuture result = JournalImpl.newSyncAndCallbackResult(sync, callback);
        this.appendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JournalImpl.this.journalLock.readLock().lock();
                JournalTransaction tx = (JournalTransaction)JournalImpl.this.transactions.remove(txID);
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("appendRollbackRecord::txID=" + txID));
                    }
                    if (tx == null) {
                        throw new IllegalStateException("Cannot find tx with id " + txID);
                    }
                    JournalRollbackRecordTX rollbackRecord = new JournalRollbackRecordTX(txID);
                    JournalFile usedFile = JournalImpl.this.appendRecord(rollbackRecord, false, sync, tx, callback);
                    tx.rollback(usedFile);
                }
                catch (ActiveMQShutdownException e) {
                    result.fail((Throwable)e);
                    logger.error((Object)("appendRollbackRecord:" + e), (Throwable)e);
                }
                catch (Throwable e) {
                    result.fail(e);
                    logger.error((Object)("appendRollbackRecord:" + e), e);
                    JournalImpl.this.setErrorCondition(callback, tx, e);
                }
                finally {
                    JournalImpl.this.journalLock.readLock().unlock();
                    result.set((Object)tx);
                }
            }
        });
        JournalTransaction tx = (JournalTransaction)result.get();
        if (tx != null) {
            tx.checkErrorCondition();
        }
    }

    @Override
    public int getAlignment() throws Exception {
        return this.fileFactory.getAlignment();
    }

    @Override
    public synchronized JournalLoadInformation loadInternalOnly() throws Exception {
        return this.load(DummyLoader.INSTANCE, true, null);
    }

    @Override
    public synchronized JournalLoadInformation loadSyncOnly(Journal.JournalState syncState) throws Exception {
        assert (syncState == Journal.JournalState.SYNCING || syncState == Journal.JournalState.SYNCING_UP_TO_DATE);
        return this.load(DummyLoader.INSTANCE, true, syncState);
    }

    @Override
    public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure, boolean fixBadTx) throws Exception {
        long survivedRecordsCount;
        SparseArrayLinkedList records = new SparseArrayLinkedList();
        JournalLoadInformation info = this.load((SparseArrayLinkedList<RecordInfo>)records, preparedTransactions, transactionFailure, fixBadTx);
        if (committedRecords instanceof ArrayList && (survivedRecordsCount = records.size()) <= Integer.MAX_VALUE) {
            ((ArrayList)committedRecords).ensureCapacity((int)survivedRecordsCount);
        }
        records.clear(committedRecords::add);
        return info;
    }

    @Override
    public synchronized JournalLoadInformation load(final SparseArrayLinkedList<RecordInfo> committedRecords, final List<PreparedTransactionInfo> preparedTransactions, final TransactionFailureCallback failureCallback, boolean fixBadTX) throws Exception {
        final LongHashSet recordsToDelete = new LongHashSet(1024);
        final Predicate<RecordInfo> toDeleteFilter = recordInfo -> recordsToDelete.contains(recordInfo.id);
        int DELETE_FLUSH = 20000;
        JournalLoadInformation info = this.load(new LoaderCallback(){
            Runtime runtime = Runtime.getRuntime();

            private void checkDeleteSize() {
                if (recordsToDelete.size() > 20000 && (double)this.runtime.freeMemory() < (double)this.runtime.maxMemory() * 0.2) {
                    if (logger.isDebugEnabled()) {
                        logger.debugf("Flushing deletes during loading, deleteCount = %d", recordsToDelete.size());
                    }
                    long removed = committedRecords.remove(toDeleteFilter);
                    if (logger.isDebugEnabled()) {
                        logger.debugf("Removed records during loading = %d", removed);
                    }
                    recordsToDelete.clear();
                    logger.debug((Object)"flush delete done");
                }
            }

            @Override
            public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
                preparedTransactions.add(preparedTransaction);
                this.checkDeleteSize();
            }

            @Override
            public void addRecord(RecordInfo info) {
                committedRecords.add((Object)info);
                this.checkDeleteSize();
            }

            @Override
            public void updateRecord(RecordInfo info) {
                committedRecords.add((Object)info);
                this.checkDeleteSize();
            }

            @Override
            public void deleteRecord(long id) {
                recordsToDelete.add(id);
                this.checkDeleteSize();
            }

            @Override
            public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete2) {
                if (failureCallback != null) {
                    failureCallback.failedTransaction(transactionID, records, recordsToDelete2);
                }
            }
        }, fixBadTX, null);
        if (!recordsToDelete.isEmpty()) {
            committedRecords.remove(toDeleteFilter);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleCompactAndBlock(int timeout) throws Exception {
        final AtomicInteger errors = new AtomicInteger(0);
        final CountDownLatch latch = this.newLatch(1);
        this.compactorRunning.set(true);
        this.compactorExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JournalImpl.this.compact();
                }
                catch (Throwable e) {
                    errors.incrementAndGet();
                    ActiveMQJournalLogger.LOGGER.errorCompacting(e);
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            this.awaitLatch(latch, timeout);
            if (errors.get() > 0) {
                throw new RuntimeException("Error during compact, look at the logs");
            }
        }
        finally {
            this.compactorRunning.set(false);
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized void compact() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ArrayList<JournalFile> getDataListToCompact() throws Exception {
        ArrayList<JournalFile> dataFilesToProcess = new ArrayList<JournalFile>(this.filesRepository.getDataFilesCount());
        this.journalLock.writeLock().lock();
        try {
            if (this.state != Journal.JournalState.LOADED) {
                ArrayList<JournalFile> arrayList = null;
                return arrayList;
            }
            this.onCompactLockingTheJournal();
            this.setAutoReclaim(false);
            this.moveNextFile(false, true);
            dataFilesToProcess.addAll(this.filesRepository.getDataFiles());
            this.filesRepository.clearDataFiles();
            if (dataFilesToProcess.size() == 0) {
                logger.trace((Object)"Finishing compacting, nothing to process");
                ArrayList<JournalFile> arrayList = null;
                return arrayList;
            }
            this.compactor = new JournalCompactor(this.fileFactory, this, this.filesRepository, this.records.keysLongHashSet(), ((JournalFile)dataFilesToProcess.get(0)).getFileID());
            if (this.replaceableRecords != null) {
                this.replaceableRecords.forEach((k, v) -> this.compactor.replaceableRecord((byte)k));
            }
            this.transactions.forEach((id, pendingTransaction) -> {
                this.compactor.addPendingTransaction(id, pendingTransaction.getPositiveArray());
                pendingTransaction.setCompacting();
            });
            this.records.clear();
        }
        finally {
            this.journalLock.writeLock().unlock();
        }
        this.processBackup();
        return dataFilesToProcess;
    }

    @Override
    public JournalLoadInformation load(LoaderCallback loadManager) throws Exception {
        return this.load(loadManager, true, null);
    }

    private synchronized JournalLoadInformation load(final LoaderCallback loadManager, boolean changeData, Journal.JournalState replicationSync, AtomicReference<ByteBuffer> wholeFileBufferRef) throws Exception {
        Journal.JournalState state;
        assert ((state = this.state) != Journal.JournalState.STOPPED && state != Journal.JournalState.LOADED && state != replicationSync);
        this.checkControlFile(wholeFileBufferRef);
        this.records.clear();
        this.filesRepository.clear();
        this.transactions.clear();
        this.currentFile = null;
        final LinkedHashMap loadTransactions = new LinkedHashMap();
        final List<JournalFile> orderedFiles = this.orderFiles();
        this.filesRepository.calculateNextfileID(orderedFiles);
        int lastDataPos = 16;
        final AtomicLong maxID = new AtomicLong(-1L);
        for (final JournalFile file : orderedFiles) {
            logger.trace((Object)("Loading file " + file.getFile().getFileName()));
            final AtomicBoolean hasData = new AtomicBoolean(false);
            int resultLastPost = JournalImpl.readJournalFile(this.fileFactory, file, new JournalReaderCallback(){

                private void checkID(long id) {
                    if (id > maxID.longValue()) {
                        maxID.lazySet(id);
                    }
                }

                @Override
                public void onReadAddRecord(RecordInfo info) throws Exception {
                    this.checkID(info.id);
                    hasData.lazySet(true);
                    loadManager.addRecord(info);
                    JournalImpl.this.records.put(info.id, (Object)new JournalRecord(file, info.data.length + 22 + 1));
                }

                @Override
                public void onReadUpdateRecord(RecordInfo info) throws Exception {
                    this.checkID(info.id);
                    hasData.lazySet(true);
                    loadManager.updateRecord(info);
                    JournalRecord posFiles = (JournalRecord)JournalImpl.this.records.get(info.id);
                    if (posFiles != null) {
                        posFiles.addUpdateFile(file, info.data.length + 22 + 1, info.replaceableUpdate);
                    }
                }

                @Override
                public void onReadDeleteRecord(long recordID) throws Exception {
                    hasData.lazySet(true);
                    loadManager.deleteRecord(recordID);
                    JournalRecord posFiles = (JournalRecord)JournalImpl.this.records.remove(recordID);
                    if (posFiles != null) {
                        posFiles.delete(file);
                    }
                }

                @Override
                public void onReadUpdateRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.onReadAddRecordTX(transactionID, info);
                }

                @Override
                public void onReadAddRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.checkID(info.id);
                    hasData.lazySet(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.recordInfos.add(info);
                    JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (tnp == null) {
                        tnp = new JournalTransaction(transactionID, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, (Object)tnp);
                    }
                    tnp.addPositive(file, info.id, info.data.length + 30 + 1, info.replaceableUpdate);
                }

                @Override
                public void onReadDeleteRecordTX(long transactionID, RecordInfo info) throws Exception {
                    hasData.lazySet(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.recordsToDelete.add(info);
                    JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (tnp == null) {
                        tnp = new JournalTransaction(transactionID, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, (Object)tnp);
                    }
                    tnp.addNegative(file, info.id);
                }

                @Override
                public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                    boolean healthy;
                    hasData.lazySet(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.prepared = true;
                    tx.extraData = extraData;
                    JournalTransaction journalTransaction = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (journalTransaction == null) {
                        journalTransaction = new JournalTransaction(transactionID, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, (Object)journalTransaction);
                    }
                    if (healthy = JournalImpl.this.checkTransactionHealth(file, journalTransaction, orderedFiles, numberOfRecords)) {
                        journalTransaction.prepare(file);
                    } else {
                        ActiveMQJournalLogger.LOGGER.preparedTXIncomplete(transactionID);
                        tx.invalid = true;
                    }
                }

                @Override
                public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                    TransactionHolder tx = (TransactionHolder)loadTransactions.remove(transactionID);
                    if (tx != null) {
                        JournalTransaction journalTransaction = (JournalTransaction)JournalImpl.this.transactions.remove(transactionID);
                        if (journalTransaction == null) {
                            throw new IllegalStateException("Cannot find tx " + transactionID);
                        }
                        boolean healthy = JournalImpl.this.checkTransactionHealth(file, journalTransaction, orderedFiles, numberOfRecords);
                        if (healthy) {
                            for (RecordInfo txRecord : tx.recordInfos) {
                                if (txRecord.isUpdate) {
                                    loadManager.updateRecord(txRecord);
                                    continue;
                                }
                                loadManager.addRecord(txRecord);
                            }
                            for (RecordInfo deleteValue : tx.recordsToDelete) {
                                loadManager.deleteRecord(deleteValue.id);
                            }
                            journalTransaction.commit(file);
                        } else {
                            ActiveMQJournalLogger.LOGGER.txMissingElements(transactionID);
                            journalTransaction.forget();
                        }
                        hasData.lazySet(true);
                    }
                }

                @Override
                public void onReadRollbackRecord(long transactionID) throws Exception {
                    TransactionHolder tx = (TransactionHolder)loadTransactions.remove(transactionID);
                    if (tx != null) {
                        JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.remove(transactionID);
                        if (tnp == null) {
                            throw new IllegalStateException("Cannot find tx " + transactionID);
                        }
                        tnp.rollback(file);
                        hasData.lazySet(true);
                    }
                }

                @Override
                public void markAsDataFile(JournalFile file2) {
                    hasData.lazySet(true);
                }
            }, wholeFileBufferRef, false, this.replaceableRecords);
            if (hasData.get()) {
                lastDataPos = resultLastPost;
                this.filesRepository.addDataFileOnBottom(file);
                continue;
            }
            if (!changeData) continue;
            this.filesRepository.addFreeFile(file, false, this.isRemoveExtraFilesOnLoad());
        }
        if (replicationSync == Journal.JournalState.SYNCING) {
            assert (this.filesRepository.getDataFiles().isEmpty());
            this.setJournalState(Journal.JournalState.SYNCING);
            return new JournalLoadInformation(0, -1L);
        }
        this.setUpCurrentFile(lastDataPos);
        this.setJournalState(Journal.JournalState.LOADED);
        for (TransactionHolder transaction : loadTransactions.values()) {
            if ((!transaction.prepared || transaction.invalid) && replicationSync != Journal.JournalState.SYNCING_UP_TO_DATE) {
                ActiveMQJournalLogger.LOGGER.uncomittedTxFound(transaction.transactionID);
                if (changeData) {
                    this.appendRollbackRecord(transaction.transactionID, false);
                }
                loadManager.failedTransaction(transaction.transactionID, transaction.recordInfos, transaction.recordsToDelete);
                continue;
            }
            for (RecordInfo info : transaction.recordInfos) {
                if (info.id <= maxID.get()) continue;
                maxID.lazySet(info.id);
            }
            PreparedTransactionInfo info = new PreparedTransactionInfo(transaction.transactionID, transaction.extraData);
            info.getRecords().addAll(transaction.recordInfos);
            info.getRecordsToDelete().addAll(transaction.recordsToDelete);
            loadManager.addPreparedTransaction(info);
        }
        if (changeData) {
            this.checkReclaimStatus();
        }
        return new JournalLoadInformation(this.records.size(), maxID.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized JournalLoadInformation load(LoaderCallback loadManager, boolean changeData, Journal.JournalState replicationSync) throws Exception {
        Journal.JournalState state = this.state;
        if (state == Journal.JournalState.STOPPED || state == Journal.JournalState.LOADED) {
            throw new IllegalStateException("Journal " + this + " must be in " + Journal.JournalState.STARTED + " state, was " + state);
        }
        if (state == replicationSync) {
            throw new IllegalStateException("Journal cannot be in state " + Journal.JournalState.STARTED);
        }
        AtomicReference<ByteBuffer> wholeFileBufferRef = new AtomicReference<ByteBuffer>();
        try {
            JournalLoadInformation journalLoadInformation = this.load(loadManager, changeData, replicationSync, wholeFileBufferRef);
            ByteBuffer wholeFileBuffer = wholeFileBufferRef.get();
            if (wholeFileBuffer != null) {
                this.fileFactory.releaseDirectBuffer(wholeFileBuffer);
                wholeFileBufferRef.lazySet(null);
            }
            return journalLoadInformation;
        }
        catch (Throwable throwable) {
            ByteBuffer wholeFileBuffer = (ByteBuffer)wholeFileBufferRef.get();
            if (wholeFileBuffer != null) {
                this.fileFactory.releaseDirectBuffer(wholeFileBuffer);
                wholeFileBufferRef.lazySet(null);
            }
            throw throwable;
        }
    }

    @Override
    public void processBackupCleanup() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processBackupCleanup with maxFiles = " + this.journalRetentionMaxFiles + " and period = " + this.journalRetentionPeriod));
        }
        if (this.journalRetentionFolder != null && (this.journalRetentionMaxFiles > 0 || this.journalRetentionPeriod > 0L)) {
            Object[] fileNames;
            FilenameFilter fnf = (d, name) -> name.endsWith("." + this.filesRepository.getFileExtension());
            if (this.journalRetentionPeriod > 0L) {
                Object fileName;
                long timeOnFile;
                fileNames = this.journalRetentionFolder.list(fnf);
                Arrays.sort(fileNames);
                GregorianCalendar calendar = this.calendarThreadLocal.get();
                calendar.setTimeInMillis(System.currentTimeMillis() - this.journalRetentionPeriod);
                long timeCutOf = calendar.getTimeInMillis();
                Object[] objectArray = fileNames;
                int n = objectArray.length;
                for (int i = 0; i < n && (timeOnFile = this.getDatePortionMillis((String)(fileName = objectArray[i]))) < timeCutOf; ++i) {
                    logger.debug((Object)("File " + (String)fileName + " is too old and should go"));
                    File fileToRemove = new File(this.journalRetentionFolder, (String)fileName);
                    if (fileToRemove.delete()) continue;
                    logger.debug((Object)("Could not remove " + fileToRemove));
                }
            }
            if (this.journalRetentionMaxFiles > 0) {
                fileNames = this.journalRetentionFolder.list(fnf);
                Arrays.sort(fileNames);
                if (fileNames.length > this.journalRetentionMaxFiles) {
                    int toRemove = fileNames.length - this.journalRetentionMaxFiles;
                    for (Object file : fileNames) {
                        logger.debug((Object)("Removing " + (String)file));
                        File fileToRemove = new File(this.journalRetentionFolder, (String)file);
                        fileToRemove.delete();
                        if (--toRemove <= 0) break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processBackup() {
        if (this.journalRetentionFolder == null) {
            return;
        }
        Object object = this.processBackupLock;
        synchronized (object) {
            ArrayList<JournalFile> filesToMove = new ArrayList<JournalFile>(this.historyPendingFiles.size());
            filesToMove.addAll(this.historyPendingFiles);
            this.historyPendingFiles.clear();
            for (JournalFile fileToCopy : filesToMove) {
                this.copyFile(fileToCopy);
            }
        }
        if (this.compactorExecutor != null) {
            this.compactorExecutor.execute(this::processBackupCleanup);
        } else {
            this.processBackupCleanup();
        }
    }

    private void checkRetentionFile(JournalFile file) {
        if (this.journalRetentionFolder == null) {
            return;
        }
        if (!file.getFile().getFileName().endsWith(BKP)) {
            return;
        }
        this.copyFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(JournalFile fileToCopy) {
        Object object = this.processBackupLock;
        synchronized (object) {
            block11: {
                if (fileToCopy == null || !fileToCopy.getFile().getFileName().endsWith(BKP)) {
                    return;
                }
                long fileId = fileToCopy.getFileID();
                GregorianCalendar calendar = this.calendarThreadLocal.get();
                calendar.setTimeInMillis(System.currentTimeMillis());
                String fileName = this.getHistoryFileName(fileId, calendar);
                File copyFrom = fileToCopy.getFile().getJavaFile();
                File copyTo = new File(this.journalRetentionFolder, fileName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Copying journal retention from " + copyFrom + " to " + copyTo));
                }
                try {
                    Files.copy(copyFrom.toPath(), copyTo.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    try {
                        this.criticalIO(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    fileToCopy.getFile().renameTo(this.removeBackupExtension(fileToCopy.getFile().getFileName()));
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    if (this.criticalErrorListener == null) break block11;
                    this.criticalErrorListener.onIOException(e, e.getMessage(), fileToCopy.getFile());
                }
            }
            fileToCopy.setReclaimable(true);
        }
    }

    public String getHistoryFileName(long sequence, Calendar calendar) {
        String fileName = String.format("%s-%04d%02d%02d%02d%02d%02d-%d.%s", this.filesRepository.getFilePrefix(), calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), sequence, this.filesRepository.getFileExtension());
        return fileName;
    }

    public String removeBackupExtension(String name) {
        int indexOfBKP = name.indexOf(BKP);
        if (indexOfBKP >= 0) {
            return name.substring(0, name.indexOf(BKP));
        }
        return name;
    }

    public long getDatePortionMillis(String name) {
        String datePortion = this.getDatePortion(name);
        GregorianCalendar calendar = this.calendarThreadLocal.get();
        int year = Integer.parseInt(datePortion.substring(0, 4));
        int month = Integer.parseInt(datePortion.substring(4, 6));
        int day = Integer.parseInt(datePortion.substring(6, 8));
        int hour = Integer.parseInt(datePortion.substring(8, 10));
        int minutes = Integer.parseInt(datePortion.substring(10, 12));
        int seconds = Integer.parseInt(datePortion.substring(12, 14));
        calendar.clear();
        calendar.set(year, month - 1, day, hour, minutes, seconds);
        return calendar.getTimeInMillis();
    }

    public String getDatePortion(String name) {
        return name.substring(this.filesRepository.getFilePrefix().length() + 1, name.indexOf("-", this.filesRepository.getFilePrefix().length() + 1));
    }

    @Override
    public final boolean checkReclaimStatus() throws Exception {
        if (this.compactorRunning.get()) {
            return false;
        }
        do {
            if (this.state != Journal.JournalState.LOADED) {
                return false;
            }
            if (this.isAutoReclaim()) continue;
            return false;
        } while (!this.journalLock.readLock().tryLock(250L, TimeUnit.MILLISECONDS));
        try {
            Reclaimer.scan(this.getDataFiles());
            for (JournalFile file : this.filesRepository.getDataFiles()) {
                if (!file.isCanReclaim()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Reclaiming file " + file));
                }
                this.filesRepository.removeDataFile(file);
                this.filesRepository.addFreeFile(file, false);
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
        return false;
    }

    private boolean needsCompact() throws Exception {
        long totalBytes;
        long compactMargin;
        JournalFile[] dataFiles = this.getDataFiles();
        long totalLiveSize = 0L;
        long updateCount = 0L;
        long addRecord = 0L;
        for (JournalFile file : dataFiles) {
            totalLiveSize += (long)file.getLiveSize();
            updateCount += (long)file.getReplaceableCount();
            addRecord += (long)file.getAddRecord();
        }
        if (dataFiles.length > this.compactMinFiles && addRecord > 0L && updateCount > 0L) {
            double updateFactor = updateCount / addRecord;
            if (updateFactor > UPDATE_FACTOR) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("There are " + addRecord + " records, with " + updateCount + " towards them. UpdateCound / AddCount = " + updateFactor + ", being greater than " + UPDATE_FACTOR + " meaning we have to schedule compacting"));
                }
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("There are " + addRecord + " records, with " + updateCount + " towards them. UpdateCound / AddCount = " + updateFactor + ", which is lower than " + UPDATE_FACTOR + " meaning we are ok to leave these records"));
            }
        }
        boolean needCompact = totalLiveSize < (compactMargin = (long)((float)(totalBytes = (long)dataFiles.length * (long)this.fileSize) * this.compactPercentage)) && dataFiles.length > this.compactMinFiles;
        return needCompact;
    }

    private void checkCompact() throws Exception {
        if (this.compactMinFiles == 0) {
            return;
        }
        if (this.state != Journal.JournalState.LOADED) {
            return;
        }
        if (!this.compactorRunning.get() && this.needsCompact()) {
            this.scheduleCompact();
        }
    }

    private void scheduleCompact() {
        if (!this.compactorRunning.compareAndSet(false, true)) {
            return;
        }
        this.compactorExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JournalImpl.this.compact();
                }
                catch (Throwable e) {
                    ActiveMQJournalLogger.LOGGER.errorCompacting(e);
                }
                finally {
                    JournalImpl.this.compactorRunning.set(false);
                }
            }
        });
    }

    @Override
    public final void setAutoReclaim(boolean autoReclaim) {
        this.autoReclaim = autoReclaim;
    }

    @Override
    public final boolean isAutoReclaim() {
        return this.autoReclaim;
    }

    @Override
    public String debug() throws Exception {
        Reclaimer.scan(this.getDataFiles());
        StringBuilder builder = new StringBuilder();
        for (JournalFile file : this.filesRepository.getDataFiles()) {
            builder.append("DataFile:" + file + " posCounter = " + file.getPosCount() + " reclaimStatus = " + file.isCanReclaim() + " live size = " + file.getLiveSize() + "\n");
            if (!(file instanceof JournalFileImpl)) continue;
            builder.append(((JournalFileImpl)file).debug());
        }
        for (JournalFile file : this.filesRepository.getFreeFiles()) {
            builder.append("FreeFile:" + file + "\n");
        }
        if (this.currentFile != null) {
            builder.append("CurrentFile:" + this.currentFile + " posCounter = " + this.currentFile.getPosCount() + "\n");
            if (this.currentFile instanceof JournalFileImpl) {
                builder.append(((JournalFileImpl)this.currentFile).debug());
            }
        } else {
            builder.append("CurrentFile: No current file at this point!");
        }
        return builder.toString();
    }

    @Override
    public void debugWait() throws InterruptedException {
        this.fileFactory.flush();
        this.flushExecutor(this.filesExecutor);
        this.flushExecutor(this.appendExecutor);
    }

    @Override
    public void flush() throws Exception {
        this.fileFactory.flush();
        this.flushExecutor(this.appendExecutor);
        this.flushExecutor(this.filesExecutor);
        this.flushExecutor(this.compactorExecutor);
    }

    @Override
    public long getMaxRecordSize() {
        if (this.fileFactory.getBufferSize() == 0L) {
            return this.getFileSize();
        }
        return Math.min((long)this.getFileSize(), this.fileFactory.getBufferSize());
    }

    private void flushExecutor(Executor executor) throws InterruptedException {
        if (executor != null) {
            final CountDownLatch latch = new CountDownLatch(1);
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        latch.countDown();
                    }
                });
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public boolean flushAppendExecutor(long timeout, TimeUnit unit) throws InterruptedException {
        return OrderedExecutorFactory.flushExecutor((Executor)this.appendExecutor, (long)timeout, (TimeUnit)unit);
    }

    @Override
    public int getDataFilesCount() {
        return this.filesRepository.getDataFilesCount();
    }

    @Override
    public JournalFile[] getDataFiles() {
        JournalFile[] files;
        for (JournalFile file : files = this.filesRepository.getDataFilesArray()) {
            this.checkRetentionFile(file);
        }
        return files;
    }

    @Override
    public int getFreeFilesCount() {
        return this.filesRepository.getFreeFilesCount();
    }

    @Override
    public int getOpenedFilesCount() {
        return this.filesRepository.getOpenedFilesCount();
    }

    @Override
    public int getIDMapSize() {
        return this.records.size();
    }

    @Override
    public int getFileSize() {
        return this.fileSize;
    }

    @Override
    public int getMinFiles() {
        return this.minFiles;
    }

    @Override
    public String getFilePrefix() {
        return this.filesRepository.getFilePrefix();
    }

    @Override
    public String getFileExtension() {
        return this.filesRepository.getFileExtension();
    }

    @Override
    public int getMaxAIO() {
        return this.filesRepository.getMaxAIO();
    }

    @Override
    public int getUserVersion() {
        return this.userVersion;
    }

    @Override
    public void forceMoveNextFile() throws Exception {
        this.debugWait();
        this.journalLock.writeLock().lock();
        try {
            this.moveNextFile(false, true);
        }
        finally {
            this.journalLock.writeLock().unlock();
        }
    }

    @Override
    public void forceBackup(int timeout, TimeUnit unit) throws Exception {
        this.journalLock.writeLock().lock();
        try {
            this.moveNextFile(true, true);
        }
        finally {
            this.journalLock.writeLock().unlock();
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.compactorExecutor.execute(latch::countDown);
        latch.await(timeout, unit);
    }

    public synchronized boolean isStarted() {
        return this.state != Journal.JournalState.STOPPED;
    }

    public synchronized void start() {
        if (this.state != Journal.JournalState.STOPPED) {
            throw new IllegalStateException("Journal " + this + " is not stopped, state is " + this.state);
        }
        if (this.providedIOThreadPool == null) {
            ThreadFactory factory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

                @Override
                public ThreadFactory run() {
                    return new ActiveMQThreadFactory("ArtemisIOThread", true, JournalImpl.class.getClassLoader());
                }
            });
            this.threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), factory);
            this.ioExecutorFactory = new OrderedExecutorFactory((Executor)this.threadPool);
        } else {
            this.ioExecutorFactory = this.providedIOThreadPool;
        }
        this.filesExecutor = this.ioExecutorFactory.getExecutor();
        this.compactorExecutor = this.ioExecutorFactory.getExecutor();
        this.appendExecutor = this.ioExecutorFactory.getExecutor();
        this.filesRepository.setExecutor(this.filesExecutor);
        this.fileFactory.start();
        this.setJournalState(Journal.JournalState.STARTED);
    }

    public synchronized void stop() throws Exception {
        if (this.state == Journal.JournalState.STOPPED) {
            return;
        }
        this.flush();
        this.setJournalState(Journal.JournalState.STOPPED);
        this.journalLock.writeLock().lock();
        try {
            try {
                for (CountDownLatch latch : this.latches) {
                    latch.countDown();
                }
            }
            catch (Throwable e) {
                ActiveMQJournalLogger.LOGGER.warn(e.getMessage(), e);
            }
            this.fileFactory.deactivateBuffer();
            if (this.currentFile != null && this.currentFile.getFile().isOpen()) {
                this.currentFile.getFile().close(true, true);
            }
            this.filesRepository.clear();
            this.fileFactory.stop();
            this.currentFile = null;
        }
        finally {
            this.journalLock.writeLock().unlock();
        }
        if (this.providedIOThreadPool == null) {
            this.threadPool.shutdown();
            if (!this.threadPool.awaitTermination(120L, TimeUnit.SECONDS)) {
                this.threadPool.shutdownNow();
            }
            this.threadPool = null;
            this.ioExecutorFactory = null;
        }
    }

    @Override
    public int getNumberOfRecords() {
        return this.records.size();
    }

    protected SequentialFile createControlFile(List<JournalFile> files, List<JournalFile> newFiles, Pair<String, String> cleanupRename) throws Exception {
        ArrayList<Pair<String, String>> cleanupList;
        if (cleanupRename == null) {
            cleanupList = null;
        } else {
            cleanupList = new ArrayList<Pair<String, String>>();
            cleanupList.add(cleanupRename);
        }
        return this.writeControlFile(this.fileFactory, files, newFiles, cleanupList);
    }

    protected SequentialFile writeControlFile(SequentialFileFactory fileFactory, List<JournalFile> files, List<JournalFile> newFiles, List<Pair<String, String>> renames) throws Exception {
        return AbstractJournalUpdateTask.writeControlFile(fileFactory, files, newFiles, renames);
    }

    protected void deleteControlFile(SequentialFile controlFile) throws Exception {
        controlFile.delete();
    }

    protected void renameFiles(final List<JournalFile> oldFiles, List<JournalFile> newFiles) throws Exception {
        final CountDownLatch done = this.newLatch(1);
        this.filesExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (JournalFile file : oldFiles) {
                        try {
                            JournalImpl.this.filesRepository.addFreeFile(file, false);
                        }
                        catch (Throwable e) {
                            ActiveMQJournalLogger.LOGGER.errorReinitializingFile(e, file);
                        }
                    }
                }
                finally {
                    done.countDown();
                }
            }
        });
        this.awaitLatch(done, -1);
        for (JournalFile file : newFiles) {
            String newName = JournalImpl.renameExtensionFile(file.getFile().getFileName(), ".cmp");
            file.getFile().renameTo(newName);
        }
    }

    protected static String renameExtensionFile(String name, String extension) {
        name = name.substring(0, name.lastIndexOf(extension));
        return name;
    }

    protected void onCompactStart() throws Exception {
    }

    protected void onCompactLockingTheJournal() throws Exception {
    }

    protected void onCompactDone() {
    }

    private boolean checkTransactionHealth(JournalFile currentFile, JournalTransaction journalTransaction, List<JournalFile> orderedFiles, int numberOfRecords) {
        return journalTransaction.getCounter(currentFile) == numberOfRecords;
    }

    private static boolean isTransaction(byte recordType) {
        return recordType == 13 || recordType == 14 || recordType == 15 || JournalImpl.isCompleteTransaction(recordType);
    }

    private static boolean isCompleteTransaction(byte recordType) {
        return recordType == 18 || recordType == 17 || recordType == 19;
    }

    private static boolean isContainsBody(byte recordType) {
        return recordType >= 10 && recordType <= 15;
    }

    private static int getRecordSize(byte recordType, int journalVersion) {
        int recordSize = 0;
        switch (recordType) {
            case 10: 
            case 11: {
                recordSize = 22;
                break;
            }
            case 12: {
                recordSize = 22;
                break;
            }
            case 13: {
                recordSize = 30;
                break;
            }
            case 14: {
                recordSize = 30;
                break;
            }
            case 16: {
                recordSize = 17;
                break;
            }
            case 15: {
                recordSize = 29;
                break;
            }
            case 17: {
                recordSize = 25;
                break;
            }
            case 18: {
                recordSize = 21;
                break;
            }
            case 19: {
                recordSize = 17;
                break;
            }
            default: {
                throw new IllegalStateException("Record other than expected");
            }
        }
        if (journalVersion >= 2) {
            return recordSize + 1;
        }
        return recordSize;
    }

    public JournalFileImpl readFileHeader(SequentialFile file) throws Exception {
        int readUserVersion;
        ByteBuffer bb = this.fileFactory.newBuffer(16);
        file.read(bb);
        int journalVersion = bb.getInt();
        if (journalVersion != 2) {
            boolean isCompatible = false;
            for (int v : COMPATIBLE_VERSIONS) {
                if (v != journalVersion) continue;
                isCompatible = true;
            }
            if (!isCompatible) {
                throw ActiveMQJournalBundle.BUNDLE.journalFileMisMatch();
            }
        }
        if ((readUserVersion = bb.getInt()) != this.userVersion) {
            throw ActiveMQJournalBundle.BUNDLE.journalDifferentVersion();
        }
        long fileID = bb.getLong();
        this.fileFactory.releaseBuffer(bb);
        bb = null;
        return new JournalFileImpl(file, fileID, journalVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int initFileHeader(SequentialFileFactory fileFactory, SequentialFile sequentialFile, int userVersion, long fileID) throws Exception {
        ByteBuffer bb = fileFactory.newBuffer(16);
        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)bb);
        try {
            JournalImpl.writeHeader(buffer, userVersion, fileID);
            bb.rewind();
            int bufferSize = bb.limit();
            sequentialFile.position(0L);
            sequentialFile.writeDirect(bb, true);
            int n = bufferSize;
            return n;
        }
        finally {
            buffer.byteBuf().unwrap().release();
        }
    }

    public static void writeHeader(ActiveMQBuffer buffer, int userVersion, long fileID) {
        buffer.writeInt(2);
        buffer.writeInt(userVersion);
        buffer.writeLong(fileID);
    }

    private JournalFile appendRecord(JournalInternalRecord encoder, boolean completeTransaction, boolean sync, JournalTransaction tx, IOCallback parameterCallback) throws Exception {
        IOCallback callback;
        this.checkJournalIsLoaded();
        int size = encoder.getEncodeSize();
        this.switchFileIfNecessary(size);
        if (tx != null) {
            if (this.fileFactory.isSupportsCallbacks()) {
                TransactionCallback txcallback = tx.getCallback(this.currentFile);
                if (parameterCallback != null) {
                    txcallback.setDelegateCompletion(parameterCallback);
                }
                callback = txcallback;
            } else {
                callback = parameterCallback;
            }
            if (completeTransaction) {
                tx.fillNumberOfRecords(this.currentFile, encoder);
            }
        } else {
            callback = parameterCallback;
        }
        encoder.setFileID(this.currentFile.getRecordID());
        if (callback != null) {
            this.currentFile.getFile().write(encoder, sync, callback);
        } else {
            this.currentFile.getFile().write(encoder, sync);
        }
        return this.currentFile;
    }

    @Override
    void scheduleReclaim() {
        if (this.state != Journal.JournalState.LOADED) {
            return;
        }
        if (this.isAutoReclaim() && !this.compactorRunning.get()) {
            this.compactorExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JournalImpl.this.processBackup();
                        if (!JournalImpl.this.checkReclaimStatus()) {
                            JournalImpl.this.checkCompact();
                        }
                    }
                    catch (Exception e) {
                        ActiveMQJournalLogger.LOGGER.errorSchedulingCompacting(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JournalTransaction getTransactionInfo(long txID) {
        this.journalLock.readLock().lock();
        try {
            JournalTransaction trans;
            JournalTransaction tx = (JournalTransaction)this.transactions.get(txID);
            if (tx == null && (trans = (JournalTransaction)this.transactions.putIfAbsent(txID, (Object)(tx = new JournalTransaction(txID, this)))) != null) {
                tx = trans;
            }
            JournalTransaction journalTransaction = tx;
            return journalTransaction;
        }
        finally {
            this.journalLock.readLock().unlock();
        }
    }

    private void checkControlFile(AtomicReference<ByteBuffer> wholeFileBufferRef) throws Exception {
        ArrayList<String> dataFiles = new ArrayList<String>();
        ArrayList<String> newFiles = new ArrayList<String>();
        ArrayList<Pair<String, String>> renames = new ArrayList<Pair<String, String>>();
        SequentialFile controlFile = AbstractJournalUpdateTask.readControlFile(this.fileFactory, dataFiles, newFiles, renames, wholeFileBufferRef);
        if (controlFile != null) {
            SequentialFile file;
            for (String string : dataFiles) {
                file = this.fileFactory.createSequentialFile(string);
                if (!file.exists()) continue;
                file.delete();
            }
            for (String string : newFiles) {
                file = this.fileFactory.createSequentialFile(string);
                if (!file.exists()) continue;
                String originalName = file.getFileName();
                String newName = originalName.substring(0, originalName.lastIndexOf(".cmp"));
                file.renameTo(newName);
            }
            for (Pair pair : renames) {
                SequentialFile fileTmp = this.fileFactory.createSequentialFile((String)pair.getA());
                SequentialFile fileTo = this.fileFactory.createSequentialFile((String)pair.getB());
                if (!fileTmp.exists()) continue;
                fileTo.delete();
                fileTmp.renameTo((String)pair.getB());
            }
            controlFile.delete();
        }
        this.cleanupTmpFiles(".cmp");
        this.cleanupTmpFiles(".tmp");
    }

    private void cleanupTmpFiles(String extension) throws Exception {
        List<String> leftFiles = this.fileFactory.listFiles(this.getFileExtension() + extension);
        if (leftFiles.size() > 0) {
            ActiveMQJournalLogger.LOGGER.tempFilesLeftOpen();
            for (String fileToDelete : leftFiles) {
                ActiveMQJournalLogger.LOGGER.deletingOrphanedFile(fileToDelete);
                SequentialFile file = this.fileFactory.createSequentialFile(fileToDelete);
                file.delete();
            }
        }
    }

    private static boolean isInvalidSize(int fileSize, int bufferPos, int size) {
        if (size < 0) {
            return true;
        }
        int position = bufferPos + size;
        return position > fileSize || position < 0;
    }

    @Override
    public final void synchronizationLock() {
        this.compactorLock.writeLock().lock();
        this.journalLock.writeLock().lock();
    }

    @Override
    public final void synchronizationUnlock() {
        try {
            this.compactorLock.writeLock().unlock();
        }
        finally {
            this.journalLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
        this.synchronizationLock();
        try {
            HashMap<Long, JournalFile> map = new HashMap<Long, JournalFile>();
            long maxID = -1L;
            for (long id : fileIds) {
                maxID = Math.max(maxID, id);
                map.put(id, this.filesRepository.createRemoteBackupSyncFile(id));
            }
            this.filesRepository.setNextFileID(maxID);
            HashMap<Long, JournalFile> hashMap = map;
            return hashMap;
        }
        finally {
            this.synchronizationUnlock();
        }
    }

    @Override
    public SequentialFileFactory getFileFactory() {
        return this.fileFactory;
    }

    protected JournalFile setUpCurrentFile(int lastDataPos) throws Exception {
        this.filesRepository.ensureMinFiles();
        this.currentFile = this.filesRepository.pollLastDataFile();
        if (this.currentFile != null) {
            if (!this.currentFile.getFile().isOpen()) {
                this.currentFile.getFile().open();
            }
            this.currentFile.getFile().position(this.currentFile.getFile().calculateBlockStart(lastDataPos));
        } else {
            this.currentFile = this.filesRepository.getFreeFile();
            this.filesRepository.openFile(this.currentFile, true);
        }
        this.fileFactory.activateBuffer(this.currentFile.getFile());
        this.filesRepository.pushOpenedFile();
        return this.currentFile;
    }

    protected JournalFile switchFileIfNecessary(int size) throws Exception {
        if (size > this.fileSize - this.currentFile.getFile().calculateBlockStart(16)) {
            throw new IllegalArgumentException("Record is too large to store " + size);
        }
        try {
            if (!this.currentFile.getFile().fits(size)) {
                this.moveNextFile(true, false);
                if (!this.currentFile.getFile().fits(size)) {
                    throw new IllegalStateException("Invalid logic on buffer allocation");
                }
            }
            return this.currentFile;
        }
        catch (Throwable e) {
            this.criticalIO(e);
            return null;
        }
    }

    private void criticalIO(Throwable e) throws Exception {
        if (this.criticalErrorListener != null) {
            this.criticalErrorListener.onIOException(e, e.getMessage(), this.currentFile == null ? null : this.currentFile.getFile());
        }
        if (e instanceof Exception) {
            throw (Exception)e;
        }
        if (e instanceof IllegalStateException) {
            throw (IllegalStateException)e;
        }
        IOException ioex = new IOException();
        ioex.initCause(e);
        throw ioex;
    }

    private CountDownLatch newLatch(int countDown) {
        if (this.state == Journal.JournalState.STOPPED) {
            throw new RuntimeException("Server is not started");
        }
        CountDownLatch latch = new CountDownLatch(countDown);
        this.latches.add((Object)latch);
        return latch;
    }

    private void awaitLatch(CountDownLatch latch, int timeout) throws InterruptedException {
        try {
            if (timeout < 0) {
                latch.await();
            } else {
                latch.await(timeout, TimeUnit.SECONDS);
            }
            if (this.state == Journal.JournalState.STOPPED) {
                throw new RuntimeException("Server is not started");
            }
        }
        finally {
            this.latches.remove((Object)latch);
        }
    }

    protected void moveNextFile(boolean scheduleReclaim, boolean blockOnClose) throws Exception {
        this.filesRepository.closeFile(this.currentFile, blockOnClose);
        if (this.journalRetentionFolder != null) {
            this.currentFile.setReclaimable(false);
            this.currentFile.getFile().renameTo(this.currentFile.getFile().getFileName() + BKP);
            this.historyPendingFiles.add(this.currentFile);
        }
        this.currentFile = this.filesRepository.openFile();
        if (scheduleReclaim) {
            this.scheduleReclaim();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Moving next file " + this.currentFile));
        }
        this.fileFactory.activateBuffer(this.currentFile.getFile());
    }

    @Override
    public void replicationSyncPreserveOldFiles() {
        this.setAutoReclaim(false);
    }

    @Override
    public void replicationSyncFinished() {
        this.setAutoReclaim(true);
    }

    @Override
    public void testCompact() {
        try {
            this.scheduleCompactAndBlock(60);
        }
        catch (Exception e) {
            logger.warn("Error during compact", (Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int getCompactCount() {
        return this.compactCount;
    }

    private /* synthetic */ void lambda$compact$9(long id, JournalTransaction newTransaction) {
        JournalTransaction liveTransaction;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Merging pending transaction " + newTransaction + " after compacting the journal"));
        }
        if ((liveTransaction = (JournalTransaction)this.transactions.get(newTransaction.getId())) != null) {
            liveTransaction.merge(newTransaction);
        } else {
            ActiveMQJournalLogger.LOGGER.compactMergeError(newTransaction.getId());
        }
    }

    private /* synthetic */ void lambda$compact$8(long id, JournalTransaction newTransaction) {
        newTransaction.replaceRecordProvider(this);
    }

    private /* synthetic */ void lambda$compact$7(long id, JournalRecord newRecord) {
        this.records.put(id, (Object)newRecord);
    }

    private static /* synthetic */ void lambda$appendDeleteRecord$5(SimpleFuture onFoundAddInfo, long record, boolean result) {
        onFoundAddInfo.set((Object)result);
    }

    private static /* synthetic */ void lambda$appendUpdateRecord$4(SimpleFuture onFoundAddInfo, long t, boolean v) {
        onFoundAddInfo.set((Object)v);
    }

    static {
        double value;
        logger = Logger.getLogger(JournalImpl.class);
        String UPDATE_FACTOR_STR = System.getProperty(JournalImpl.class.getName() + ".UPDATE_FACTOR");
        try {
            value = UPDATE_FACTOR_STR == null ? 10.0 : Double.parseDouble(UPDATE_FACTOR_STR);
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
            value = 100.0;
        }
        UPDATE_FACTOR = value;
        COMPATIBLE_VERSIONS = new int[]{1};
        JOURNAL_FILE_COMPARATOR = Comparator.comparingLong(JournalFile::getFileID);
    }

    private static final class TransactionHolder {
        public final long transactionID;
        public final List<RecordInfo> recordInfos = new ArrayList<RecordInfo>();
        public final List<RecordInfo> recordsToDelete = new ArrayList<RecordInfo>();
        public boolean prepared;
        public boolean invalid;
        public byte[] extraData;

        private TransactionHolder(long id) {
            this.transactionID = id;
        }
    }

    private static final class DummyLoader
    implements LoaderCallback {
        static final LoaderCallback INSTANCE = new DummyLoader();

        private DummyLoader() {
        }

        @Override
        public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
        }

        @Override
        public void updateRecord(RecordInfo info) {
        }

        @Override
        public void deleteRecord(long id) {
        }

        @Override
        public void addRecord(RecordInfo info) {
        }

        @Override
        public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
        }
    }
}

