/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Basic;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapsId;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedStoredProcedureQueries;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.SequenceGenerators;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.SqlResultSetMappings;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.TableGenerators;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.CollectionTypeRegistration;
import org.hibernate.annotations.CollectionTypeRegistrations;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.CompositeType;
import org.hibernate.annotations.CompositeTypeRegistration;
import org.hibernate.annotations.CompositeTypeRegistrations;
import org.hibernate.annotations.ConverterRegistration;
import org.hibernate.annotations.ConverterRegistrations;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.EmbeddableInstantiatorRegistration;
import org.hibernate.annotations.EmbeddableInstantiatorRegistrations;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.annotations.FetchProfiles;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.GenericGenerators;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.JavaTypeRegistration;
import org.hibernate.annotations.JavaTypeRegistrations;
import org.hibernate.annotations.JdbcTypeRegistration;
import org.hibernate.annotations.JdbcTypeRegistrations;
import org.hibernate.annotations.LazyGroup;
import org.hibernate.annotations.LazyToOne;
import org.hibernate.annotations.LazyToOneOption;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.Source;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.IdGeneratorStrategyInterpreter;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.convert.spi.RegisteredConversion;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotatedColumn;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CannotForceNonNullableException;
import org.hibernate.cfg.ColumnsBuilder;
import org.hibernate.cfg.CopyIdentifierComponentSecondPass;
import org.hibernate.cfg.IdGeneratorResolverSecondPass;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.OneToOneSecondPass;
import org.hibernate.cfg.PropertyContainer;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.ToOneBinder;
import org.hibernate.cfg.ToOneFkSecondPass;
import org.hibernate.cfg.VerifyFetchProfileReferenceSecondPass;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.HCANNHelper;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.QueryBinder;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.GenericsHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.IdentifierGeneratorCreator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.internal.JpaAttributeConverterImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyCompositeUserTypeImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMixedImpl;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.hibernate.usertype.internal.OffsetDateTimeCompositeUserType;
import org.hibernate.usertype.internal.ZonedDateTimeCompositeUserType;

public final class AnnotationBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindDefaults(MetadataBuildingContext context) {
        List annotations;
        IdentifierGeneratorDefinition idGen;
        Map defaults = context.getBootstrapContext().getReflectionManager().getDefaults();
        List anns = (List)defaults.get(SequenceGenerator.class);
        if (anns != null) {
            for (SequenceGenerator ann : anns) {
                idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, context);
                if (idGen == null) continue;
                context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
            }
        }
        if ((anns = (List)defaults.get(TableGenerator.class)) != null) {
            for (SequenceGenerator ann : anns) {
                idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, context);
                if (idGen == null) continue;
                context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
            }
        }
        if ((anns = (List)defaults.get(TableGenerators.class)) != null) {
            anns.forEach(tableGenerators -> {
                for (TableGenerator tableGenerator : tableGenerators.value()) {
                    IdentifierGeneratorDefinition idGen = AnnotationBinder.buildIdGenerator((Annotation)tableGenerator, context);
                    if (idGen == null) continue;
                    context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
                }
            });
        }
        if ((anns = (List)defaults.get(SequenceGenerators.class)) != null) {
            anns.forEach(sequenceGenerators -> {
                for (SequenceGenerator ann : sequenceGenerators.value()) {
                    IdentifierGeneratorDefinition idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, context);
                    if (idGen == null) continue;
                    context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
                }
            });
        }
        if ((anns = (List)defaults.get(jakarta.persistence.NamedQuery.class)) != null) {
            for (SequenceGenerator ann : anns) {
                QueryBinder.bindQuery((jakarta.persistence.NamedQuery)ann, context, true);
            }
        }
        if ((anns = (List)defaults.get(NamedNativeQuery.class)) != null) {
            for (SequenceGenerator ann : anns) {
                QueryBinder.bindNativeQuery((NamedNativeQuery)ann, context, true);
            }
        }
        if ((anns = (List)defaults.get(SqlResultSetMapping.class)) != null) {
            for (SequenceGenerator ann : anns) {
                QueryBinder.bindSqlResultSetMapping((SqlResultSetMapping)ann, context, true);
            }
        }
        if ((annotations = (List)defaults.get(NamedStoredProcedureQuery.class)) != null) {
            for (NamedStoredProcedureQuery annotation : annotations) {
                AnnotationBinder.bindNamedStoredProcedureQuery(annotation, context, true);
            }
        }
        if ((annotations = (List)defaults.get(NamedStoredProcedureQueries.class)) != null) {
            for (NamedStoredProcedureQuery annotation : annotations) {
                AnnotationBinder.bindNamedStoredProcedureQueries((NamedStoredProcedureQueries)annotation, context, true);
            }
        }
    }

    public static void bindPackage(ClassLoaderService cls, String packageName, MetadataBuildingContext context) {
        Object idGen;
        SequenceGenerator ann;
        Package packaze = cls.packageForNameOrNull(packageName);
        if (packaze == null) {
            return;
        }
        XPackage pckg = context.getBootstrapContext().getReflectionManager().toXPackage(packaze);
        if (pckg.isAnnotationPresent(SequenceGenerator.class)) {
            ann = (SequenceGenerator)pckg.getAnnotation(SequenceGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, context);
            context.getMetadataCollector().addIdentifierGenerator((IdentifierGeneratorDefinition)idGen);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add sequence generator with name: {0}", ((IdentifierGeneratorDefinition)idGen).getName());
            }
        }
        if (pckg.isAnnotationPresent(SequenceGenerators.class)) {
            ann = (SequenceGenerators)pckg.getAnnotation(SequenceGenerators.class);
            for (SequenceGenerator sequenceGenerator : ann.value()) {
                context.getMetadataCollector().addIdentifierGenerator(AnnotationBinder.buildIdGenerator((Annotation)sequenceGenerator, context));
            }
        }
        if (pckg.isAnnotationPresent(TableGenerator.class)) {
            ann = (TableGenerator)pckg.getAnnotation(TableGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, context);
            context.getMetadataCollector().addIdentifierGenerator((IdentifierGeneratorDefinition)idGen);
        }
        if (pckg.isAnnotationPresent(TableGenerators.class)) {
            ann = (TableGenerators)pckg.getAnnotation(TableGenerators.class);
            for (TableGenerator tableGenerator : ann.value()) {
                context.getMetadataCollector().addIdentifierGenerator(AnnotationBinder.buildIdGenerator((Annotation)tableGenerator, context));
            }
        }
        AnnotationBinder.handleTypeDescriptorRegistrations((XAnnotatedElement)pckg, context);
        AnnotationBinder.bindEmbeddableInstantiatorRegistrations((XAnnotatedElement)pckg, context);
        AnnotationBinder.bindCompositeUserTypeRegistrations((XAnnotatedElement)pckg, context);
        AnnotationBinder.handleConverterRegistrations((XAnnotatedElement)pckg, context);
        AnnotationBinder.bindGenericGenerators((XAnnotatedElement)pckg, context);
        AnnotationBinder.bindQueries((XAnnotatedElement)pckg, context);
        AnnotationBinder.bindFilterDefs((XAnnotatedElement)pckg, context);
    }

    private static void bindGenericGenerators(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        GenericGenerator defAnn = (GenericGenerator)annotatedElement.getAnnotation(GenericGenerator.class);
        GenericGenerators defsAnn = (GenericGenerators)annotatedElement.getAnnotation(GenericGenerators.class);
        if (defAnn != null) {
            AnnotationBinder.bindGenericGenerator(defAnn, context);
        }
        if (defsAnn != null) {
            for (GenericGenerator def : defsAnn.value()) {
                AnnotationBinder.bindGenericGenerator(def, context);
            }
        }
    }

    private static void bindGenericGenerator(GenericGenerator def, MetadataBuildingContext context) {
        context.getMetadataCollector().addIdentifierGenerator(AnnotationBinder.buildIdGenerator(def, context));
    }

    private static void bindNamedJpaQueries(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        QueryBinder.bindSqlResultSetMapping((SqlResultSetMapping)annotatedElement.getAnnotation(SqlResultSetMapping.class), context, false);
        SqlResultSetMappings ann = (SqlResultSetMappings)annotatedElement.getAnnotation(SqlResultSetMappings.class);
        if (ann != null) {
            for (SqlResultSetMapping current : ann.value()) {
                QueryBinder.bindSqlResultSetMapping(current, context, false);
            }
        }
        QueryBinder.bindQuery((jakarta.persistence.NamedQuery)annotatedElement.getAnnotation(jakarta.persistence.NamedQuery.class), context, false);
        QueryBinder.bindQueries((NamedQueries)annotatedElement.getAnnotation(NamedQueries.class), context, false);
        QueryBinder.bindNativeQuery((NamedNativeQuery)annotatedElement.getAnnotation(NamedNativeQuery.class), context, false);
        QueryBinder.bindNativeQueries((jakarta.persistence.NamedNativeQueries)annotatedElement.getAnnotation(jakarta.persistence.NamedNativeQueries.class), context, false);
    }

    public static void bindQueries(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        AnnotationBinder.bindNamedJpaQueries(annotatedElement, context);
        QueryBinder.bindQuery((NamedQuery)annotatedElement.getAnnotation(NamedQuery.class), context);
        QueryBinder.bindQueries((org.hibernate.annotations.NamedQueries)annotatedElement.getAnnotation(org.hibernate.annotations.NamedQueries.class), context);
        QueryBinder.bindNativeQuery((org.hibernate.annotations.NamedNativeQuery)annotatedElement.getAnnotation(org.hibernate.annotations.NamedNativeQuery.class), context);
        QueryBinder.bindNativeQueries((NamedNativeQueries)annotatedElement.getAnnotation(NamedNativeQueries.class), context);
        AnnotationBinder.bindNamedStoredProcedureQuery((NamedStoredProcedureQuery)annotatedElement.getAnnotation(NamedStoredProcedureQuery.class), context, false);
        AnnotationBinder.bindNamedStoredProcedureQueries((NamedStoredProcedureQueries)annotatedElement.getAnnotation(NamedStoredProcedureQueries.class), context, false);
    }

    private static void bindNamedStoredProcedureQueries(NamedStoredProcedureQueries annotation, MetadataBuildingContext context, boolean isDefault) {
        if (annotation != null) {
            for (NamedStoredProcedureQuery queryAnnotation : annotation.value()) {
                AnnotationBinder.bindNamedStoredProcedureQuery(queryAnnotation, context, isDefault);
            }
        }
    }

    private static void bindNamedStoredProcedureQuery(NamedStoredProcedureQuery annotation, MetadataBuildingContext context, boolean isDefault) {
        if (annotation != null) {
            QueryBinder.bindNamedStoredProcedureQuery(annotation, context, isDefault);
        }
    }

    private static IdentifierGeneratorDefinition buildIdGenerator(Annotation generatorAnn, MetadataBuildingContext context) {
        if (generatorAnn == null) {
            return null;
        }
        IdentifierGeneratorDefinition.Builder definitionBuilder = new IdentifierGeneratorDefinition.Builder();
        if (generatorAnn instanceof TableGenerator) {
            context.getBuildingOptions().getIdGenerationTypeInterpreter().interpretTableGenerator((TableGenerator)generatorAnn, definitionBuilder);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add table generator with name: {0}", definitionBuilder.getName());
            }
        } else if (generatorAnn instanceof SequenceGenerator) {
            context.getBuildingOptions().getIdGenerationTypeInterpreter().interpretSequenceGenerator((SequenceGenerator)generatorAnn, definitionBuilder);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add sequence generator with name: {0}", definitionBuilder.getName());
            }
        } else if (generatorAnn instanceof GenericGenerator) {
            Parameter[] params;
            GenericGenerator genGen = (GenericGenerator)generatorAnn;
            definitionBuilder.setName(genGen.name());
            definitionBuilder.setStrategy(genGen.strategy());
            for (Parameter parameter : params = genGen.parameters()) {
                definitionBuilder.addParam(parameter.name(), parameter.value());
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add generic generator with name: {0}", definitionBuilder.getName());
            }
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + generatorAnn);
        }
        return definitionBuilder.build();
    }

    public static void bindClass(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context) throws MappingException {
        AnnotationBinder.detectMappedSuperclassProblems(clazzToProcess);
        switch (context.getMetadataCollector().getClassType(clazzToProcess)) {
            case MAPPED_SUPERCLASS: {
                AnnotationBinder.bindQueries((XAnnotatedElement)clazzToProcess, context);
                AnnotationBinder.bindFilterDefs((XAnnotatedElement)clazzToProcess, context);
            }
            case EMBEDDABLE: 
            case NONE: {
                return;
            }
        }
        HashMap<String, IdentifierGeneratorDefinition> classGenerators = AnnotationBinder.buildGenerators((XAnnotatedElement)clazzToProcess, context);
        AnnotationBinder.handleTypeDescriptorRegistrations((XAnnotatedElement)clazzToProcess, context);
        AnnotationBinder.bindEmbeddableInstantiatorRegistrations((XAnnotatedElement)clazzToProcess, context);
        AnnotationBinder.bindCompositeUserTypeRegistrations((XAnnotatedElement)clazzToProcess, context);
        AnnotationBinder.handleConverterRegistrations((XAnnotatedElement)clazzToProcess, context);
        AnnotationBinder.bindQueries((XAnnotatedElement)clazzToProcess, context);
        AnnotationBinder.bindFilterDefs((XAnnotatedElement)clazzToProcess, context);
        EntityBinder.bindEntityClass(clazzToProcess, inheritanceStatePerClass, classGenerators, context);
    }

    private static void detectMappedSuperclassProblems(XClass clazzToProcess) {
        if (clazzToProcess.isAnnotationPresent(Entity.class) && clazzToProcess.isAnnotationPresent(jakarta.persistence.MappedSuperclass.class)) {
            throw new AnnotationException("Type '" + clazzToProcess.getName() + "' is annotated both '@Entity' and '@MappedSuperclass'");
        }
        if (clazzToProcess.isAnnotationPresent(Inheritance.class) && clazzToProcess.isAnnotationPresent(jakarta.persistence.MappedSuperclass.class)) {
            LOG.unsupportedMappedSuperclassWithEntityInheritance(clazzToProcess.getName());
        }
    }

    private static void handleTypeDescriptorRegistrations(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        CollectionTypeRegistrations multiRegistration;
        ManagedBeanRegistry managedBeanRegistry = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        JavaTypeRegistration javaTypeAnn = (JavaTypeRegistration)annotatedElement.getAnnotation(JavaTypeRegistration.class);
        if (javaTypeAnn != null) {
            AnnotationBinder.handleJavaTypeRegistration(context, managedBeanRegistry, javaTypeAnn);
        } else {
            JavaTypeRegistrations annotation = (JavaTypeRegistrations)annotatedElement.getAnnotation(JavaTypeRegistrations.class);
            if (annotation != null) {
                JavaTypeRegistration[] registrations;
                for (JavaTypeRegistration registration : registrations = annotation.value()) {
                    AnnotationBinder.handleJavaTypeRegistration(context, managedBeanRegistry, registration);
                }
            }
        }
        JdbcTypeRegistration jdbcTypeAnn = (JdbcTypeRegistration)annotatedElement.getAnnotation(JdbcTypeRegistration.class);
        if (jdbcTypeAnn != null) {
            AnnotationBinder.handleJdbcTypeRegistration(context, managedBeanRegistry, jdbcTypeAnn);
        } else {
            JdbcTypeRegistrations jdbcTypesAnn = (JdbcTypeRegistrations)annotatedElement.getAnnotation(JdbcTypeRegistrations.class);
            if (jdbcTypesAnn != null) {
                JdbcTypeRegistration[] registrations;
                for (JdbcTypeRegistration jdbcTypeRegistration : registrations = jdbcTypesAnn.value()) {
                    AnnotationBinder.handleJdbcTypeRegistration(context, managedBeanRegistry, jdbcTypeRegistration);
                }
            }
        }
        CollectionTypeRegistration singleRegistration = (CollectionTypeRegistration)annotatedElement.getAnnotation(CollectionTypeRegistration.class);
        if (singleRegistration != null) {
            context.getMetadataCollector().addCollectionTypeRegistration(singleRegistration);
        }
        if ((multiRegistration = (CollectionTypeRegistrations)annotatedElement.getAnnotation(CollectionTypeRegistrations.class)) != null) {
            for (CollectionTypeRegistration collectionTypeRegistration : multiRegistration.value()) {
                context.getMetadataCollector().addCollectionTypeRegistration(collectionTypeRegistration);
            }
        }
    }

    private static void handleJdbcTypeRegistration(MetadataBuildingContext context, ManagedBeanRegistry managedBeanRegistry, JdbcTypeRegistration annotation) {
        Class<? extends JdbcType> jdbcTypeClass = annotation.value();
        JdbcType jdbcType = managedBeanRegistry.getBean(jdbcTypeClass).getBeanInstance();
        int typeCode = annotation.registrationCode() == Integer.MIN_VALUE ? jdbcType.getJdbcTypeCode() : annotation.registrationCode();
        context.getMetadataCollector().addJdbcTypeRegistration(typeCode, jdbcType);
    }

    private static void handleJavaTypeRegistration(MetadataBuildingContext context, ManagedBeanRegistry managedBeanRegistry, JavaTypeRegistration annotation) {
        Class<? extends BasicJavaType<?>> jtdClass = annotation.descriptorClass();
        BasicJavaType<?> jtd = managedBeanRegistry.getBean(jtdClass).getBeanInstance();
        context.getMetadataCollector().addJavaTypeRegistration(annotation.javaType(), jtd);
    }

    private static void bindEmbeddableInstantiatorRegistrations(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        EmbeddableInstantiatorRegistration instantiatorReg = (EmbeddableInstantiatorRegistration)annotatedElement.getAnnotation(EmbeddableInstantiatorRegistration.class);
        if (instantiatorReg != null) {
            AnnotationBinder.handleEmbeddableInstantiatorRegistration(context, instantiatorReg);
        } else {
            EmbeddableInstantiatorRegistrations annotation = (EmbeddableInstantiatorRegistrations)annotatedElement.getAnnotation(EmbeddableInstantiatorRegistrations.class);
            if (annotation != null) {
                EmbeddableInstantiatorRegistration[] registrations;
                for (EmbeddableInstantiatorRegistration registration : registrations = annotation.value()) {
                    AnnotationBinder.handleEmbeddableInstantiatorRegistration(context, registration);
                }
            }
        }
    }

    private static void handleEmbeddableInstantiatorRegistration(MetadataBuildingContext context, EmbeddableInstantiatorRegistration annotation) {
        context.getMetadataCollector().registerEmbeddableInstantiator(annotation.embeddableClass(), annotation.instantiator());
    }

    private static void bindCompositeUserTypeRegistrations(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        CompositeTypeRegistration singleRegistration = (CompositeTypeRegistration)annotatedElement.getAnnotation(CompositeTypeRegistration.class);
        if (singleRegistration != null) {
            AnnotationBinder.handleCompositeUserTypeRegistration(context, singleRegistration);
        } else {
            CompositeTypeRegistrations annotation = (CompositeTypeRegistrations)annotatedElement.getAnnotation(CompositeTypeRegistrations.class);
            if (annotation != null) {
                CompositeTypeRegistration[] registrations;
                for (CompositeTypeRegistration registration : registrations = annotation.value()) {
                    AnnotationBinder.handleCompositeUserTypeRegistration(context, registration);
                }
            }
        }
    }

    private static void handleCompositeUserTypeRegistration(MetadataBuildingContext context, CompositeTypeRegistration annotation) {
        context.getMetadataCollector().registerCompositeUserType(annotation.embeddableClass(), annotation.userType());
    }

    private static void handleConverterRegistrations(XAnnotatedElement container, MetadataBuildingContext context) {
        ConverterRegistration singular = (ConverterRegistration)container.getAnnotation(ConverterRegistration.class);
        if (singular != null) {
            AnnotationBinder.handleConverterRegistration(singular, context);
            return;
        }
        ConverterRegistrations plural = (ConverterRegistrations)container.getAnnotation(ConverterRegistrations.class);
        if (plural != null) {
            ConverterRegistration[] registrations;
            for (ConverterRegistration registration : registrations = plural.value()) {
                AnnotationBinder.handleConverterRegistration(registration, context);
            }
        }
    }

    private static void handleConverterRegistration(ConverterRegistration registration, MetadataBuildingContext context) {
        InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
        metadataCollector.addRegisteredConversion(new RegisteredConversion(registration.domainType(), registration.converter(), registration.autoApply(), context));
    }

    public static void bindFilterDefs(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        FilterDef defAnn = (FilterDef)annotatedElement.getAnnotation(FilterDef.class);
        FilterDefs defsAnn = BinderHelper.getOverridableAnnotation(annotatedElement, FilterDefs.class, context);
        if (defAnn != null) {
            AnnotationBinder.bindFilterDef(defAnn, context);
        }
        if (defsAnn != null) {
            for (FilterDef def : defsAnn.value()) {
                AnnotationBinder.bindFilterDef(def, context);
            }
        }
    }

    private static void bindFilterDef(FilterDef defAnn, MetadataBuildingContext context) {
        HashMap<String, JdbcMapping> explicitParamJaMappings = defAnn.parameters().length == 0 ? null : new HashMap<String, JdbcMapping>();
        for (ParamDef param : defAnn.parameters()) {
            JdbcMapping jdbcMapping = AnnotationBinder.resolveFilterParamType(param.type(), context);
            if (jdbcMapping == null) {
                throw new MappingException(String.format(Locale.ROOT, "Unable to resolve type specified for parameter (%s) defined for @FilterDef (%s)", param.name(), defAnn.name()));
            }
            explicitParamJaMappings.put(param.name(), jdbcMapping);
        }
        FilterDefinition def = new FilterDefinition(defAnn.name(), defAnn.defaultCondition(), explicitParamJaMappings);
        LOG.debugf("Binding filter definition: %s", def.getFilterName());
        context.getMetadataCollector().addFilterDefinition(def);
    }

    private static JdbcMapping resolveFilterParamType(Class<?> type, final MetadataBuildingContext context) {
        if (UserType.class.isAssignableFrom(type)) {
            return AnnotationBinder.resolveUserType(type, context);
        }
        if (AttributeConverter.class.isAssignableFrom(type)) {
            return AnnotationBinder.resolveAttributeConverter(type, context);
        }
        if (JavaType.class.isAssignableFrom(type)) {
            return AnnotationBinder.resolveJavaType(type, context);
        }
        final TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType jtd = typeConfiguration.getJavaTypeRegistry().findDescriptor(type);
        if (jtd != null) {
            JdbcType jdbcType = jtd.getRecommendedJdbcType(new JdbcTypeIndicators(){

                @Override
                public TypeConfiguration getTypeConfiguration() {
                    return typeConfiguration;
                }

                @Override
                public int getPreferredSqlTypeCodeForBoolean() {
                    return context.getPreferredSqlTypeCodeForBoolean();
                }

                @Override
                public int getPreferredSqlTypeCodeForDuration() {
                    return context.getPreferredSqlTypeCodeForDuration();
                }

                @Override
                public int getPreferredSqlTypeCodeForUuid() {
                    return context.getPreferredSqlTypeCodeForUuid();
                }

                @Override
                public int getPreferredSqlTypeCodeForInstant() {
                    return context.getPreferredSqlTypeCodeForInstant();
                }

                @Override
                public int getPreferredSqlTypeCodeForArray() {
                    return context.getPreferredSqlTypeCodeForArray();
                }
            });
            return typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
        }
        return null;
    }

    private static JdbcMapping resolveUserType(Class<UserType<?>> type, MetadataBuildingContext context) {
        StandardServiceRegistry serviceRegistry = context.getBootstrapContext().getServiceRegistry();
        ManagedBeanRegistry beanRegistry = serviceRegistry.getService(ManagedBeanRegistry.class);
        ManagedBean<UserType<?>> bean = beanRegistry.getBean(type);
        UserType<?> userType = bean.getBeanInstance();
        return new CustomType(userType, context.getBootstrapContext().getTypeConfiguration());
    }

    private static JdbcMapping resolveAttributeConverter(Class<AttributeConverter<?, ?>> type, MetadataBuildingContext context) {
        StandardServiceRegistry serviceRegistry = context.getBootstrapContext().getServiceRegistry();
        ManagedBeanRegistry beanRegistry = serviceRegistry.getService(ManagedBeanRegistry.class);
        ManagedBean<AttributeConverter<?, ?>> bean = beanRegistry.getBean(type);
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeRegistry();
        JavaType converterJtd = jtdRegistry.resolveDescriptor(bean.getBeanClass());
        ParameterizedType converterParameterizedType = GenericsHelper.extractParameterizedType(bean.getBeanClass());
        Class<?> domainJavaClass = GenericsHelper.extractClass(converterParameterizedType.getActualTypeArguments()[0]);
        Class<?> relationalJavaClass = GenericsHelper.extractClass(converterParameterizedType.getActualTypeArguments()[1]);
        JavaType domainJtd = jtdRegistry.resolveDescriptor(domainJavaClass);
        JavaType relationalJtd = jtdRegistry.resolveDescriptor(relationalJavaClass);
        JpaAttributeConverterImpl valueConverter = new JpaAttributeConverterImpl(bean, converterJtd, domainJtd, relationalJtd);
        return new ConvertedBasicTypeImpl("converted::" + valueConverter.getConverterJavaType().getJavaType().getTypeName(), String.format("BasicType adapter for AttributeConverter<%s,%s>", domainJtd.getJavaType().getTypeName(), relationalJtd.getJavaType().getTypeName()), relationalJtd.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators()), valueConverter);
    }

    private static JdbcMapping resolveJavaType(Class<JavaType<?>> type, MetadataBuildingContext context) {
        JavaType<Object> jtd;
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        JavaType registeredJtd = javaTypeRegistry.findDescriptor(type);
        if (registeredJtd != null) {
            jtd = registeredJtd;
        } else {
            StandardServiceRegistry serviceRegistry = context.getBootstrapContext().getServiceRegistry();
            ManagedBeanRegistry beanRegistry = serviceRegistry.getService(ManagedBeanRegistry.class);
            ManagedBean<JavaType<?>> bean = beanRegistry.getBean(type);
            jtd = bean.getBeanInstance();
        }
        JdbcType jdbcType = jtd.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators());
        return typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
    }

    public static void bindFetchProfilesForClass(XClass clazzToProcess, MetadataBuildingContext context) {
        AnnotationBinder.bindFetchProfiles((XAnnotatedElement)clazzToProcess, context);
    }

    public static void bindFetchProfilesForPackage(ClassLoaderService cls, String packageName, MetadataBuildingContext context) {
        Package packaze = cls.packageForNameOrNull(packageName);
        if (packaze == null) {
            return;
        }
        ReflectionManager reflectionManager = context.getBootstrapContext().getReflectionManager();
        XPackage pckg = reflectionManager.toXPackage(packaze);
        AnnotationBinder.bindFetchProfiles((XAnnotatedElement)pckg, context);
    }

    private static void bindFetchProfiles(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        FetchProfile fetchProfileAnnotation = (FetchProfile)annotatedElement.getAnnotation(FetchProfile.class);
        FetchProfiles fetchProfileAnnotations = (FetchProfiles)annotatedElement.getAnnotation(FetchProfiles.class);
        if (fetchProfileAnnotation != null) {
            AnnotationBinder.bindFetchProfile(fetchProfileAnnotation, context);
        }
        if (fetchProfileAnnotations != null) {
            for (FetchProfile profile : fetchProfileAnnotations.value()) {
                AnnotationBinder.bindFetchProfile(profile, context);
            }
        }
    }

    private static void bindFetchProfile(FetchProfile fetchProfileAnnotation, MetadataBuildingContext context) {
        for (FetchProfile.FetchOverride fetch : fetchProfileAnnotation.fetchOverrides()) {
            org.hibernate.annotations.FetchMode mode = fetch.mode();
            if (!mode.equals((Object)org.hibernate.annotations.FetchMode.JOIN)) {
                throw new MappingException("Only FetchMode.JOIN is currently supported");
            }
            context.getMetadataCollector().addSecondPass(new VerifyFetchProfileReferenceSecondPass(fetchProfileAnnotation.name(), fetch, context));
        }
    }

    static int addElementsOfClass(List<PropertyData> elements, PropertyContainer propertyContainer, MetadataBuildingContext context) {
        int idPropertyCounter = 0;
        for (XProperty p : propertyContainer.propertyIterator()) {
            int currentIdPropertyCounter = AnnotationBinder.addProperty(propertyContainer, p, elements, context);
            idPropertyCounter += currentIdPropertyCounter;
        }
        return idPropertyCounter;
    }

    private static int addProperty(PropertyContainer propertyContainer, XProperty property, List<PropertyData> inFlightPropertyDataList, MetadataBuildingContext context) {
        for (PropertyData propertyData : inFlightPropertyDataList) {
            if (!propertyData.getPropertyName().equals(property.getName())) continue;
            Id incomingIdProperty = (Id)property.getAnnotation(Id.class);
            Id existingIdProperty = (Id)propertyData.getProperty().getAnnotation(Id.class);
            if (incomingIdProperty != null && existingIdProperty == null) {
                throw new MappingException(String.format("You cannot override the [%s] non-identifier property from the [%s] base class or @MappedSuperclass and make it an identifier in the [%s] subclass", propertyData.getProperty().getName(), propertyData.getProperty().getDeclaringClass().getName(), property.getDeclaringClass().getName()));
            }
            return 0;
        }
        XClass declaringClass = propertyContainer.getDeclaringClass();
        XClass entity = propertyContainer.getEntityAtStake();
        int idPropertyCounter = 0;
        PropertyInferredData propertyAnnotatedElement = new PropertyInferredData(declaringClass, property, propertyContainer.getClassLevelAccessType().getType(), context.getBootstrapContext().getReflectionManager());
        XProperty element = propertyAnnotatedElement.getProperty();
        if (AnnotationBinder.hasIdAnnotation((XAnnotatedElement)element)) {
            inFlightPropertyDataList.add(0, propertyAnnotatedElement);
            if (context.getBuildingOptions().isSpecjProprietarySyntaxEnabled() && element.isAnnotationPresent(Id.class) && element.isAnnotationPresent(jakarta.persistence.Column.class)) {
                String columnName = ((jakarta.persistence.Column)element.getAnnotation(jakarta.persistence.Column.class)).name();
                for (XProperty prop : declaringClass.getDeclaredProperties(AccessType.FIELD.getType())) {
                    if (prop.isAnnotationPresent(MapsId.class)) continue;
                    boolean isRequiredAnnotationPresent = false;
                    JoinColumns groupAnnotation = (JoinColumns)prop.getAnnotation(JoinColumns.class);
                    if (prop.isAnnotationPresent(JoinColumn.class) && ((JoinColumn)prop.getAnnotation(JoinColumn.class)).name().equals(columnName)) {
                        isRequiredAnnotationPresent = true;
                    } else if (prop.isAnnotationPresent(JoinColumns.class)) {
                        for (JoinColumn columnAnnotation : groupAnnotation.value()) {
                            if (!columnName.equals(columnAnnotation.name())) continue;
                            isRequiredAnnotationPresent = true;
                            break;
                        }
                    }
                    if (!isRequiredAnnotationPresent) continue;
                    PropertyInferredData specJPropertyData = new PropertyInferredData(declaringClass, prop, propertyContainer.getClassLevelAccessType().getType(), context.getBootstrapContext().getReflectionManager());
                    context.getMetadataCollector().addPropertyAnnotatedWithMapsIdSpecj(entity, specJPropertyData, element.toString());
                }
            }
            if (BinderHelper.hasToOneAnnotation((XAnnotatedElement)element)) {
                context.getMetadataCollector().addToOneAndIdProperty(entity, propertyAnnotatedElement);
            }
            ++idPropertyCounter;
        } else {
            inFlightPropertyDataList.add(propertyAnnotatedElement);
        }
        if (element.isAnnotationPresent(MapsId.class)) {
            context.getMetadataCollector().addPropertyAnnotatedWithMapsId(entity, propertyAnnotatedElement);
        }
        return idPropertyCounter;
    }

    private static boolean hasIdAnnotation(XAnnotatedElement element) {
        return element.isAnnotationPresent(Id.class) || element.isAnnotationPresent(EmbeddedId.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processElementAnnotations(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, HashMap<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) throws MappingException {
        if (!propertyHolder.isComponent() && entityBinder.isPropertyDefinedInSuperHierarchy(inferredData.getPropertyName())) {
            LOG.debugf("Skipping attribute [%s : %s] as it was already processed as part of super hierarchy", inferredData.getClassOrElementName(), inferredData.getPropertyName());
            return;
        } else {
            XProperty property;
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Processing annotations of {0}.{1}", propertyHolder.getEntityName(), inferredData.getPropertyName());
            }
            if ((property = inferredData.getProperty()).isAnnotationPresent(Parent.class)) {
                if (!propertyHolder.isComponent()) throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is annotated '@Parent' but is not a member of an embeddable class");
                propertyHolder.setParentProperty(property.getName());
                return;
            } else {
                AnnotationBinder.buildProperty(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass, property, inferredData.getClassOrElement());
            }
        }
    }

    private static void buildProperty(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, HashMap<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, XClass returnedClass) {
        ColumnsBuilder columnsBuilder = new ColumnsBuilder(propertyHolder, nullability, property, inferredData, entityBinder, context).extractMetadata();
        AnnotatedColumn[] columns = columnsBuilder.getColumns();
        AnnotatedJoinColumn[] joinColumns = columnsBuilder.getJoinColumns();
        PropertyBinder propertyBinder = new PropertyBinder();
        propertyBinder.setName(inferredData.getPropertyName());
        propertyBinder.setReturnedClassName(inferredData.getTypeName());
        propertyBinder.setAccessType(inferredData.getDefaultAccess());
        propertyBinder.setHolder(propertyHolder);
        propertyBinder.setProperty(property);
        propertyBinder.setReturnedClass(inferredData.getPropertyClass());
        propertyBinder.setBuildingContext(context);
        if (isIdentifierMapper) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        }
        propertyBinder.setDeclaringClass(inferredData.getDeclaringClass());
        propertyBinder.setEntityBinder(entityBinder);
        propertyBinder.setInheritanceStatePerClass(inheritanceStatePerClass);
        boolean isId = !entityBinder.isIgnoreIdAnnotations() && AnnotationBinder.hasIdAnnotation((XAnnotatedElement)property);
        propertyBinder.setId(isId);
        LazyGroup lazyGroupAnnotation = (LazyGroup)property.getAnnotation(LazyGroup.class);
        if (lazyGroupAnnotation != null) {
            propertyBinder.setLazyGroup(lazyGroupAnnotation.value());
        }
        if (property.isAnnotationPresent(Version.class)) {
            AnnotationBinder.bindVersionProperty(propertyHolder, inferredData, isIdentifierMapper, context, inheritanceStatePerClass, property, columns, propertyBinder);
        } else if (property.isAnnotationPresent(ManyToOne.class)) {
            AnnotationBinder.bindManyToOne(propertyHolder, inferredData, isIdentifierMapper, inSecondPass, context, property, joinColumns, propertyBinder, AnnotationBinder.isForcePersist(property));
        } else if (property.isAnnotationPresent(OneToOne.class)) {
            AnnotationBinder.bindOneToOne(propertyHolder, inferredData, isIdentifierMapper, inSecondPass, context, property, joinColumns, propertyBinder, AnnotationBinder.isForcePersist(property));
        } else if (property.isAnnotationPresent(Any.class)) {
            AnnotationBinder.bindAny(propertyHolder, nullability, inferredData, entityBinder, isIdentifierMapper, context, property, joinColumns, AnnotationBinder.isForcePersist(property));
        } else if (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToMany.class) || property.isAnnotationPresent(ElementCollection.class) || property.isAnnotationPresent(ManyToAny.class)) {
            CollectionBinder.bindCollection(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, context, inheritanceStatePerClass, property, joinColumns);
        } else if (!isId || !entityBinder.isIgnoreIdAnnotations()) {
            columns = AnnotationBinder.bindBasic(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, isComponentEmbedded, context, inheritanceStatePerClass, property, columnsBuilder, columns, returnedClass, propertyBinder, isId);
        }
        AnnotationBinder.addIndexes(inSecondPass, property, columns, joinColumns);
        AnnotationBinder.addNaturalIds(inSecondPass, property, columns, joinColumns);
    }

    private static boolean isForcePersist(XProperty property) {
        return property.isAnnotationPresent(MapsId.class) || property.isAnnotationPresent(Id.class);
    }

    private static void bindVersionProperty(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, AnnotatedColumn[] columns, PropertyBinder propertyBinder) {
        if (isIdentifierMapper) {
            throw new AnnotationException("Class '" + propertyHolder.getEntityName() + "' is annotated '@IdClass' and may not have a property annotated '@Version'");
        }
        if (!(propertyHolder.getPersistentClass() instanceof RootClass)) {
            throw new AnnotationException("Entity '" + propertyHolder.getEntityName() + "' is a subclass in an entity class hierarchy and may not have a property annotated '@Version'");
        }
        if (!propertyHolder.isEntity()) {
            throw new AnnotationException("Embedded class '" + propertyHolder.getEntityName() + "' may not have a property annotated '@Version'");
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("{0} is a version property", inferredData.getPropertyName());
        }
        RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
        propertyBinder.setColumns(columns);
        Property prop = propertyBinder.makePropertyValueAndBind();
        AnnotationBinder.setVersionInformation(property, propertyBinder);
        rootClass.setVersion(prop);
        MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(inferredData.getDeclaringClass(), inheritanceStatePerClass, context);
        if (superclass != null) {
            superclass.setDeclaredVersion(prop);
        } else {
            rootClass.setDeclaredVersion(prop);
        }
        ((SimpleValue)prop.getValue()).setNullValue("undefined");
        rootClass.setOptimisticLockStyle(OptimisticLockStyle.VERSION);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Version name: {0}, unsavedValue: {1}", rootClass.getVersion().getName(), ((SimpleValue)rootClass.getVersion().getValue()).getNullValue());
        }
    }

    private static AnnotatedColumn[] bindBasic(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, ColumnsBuilder columnsBuilder, AnnotatedColumn[] columns, XClass returnedClass, PropertyBinder propertyBinder, boolean isId) {
        PropertyData mapsIdProperty;
        PropertyData overridingProperty;
        boolean isComponent = false;
        boolean isOverridden = false;
        if ((isId || propertyHolder.isOrWithinEmbeddedId() || propertyHolder.isInIdClass()) && (overridingProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, propertyHolder, property.getName(), context)) != null) {
            isOverridden = true;
            InheritanceState state = inheritanceStatePerClass.get(overridingProperty.getClassOrElement());
            if (state != null) {
                isComponent = state.hasIdClassOrEmbeddedId();
            }
            columns = columnsBuilder.overrideColumnFromMapperOrMapsIdProperty(isId);
        }
        isComponent = isComponent || AnnotationBinder.isEmbedded(property, returnedClass);
        Class<? extends CompositeUserType<?>> compositeUserType = AnnotationBinder.resolveCompositeUserType(inferredData.getProperty(), inferredData.getClassOrElement(), context);
        if (isComponent || compositeUserType != null) {
            String propertyName;
            String referencedEntityName;
            if (isOverridden) {
                mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, propertyHolder, property.getName(), context);
                referencedEntityName = mapsIdProperty.getClassOrElementName();
                propertyName = mapsIdProperty.getPropertyName();
            } else {
                referencedEntityName = null;
                propertyName = null;
            }
            propertyBinder = AnnotationBinder.bindComponent(inferredData, propertyHolder, entityBinder.getPropertyAccessor((XAnnotatedElement)property), entityBinder, isIdentifierMapper, context, isComponentEmbedded, isId, inheritanceStatePerClass, referencedEntityName, propertyName, AnnotationBinder.determineCustomInstantiator(property, returnedClass, context), compositeUserType, isOverridden ? (AnnotatedJoinColumn[])columns : null);
        } else {
            boolean optional = true;
            boolean lazy = false;
            if (property.isAnnotationPresent(Basic.class)) {
                Basic ann = (Basic)property.getAnnotation(Basic.class);
                optional = ann.optional();
                boolean bl = lazy = ann.fetch() == FetchType.LAZY;
            }
            if (isId || !optional && nullability != Nullability.FORCED_NULL) {
                for (Basic col : columns) {
                    if (isId && col.isFormula()) {
                        throw new CannotForceNonNullableException(String.format(Locale.ROOT, "Identifier property [%s] cannot contain formula mapping [%s]", HCANNHelper.annotatedElementSignature(property), col.getFormulaString()));
                    }
                    col.forceNotNull();
                }
            }
            propertyBinder.setLazy(lazy);
            propertyBinder.setColumns((AnnotatedColumn[])columns);
            if (isOverridden) {
                mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, propertyHolder, property.getName(), context);
                propertyBinder.setReferencedEntityName(mapsIdProperty.getClassOrElementName());
            }
            propertyBinder.makePropertyValueAndBind();
        }
        if (isOverridden) {
            PropertyData mapsIdProperty2 = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, propertyHolder, property.getName(), context);
            IdentifierGeneratorDefinition.Builder foreignGeneratorBuilder = new IdentifierGeneratorDefinition.Builder();
            foreignGeneratorBuilder.setName("Hibernate-local--foreign generator");
            foreignGeneratorBuilder.setStrategy("foreign");
            foreignGeneratorBuilder.addParam("property", mapsIdProperty2.getPropertyName());
            IdentifierGeneratorDefinition foreignGenerator = foreignGeneratorBuilder.build();
            if (AnnotationBinder.isGlobalGeneratorNameGlobal(context)) {
                IdGeneratorResolverSecondPass secondPass = new IdGeneratorResolverSecondPass((SimpleValue)propertyBinder.getValue(), property, foreignGenerator.getStrategy(), foreignGenerator.getName(), context, foreignGenerator);
                context.getMetadataCollector().addSecondPass(secondPass);
            } else {
                HashMap<String, IdentifierGeneratorDefinition> localGenerators = new HashMap<String, IdentifierGeneratorDefinition>(classGenerators);
                localGenerators.put(foreignGenerator.getName(), foreignGenerator);
                BinderHelper.makeIdGenerator((SimpleValue)propertyBinder.getValue(), property, foreignGenerator.getStrategy(), foreignGenerator.getName(), context, localGenerators);
            }
        }
        if (isId && !isOverridden) {
            AnnotationBinder.processId(propertyHolder, inferredData, (SimpleValue)propertyBinder.getValue(), classGenerators, isIdentifierMapper, context);
        }
        return columns;
    }

    private static boolean isEmbedded(XProperty property, XClass returnedClass) {
        return property.isAnnotationPresent(Embedded.class) || property.isAnnotationPresent(EmbeddedId.class) || returnedClass.isAnnotationPresent(Embeddable.class);
    }

    private static void bindAny(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context, XProperty property, AnnotatedJoinColumn[] joinColumns, boolean forcePersist) {
        if (property.isAnnotationPresent(Columns.class)) {
            throw new AnnotationException(String.format(Locale.ROOT, "Property '%s' is annotated '@Any' and may not have a '@Columns' annotation (a single '@Column' or '@Formula' must be used to map the discriminator, and '@JoinColumn's must be used to map the foreign key) ", BinderHelper.getPath(propertyHolder, inferredData)));
        }
        Cascade hibernateCascade = (Cascade)property.getAnnotation(Cascade.class);
        OnDelete onDeleteAnn = (OnDelete)property.getAnnotation(OnDelete.class);
        JoinTable assocTable = propertyHolder.getJoinTable(property);
        if (assocTable != null) {
            Join join = propertyHolder.addJoin(assocTable, false);
            for (AnnotatedJoinColumn joinColumn : joinColumns) {
                joinColumn.setExplicitTableName(join.getTable().getName());
            }
        }
        AnnotationBinder.bindAny(AnnotationBinder.getCascadeStrategy(null, hibernateCascade, false, forcePersist), joinColumns, onDeleteAnn != null && OnDeleteAction.CASCADE == onDeleteAnn.action(), nullability, propertyHolder, inferredData, entityBinder, isIdentifierMapper, context);
    }

    private static void bindOneToOne(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, boolean inSecondPass, MetadataBuildingContext context, XProperty property, AnnotatedJoinColumn[] joinColumns, PropertyBinder propertyBinder, boolean forcePersist) {
        OneToOne ann = (OneToOne)property.getAnnotation(OneToOne.class);
        if (property.isAnnotationPresent(jakarta.persistence.Column.class) || property.isAnnotationPresent(Columns.class)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is a '@OneToOne' association and may not use '@Column' to specify column mappings (use '@PrimaryKeyJoinColumn' instead)");
        }
        boolean trueOneToOne = property.isAnnotationPresent(PrimaryKeyJoinColumn.class) || property.isAnnotationPresent(PrimaryKeyJoinColumns.class);
        Cascade hibernateCascade = (Cascade)property.getAnnotation(Cascade.class);
        NotFound notFound = (NotFound)property.getAnnotation(NotFound.class);
        NotFoundAction notFoundAction = notFound == null ? null : notFound.action();
        boolean hasNotFoundAction = notFoundAction != null;
        boolean mandatory = !ann.optional() || property.isAnnotationPresent(Id.class) || property.isAnnotationPresent(MapsId.class) && !hasNotFoundAction;
        AnnotationBinder.matchIgnoreNotFoundWithFetchType(propertyHolder.getEntityName(), property.getName(), notFoundAction, ann.fetch());
        OnDelete onDeleteAnn = (OnDelete)property.getAnnotation(OnDelete.class);
        JoinTable assocTable = propertyHolder.getJoinTable(property);
        if (assocTable != null) {
            Join join = propertyHolder.addJoin(assocTable, false);
            if (hasNotFoundAction) {
                join.disableForeignKeyCreation();
            }
            for (AnnotatedJoinColumn joinColumn : joinColumns) {
                joinColumn.setExplicitTableName(join.getTable().getName());
            }
        }
        AnnotationBinder.bindOneToOne(AnnotationBinder.getCascadeStrategy(ann.cascade(), hibernateCascade, ann.orphanRemoval(), forcePersist), joinColumns, !mandatory, AnnotationBinder.getFetchMode(ann.fetch()), notFoundAction, onDeleteAnn != null && OnDeleteAction.CASCADE == onDeleteAnn.action(), ToOneBinder.getTargetEntity(inferredData, context), propertyHolder, inferredData, ann.mappedBy(), trueOneToOne, isIdentifierMapper, inSecondPass, propertyBinder, context);
    }

    private static void bindManyToOne(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, boolean inSecondPass, MetadataBuildingContext context, XProperty property, AnnotatedJoinColumn[] joinColumns, PropertyBinder propertyBinder, boolean forcePersist) {
        ManyToOne ann = (ManyToOne)property.getAnnotation(ManyToOne.class);
        if (property.isAnnotationPresent(jakarta.persistence.Column.class) || property.isAnnotationPresent(Columns.class)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is a '@ManyToOne' association and may not use '@Column' to specify column mappings (use '@JoinColumn' instead)");
        }
        Cascade hibernateCascade = (Cascade)property.getAnnotation(Cascade.class);
        NotFound notFound = (NotFound)property.getAnnotation(NotFound.class);
        NotFoundAction notFoundAction = notFound == null ? null : notFound.action();
        AnnotationBinder.matchIgnoreNotFoundWithFetchType(propertyHolder.getEntityName(), property.getName(), notFoundAction, ann.fetch());
        OnDelete onDeleteAnn = (OnDelete)property.getAnnotation(OnDelete.class);
        JoinTable assocTable = propertyHolder.getJoinTable(property);
        if (assocTable != null) {
            Join join = propertyHolder.addJoin(assocTable, false);
            for (AnnotatedJoinColumn joinColumn : joinColumns) {
                joinColumn.setExplicitTableName(join.getTable().getName());
            }
        }
        boolean mandatory = !ann.optional() || property.isAnnotationPresent(Id.class) || property.isAnnotationPresent(MapsId.class) && notFoundAction != null;
        AnnotationBinder.bindManyToOne(AnnotationBinder.getCascadeStrategy(ann.cascade(), hibernateCascade, false, forcePersist), joinColumns, !mandatory, notFoundAction, onDeleteAnn != null && OnDeleteAction.CASCADE == onDeleteAnn.action(), ToOneBinder.getTargetEntity(inferredData, context), propertyHolder, inferredData, false, isIdentifierMapper, inSecondPass, propertyBinder, context);
    }

    private static void addIndexes(boolean inSecondPass, XProperty property, AnnotatedColumn[] columns, AnnotatedJoinColumn[] joinColumns) {
        block2: {
            Index index;
            block3: {
                index = (Index)property.getAnnotation(Index.class);
                if (index == null) break block2;
                if (joinColumns == null) break block3;
                for (AnnotatedJoinColumn column : joinColumns) {
                    column.addIndex(index, inSecondPass);
                }
                break block2;
            }
            if (columns == null) break block2;
            for (AnnotatedColumn column : columns) {
                column.addIndex(index, inSecondPass);
            }
        }
    }

    private static void addNaturalIds(boolean inSecondPass, XProperty property, AnnotatedColumn[] columns, AnnotatedJoinColumn[] joinColumns) {
        block4: {
            NaturalId naturalIdAnn = (NaturalId)property.getAnnotation(NaturalId.class);
            if (naturalIdAnn == null) break block4;
            if (joinColumns != null) {
                for (AnnotatedJoinColumn column : joinColumns) {
                    String keyName = "UK_" + Constraint.hashedName(column.getTable().getName() + "_NaturalID");
                    column.addUniqueKey(keyName, inSecondPass);
                }
            } else {
                for (AnnotatedColumn column : columns) {
                    String keyName = "UK_" + Constraint.hashedName(column.getTable().getName() + "_NaturalID");
                    column.addUniqueKey(keyName, inSecondPass);
                }
            }
        }
    }

    private static Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> determineCustomInstantiator(XProperty property, XClass returnedClass, MetadataBuildingContext context) {
        if (property.isAnnotationPresent(EmbeddedId.class)) {
            return null;
        }
        EmbeddableInstantiator propertyAnnotation = (EmbeddableInstantiator)property.getAnnotation(EmbeddableInstantiator.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        EmbeddableInstantiator classAnnotation = (EmbeddableInstantiator)returnedClass.getAnnotation(EmbeddableInstantiator.class);
        if (classAnnotation != null) {
            return classAnnotation.value();
        }
        Class embeddableClass = context.getBootstrapContext().getReflectionManager().toClass(returnedClass);
        if (embeddableClass != null) {
            return context.getMetadataCollector().findRegisteredEmbeddableInstantiator(embeddableClass);
        }
        return null;
    }

    private static Class<? extends CompositeUserType<?>> resolveCompositeUserType(XProperty property, XClass returnedClass, MetadataBuildingContext context) {
        Class embeddableClass;
        if (property != null) {
            CompositeType compositeType = (CompositeType)property.getAnnotation(CompositeType.class);
            if (compositeType != null) {
                return compositeType.value();
            }
            Class<? extends CompositeUserType<?>> compositeUserType = AnnotationBinder.resolveTimeZoneStorageCompositeUserType(property, returnedClass, context);
            if (compositeUserType != null) {
                return compositeUserType;
            }
        }
        if (returnedClass != null && (embeddableClass = context.getBootstrapContext().getReflectionManager().toClass(returnedClass)) != null) {
            return context.getMetadataCollector().findRegisteredCompositeUserType(embeddableClass);
        }
        return null;
    }

    static Class<? extends CompositeUserType<?>> resolveTimeZoneStorageCompositeUserType(XProperty property, XClass returnedClass, MetadataBuildingContext context) {
        TimeZoneStorage timeZoneStorage;
        if (property != null && (timeZoneStorage = (TimeZoneStorage)property.getAnnotation(TimeZoneStorage.class)) != null) {
            switch (timeZoneStorage.value()) {
                case AUTO: {
                    if (context.getBuildingOptions().getDefaultTimeZoneStorage() != TimeZoneStorageStrategy.COLUMN) {
                        return null;
                    }
                }
                case COLUMN: {
                    switch (returnedClass.getName()) {
                        case "java.time.OffsetDateTime": {
                            return OffsetDateTimeCompositeUserType.class;
                        }
                        case "java.time.ZonedDateTime": {
                            return ZonedDateTimeCompositeUserType.class;
                        }
                    }
                }
            }
        }
        return null;
    }

    private static boolean isGlobalGeneratorNameGlobal(MetadataBuildingContext context) {
        return context.getBootstrapContext().getJpaCompliance().isGlobalGeneratorScopeEnabled();
    }

    private static void setVersionInformation(XProperty property, PropertyBinder propertyBinder) {
        propertyBinder.getBasicValueBinder().setVersion(true);
        if (property.isAnnotationPresent(Source.class)) {
            Source source = (Source)property.getAnnotation(Source.class);
            propertyBinder.getBasicValueBinder().setTimestampVersionType(source.value().typeName());
        }
    }

    private static void processId(PropertyHolder propertyHolder, PropertyData inferredData, SimpleValue idValue, Map<String, IdentifierGeneratorDefinition> classGenerators, boolean isIdentifierMapper, MetadataBuildingContext buildingContext) {
        if (isIdentifierMapper) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' belongs to an '@IdClass' and may not be annotated '@Id' or '@EmbeddedId'");
        }
        XClass entityXClass = inferredData.getClassOrElement();
        XProperty idXProperty = inferredData.getProperty();
        Object generatorAnnotation = HCANNHelper.findContainingAnnotation((XAnnotatedElement)idXProperty, IdGeneratorType.class);
        if (generatorAnnotation != null) {
            idValue.setCustomIdGeneratorCreator(new CustomIdGeneratorCreator((Annotation)generatorAnnotation, idXProperty));
        } else {
            String generatorName;
            boolean isComponent = entityXClass.isAnnotationPresent(Embeddable.class) || idXProperty.isAnnotationPresent(EmbeddedId.class);
            GeneratedValue generatedValue = (GeneratedValue)idXProperty.getAnnotation(GeneratedValue.class);
            String generatorType = generatedValue != null ? AnnotationBinder.generatorType(generatedValue, buildingContext, entityXClass) : "assigned";
            String string = generatorName = generatedValue != null ? generatedValue.generator() : "";
            if (isComponent) {
                generatorType = "assigned";
            }
            if (AnnotationBinder.isGlobalGeneratorNameGlobal(buildingContext)) {
                AnnotationBinder.buildGenerators((XAnnotatedElement)idXProperty, buildingContext);
                IdGeneratorResolverSecondPass secondPass = new IdGeneratorResolverSecondPass(idValue, idXProperty, generatorType, generatorName, buildingContext);
                buildingContext.getMetadataCollector().addSecondPass(secondPass);
            } else {
                HashMap<String, IdentifierGeneratorDefinition> localGenerators = new HashMap<String, IdentifierGeneratorDefinition>(classGenerators);
                localGenerators.putAll(AnnotationBinder.buildGenerators((XAnnotatedElement)idXProperty, buildingContext));
                BinderHelper.makeIdGenerator(idValue, idXProperty, generatorType, generatorName, buildingContext, localGenerators);
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Bind {0} on {1}", isComponent ? "@EmbeddedId" : "@Id", inferredData.getPropertyName());
            }
        }
    }

    public static String generatorType(final GeneratedValue generatedValueAnn, final MetadataBuildingContext buildingContext, final XClass javaTypeXClass) {
        return buildingContext.getBuildingOptions().getIdGenerationTypeInterpreter().determineGeneratorName(generatedValueAnn.strategy(), new IdGeneratorStrategyInterpreter.GeneratorNameDeterminationContext(){
            Class<?> javaType = null;

            @Override
            public Class<?> getIdType() {
                if (this.javaType == null) {
                    this.javaType = buildingContext.getBootstrapContext().getReflectionManager().toClass(javaTypeXClass);
                }
                return this.javaType;
            }

            @Override
            public String getGeneratedValueGeneratorName() {
                return generatedValueAnn.generator();
            }
        });
    }

    private static PropertyBinder bindComponent(PropertyData inferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext buildingContext, boolean isComponentEmbedded, boolean isId, Map<XClass, InheritanceState> inheritanceStatePerClass, String referencedEntityName, String propertyName, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedJoinColumn[] columns) {
        Component comp;
        if (referencedEntityName != null) {
            comp = AnnotationBinder.createComponent(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, buildingContext);
            CopyIdentifierComponentSecondPass sp = new CopyIdentifierComponentSecondPass(comp, referencedEntityName, propertyName, columns, buildingContext);
            buildingContext.getMetadataCollector().addSecondPass(sp);
        } else {
            comp = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAccessor, !isId, entityBinder, isComponentEmbedded, isIdentifierMapper, false, customInstantiatorImpl, compositeUserTypeClass, buildingContext, inheritanceStatePerClass);
        }
        if (isId) {
            comp.setKey(true);
            if (propertyHolder.getPersistentClass().getIdentifier() != null) {
                throw new AnnotationException("Embeddable class '" + comp.getComponentClassName() + "' may not have a property annotated '@Id' since it is used by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' as an '@EmbeddedId'");
            }
            if (referencedEntityName == null && comp.getPropertySpan() == 0) {
                throw new AnnotationException("Embeddable class '" + comp.getComponentClassName() + "' may not be used as an '@EmbeddedId' by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' because it has no properties");
            }
        }
        PropertyBinder binder = new PropertyBinder();
        binder.setDeclaringClass(inferredData.getDeclaringClass());
        binder.setName(inferredData.getPropertyName());
        binder.setValue(comp);
        binder.setProperty(inferredData.getProperty());
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setEmbedded(isComponentEmbedded);
        binder.setHolder(propertyHolder);
        binder.setId(isId);
        binder.setEntityBinder(entityBinder);
        binder.setInheritanceStatePerClass(inheritanceStatePerClass);
        binder.setBuildingContext(buildingContext);
        binder.makePropertyAndBind();
        return binder;
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData inferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, MetadataBuildingContext buildingContext, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        return AnnotationBinder.fillComponent(propertyHolder, inferredData, null, propertyAccessor, isNullable, entityBinder, isComponentEmbedded, isIdentifierMapper, inSecondPass, customInstantiatorImpl, compositeUserTypeClass, buildingContext, inheritanceStatePerClass);
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, MetadataBuildingContext buildingContext, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        XClass returnedClassOrElement;
        CompositeUserType<?> compositeUserType;
        Component comp = AnnotationBinder.createComponent(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, buildingContext);
        String subpath = BinderHelper.getPath(propertyHolder, inferredData);
        LOG.tracev("Binding component with path: {0}", subpath);
        PropertyHolder subHolder = PropertyHolderBuilder.buildPropertyHolder(comp, subpath, inferredData, propertyHolder, buildingContext);
        propertyHolder.startingProperty(inferredData.getProperty());
        XClass xClassProcessed = inferredData.getPropertyClass();
        ArrayList<PropertyData> classElements = new ArrayList<PropertyData>();
        if (compositeUserTypeClass == null) {
            compositeUserType = null;
            returnedClassOrElement = inferredData.getClassOrElement();
        } else {
            compositeUserType = buildingContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(compositeUserTypeClass).getBeanInstance();
            comp.setTypeName(compositeUserTypeClass.getName());
            returnedClassOrElement = buildingContext.getBootstrapContext().getReflectionManager().toXClass(compositeUserType.embeddable());
        }
        ArrayList<PropertyData> baseClassElements = null;
        HashMap<String, PropertyData> orderedBaseClassElements = new HashMap<String, PropertyData>();
        if (baseInferredData != null) {
            baseClassElements = new ArrayList<PropertyData>();
            XClass baseReturnedClassOrElement = baseInferredData.getClassOrElement();
            while (!Object.class.getName().equals(baseReturnedClassOrElement.getName())) {
                AnnotationBinder.addElementsOfClass(baseClassElements, new PropertyContainer(baseReturnedClassOrElement, xClassProcessed, propertyAccessor), buildingContext);
                for (PropertyData element : baseClassElements) {
                    orderedBaseClassElements.put(element.getPropertyName(), element);
                }
                baseReturnedClassOrElement = baseReturnedClassOrElement.getSuperclass();
            }
        }
        PropertyContainer propContainer = new PropertyContainer(returnedClassOrElement, xClassProcessed, propertyAccessor);
        AnnotationBinder.addElementsOfClass(classElements, propContainer, buildingContext);
        for (XClass superClass = xClassProcessed.getSuperclass(); superClass != null && superClass.isAnnotationPresent(jakarta.persistence.MappedSuperclass.class); superClass = superClass.getSuperclass()) {
            propContainer = new PropertyContainer(superClass, xClassProcessed, propertyAccessor);
            AnnotationBinder.addElementsOfClass(classElements, propContainer, buildingContext);
        }
        if (baseClassElements != null && !AnnotationBinder.hasAnnotationsOnIdClass(xClassProcessed)) {
            for (int i = 0; i < classElements.size(); ++i) {
                PropertyData idClassPropertyData = (PropertyData)classElements.get(i);
                PropertyData entityPropertyData = (PropertyData)orderedBaseClassElements.get(idClassPropertyData.getPropertyName());
                if (propertyHolder.isInIdClass()) {
                    boolean isOfDifferentType;
                    if (entityPropertyData == null) {
                        throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, idClassPropertyData) + "' belongs to an '@IdClass' but has no matching property in entity class '" + baseInferredData.getPropertyClass().getName() + "' (every property of the '@IdClass' must have a corresponding persistent property in the '@Entity' class)");
                    }
                    boolean hasXToOneAnnotation = BinderHelper.hasToOneAnnotation((XAnnotatedElement)entityPropertyData.getProperty());
                    boolean bl = isOfDifferentType = !entityPropertyData.getClassOrElement().equals(idClassPropertyData.getClassOrElement());
                    if (hasXToOneAnnotation && isOfDifferentType) continue;
                    classElements.set(i, entityPropertyData);
                    continue;
                }
                classElements.set(i, entityPropertyData);
            }
        }
        for (PropertyData propertyAnnotatedElement : classElements) {
            String generator;
            AnnotationBinder.processElementAnnotations(subHolder, isNullable ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL, propertyAnnotatedElement, new HashMap<String, IdentifierGeneratorDefinition>(), entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, buildingContext, inheritanceStatePerClass);
            XProperty property = propertyAnnotatedElement.getProperty();
            if (!property.isAnnotationPresent(GeneratedValue.class) || !property.isAnnotationPresent(Id.class)) continue;
            GeneratedValue generatedValue = (GeneratedValue)property.getAnnotation(GeneratedValue.class);
            String generatorType = generatedValue != null ? AnnotationBinder.generatorType(generatedValue, buildingContext, property.getType()) : "assigned";
            String string = generator = generatedValue != null ? generatedValue.generator() : "";
            if (AnnotationBinder.isGlobalGeneratorNameGlobal(buildingContext)) {
                AnnotationBinder.buildGenerators((XAnnotatedElement)property, buildingContext);
                IdGeneratorResolverSecondPass secondPass = new IdGeneratorResolverSecondPass((SimpleValue)comp.getProperty(property.getName()).getValue(), property, generatorType, generator, buildingContext);
                buildingContext.getMetadataCollector().addSecondPass(secondPass);
                AnnotationBinder.handleTypeDescriptorRegistrations((XAnnotatedElement)property, buildingContext);
                AnnotationBinder.bindEmbeddableInstantiatorRegistrations((XAnnotatedElement)property, buildingContext);
                AnnotationBinder.bindCompositeUserTypeRegistrations((XAnnotatedElement)property, buildingContext);
                AnnotationBinder.handleConverterRegistrations((XAnnotatedElement)property, buildingContext);
                continue;
            }
            HashMap<String, IdentifierGeneratorDefinition> localGenerators = new HashMap<String, IdentifierGeneratorDefinition>(AnnotationBinder.buildGenerators((XAnnotatedElement)property, buildingContext));
            BinderHelper.makeIdGenerator((SimpleValue)comp.getProperty(property.getName()).getValue(), property, generatorType, generator, buildingContext, localGenerators);
        }
        if (compositeUserType != null) {
            comp.sortProperties();
            ArrayList<String> sortedPropertyNames = new ArrayList<String>(comp.getPropertySpan());
            ArrayList<Type> sortedPropertyTypes = new ArrayList<Type>(comp.getPropertySpan());
            PropertyAccessStrategyCompositeUserTypeImpl strategy = new PropertyAccessStrategyCompositeUserTypeImpl(compositeUserType, sortedPropertyNames, sortedPropertyTypes);
            for (Property property : comp.getProperties()) {
                sortedPropertyNames.add(property.getName());
                sortedPropertyTypes.add(PropertyAccessStrategyMixedImpl.INSTANCE.buildPropertyAccess(compositeUserType.embeddable(), property.getName(), false).getGetter().getReturnType());
                property.setPropertyAccessStrategy(strategy);
            }
        }
        return comp;
    }

    public static Component createComponent(PropertyHolder propertyHolder, PropertyData inferredData, boolean isComponentEmbedded, boolean isIdentifierMapper, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, MetadataBuildingContext context) {
        Component comp = new Component(context, propertyHolder.getPersistentClass());
        comp.setEmbedded(isComponentEmbedded);
        comp.setTable(propertyHolder.getTable());
        if (isIdentifierMapper || isComponentEmbedded && inferredData.getPropertyName() == null) {
            comp.setComponentClassName(comp.getOwner().getClassName());
        } else {
            comp.setComponentClassName(inferredData.getClassOrElementName());
        }
        comp.setCustomInstantiator(customInstantiatorImpl);
        return comp;
    }

    public static PropertyData getUniqueIdPropertyFromBaseClass(PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, MetadataBuildingContext context) {
        ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
        PropertyContainer propContainer = new PropertyContainer(baseInferredData.getClassOrElement(), inferredData.getPropertyClass(), propertyAccessor);
        AnnotationBinder.addElementsOfClass(baseClassElements, propContainer, context);
        return (PropertyData)baseClassElements.get(0);
    }

    private static void bindManyToOne(String cascadeStrategy, AnnotatedJoinColumn[] columns, boolean optional, NotFoundAction notFoundAction, boolean cascadeOnDelete, XClass targetEntity, PropertyHolder propertyHolder, PropertyData inferredData, boolean unique, boolean isIdentifierMapper, boolean inSecondPass, PropertyBinder propertyBinder, MetadataBuildingContext context) {
        org.hibernate.mapping.ManyToOne value = new org.hibernate.mapping.ManyToOne(context, columns[0].getTable());
        if (unique) {
            value.markAsLogicalOneToOne();
        }
        value.setReferencedEntityName(ToOneBinder.getReferenceEntityName(inferredData, targetEntity, context));
        XProperty property = inferredData.getProperty();
        AnnotationBinder.defineFetchingStrategy(value, property);
        value.setNotFoundAction(notFoundAction);
        value.setCascadeDeleteEnabled(cascadeOnDelete);
        if (!optional) {
            for (AnnotatedJoinColumn column : columns) {
                column.setNullable(false);
            }
        }
        if (property.isAnnotationPresent(MapsId.class)) {
            for (AnnotatedJoinColumn column : columns) {
                column.setInsertable(false);
                column.setUpdatable(false);
            }
        }
        JoinColumn joinColumn = (JoinColumn)property.getAnnotation(JoinColumn.class);
        JoinColumns joinColumns = (JoinColumns)property.getAnnotation(JoinColumns.class);
        boolean hasSpecjManyToOne = false;
        if (context.getBuildingOptions().isSpecjProprietarySyntaxEnabled()) {
            String columnName = "";
            for (XProperty prop : inferredData.getDeclaringClass().getDeclaredProperties(AccessType.FIELD.getType())) {
                if (prop.isAnnotationPresent(Id.class) && prop.isAnnotationPresent(jakarta.persistence.Column.class)) {
                    columnName = ((jakarta.persistence.Column)prop.getAnnotation(jakarta.persistence.Column.class)).name();
                }
                if (!property.isAnnotationPresent(ManyToOne.class) || joinColumn == null || BinderHelper.isEmptyAnnotationValue(joinColumn.name()) || !joinColumn.name().equals(columnName) || property.isAnnotationPresent(MapsId.class)) continue;
                hasSpecjManyToOne = true;
                for (AnnotatedJoinColumn column : columns) {
                    column.setInsertable(false);
                    column.setUpdatable(false);
                }
            }
        }
        value.setTypeName(inferredData.getClassOrElementName());
        String propertyName = inferredData.getPropertyName();
        value.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        AnnotationBinder.bindForeignKeyNameAndDefinition(value, property, propertyHolder.getOverriddenForeignKey(StringHelper.qualify(propertyHolder.getPath(), propertyName)), joinColumn, joinColumns, context);
        ToOneFkSecondPass secondPass = new ToOneFkSecondPass(value, columns, !optional && unique, propertyHolder.getEntityOwnerClassName(), propertyHolder.getPath() + "." + propertyName, context);
        if (inSecondPass) {
            secondPass.doSecondPass(context.getMetadataCollector().getEntityBindingMap());
        } else {
            context.getMetadataCollector().addSecondPass(secondPass);
        }
        AnnotatedColumn.checkPropertyConsistency(columns, propertyHolder.getEntityName() + "." + propertyName);
        propertyBinder.setName(propertyName);
        propertyBinder.setValue(value);
        if (isIdentifierMapper) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        } else if (hasSpecjManyToOne) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        } else {
            propertyBinder.setInsertable(columns[0].isInsertable());
            propertyBinder.setUpdatable(columns[0].isUpdatable());
        }
        propertyBinder.setColumns(columns);
        propertyBinder.setAccessType(inferredData.getDefaultAccess());
        propertyBinder.setCascade(cascadeStrategy);
        propertyBinder.setProperty(property);
        propertyBinder.setXToMany(true);
        propertyBinder.makePropertyAndBind().setOptional(optional && AnnotationBinder.isNullable(joinColumns, joinColumn));
    }

    private static boolean isNullable(JoinColumns joinColumns, JoinColumn joinColumn) {
        if (joinColumn != null) {
            return joinColumn.nullable();
        }
        if (joinColumns != null) {
            JoinColumn[] columns = joinColumns.value();
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].nullable()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void defineFetchingStrategy(ToOne toOne, XProperty property) {
        FetchType fetchType = AnnotationBinder.getJpaFetchType(property);
        LazyToOne lazy = (LazyToOne)property.getAnnotation(LazyToOne.class);
        NotFound notFound = (NotFound)property.getAnnotation(NotFound.class);
        if (notFound != null) {
            toOne.setLazy(false);
            toOne.setUnwrapProxy(true);
        } else if (lazy != null) {
            toOne.setLazy(lazy.value() != LazyToOneOption.FALSE);
            toOne.setUnwrapProxy(lazy.value() == LazyToOneOption.NO_PROXY);
        } else {
            toOne.setLazy(fetchType == FetchType.LAZY);
            toOne.setUnwrapProxy(fetchType != FetchType.LAZY);
            toOne.setUnwrapProxyImplicit(true);
        }
        Fetch fetch = (Fetch)property.getAnnotation(Fetch.class);
        if (fetch == null) {
            toOne.setFetchMode(AnnotationBinder.getFetchMode(fetchType));
            return;
        }
        if (fetch.value() == org.hibernate.annotations.FetchMode.JOIN) {
            toOne.setFetchMode(FetchMode.JOIN);
            toOne.setLazy(false);
            toOne.setUnwrapProxy(false);
            return;
        }
        if (fetch.value() == org.hibernate.annotations.FetchMode.SELECT) {
            toOne.setFetchMode(FetchMode.SELECT);
            return;
        }
        if (fetch.value() != org.hibernate.annotations.FetchMode.SUBSELECT) throw new AssertionFailure("Unknown FetchMode: " + fetch.value());
        throw new AnnotationException("Association '" + property.getName() + "' is annotated '@Fetch(SUBSELECT)' but is not many-valued");
    }

    private static FetchType getJpaFetchType(XProperty property) {
        ManyToOne manyToOne = (ManyToOne)property.getAnnotation(ManyToOne.class);
        OneToOne oneToOne = (OneToOne)property.getAnnotation(OneToOne.class);
        if (manyToOne != null) {
            return manyToOne.fetch();
        }
        if (oneToOne != null) {
            return oneToOne.fetch();
        }
        throw new AssertionFailure("Define fetch strategy on a property not annotated with @OneToMany nor @OneToOne");
    }

    private static void bindOneToOne(String cascadeStrategy, AnnotatedJoinColumn[] joinColumns, boolean optional, FetchMode fetchMode, NotFoundAction notFoundAction, boolean cascadeOnDelete, XClass targetEntity, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy, boolean trueOneToOne, boolean isIdentifierMapper, boolean inSecondPass, PropertyBinder propertyBinder, MetadataBuildingContext context) {
        String propertyName = inferredData.getPropertyName();
        LOG.tracev("Fetching {0} with {1}", propertyName, (Object)fetchMode);
        if (AnnotationBinder.isMapToPK(joinColumns, propertyHolder, trueOneToOne) || !BinderHelper.isEmptyAnnotationValue(mappedBy)) {
            OneToOneSecondPass secondPass = new OneToOneSecondPass(mappedBy, propertyHolder.getEntityName(), propertyName, propertyHolder, inferredData, targetEntity, notFoundAction, cascadeOnDelete, optional, cascadeStrategy, joinColumns, context);
            if (inSecondPass) {
                secondPass.doSecondPass(context.getMetadataCollector().getEntityBindingMap());
            } else {
                context.getMetadataCollector().addSecondPass(secondPass, BinderHelper.isEmptyAnnotationValue(mappedBy));
            }
        } else {
            AnnotationBinder.bindManyToOne(cascadeStrategy, joinColumns, optional, notFoundAction, cascadeOnDelete, targetEntity, propertyHolder, inferredData, true, isIdentifierMapper, inSecondPass, propertyBinder, context);
        }
    }

    private static boolean isMapToPK(AnnotatedJoinColumn[] joinColumns, PropertyHolder propertyHolder, boolean trueOneToOne) {
        if (trueOneToOne) {
            return true;
        }
        KeyValue identifier = propertyHolder.getIdentifier();
        if (identifier == null) {
            return false;
        }
        ArrayList<String> idColumnNames = new ArrayList<String>();
        if (identifier.getColumnSpan() != joinColumns.length) {
            return false;
        }
        for (Column currentColumn : identifier.getColumns()) {
            idColumnNames.add(currentColumn.getName());
        }
        for (AnnotatedJoinColumn col : joinColumns) {
            if (idColumnNames.contains(col.getMappingColumn().getName())) continue;
            return false;
        }
        return true;
    }

    private static void bindAny(String cascadeStrategy, AnnotatedJoinColumn[] columns, boolean cascadeOnDelete, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext buildingContext) {
        XProperty property = inferredData.getProperty();
        Any any = (Any)property.getAnnotation(Any.class);
        if (any == null) {
            throw new AssertionFailure("Missing @Any annotation: " + BinderHelper.getPath(propertyHolder, inferredData));
        }
        boolean lazy = any.fetch() == FetchType.LAZY;
        org.hibernate.mapping.Any value = BinderHelper.buildAnyValue((jakarta.persistence.Column)property.getAnnotation(jakarta.persistence.Column.class), BinderHelper.getOverridableAnnotation((XAnnotatedElement)property, Formula.class, buildingContext), columns, inferredData, cascadeOnDelete, lazy, nullability, propertyHolder, entityBinder, any.optional(), buildingContext);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue(value);
        binder.setLazy(lazy);
        if (isIdentifierMapper) {
            binder.setInsertable(false);
            binder.setUpdatable(false);
        } else {
            binder.setInsertable(columns[0].isInsertable());
            binder.setUpdatable(columns[0].isUpdatable());
        }
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setCascade(cascadeStrategy);
        Property prop = binder.makeProperty();
        propertyHolder.addProperty(prop, columns, inferredData.getDeclaringClass());
    }

    private static EnumSet<CascadeType> convertToHibernateCascadeType(jakarta.persistence.CascadeType[] ejbCascades) {
        EnumSet<CascadeType> cascadeTypes = EnumSet.noneOf(CascadeType.class);
        if (ejbCascades != null && ejbCascades.length > 0) {
            for (jakarta.persistence.CascadeType cascade : ejbCascades) {
                cascadeTypes.add(AnnotationBinder.convertCascadeType(cascade));
            }
        }
        return cascadeTypes;
    }

    private static CascadeType convertCascadeType(jakarta.persistence.CascadeType cascade) {
        switch (cascade) {
            case ALL: {
                return CascadeType.ALL;
            }
            case PERSIST: {
                return CascadeType.PERSIST;
            }
            case MERGE: {
                return CascadeType.MERGE;
            }
            case REMOVE: {
                return CascadeType.REMOVE;
            }
            case REFRESH: {
                return CascadeType.REFRESH;
            }
            case DETACH: {
                return CascadeType.DETACH;
            }
        }
        throw new AssertionFailure("unknown cascade type: " + cascade);
    }

    public static String getCascadeStrategy(jakarta.persistence.CascadeType[] ejbCascades, Cascade hibernateCascadeAnnotation, boolean orphanRemoval, boolean forcePersist) {
        CascadeType[] hibernateCascades;
        EnumSet<CascadeType> cascadeTypes = AnnotationBinder.convertToHibernateCascadeType(ejbCascades);
        CascadeType[] cascadeTypeArray = hibernateCascades = hibernateCascadeAnnotation == null ? null : hibernateCascadeAnnotation.value();
        if (hibernateCascades != null && hibernateCascades.length > 0) {
            cascadeTypes.addAll(Arrays.asList(hibernateCascades));
        }
        if (orphanRemoval) {
            cascadeTypes.add(CascadeType.DELETE_ORPHAN);
            cascadeTypes.add(CascadeType.REMOVE);
        }
        if (forcePersist) {
            cascadeTypes.add(CascadeType.PERSIST);
        }
        return AnnotationBinder.renderCascadeTypeList(cascadeTypes);
    }

    private static String renderCascadeTypeList(EnumSet<CascadeType> cascadeTypes) {
        StringBuilder cascade = new StringBuilder();
        for (CascadeType cascadeType : cascadeTypes) {
            switch (cascadeType) {
                case ALL: {
                    cascade.append(",").append("all");
                    break;
                }
                case SAVE_UPDATE: {
                    cascade.append(",").append("save-update");
                    break;
                }
                case PERSIST: {
                    cascade.append(",").append("persist");
                    break;
                }
                case MERGE: {
                    cascade.append(",").append("merge");
                    break;
                }
                case LOCK: {
                    cascade.append(",").append("lock");
                    break;
                }
                case REFRESH: {
                    cascade.append(",").append("refresh");
                    break;
                }
                case REPLICATE: {
                    cascade.append(",").append("replicate");
                    break;
                }
                case DETACH: {
                    cascade.append(",").append("evict");
                    break;
                }
                case DELETE: 
                case REMOVE: {
                    cascade.append(",").append("delete");
                    break;
                }
                case DELETE_ORPHAN: {
                    cascade.append(",").append("delete-orphan");
                }
            }
        }
        return cascade.length() > 0 ? cascade.substring(1) : "none";
    }

    public static FetchMode getFetchMode(FetchType fetch) {
        return fetch == FetchType.EAGER ? FetchMode.JOIN : FetchMode.SELECT;
    }

    public static void bindForeignKeyNameAndDefinition(SimpleValue value, XProperty property, ForeignKey fkOverride, JoinColumn joinColumn, JoinColumns joinColumns, MetadataBuildingContext context) {
        if (property.getAnnotation(NotFound.class) != null) {
            value.disableForeignKey();
        } else if (joinColumn != null && AnnotationBinder.noConstraint(joinColumn.foreignKey(), context) || joinColumns != null && AnnotationBinder.noConstraint(joinColumns.foreignKey(), context)) {
            value.disableForeignKey();
        } else {
            org.hibernate.annotations.ForeignKey fk = (org.hibernate.annotations.ForeignKey)property.getAnnotation(org.hibernate.annotations.ForeignKey.class);
            if (fk != null && StringHelper.isNotEmpty(fk.name())) {
                value.setForeignKeyName(fk.name());
            } else if (AnnotationBinder.noConstraint(fkOverride, context)) {
                value.disableForeignKey();
            } else if (fkOverride != null) {
                value.setForeignKeyName(StringHelper.nullIfEmpty(fkOverride.name()));
                value.setForeignKeyDefinition(StringHelper.nullIfEmpty(fkOverride.foreignKeyDefinition()));
            } else if (joinColumns != null) {
                value.setForeignKeyName(StringHelper.nullIfEmpty(joinColumns.foreignKey().name()));
                value.setForeignKeyDefinition(StringHelper.nullIfEmpty(joinColumns.foreignKey().foreignKeyDefinition()));
            } else if (joinColumn != null) {
                value.setForeignKeyName(StringHelper.nullIfEmpty(joinColumn.foreignKey().name()));
                value.setForeignKeyDefinition(StringHelper.nullIfEmpty(joinColumn.foreignKey().foreignKeyDefinition()));
            }
        }
    }

    private static boolean noConstraint(ForeignKey joinColumns, MetadataBuildingContext context) {
        return joinColumns != null && (joinColumns.value() == ConstraintMode.NO_CONSTRAINT || joinColumns.value() == ConstraintMode.PROVIDER_DEFAULT && context.getBuildingOptions().isNoConstraintByDefault());
    }

    public static HashMap<String, IdentifierGeneratorDefinition> buildGenerators(XAnnotatedElement annElt, MetadataBuildingContext context) {
        GenericGenerator genGen;
        SequenceGenerator seqGen;
        TableGenerator tabGen;
        SequenceGenerators sequenceGenerators;
        InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
        HashMap<String, IdentifierGeneratorDefinition> generators = new HashMap<String, IdentifierGeneratorDefinition>();
        TableGenerators tableGenerators = (TableGenerators)annElt.getAnnotation(TableGenerators.class);
        if (tableGenerators != null) {
            for (TableGenerator tableGenerator : tableGenerators.value()) {
                IdentifierGeneratorDefinition idGenerator = AnnotationBinder.buildIdGenerator((Annotation)tableGenerator, context);
                generators.put(idGenerator.getName(), idGenerator);
                metadataCollector.addIdentifierGenerator(idGenerator);
            }
        }
        if ((sequenceGenerators = (SequenceGenerators)annElt.getAnnotation(SequenceGenerators.class)) != null) {
            for (SequenceGenerator sequenceGenerator : sequenceGenerators.value()) {
                IdentifierGeneratorDefinition idGenerator = AnnotationBinder.buildIdGenerator((Annotation)sequenceGenerator, context);
                generators.put(idGenerator.getName(), idGenerator);
                metadataCollector.addIdentifierGenerator(idGenerator);
            }
        }
        if ((tabGen = (TableGenerator)annElt.getAnnotation(TableGenerator.class)) != null) {
            IdentifierGeneratorDefinition idGen = AnnotationBinder.buildIdGenerator((Annotation)tabGen, context);
            generators.put(idGen.getName(), idGen);
            metadataCollector.addIdentifierGenerator(idGen);
        }
        if ((seqGen = (SequenceGenerator)annElt.getAnnotation(SequenceGenerator.class)) != null) {
            IdentifierGeneratorDefinition idGen = AnnotationBinder.buildIdGenerator((Annotation)seqGen, context);
            generators.put(idGen.getName(), idGen);
            metadataCollector.addIdentifierGenerator(idGen);
        }
        if ((genGen = (GenericGenerator)annElt.getAnnotation(GenericGenerator.class)) != null) {
            IdentifierGeneratorDefinition idGen = AnnotationBinder.buildIdGenerator(genGen, context);
            generators.put(idGen.getName(), idGen);
            metadataCollector.addIdentifierGenerator(idGen);
        }
        return generators;
    }

    public static boolean isDefault(XClass clazz, MetadataBuildingContext context) {
        return context.getBootstrapContext().getReflectionManager().equals(clazz, Void.TYPE);
    }

    public static Map<XClass, InheritanceState> buildInheritanceStates(List<XClass> orderedClasses, MetadataBuildingContext buildingContext) {
        HashMap<XClass, InheritanceState> inheritanceStatePerClass = new HashMap<XClass, InheritanceState>(orderedClasses.size());
        for (XClass clazz : orderedClasses) {
            InheritanceState superclassState = InheritanceState.getSuperclassInheritanceState(clazz, inheritanceStatePerClass);
            InheritanceState state = new InheritanceState(clazz, inheritanceStatePerClass, buildingContext);
            if (superclassState != null) {
                superclassState.setHasSiblings(true);
                InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(clazz, inheritanceStatePerClass);
                state.setHasParents(superEntityState != null);
                AnnotationBinder.logMixedInheritance(clazz, superclassState, state);
                if (superclassState.getType() != null) {
                    state.setType(superclassState.getType());
                }
            }
            inheritanceStatePerClass.put(clazz, state);
        }
        return inheritanceStatePerClass;
    }

    private static void logMixedInheritance(XClass clazz, InheritanceState superclassState, InheritanceState state) {
        if (state.getType() != null && superclassState.getType() != null) {
            boolean mixingStrategy;
            boolean nonDefault = InheritanceType.SINGLE_TABLE != state.getType();
            boolean bl = mixingStrategy = state.getType() != superclassState.getType();
            if (nonDefault && mixingStrategy) {
                LOG.invalidSubStrategy(clazz.getName());
            }
        }
    }

    private static boolean hasAnnotationsOnIdClass(XClass idClass) {
        for (XProperty property : idClass.getDeclaredProperties("field")) {
            if (!AnnotationBinder.hasTriggeringAnnotation((XAnnotatedElement)property)) continue;
            return true;
        }
        for (XMethod method : idClass.getDeclaredMethods()) {
            if (!AnnotationBinder.hasTriggeringAnnotation((XAnnotatedElement)method)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTriggeringAnnotation(XAnnotatedElement property) {
        return property.isAnnotationPresent(jakarta.persistence.Column.class) || property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToOne.class) || property.isAnnotationPresent(Id.class) || property.isAnnotationPresent(GeneratedValue.class) || property.isAnnotationPresent(OneToOne.class) || property.isAnnotationPresent(ManyToMany.class);
    }

    private static void matchIgnoreNotFoundWithFetchType(String entity, String association, NotFoundAction notFoundAction, FetchType fetchType) {
        if (notFoundAction != null && fetchType == FetchType.LAZY) {
            LOG.ignoreNotFoundWithFetchTypeLazy(entity, association);
        }
    }

    private static class CustomIdGeneratorCreator
    implements IdentifierGeneratorCreator {
        private final Annotation generatorAnnotation;
        private final Member underlyingMember;

        public CustomIdGeneratorCreator(Annotation generatorAnnotation, XProperty idXProperty) {
            this.generatorAnnotation = generatorAnnotation;
            this.underlyingMember = HCANNHelper.getUnderlyingMember(idXProperty);
        }

        @Override
        public IdentifierGenerator createGenerator(CustomIdGeneratorCreationContext context) {
            IdGeneratorType idGeneratorType = this.generatorAnnotation.annotationType().getAnnotation(IdGeneratorType.class);
            assert (idGeneratorType != null);
            Class<? extends IdentifierGenerator> generatorClass = idGeneratorType.value();
            try {
                return generatorClass.getConstructor(this.generatorAnnotation.annotationType(), Member.class, CustomIdGeneratorCreationContext.class).newInstance(this.generatorAnnotation, this.underlyingMember, context);
            }
            catch (NoSuchMethodException e) {
                throw new HibernateException("Unable to find appropriate constructor for @IdGeneratorType handling : " + generatorClass.getName(), e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new HibernateException("Unable to invoke constructor for @IdGeneratorType handling : " + generatorClass.getName(), e);
            }
        }
    }
}

