/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.internal.AbstractDiscriminatorMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;

public class ExplicitColumnDiscriminatorMappingImpl
extends AbstractDiscriminatorMapping {
    private final String tableExpression;
    private final String columnName;
    private final String columnFormula;
    private final boolean isPhysical;
    private final String columnDefinition;
    private final Long length;
    private final Integer precision;
    private final Integer scale;

    public ExplicitColumnDiscriminatorMappingImpl(EntityPersister entityDescriptor, DiscriminatorType<?> discriminatorType, String tableExpression, String columnExpression, boolean isFormula, boolean isPhysical, String columnDefinition, Long length, Integer precision, Integer scale, MappingModelCreationProcess creationProcess) {
        super(entityDescriptor, discriminatorType, creationProcess);
        this.tableExpression = tableExpression;
        this.isPhysical = isPhysical;
        this.columnDefinition = columnDefinition;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        if (isFormula) {
            this.columnName = null;
            this.columnFormula = columnExpression;
        } else {
            this.columnName = columnExpression;
            this.columnFormula = null;
        }
    }

    @Override
    public Expression resolveSqlExpression(NavigablePath navigablePath, JdbcMapping jdbcMappingToUse, TableGroup tableGroup, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath, this.tableExpression);
        String selectionExpression = this.getSelectionExpression();
        return expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectionExpression), sqlAstProcessingState -> new ColumnReference(tableReference, selectionExpression, this.columnFormula != null, null, null, this.getJdbcMapping(), this.getSessionFactory()));
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public String getSelectionExpression() {
        return this.columnName == null ? this.columnFormula : this.columnName;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public boolean isFormula() {
        return this.columnFormula != null;
    }

    @Override
    public boolean isPhysical() {
        return this.isPhysical;
    }
}

