/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.procedure.ProcedureParameter;
import org.hibernate.query.spi.ProcedureParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterImplementor;

public class ProcedureParameterMetadataImpl
implements ProcedureParameterMetadataImplementor {
    private ParameterStrategy parameterStrategy = ParameterStrategy.UNKNOWN;
    private List<ProcedureParameterImplementor<?>> parameters;

    public ProcedureParameterMetadataImpl() {
    }

    public ProcedureParameterMetadataImpl(NamedCallableQueryMemento memento, SharedSessionContractImplementor session) {
        memento.getParameterMementos().forEach(parameterMemento -> this.registerParameter(parameterMemento.resolve(session)));
    }

    public void registerParameter(ProcedureParameterImplementor parameter) {
        if (parameter.getName() != null) {
            if (this.parameterStrategy == ParameterStrategy.POSITIONAL) {
                throw new IllegalArgumentException("Cannot mix named parameter with positional parameter registrations");
            }
            this.parameterStrategy = ParameterStrategy.NAMED;
        } else if (parameter.getPosition() != null) {
            if (this.parameterStrategy == ParameterStrategy.NAMED) {
                throw new IllegalArgumentException("Cannot mix positional parameter with named parameter registrations");
            }
            this.parameterStrategy = ParameterStrategy.POSITIONAL;
        } else {
            throw new IllegalArgumentException("Unrecognized parameter type : " + parameter);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parameter);
    }

    @Override
    public void visitParameters(Consumer<QueryParameterImplementor<?>> consumer) {
        if (this.parameters != null) {
            this.parameters.forEach(consumer);
        }
    }

    @Override
    public boolean hasNamedParameters() {
        return this.parameterStrategy == ParameterStrategy.NAMED;
    }

    @Override
    public boolean hasPositionalParameters() {
        return this.parameterStrategy == ParameterStrategy.POSITIONAL;
    }

    @Override
    public Set<String> getNamedParameterNames() {
        if (!this.hasNamedParameters()) {
            return Collections.emptySet();
        }
        HashSet<String> rtn = new HashSet<String>();
        for (ProcedureParameter procedureParameter : this.parameters) {
            if (procedureParameter.getName() == null) continue;
            rtn.add(procedureParameter.getName());
        }
        return rtn;
    }

    @Override
    public int getParameterCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public boolean containsReference(QueryParameter parameter) {
        if (this.parameters == null) {
            return false;
        }
        return this.parameters.contains(parameter);
    }

    public ParameterStrategy getParameterStrategy() {
        return this.parameterStrategy;
    }

    @Override
    public boolean hasAnyMatching(Predicate<QueryParameterImplementor<?>> filter) {
        if (this.parameters.isEmpty()) {
            return false;
        }
        for (ProcedureParameterImplementor<?> parameter : this.parameters) {
            if (!filter.test(parameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ProcedureParameterImplementor<?> findQueryParameter(String name) {
        for (ProcedureParameterImplementor<?> parameter : this.parameters) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public ProcedureParameterImplementor<?> getQueryParameter(String name) {
        QueryParameterImplementor parameter = this.findQueryParameter(name);
        if (parameter != null) {
            return parameter;
        }
        throw new IllegalArgumentException("Named parameter [" + name + "] is not registered with this procedure call");
    }

    @Override
    public ProcedureParameterImplementor<?> findQueryParameter(int positionLabel) {
        for (ProcedureParameterImplementor<?> parameter : this.parameters) {
            if (parameter.getName() != null || positionLabel != parameter.getPosition()) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public ProcedureParameterImplementor<?> getQueryParameter(int positionLabel) {
        QueryParameterImplementor queryParameter = this.findQueryParameter(positionLabel);
        if (queryParameter != null) {
            return queryParameter;
        }
        throw new IllegalArgumentException("Positional parameter [" + positionLabel + "] is not registered with this procedure call");
    }

    public <P> ProcedureParameterImplementor<P> resolve(Parameter<P> param) {
        if (param instanceof ProcedureParameterImplementor) {
            for (ProcedureParameterImplementor<?> p : this.parameters) {
                if (p != param) continue;
                return p;
            }
        }
        return null;
    }

    @Override
    public Set<? extends QueryParameter<?>> getRegistrations() {
        if (this.parameters == null) {
            return Collections.emptySet();
        }
        return new HashSet(this.parameters);
    }

    @Override
    public List<? extends ProcedureParameterImplementor<?>> getRegistrationsAsList() {
        if (this.parameters == null) {
            return Collections.emptyList();
        }
        return this.parameters;
    }

    @Override
    public void visitRegistrations(Consumer<? extends QueryParameter<?>> action) {
        if (this.parameters != null) {
            this.parameters.forEach(action);
        }
    }

    @Override
    public Set<Integer> getOrdinalParameterLabels() {
        HashSet<Integer> labels = new HashSet<Integer>();
        this.visitRegistrations(p -> {
            if (p.getPosition() != null) {
                labels.add(p.getPosition());
            }
        });
        return labels;
    }
}

