/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.cte;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.sql.ast.tree.cte.CteColumn;

public class CteTable {
    private final SessionFactoryImplementor sessionFactory;
    private final String cteName;
    private final List<CteColumn> cteColumns;

    public CteTable(String cteName, EntityMappingType entityDescriptor) {
        int numberOfColumns = entityDescriptor.getIdentifierMapping().getJdbcTypeCount();
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(numberOfColumns);
        entityDescriptor.getIdentifierMapping().forEachSelectable((columnIndex, selection) -> columns.add(new CteColumn("cte_" + selection.getSelectionExpression(), selection.getJdbcMapping())));
        this.cteName = cteName;
        this.cteColumns = columns;
        this.sessionFactory = entityDescriptor.getEntityPersister().getFactory();
    }

    public CteTable(String cteName, List<CteColumn> cteColumns, SessionFactoryImplementor sessionFactory) {
        this.cteName = cteName;
        this.cteColumns = cteColumns;
        this.sessionFactory = sessionFactory;
    }

    public String getTableExpression() {
        return this.cteName;
    }

    public List<CteColumn> getCteColumns() {
        return this.cteColumns;
    }

    public CteTable withName(String name) {
        return new CteTable(name, this.cteColumns, this.sessionFactory);
    }
}

