/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing.contrib.interceptor;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.smallrye.opentracing.contrib.resolver.TracerResolver;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.ws.rs.Path;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.microprofile.opentracing.Traced;

@Traced
@Interceptor
@Priority(value=1001)
public class OpenTracingInterceptor {
    public static final String SPAN_CONTEXT = "__opentracing_span_context";
    private static final Logger log = Logger.getLogger(OpenTracingInterceptor.class.getName());
    @Inject
    Instance<Tracer> tracerInstance;
    private volatile Tracer tracer = null;

    @AroundInvoke
    public Object wrap(InvocationContext ctx) throws Exception {
        if (this.skipJaxRs(ctx.getMethod())) {
            return ctx.proceed();
        }
        if (!this.traced(ctx.getMethod())) {
            return ctx.proceed();
        }
        Tracer tracer = this.getTracer();
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(this.getOperationName(ctx.getMethod()));
        int contextParameterIndex = -1;
        for (int i = 0; i < ctx.getParameters().length; ++i) {
            Object parameter = ctx.getParameters()[i];
            if (parameter instanceof SpanContext) {
                log.fine("Found parameter as span context. Using it as the parent of this new span");
                spanBuilder.asChildOf((SpanContext)parameter);
                contextParameterIndex = i;
                break;
            }
            if (!(parameter instanceof Span)) continue;
            log.fine("Found parameter as span. Using it as the parent of this new span");
            spanBuilder.asChildOf((Span)parameter);
            contextParameterIndex = i;
            break;
        }
        if (contextParameterIndex < 0) {
            log.fine("No parent found. Trying to get span context from context data");
            Object ctxParentSpan = ctx.getContextData().get(SPAN_CONTEXT);
            if (ctxParentSpan instanceof SpanContext) {
                log.fine("Found span context from context data.");
                SpanContext parentSpan = (SpanContext)ctxParentSpan;
                spanBuilder.asChildOf(parentSpan);
            }
        }
        Span span = spanBuilder.start();
        Scope scope = tracer.activateSpan(span);
        try {
            log.fine("Adding span context into the invocation context.");
            ctx.getContextData().put(SPAN_CONTEXT, span.context());
            if (contextParameterIndex >= 0) {
                log.fine("Overriding the original span context with our new context.");
                for (int i = 0; i < ctx.getParameters().length; ++i) {
                    if (ctx.getParameters()[contextParameterIndex] instanceof Span) {
                        ctx.getParameters()[contextParameterIndex] = span;
                    }
                    if (!(ctx.getParameters()[contextParameterIndex] instanceof SpanContext)) continue;
                    ctx.getParameters()[contextParameterIndex] = span.context();
                }
            }
            Object i = ctx.proceed();
            return i;
        }
        catch (Exception e) {
            this.logException(span, e);
            throw e;
        }
        finally {
            span.finish();
            scope.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer getTracer() {
        Tracer val = this.tracer;
        if (val != null) {
            return val;
        }
        OpenTracingInterceptor openTracingInterceptor = this;
        synchronized (openTracingInterceptor) {
            if (this.tracer == null) {
                this.tracer = null != this.tracerInstance && !this.tracerInstance.isUnsatisfied() ? (Tracer)this.tracerInstance.get() : TracerResolver.resolveTracer();
            }
            return this.tracer;
        }
    }

    private boolean traced(Method method) {
        Traced classTraced = method.getDeclaringClass().getAnnotation(Traced.class);
        Traced methodTraced = method.getAnnotation(Traced.class);
        if (methodTraced != null) {
            return methodTraced.value();
        }
        return classTraced != null && classTraced.value();
    }

    private boolean skipJaxRs(Method method) {
        return method.getAnnotation(Path.class) != null || method.getDeclaringClass().getAnnotation(Path.class) != null;
    }

    private String getOperationName(Method method) {
        Traced classTraced = method.getDeclaringClass().getAnnotation(Traced.class);
        Traced methodTraced = method.getAnnotation(Traced.class);
        if (methodTraced != null && methodTraced.operationName().length() > 0) {
            return methodTraced.operationName();
        }
        if (classTraced != null && classTraced.operationName().length() > 0) {
            return classTraced.operationName();
        }
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        int capacity = className.length() + methodName.length() + 1;
        StringBuilder builder = new StringBuilder(capacity);
        builder.append(className).append('.').append(methodName);
        return builder.toString();
    }

    private void logException(Span span, Exception e) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.object", e);
        span.log(errorLogs);
        Tags.ERROR.set(span, Boolean.valueOf(true));
    }
}

