/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AmqpIngressTimestampTest
extends AmqpClientTestSupport {
    public int amqpMinLargeMessageSize = 102400;
    @Parameterized.Parameter(value=0)
    public boolean restart;
    @Parameterized.Parameter(value=1)
    public boolean large;

    @Parameterized.Parameters(name="restart={0}, large={1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true, true}, {false, false}, {true, false}, {false, true});
    }

    @Test(timeout=60000L)
    public void testIngressTimestampSendCore() throws Exception {
        this.internalTestIngressTimestamp(Protocol.CORE);
    }

    @Test(timeout=60000L)
    public void testIngressTimestampSendAMQP() throws Exception {
        this.internalTestIngressTimestamp(Protocol.AMQP);
    }

    @Test(timeout=60000L)
    public void testIngressTimestampSendOpenWire() throws Exception {
        this.internalTestIngressTimestamp(Protocol.OPENWIRE);
    }

    private void internalTestIngressTimestamp(Protocol protocol) throws Exception {
        String QUEUE_NAME = RandomUtil.randomString();
        this.server.createQueue(new QueueConfiguration(QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        this.server.getAddressSettingsRepository().addMatch(QUEUE_NAME, (Object)new AddressSettings().setEnableIngressTimestamp(true));
        long beforeSend = System.currentTimeMillis();
        if (protocol == Protocol.CORE) {
            this.sendMessagesCore(QUEUE_NAME, 1, true, this.getMessagePayload());
        } else if (protocol == Protocol.OPENWIRE) {
            this.sendMessagesOpenWire(QUEUE_NAME, 1, true, this.getMessagePayload());
        } else {
            this.sendMessages(QUEUE_NAME, 1, true, this.getMessagePayload());
        }
        long afterSend = System.currentTimeMillis();
        if (this.restart) {
            this.server.stop();
            this.server.start();
            AmqpIngressTimestampTest.assertTrue((boolean)this.server.waitForActivation(3L, TimeUnit.SECONDS));
        }
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(QUEUE_NAME);
        Queue queueView = this.getProxyToQueue(QUEUE_NAME);
        Wait.assertEquals((Long)1L, () -> ((Queue)queueView).getMessageCount(), (long)2000L, (long)100L, (boolean)false);
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpIngressTimestampTest.assertNotNull((Object)receive);
        this.instanceLog.info((Object)receive);
        Object ingressTimestampHeader = receive.getMessageAnnotation("x-opt-ingress-time");
        AmqpIngressTimestampTest.assertNotNull((Object)ingressTimestampHeader);
        AmqpIngressTimestampTest.assertTrue((boolean)(ingressTimestampHeader instanceof Long));
        long ingressTimestamp = (Long)ingressTimestampHeader;
        AmqpIngressTimestampTest.assertTrue((String)("Ingress timstamp " + ingressTimestamp + " should be >= " + beforeSend + " and <= " + afterSend), (ingressTimestamp >= beforeSend && ingressTimestamp <= afterSend ? 1 : 0) != 0);
        receiver.close();
        AmqpIngressTimestampTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Override
    protected void setData(AmqpMessage amqpMessage) throws Exception {
        amqpMessage.setBytes(this.getMessagePayload());
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        params.put("amqpMinLargeMessageSize", 102400);
    }

    private byte[] getMessagePayload() {
        StringBuilder result = new StringBuilder();
        if (this.large) {
            for (int i = 0; i < 2048000; ++i) {
                result.append("AB");
            }
        } else {
            result.append("AB");
        }
        return result.toString().getBytes();
    }

    private static enum Protocol {
        CORE,
        AMQP,
        OPENWIRE;

    }
}

