/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.json.JsonArray;
import java.util.ArrayList;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.JGroupsFileBroadcastGroupControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JGroupsFileBroadcastGroupControlTest
extends ManagementTestBase {
    private ActiveMQServer server;
    BroadcastGroupConfiguration broadcastGroupConfig;
    JGroupsFileBroadcastGroupControl broadcastGroupControl;

    @Test
    public void testAttributes() throws Exception {
        JGroupsFileBroadcastEndpointFactory udpCfg = (JGroupsFileBroadcastEndpointFactory)this.broadcastGroupConfig.getEndpointFactory();
        Assert.assertEquals((Object)this.broadcastGroupConfig.getName(), (Object)this.broadcastGroupControl.getName());
        Assert.assertEquals((Object)udpCfg.getChannelName(), (Object)this.broadcastGroupControl.getChannelName());
        Assert.assertEquals((Object)udpCfg.getFile(), (Object)this.broadcastGroupControl.getFile());
        Assert.assertEquals((long)this.broadcastGroupConfig.getBroadcastPeriod(), (long)this.broadcastGroupControl.getBroadcastPeriod());
        Object[] connectorPairs = this.broadcastGroupControl.getConnectorPairs();
        Assert.assertEquals((long)1L, (long)connectorPairs.length);
        String connectorPairData = (String)connectorPairs[0];
        Assert.assertEquals(this.broadcastGroupConfig.getConnectorInfos().get(0), (Object)connectorPairData);
        String jsonString = this.broadcastGroupControl.getConnectorPairsAsJSON();
        Assert.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assert.assertEquals((long)1L, (long)array.size());
        Assert.assertEquals(this.broadcastGroupConfig.getConnectorInfos().get(0), (Object)array.getString(0));
        Assert.assertTrue((boolean)this.broadcastGroupControl.isStarted());
    }

    protected JGroupsFileBroadcastGroupControl createManagementControl(String name) throws Exception {
        return ManagementControlHelper.createJgroupsFileBroadcastGroupControl(name, this.mbeanServer);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        TransportConfiguration connectorConfiguration = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        ArrayList<String> connectorInfos = new ArrayList<String>();
        connectorInfos.add(connectorConfiguration.getName());
        this.broadcastGroupConfig = new BroadcastGroupConfiguration().setName(RandomUtil.randomString()).setBroadcastPeriod((long)RandomUtil.randomPositiveInt()).setConnectorInfos(connectorInfos).setEndpointFactory((BroadcastEndpointFactory)new JGroupsFileBroadcastEndpointFactory().setChannelName("myChannel").setFile("test-jgroups-file_ping.xml"));
        Configuration config = this.createDefaultInVMConfig().setJMXManagementEnabled(true).addConnectorConfiguration(connectorConfiguration.getName(), connectorConfiguration).addBroadcastGroupConfiguration(this.broadcastGroupConfig);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (MBeanServer)this.mbeanServer, (boolean)false));
        this.server.start();
        this.broadcastGroupControl = this.createManagementControl(this.broadcastGroupConfig.getName());
    }
}

