/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.impl.NotificationActiveMQServerPlugin;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NotificationTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession session;
    private ClientConsumer notifConsumer;
    private SimpleString notifQueue;
    private ServerLocator locator;

    @Test
    public void testBINDING_ADDED() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        NotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(durable)));
        ClientMessage[] notifications = NotificationTest.consumeMessages(2, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.BINDING_ADDED.toString(), (Object)notifications[1].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertEquals((Object)queue.toString(), (Object)notifications[1].getObjectProperty(ManagementHelper.HDR_ROUTING_NAME).toString());
        Assert.assertEquals((Object)address.toString(), (Object)notifications[1].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assert.assertTrue((notifications[1].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[1].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[1].getTimestamp(), (long)((Long)notifications[1].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
        this.session.deleteQueue(queue);
    }

    @Test
    public void testBINDING_ADDEDWithMatchingFilter() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        this.notifConsumer.close();
        this.notifConsumer = this.session.createConsumer(this.notifQueue.toString(), ManagementHelper.HDR_ROUTING_NAME + "= '" + queue + "'");
        NotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(durable)));
        ClientMessage[] notifications = NotificationTest.consumeMessages(1, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.BINDING_ADDED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertEquals((Object)queue.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_NAME).toString());
        Assert.assertEquals((Object)address.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
        this.session.deleteQueue(queue);
    }

    @Test
    public void testBINDING_ADDEDWithNonMatchingFilter() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        this.notifConsumer.close();
        this.notifConsumer = this.session.createConsumer(this.notifQueue.toString(), ManagementHelper.HDR_ROUTING_NAME + " <> '" + queue + "' AND " + ManagementHelper.HDR_ADDRESS + " <> '" + address + "'");
        NotificationTest.flush(this.notifConsumer);
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(durable)));
        NotificationTest.consumeMessages(0, this.notifConsumer);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testBINDING_REMOVED() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(durable)));
        NotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        this.session.deleteQueue(queue);
        ClientMessage[] notifications = NotificationTest.consumeMessages(2, this.notifConsumer, 5000);
        Assert.assertEquals((Object)CoreNotificationType.BINDING_REMOVED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertEquals((Object)queue.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_NAME).toString());
        Assert.assertEquals((Object)address.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
    }

    @Test
    public void testCONSUMER_CREATED() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession mySession = sf.createSession("myUser", "myPassword", false, true, true, this.locator.isPreAcknowledge(), this.locator.getAckBatchSize());
        mySession.start();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(durable)));
        NotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        ClientConsumer consumer = mySession.createConsumer(queue);
        SimpleString consumerName = SimpleString.toSimpleString((String)((ClientSessionInternal)mySession).getName());
        ClientMessage[] notifications = NotificationTest.consumeMessages(1, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.CONSUMER_CREATED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertEquals((Object)queue.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_NAME).toString());
        Assert.assertEquals((Object)address.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assert.assertEquals((Object)1, (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_CONSUMER_COUNT));
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"myUser"), (Object)notifications[0].getSimpleStringProperty(ManagementHelper.HDR_USER));
        Assert.assertEquals(null, (Object)notifications[0].getSimpleStringProperty(ManagementHelper.HDR_VALIDATED_USER));
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"invm:0"), (Object)notifications[0].getSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS));
        Assert.assertEquals((Object)consumerName, (Object)notifications[0].getSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME));
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"unavailable"), (Object)notifications[0].getSimpleStringProperty(ManagementHelper.HDR_CERT_SUBJECT_DN));
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testCONSUMER_CLOSED() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession mySession = sf.createSession("myUser", "myPassword", false, true, true, this.locator.isPreAcknowledge(), this.locator.getAckBatchSize());
        mySession.start();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        mySession.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(durable)));
        ClientConsumer consumer = mySession.createConsumer(queue);
        SimpleString sessionName = SimpleString.toSimpleString((String)((ClientSessionInternal)mySession).getName());
        NotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        consumer.close();
        ClientMessage[] notifications = NotificationTest.consumeMessages(1, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.CONSUMER_CLOSED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertEquals((Object)queue.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_NAME).toString());
        Assert.assertEquals((Object)address.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assert.assertEquals((Object)0, (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_CONSUMER_COUNT));
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"myUser"), (Object)notifications[0].getSimpleStringProperty(ManagementHelper.HDR_USER));
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"invm:0"), (Object)notifications[0].getSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS));
        Assert.assertEquals((Object)sessionName, (Object)notifications[0].getSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME));
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
        this.session.deleteQueue(queue);
    }

    @Test
    public void testAddressAdded() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        NotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        this.session.createAddress(address, RoutingType.ANYCAST, true);
        ClientMessage[] notifications = NotificationTest.consumeMessages(1, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.ADDRESS_ADDED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertEquals((Object)RoutingType.ANYCAST.getType(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_TYPE));
        Assert.assertEquals((Object)address.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
    }

    @Test
    public void testAddressRemoved() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, true);
        NotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        this.server.getPostOffice().removeAddressInfo(address);
        ClientMessage[] notifications = NotificationTest.consumeMessages(1, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.ADDRESS_REMOVED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertEquals((Object)RoutingType.ANYCAST.getType(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_TYPE));
        Assert.assertEquals((Object)address.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
    }

    @Test
    public void testConnectionCreatedAndDestroyed() throws Exception {
        NotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession mySession = sf.createSession("myUser", "myPassword", false, true, true, this.locator.isPreAcknowledge(), this.locator.getAckBatchSize());
        mySession.start();
        ClientMessage[] notifications = NotificationTest.consumeMessages(2, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.CONNECTION_CREATED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertNotNull((Object)notifications[0].getObjectProperty(ManagementHelper.HDR_CONNECTION_NAME));
        String connectionId = notifications[0].getObjectProperty(ManagementHelper.HDR_CONNECTION_NAME).toString();
        Assert.assertEquals((Object)CoreNotificationType.SESSION_CREATED.toString(), (Object)notifications[1].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertNotNull((Object)notifications[1].getObjectProperty(ManagementHelper.HDR_CONNECTION_NAME));
        Assert.assertNotNull((Object)notifications[1].getObjectProperty(ManagementHelper.HDR_SESSION_NAME));
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"myUser"), (Object)notifications[1].getObjectProperty(ManagementHelper.HDR_USER));
        Assert.assertTrue((notifications[1].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[1].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[1].getTimestamp(), (long)((Long)notifications[1].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
        NotificationTest.flush(this.notifConsumer);
        start = System.currentTimeMillis();
        mySession.close();
        sf.close();
        notifications = NotificationTest.consumeMessages(2, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.SESSION_CLOSED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertNotNull((Object)notifications[0].getObjectProperty(ManagementHelper.HDR_CONNECTION_NAME));
        Assert.assertNotNull((Object)notifications[0].getObjectProperty(ManagementHelper.HDR_SESSION_NAME));
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"myUser"), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_USER));
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((Object)CoreNotificationType.CONNECTION_DESTROYED.toString(), (Object)notifications[1].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertNotNull((Object)notifications[1].getObjectProperty(ManagementHelper.HDR_CONNECTION_NAME));
        Assert.assertEquals((Object)connectionId, (Object)notifications[1].getObjectProperty(ManagementHelper.HDR_CONNECTION_NAME).toString());
        Assert.assertTrue((notifications[1].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[1].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[1].getTimestamp(), (long)((Long)notifications[1].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
    }

    @Test
    public void testMessageDelivered() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession mySession = sf.createSession("myUser", "myPassword", false, true, true, this.locator.isPreAcknowledge(), this.locator.getAckBatchSize());
        mySession.start();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(durable)));
        ClientConsumer consumer = mySession.createConsumer(queue);
        ClientProducer producer = mySession.createProducer(address);
        NotificationTest.flush(this.notifConsumer);
        ClientMessage msg = this.session.createMessage(false);
        msg.putStringProperty("someKey", "someValue");
        producer.send((Message)msg);
        long start = System.currentTimeMillis();
        consumer.receive(1000L);
        ClientMessage[] notifications = NotificationTest.consumeMessages(1, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.MESSAGE_DELIVERED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertNotNull((Object)notifications[0].getObjectProperty(ManagementHelper.HDR_MESSAGE_ID));
        Assert.assertNotNull((Object)notifications[0].getObjectProperty(ManagementHelper.HDR_CONSUMER_NAME));
        Assert.assertEquals((Object)address, (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS));
        Assert.assertEquals((Object)queue, (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_NAME));
        Assert.assertEquals((Object)RoutingType.MULTICAST.getType(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_TYPE));
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageExpired() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession mySession = sf.createSession("myUser", "myPassword", false, true, true, this.locator.isPreAcknowledge(), this.locator.getAckBatchSize());
        mySession.start();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(durable)));
        ClientConsumer consumer = mySession.createConsumer(queue);
        ClientProducer producer = mySession.createProducer(address);
        NotificationTest.flush(this.notifConsumer);
        ClientMessage msg = this.session.createMessage(false);
        msg.putStringProperty("someKey", "someValue");
        msg.setExpiration(1L);
        long start = System.currentTimeMillis();
        producer.send((Message)msg);
        Assert.assertNull((Object)consumer.receiveImmediate());
        ClientMessage[] notifications = NotificationTest.consumeMessages(1, this.notifConsumer);
        Assert.assertEquals((Object)CoreNotificationType.MESSAGE_EXPIRED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertNotNull((Object)notifications[0].getObjectProperty(ManagementHelper.HDR_MESSAGE_ID));
        Assert.assertEquals((Object)address, (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS));
        Assert.assertEquals((Object)queue, (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_NAME));
        Assert.assertEquals((Object)RoutingType.MULTICAST.getType(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_TYPE));
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageExpiredWithoutConsumers() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession mySession = sf.createSession("myUser", "myPassword", false, true, true, this.locator.isPreAcknowledge(), this.locator.getAckBatchSize());
        mySession.start();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(durable)));
        ClientProducer producer = mySession.createProducer(address);
        NotificationTest.flush(this.notifConsumer);
        ClientMessage msg = this.session.createMessage(false);
        msg.putStringProperty("someKey", "someValue");
        msg.setExpiration(1L);
        long start = System.currentTimeMillis();
        producer.send((Message)msg);
        ClientMessage[] notifications = NotificationTest.consumeMessages(1, this.notifConsumer, 5000);
        Assert.assertEquals((Object)CoreNotificationType.MESSAGE_EXPIRED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assert.assertNotNull((Object)notifications[0].getObjectProperty(ManagementHelper.HDR_MESSAGE_ID));
        Assert.assertEquals((Object)address, (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS));
        Assert.assertEquals((Object)queue, (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_NAME));
        Assert.assertEquals((Object)RoutingType.MULTICAST.getType(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ROUTING_TYPE));
        Assert.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assert.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assert.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setMessageExpiryScanPeriod(100L), (boolean)false));
        this.server.getConfiguration().setAddressQueueScanPeriod(100L);
        NotificationActiveMQServerPlugin notificationPlugin = new NotificationActiveMQServerPlugin();
        notificationPlugin.setSendAddressNotifications(true);
        notificationPlugin.setSendConnectionNotifications(true);
        notificationPlugin.setSendDeliveredNotifications(true);
        notificationPlugin.setSendExpiredNotifications(true);
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)notificationPlugin);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        this.session = sf.createSession(false, true, true);
        this.session.start();
        this.notifQueue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(this.notifQueue).setAddress(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress()).setDurable(Boolean.valueOf(false)));
        this.notifConsumer = this.session.createConsumer(this.notifQueue);
    }

    private static void flush(ClientConsumer notifConsumer) throws ActiveMQException {
        ClientMessage message = null;
        while ((message = notifConsumer.receiveImmediate()) != null) {
        }
    }

    protected static ClientMessage[] consumeMessages(int expected, ClientConsumer consumer) throws Exception {
        return NotificationTest.consumeMessages(expected, consumer, 500);
    }

    protected static ClientMessage[] consumeMessages(int expected, ClientConsumer consumer, int timeout) throws Exception {
        ClientMessage[] messages = new ClientMessage[expected];
        ClientMessage m = null;
        for (int i = 0; i < expected; ++i) {
            m = consumer.receive((long)timeout);
            Assert.assertNotNull((String)("expected to received " + expected + " messages, got only " + i), (Object)m);
            messages[i] = m;
            m.acknowledge();
        }
        m = consumer.receiveImmediate();
        Assert.assertNull((String)("received one more message than expected (" + expected + ")"), (Object)m);
        return messages;
    }
}

