/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTTestSupport;
import org.apache.felix.resolver.util.ArrayMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class MQTTInterceptorPropertiesTest
extends MQTTTestSupport {
    private static final String ADDRESS = "address";
    private static final String MESSAGE_TEXT = "messageText";
    private static final String RETAINED = "retained";
    @Rule
    public ErrorCollector collector = new ErrorCollector();

    private boolean checkMessageProperties(MqttMessage message, Map<String, Object> expectedProperties) {
        try {
            MQTTInterceptorPropertiesTest.assertNotNull((Object)message);
            MQTTInterceptorPropertiesTest.assertNotNull((Object)this.server.getNodeID());
            MqttFixedHeader header = message.fixedHeader();
            MQTTInterceptorPropertiesTest.assertNotNull((Object)header.messageType());
            MQTTInterceptorPropertiesTest.assertEquals((long)header.qosLevel().value(), (long)0L);
            MQTTInterceptorPropertiesTest.assertEquals((Object)header.isRetain(), (Object)expectedProperties.get(RETAINED));
        }
        catch (Throwable t) {
            this.collector.addError(t);
        }
        return true;
    }

    @Test(timeout=60000L)
    public void testCheckInterceptedMQTTMessageProperties() throws Exception {
        String addressQueue = this.name.getMethodName();
        String msgText = "Test intercepted message";
        boolean retained = true;
        ArrayMap expectedProperties = new ArrayMap();
        expectedProperties.put(ADDRESS, addressQueue);
        expectedProperties.put(MESSAGE_TEXT, "Test intercepted message");
        expectedProperties.put(RETAINED, true);
        final MQTTClientProvider subscribeProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscribeProvider);
        subscribeProvider.subscribe(addressQueue, 0);
        final CountDownLatch latch = new CountDownLatch(1);
        MQTTInterceptor incomingInterceptor = new MQTTInterceptor((Map)expectedProperties){
            final /* synthetic */ Map val$expectedProperties;
            {
                this.val$expectedProperties = map;
            }

            public boolean intercept(MqttMessage packet, RemotingConnection connection) throws ActiveMQException {
                if (packet.getClass() == MqttPublishMessage.class) {
                    return MQTTInterceptorPropertiesTest.this.checkMessageProperties(packet, this.val$expectedProperties);
                }
                return true;
            }
        };
        MQTTInterceptor outgoingInterceptor = new MQTTInterceptor((Map)expectedProperties){
            final /* synthetic */ Map val$expectedProperties;
            {
                this.val$expectedProperties = map;
            }

            public boolean intercept(MqttMessage packet, RemotingConnection connection) throws ActiveMQException {
                if (packet.getClass() == MqttPublishMessage.class) {
                    return MQTTInterceptorPropertiesTest.this.checkMessageProperties(packet, this.val$expectedProperties);
                }
                return true;
            }
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] payload = subscribeProvider.receive(10000);
                    Assert.assertNotNull((String)"Should get a message", (Object)payload);
                    latch.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        publishProvider.publish(addressQueue, "Test intercepted message".getBytes(), 0, true);
        latch.await(10L, TimeUnit.SECONDS);
        subscribeProvider.disconnect();
        publishProvider.disconnect();
    }
}

