/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class QueueQueryTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
    }

    @Test
    public void testQueueQueryDefaultsOnStaticQueue() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        this.server.createQueue(new QueueConfiguration(queueName).setAddress(addressName));
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueName);
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isExists());
        QueueQueryTest.assertEquals((Object)RoutingType.MULTICAST, (Object)queueQueryResult.getRoutingType());
        QueueQueryTest.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isAutoCreateQueues());
        QueueQueryTest.assertEquals(null, (Object)queueQueryResult.getFilterString());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isAutoCreated());
        QueueQueryTest.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
        QueueQueryTest.assertEquals((long)0L, (long)queueQueryResult.getMessageCount());
        QueueQueryTest.assertEquals((long)0L, (long)queueQueryResult.getConsumerCount());
        QueueQueryTest.assertEquals((long)-1L, (long)queueQueryResult.getMaxConsumers());
        QueueQueryTest.assertEquals((long)0L, (long)queueQueryResult.getConsumersBeforeDispatch().intValue());
        QueueQueryTest.assertEquals((long)0x100000L, (long)queueQueryResult.getDefaultConsumerWindowSize().intValue());
        QueueQueryTest.assertEquals((long)-1L, (long)queueQueryResult.getDelayBeforeDispatch());
        QueueQueryTest.assertEquals(null, (Object)queueQueryResult.getLastValueKey());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isDurable());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isPurgeOnNoConsumers());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isTemporary());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isExclusive());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isNonDestructive());
    }

    @Test
    public void testQueueQueryOnStaticQueueWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        SimpleString queueName = SimpleString.toSimpleString((String)"myQueue");
        SimpleString fqqn = addressName.concat("::").concat(queueName);
        this.server.createQueue(new QueueConfiguration(fqqn));
        QueueQueryResult queueQueryResult = this.server.queueQuery(fqqn);
        QueueQueryTest.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        QueueQueryTest.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
        queueQueryResult = this.server.queueQuery(queueName);
        QueueQueryTest.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        QueueQueryTest.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
    }

    @Test
    public void testQueueQueryNonDefaultsOnStaticQueue() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString filter = SimpleString.toSimpleString((String)"x = 'y'");
        SimpleString lastValueKey = SimpleString.toSimpleString((String)"myLastValueKey");
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setDefaultMaxConsumers(Integer.valueOf(1)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)).setDefaultConsumersBeforeDispatch(Integer.valueOf(13)).setDefaultConsumerWindowSize(51).setDefaultDelayBeforeDispatch(Long.valueOf(19L)).setDefaultLastValueQueue(true).setDefaultLastValueKey(lastValueKey).setDefaultExclusiveQueue(Boolean.valueOf(true)).setDefaultNonDestructive(true));
        this.server.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString(filter).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueName);
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isExists());
        QueueQueryTest.assertEquals((Object)RoutingType.ANYCAST, (Object)queueQueryResult.getRoutingType());
        QueueQueryTest.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isAutoCreateQueues());
        QueueQueryTest.assertEquals((Object)filter, (Object)queueQueryResult.getFilterString());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isAutoCreated());
        QueueQueryTest.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
        QueueQueryTest.assertEquals((long)0L, (long)queueQueryResult.getMessageCount());
        QueueQueryTest.assertEquals((long)0L, (long)queueQueryResult.getConsumerCount());
        QueueQueryTest.assertEquals((long)1L, (long)queueQueryResult.getMaxConsumers());
        QueueQueryTest.assertEquals((long)13L, (long)queueQueryResult.getConsumersBeforeDispatch().intValue());
        QueueQueryTest.assertEquals((long)51L, (long)queueQueryResult.getDefaultConsumerWindowSize().intValue());
        QueueQueryTest.assertEquals((long)19L, (long)queueQueryResult.getDelayBeforeDispatch());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isLastValue());
        QueueQueryTest.assertEquals((Object)lastValueKey, (Object)queueQueryResult.getLastValueKey());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isDurable());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isPurgeOnNoConsumers());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isTemporary());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isExclusive());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isNonDestructive());
    }

    @Test
    public void testQueueQueryDefaultsOnAutoCreatedQueue() throws Exception {
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        this.server.getAddressSettingsRepository().addMatch(queueName.toString(), (Object)new AddressSettings());
        JMSContext c = new ActiveMQConnectionFactory("vm://0").createContext();
        c.createProducer().send((Destination)c.createQueue(queueName.toString()), c.createMessage());
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(queueName)).getMessageCount());
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueName);
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isAutoCreateQueues());
        QueueQueryTest.assertEquals(null, (Object)queueQueryResult.getFilterString());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isAutoCreated());
        QueueQueryTest.assertEquals((Object)queueName, (Object)queueQueryResult.getAddress());
        QueueQueryTest.assertEquals((long)1L, (long)queueQueryResult.getMessageCount());
        QueueQueryTest.assertEquals((long)0L, (long)queueQueryResult.getConsumerCount());
        QueueQueryTest.assertEquals((long)-1L, (long)queueQueryResult.getMaxConsumers());
        QueueQueryTest.assertEquals((long)0L, (long)queueQueryResult.getConsumersBeforeDispatch().intValue());
        QueueQueryTest.assertEquals((long)0x100000L, (long)queueQueryResult.getDefaultConsumerWindowSize().intValue());
        QueueQueryTest.assertEquals((long)-1L, (long)queueQueryResult.getDelayBeforeDispatch());
        QueueQueryTest.assertEquals(null, (Object)queueQueryResult.getLastValueKey());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isDurable());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isPurgeOnNoConsumers());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isTemporary());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isExclusive());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isNonDestructive());
    }

    @Test
    public void testQueueQueryOnAutoCreatedQueueWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString fqqn = addressName.concat("::").concat(queueName);
        try (JMSContext c = new ActiveMQConnectionFactory("vm://0").createContext();){
            c.createProducer().send((Destination)c.createQueue(fqqn.toString()), c.createMessage());
            QueueQueryResult queueQueryResult = this.server.queueQuery(fqqn);
            QueueQueryTest.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
            QueueQueryTest.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
            Wait.assertEquals((long)1L, () -> this.server.queueQuery(fqqn).getMessageCount());
            queueQueryResult = this.server.queueQuery(queueName);
            QueueQueryTest.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
            QueueQueryTest.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
            QueueQueryTest.assertEquals((long)1L, (long)queueQueryResult.getMessageCount());
            c.createProducer().send((Destination)c.createQueue(addressName.toString()), c.createMessage());
            Wait.assertEquals((long)2L, () -> this.server.queueQuery(fqqn).getMessageCount());
            Wait.assertEquals((long)2L, () -> this.server.queueQuery(queueName).getMessageCount());
        }
    }

    @Test
    public void testQueueQueryNonDefaultsOnAutoCreatedQueue() throws Exception {
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString lastValueKey = SimpleString.toSimpleString((String)"myLastValueKey");
        this.server.getAddressSettingsRepository().addMatch(queueName.toString(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true)).setDefaultMaxConsumers(Integer.valueOf(1)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)).setDefaultConsumersBeforeDispatch(Integer.valueOf(13)).setDefaultConsumerWindowSize(51).setDefaultDelayBeforeDispatch(Long.valueOf(19L)).setDefaultLastValueQueue(true).setDefaultLastValueKey(lastValueKey).setDefaultExclusiveQueue(Boolean.valueOf(true)).setDefaultNonDestructive(true));
        JMSContext c = new ActiveMQConnectionFactory("vm://0").createContext();
        c.createProducer().send((Destination)c.createQueue(queueName.toString()), c.createMessage());
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueName);
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isExists());
        QueueQueryTest.assertEquals((Object)RoutingType.ANYCAST, (Object)queueQueryResult.getRoutingType());
        QueueQueryTest.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isAutoCreateQueues());
        QueueQueryTest.assertNull((Object)queueQueryResult.getFilterString());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isAutoCreated());
        QueueQueryTest.assertEquals((Object)queueName, (Object)queueQueryResult.getAddress());
        QueueQueryTest.assertEquals((long)0L, (long)queueQueryResult.getMessageCount());
        QueueQueryTest.assertEquals((long)0L, (long)queueQueryResult.getConsumerCount());
        QueueQueryTest.assertEquals((long)1L, (long)queueQueryResult.getMaxConsumers());
        QueueQueryTest.assertEquals((long)13L, (long)queueQueryResult.getConsumersBeforeDispatch().intValue());
        QueueQueryTest.assertEquals((long)51L, (long)queueQueryResult.getDefaultConsumerWindowSize().intValue());
        QueueQueryTest.assertEquals((long)19L, (long)queueQueryResult.getDelayBeforeDispatch());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isLastValue());
        QueueQueryTest.assertEquals((Object)lastValueKey, (Object)queueQueryResult.getLastValueKey());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isDurable());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isPurgeOnNoConsumers());
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isTemporary());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isExclusive());
        QueueQueryTest.assertTrue((boolean)queueQueryResult.isNonDestructive());
    }

    @Test
    public void testQueueQueryNonExistentQueue() throws Exception {
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueName);
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isExists());
        QueueQueryTest.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
    }

    @Test
    public void testQueueQueryNonExistentQueueWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString fqqn = addressName.concat("::").concat(queueName);
        QueueQueryResult queueQueryResult = this.server.queueQuery(fqqn);
        QueueQueryTest.assertFalse((boolean)queueQueryResult.isExists());
        QueueQueryTest.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        QueueQueryTest.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
    }
}

