/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.paging.impl;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersister;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.FakeSequentialFileFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PageTest
extends ActiveMQTestBase {
    @Before
    public void registerProtocols() {
        MessagePersister.registerPersister((Persister)CoreMessagePersister.getInstance());
        MessagePersister.registerPersister((Persister)AMQPMessagePersister.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeMessagePageWithNIO() throws Exception {
        PageTest.recreateDirectory((String)this.getTestDir());
        ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        ExecutorService ioexecutor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        OrderedExecutorFactory factory = new OrderedExecutorFactory((Executor)executor);
        OrderedExecutorFactory iofactory = new OrderedExecutorFactory((Executor)ioexecutor);
        JournalStorageManager storageManager = new JournalStorageManager((Configuration)this.createBasicConfig(), (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), (ExecutorFactory)factory, (ExecutorFactory)iofactory);
        storageManager.start();
        storageManager.loadInternalOnly();
        try {
            this.testAdd((StorageManager)storageManager, (SequentialFileFactory)new NIOSequentialFileFactory(this.getTestDirfile(), 1), 1000, true);
        }
        finally {
            storageManager.stop();
            executor.shutdownNow();
            ioexecutor.shutdownNow();
        }
    }

    @Test
    public void testPageWithNIO() throws Exception {
        PageTest.recreateDirectory((String)this.getTestDir());
        this.testAdd((SequentialFileFactory)new NIOSequentialFileFactory(this.getTestDirfile(), 1), 1000);
    }

    @Test
    public void testDamagedDataWithNIO() throws Exception {
        PageTest.recreateDirectory((String)this.getTestDir());
        this.testDamagedPage((SequentialFileFactory)new NIOSequentialFileFactory(this.getTestDirfile(), 1), 1000);
    }

    @Test
    public void testPageFakeWithoutCallbacks() throws Exception {
        this.testAdd(new FakeSequentialFileFactory(1, false), 10);
    }

    @Test
    public void testPageSingleMessageWithNIO() throws Exception {
        this.testAdd((SequentialFileFactory)new NIOSequentialFileFactory(this.getTestDirfile(), 1), 1);
    }

    @Test
    public void testDamagedPage() throws Exception {
        this.testDamagedPage(new FakeSequentialFileFactory(1, false), 100);
    }

    protected void testAdd(SequentialFileFactory factory, int numberOfElements) throws Exception {
        this.testAdd((StorageManager)new NullStorageManager(), factory, numberOfElements, false);
    }

    protected void testAdd(StorageManager storageManager, SequentialFileFactory factory, int numberOfElements, boolean largeMessages) throws Exception {
        SequentialFile file = factory.createSequentialFile("00010.page");
        Page page = new Page(new SimpleString("something"), storageManager, factory, file, 10);
        Assert.assertEquals((long)10L, (long)page.getPageId());
        page.open();
        Assert.assertEquals((long)1L, (long)factory.listFiles("page").size());
        SimpleString simpleDestination = new SimpleString("Test");
        long startMessageID = 1L;
        this.addPageElements(storageManager, simpleDestination, page, numberOfElements, largeMessages, 1L);
        page.sync();
        page.close(false, false);
        file = factory.createSequentialFile("00010.page");
        file.open();
        page = new Page(new SimpleString("something"), storageManager, factory, file, 10);
        List msgs = page.read(storageManager, largeMessages);
        Assert.assertEquals((long)numberOfElements, (long)msgs.size());
        Assert.assertEquals((long)numberOfElements, (long)page.getNumberOfMessages());
        for (int i = 0; i < msgs.size(); ++i) {
            PagedMessage pagedMessage = (PagedMessage)msgs.get(i);
            Assert.assertEquals((Object)simpleDestination, (Object)pagedMessage.getMessage().getAddressSimpleString());
            Assert.assertEquals((Object)largeMessages, (Object)pagedMessage.getMessage().isLargeMessage());
            Assert.assertEquals((long)(1L + (long)i), (long)pagedMessage.getMessage().getMessageID());
            Assert.assertEquals((long)(largeMessages ? 1L : 0L), (long)pagedMessage.getMessage().getUsage());
        }
        if (!largeMessages) {
            Page tmpPage = new Page(new SimpleString("something"), storageManager, factory, file, 10);
            Assert.assertEquals((long)0L, (long)tmpPage.read(storageManager, true).size());
            Assert.assertEquals((long)numberOfElements, (long)tmpPage.getNumberOfMessages());
        }
        Assert.assertTrue((boolean)page.delete(msgs.toArray(new PagedMessage[msgs.size()])));
        for (PagedMessage pagedMessage : msgs) {
            Assert.assertEquals((long)0L, (long)pagedMessage.getMessage().getUsage());
        }
        Assert.assertEquals((long)0L, (long)factory.listFiles(".page").size());
    }

    protected void testDamagedPage(SequentialFileFactory factory, int numberOfElements) throws Exception {
        SequentialFile file = factory.createSequentialFile("00010.page");
        Page page = new Page(new SimpleString("something"), (StorageManager)new NullStorageManager(), factory, file, 10);
        Assert.assertEquals((long)10L, (long)page.getPageId());
        page.open();
        Assert.assertEquals((long)1L, (long)factory.listFiles("page").size());
        SimpleString simpleDestination = new SimpleString("Test");
        this.addPageElements(simpleDestination, page, numberOfElements, 1L);
        page.sync();
        long positionA = file.position();
        this.addPageElements(simpleDestination, page, 1, numberOfElements + 1);
        long positionB = file.position();
        this.addPageElements(simpleDestination, page, 10, numberOfElements + 2);
        file.position(positionA + (positionB - positionA) / 2L);
        ByteBuffer buffer = ByteBuffer.allocate((int)(positionB - file.position()));
        for (int i = 0; i < buffer.capacity(); ++i) {
            buffer.put((byte)90);
        }
        buffer.rewind();
        file.writeDirect(buffer, true);
        page.close(false);
        file = factory.createSequentialFile("00010.page");
        file.open();
        Page page1 = new Page(new SimpleString("something"), (StorageManager)new NullStorageManager(), factory, file, 10);
        List msgs = page1.read((StorageManager)new NullStorageManager());
        Assert.assertEquals((long)numberOfElements, (long)msgs.size());
        Assert.assertEquals((long)numberOfElements, (long)page1.getNumberOfMessages());
        for (int i = 0; i < msgs.size(); ++i) {
            Assert.assertEquals((Object)simpleDestination, (Object)((PagedMessage)msgs.get(i)).getMessage().getAddressSimpleString());
        }
        page.close(false);
        page1.delete(null);
        Assert.assertEquals((long)0L, (long)factory.listFiles("page").size());
        Assert.assertEquals((long)1L, (long)factory.listFiles("invalidPage").size());
    }

    protected void addPageElements(SimpleString simpleDestination, Page page, int numberOfElements, long startMessageID) throws Exception {
        this.addPageElements((StorageManager)new NullStorageManager(), simpleDestination, page, numberOfElements, false, startMessageID);
    }

    protected void addPageElements(StorageManager storageManager, SimpleString simpleDestination, Page page, int numberOfElements, boolean largeMessages, long startMessageID) throws Exception {
        int initialNumberOfMessages = page.getNumberOfMessages();
        int msgSize = 10;
        byte[] content = new byte[10];
        Arrays.fill(content, (byte)98);
        for (int i = 0; i < numberOfElements; ++i) {
            this.writeMessage(storageManager, largeMessages, startMessageID + (long)i, simpleDestination, content, page);
            Assert.assertEquals((long)(initialNumberOfMessages + i + 1), (long)page.getNumberOfMessages());
        }
    }

    protected void writeMessage(StorageManager storageManager, boolean isLargeMessage, long msgID, SimpleString address, byte[] content, Page page) throws Exception {
        if (isLargeMessage) {
            LargeServerMessageImpl msg = new LargeServerMessageImpl(storageManager);
            msg.setMessageID(msgID);
            msg.addBytes(content);
            msg.setAddress(address);
            page.write((PagedMessage)new PagedMessageImpl((Message)msg, new long[0]));
            msg.releaseResources(false, false);
        } else {
            CoreMessage msg = new CoreMessage().initBuffer(100);
            msg.setMessageID(msgID);
            msg.getBodyBuffer().writeBytes(content);
            msg.setAddress(address);
            page.write((PagedMessage)new PagedMessageImpl((Message)msg, new long[0]));
        }
    }
}

