/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting.impl.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class SocksProxyTest
extends ActiveMQTestBase {
    private static final int SOCKS_PORT = 1080;
    private ExecutorService closeExecutor;
    private ExecutorService threadPool;
    private ScheduledExecutorService scheduledThreadPool;
    private NioEventLoopGroup bossGroup;
    private NioEventLoopGroup workerGroup;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.closeExecutor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        this.threadPool = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        this.scheduledThreadPool = Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        this.startSocksProxy();
    }

    @After
    public void tearDown() throws Exception {
        this.closeExecutor.shutdownNow();
        this.threadPool.shutdownNow();
        this.scheduledThreadPool.shutdownNow();
        this.stopSocksProxy();
        super.tearDown();
    }

    @Test
    public void testSocksProxyHandlerAdded() throws Exception {
        InetAddress address = this.getNonLoopbackAddress();
        Assume.assumeTrue((String)"Cannot find non-loopback address", (address != null ? (byte)1 : 0) != 0);
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", address.getHostAddress());
        params.put("socksEnabled", true);
        params.put("socksHost", "localhost");
        ClientConnectionLifeCycleListener listener = new ClientConnectionLifeCycleListener(){

            public void connectionException(Object connectionID, ActiveMQException me) {
            }

            public void connectionDestroyed(Object connectionID) {
            }

            public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
            }

            public void connectionReadyForWrites(Object connectionID, boolean ready) {
            }
        };
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)listener, (Executor)this.closeExecutor, (Executor)this.threadPool, this.scheduledThreadPool);
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        ChannelPipeline pipeline = connector.getBootStrap().register().await().channel().pipeline();
        Assert.assertNotNull((Object)pipeline.get(Socks5ProxyHandler.class));
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    private InetAddress getNonLoopbackAddress() throws SocketException {
        Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
        InetAddress addr = null;
        while (n.hasMoreElements()) {
            NetworkInterface e = n.nextElement();
            Enumeration<InetAddress> a = e.getInetAddresses();
            boolean found = false;
            while (a.hasMoreElements()) {
                addr = a.nextElement();
                if (addr.isLoopbackAddress()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        return addr;
    }

    @Test
    public void testSocksProxyHandlerNotAddedForLocalhost() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", "localhost");
        params.put("socksEnabled", true);
        params.put("socksHost", "localhost");
        ClientConnectionLifeCycleListener listener = new ClientConnectionLifeCycleListener(){

            public void connectionException(Object connectionID, ActiveMQException me) {
            }

            public void connectionDestroyed(Object connectionID) {
            }

            public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
            }

            public void connectionReadyForWrites(Object connectionID, boolean ready) {
            }
        };
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)listener, (Executor)this.closeExecutor, (Executor)this.threadPool, this.scheduledThreadPool);
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        ChannelPipeline pipeline = connector.getBootStrap().register().await().channel().pipeline();
        Assert.assertNull((Object)pipeline.get(Socks5ProxyHandler.class));
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testSocks5hSupport() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", "only-resolvable-on-proxy");
        params.put("socksEnabled", true);
        params.put("socksHost", "localhost");
        params.put("socksPort", 1080);
        params.put("socksRemoteDNS", true);
        ClientConnectionLifeCycleListener listener = new ClientConnectionLifeCycleListener(){

            public void connectionException(Object connectionID, ActiveMQException me) {
            }

            public void connectionDestroyed(Object connectionID) {
            }

            public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
            }

            public void connectionReadyForWrites(Object connectionID, boolean ready) {
            }
        };
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)listener, (Executor)this.closeExecutor, (Executor)this.threadPool, this.scheduledThreadPool);
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        connector.getBootStrap().register().await().channel().pipeline();
        AddressResolverGroup resolver = connector.getBootStrap().config().resolver();
        Assert.assertSame((Object)resolver, (Object)NoopAddressResolverGroup.INSTANCE);
        Connection connection = connector.createConnection(future -> {
            future.awaitUninterruptibly();
            Assert.assertTrue((boolean)future.isSuccess());
            Socks5ProxyHandler socks5Handler = (Socks5ProxyHandler)future.channel().pipeline().get(Socks5ProxyHandler.class);
            Assert.assertNotNull((Object)socks5Handler);
            InetSocketAddress remoteAddress = (InetSocketAddress)socks5Handler.destinationAddress();
            Assert.assertTrue((boolean)remoteAddress.isUnresolved());
        });
        Assert.assertNotNull((Object)connection);
        Assert.assertTrue((boolean)connection.isOpen());
        connection.close();
        Assert.assertFalse((boolean)connection.isOpen());
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    private void startSocksProxy() throws Exception {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup);
        b.channel(NioServerSocketChannel.class);
        b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
            }
        });
        b.bind(1080).sync();
    }

    private void stopSocksProxy() {
        this.bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
    }
}

