/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Collections;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentReference;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentRepository;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentState;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentType;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.ClusterDescriptor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class AgentPersister {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AgentType type;
    private final String name;
    private final ShardAssignmentDescriptor staticShardAssignment;
    private AgentReference selfReference;

    public AgentPersister(AgentType type, String name, ShardAssignmentDescriptor staticShardAssignment) {
        this.type = type;
        this.name = name;
        this.staticShardAssignment = staticShardAssignment;
    }

    public AgentReference selfReference() {
        return this.selfReference;
    }

    public void setSelfReferenceForTests(AgentReference selfReference) {
        this.selfReference = selfReference;
    }

    public Agent findSelf(AgentRepository agentRepository) {
        if (this.selfReference != null) {
            return agentRepository.find(this.selfReference.id);
        }
        return null;
    }

    public void createSelf(AgentRepository agentRepository, Instant expiration) {
        Agent self = new Agent(this.type, this.name, expiration, AgentState.SUSPENDED, this.staticShardAssignment);
        agentRepository.create(self);
        this.selfReference = self.getReference();
        log.infof("Agent '%s': registering", this.selfReference);
    }

    public void leaveCluster(AgentRepository store) {
        if (this.selfReference == null) {
            return;
        }
        log.infof("Agent '%s': leaving cluster", this.selfReference);
        Agent agent = store.find(this.selfReference.id);
        if (agent != null) {
            store.delete(Collections.singletonList(agent));
        }
    }

    public void setSuspended(Agent self) {
        if (self.getState() != AgentState.SUSPENDED) {
            log.infof("Agent '%s': suspending", this.selfReference);
            self.setState(AgentState.SUSPENDED);
        }
        if (this.staticShardAssignment == null) {
            self.setTotalShardCount(null);
            self.setAssignedShardIndex(null);
        }
    }

    public void setWaiting(Agent self, ClusterDescriptor clusterDescriptor, ShardAssignmentDescriptor shardAssignment) {
        if (self.getState() != AgentState.WAITING) {
            log.infof("Agent '%s': waiting for cluster changes. Shard assignment: %s. Cluster: %s", this.selfReference, shardAssignment, clusterDescriptor);
            self.setState(AgentState.WAITING);
        }
        if (this.staticShardAssignment == null && shardAssignment != null) {
            self.setTotalShardCount(shardAssignment.totalShardCount);
            self.setAssignedShardIndex(shardAssignment.assignedShardIndex);
        }
    }

    public void setRunning(Agent self, ClusterDescriptor clusterDescriptor) {
        if (self.getState() != AgentState.RUNNING) {
            log.infof("Agent '%s': running. Shard assignment: %s. Cluster: %s", this.selfReference, self.getShardAssignment(), clusterDescriptor);
            self.setState(AgentState.RUNNING);
        }
    }
}

