/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl;

import java.lang.invoke.MethodHandles;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentPersister;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentState;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentType;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.ClusterDescriptor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.AbstractAgentClusterLink;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxPollingMassIndexingInstructions;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class OutboxPollingMassIndexerAgentClusterLink
extends AbstractAgentClusterLink<OutboxPollingMassIndexingInstructions> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ClusterDescriptor SINGLE_NODE_CLUSTER_DESCRIPTOR = null;
    private static final ShardAssignmentDescriptor SINGLE_NODE_SHARD_ASSIGNMENT = null;

    public OutboxPollingMassIndexerAgentClusterLink(String agentName, FailureHandler failureHandler, Clock clock, Duration pollingInterval, Duration pulseInterval, Duration pulseExpiration) {
        super(new AgentPersister(AgentType.MASS_INDEXING, agentName, null), failureHandler, clock, pollingInterval, pulseInterval, pulseExpiration);
        log.tracef("Agent '%s': created", agentName);
    }

    @Override
    protected AbstractAgentClusterLink.WriteAction<OutboxPollingMassIndexingInstructions> doPulse(List<Agent> allAgentsInIdOrder, Agent currentSelf) {
        List<Agent> eventProcessors = allAgentsInIdOrder.stream().filter(a -> AgentType.EVENT_PROCESSING.contains((Object)a.getType())).collect(Collectors.toList());
        if (!this.eventProcessorsAreSuspended(eventProcessors)) {
            return (now, self, agentPersister) -> {
                agentPersister.setWaiting(self, SINGLE_NODE_CLUSTER_DESCRIPTOR, SINGLE_NODE_SHARD_ASSIGNMENT);
                return this.instructCommitAndRetryPulseAfterDelay(now, this.pollingInterval);
            };
        }
        if (AgentState.SUSPENDED.equals((Object)currentSelf.getState())) {
            return (now, self, agentPersister) -> {
                agentPersister.setWaiting(self, SINGLE_NODE_CLUSTER_DESCRIPTOR, SINGLE_NODE_SHARD_ASSIGNMENT);
                return this.instructCommitAndRetryPulseAfterDelay(now, this.pollingInterval);
            };
        }
        return (now, self, agentPersister) -> {
            agentPersister.setRunning(self, SINGLE_NODE_CLUSTER_DESCRIPTOR);
            return this.instructProceedWithMassIndexing(now);
        };
    }

    private boolean eventProcessorsAreSuspended(List<Agent> eventProcessors) {
        AgentState expectedState = AgentState.SUSPENDED;
        for (Agent eventProcessor : eventProcessors) {
            if (expectedState.equals((Object)eventProcessor.getState())) continue;
            log.tracef("Agent '%s': waiting for event processor '%s', which has not reached state '%s' yet", this.selfReference(), eventProcessor.getReference(), (Object)expectedState);
            return false;
        }
        log.tracef("Agent '%s': all event processors reached the expected state %s", this.selfReference(), (Object)expectedState);
        return true;
    }

    @Override
    protected OutboxPollingMassIndexingInstructions instructCommitAndRetryPulseAfterDelay(Instant now, Duration delay) {
        Instant expiration = now.plus(delay);
        log.tracef("Agent '%s': instructions are to hold off mass indexing and to retry a pulse in %s, around %s", this.selfReference(), delay, expiration);
        return new OutboxPollingMassIndexingInstructions(this.clock, expiration, false);
    }

    private OutboxPollingMassIndexingInstructions instructProceedWithMassIndexing(Instant now) {
        Instant expiration = now.plus(this.pulseInterval);
        log.tracef("Agent '%s': instructions are to proceed with mass indexing and to retry a pulse in %s, around %s", this.selfReference(), this.pulseInterval, expiration);
        return new OutboxPollingMassIndexingInstructions(this.clock, expiration, true);
    }
}

