/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateSearchOrmMappingProducer;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationConfigurationContext;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategy;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategyPreStopContext;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategyStartContext;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentRepositoryProvider;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.DefaultAgentRepository;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.OutboxPollingAgentAdditionalJaxbMappingProducer;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.DefaultOutboxEventFinder;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEventFinderProvider;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxPollingEventProcessor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxPollingMassIndexerAgent;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxPollingOutboxEventAdditionalJaxbMappingProducer;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxPollingOutboxEventSendingPlan;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.mapping.impl.OutboxPollingSearchMappingImpl;
import org.hibernate.search.mapper.orm.tenancy.spi.TenancyConfiguration;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgent;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgentCreateContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class OutboxPollingCoordinationStrategy
implements CoordinationStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Boolean> EVENT_PROCESSOR_ENABLED = ConfigurationProperty.forKey((String)"event_processor.enabled").asBoolean().withDefault((Object)true).build();
    private static final OptionalConfigurationProperty<Integer> EVENT_PROCESSOR_SHARDS_TOTAL_COUNT = ConfigurationProperty.forKey((String)"event_processor.shards.total_count").asIntegerStrictlyPositive().build();
    private static final OptionalConfigurationProperty<List<Integer>> EVENT_PROCESSOR_SHARDS_ASSIGNED = ConfigurationProperty.forKey((String)"event_processor.shards.assigned").asIntegerPositiveOrZero().multivalued().build();
    private static final OptionalConfigurationProperty<BeanReference<? extends AgentRepositoryProvider>> AGENT_REPOSITORY_PROVIDER = ConfigurationProperty.forKey((String)"agent_repository.provider").asBeanReference(AgentRepositoryProvider.class).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends OutboxEventFinderProvider>> OUTBOX_EVENT_FINDER_PROVIDER = ConfigurationProperty.forKey((String)"outbox_event_finder.provider").asBeanReference(OutboxEventFinderProvider.class).build();
    private BeanHolder<? extends OutboxEventFinderProvider> finderProviderHolder;
    private BeanHolder<? extends AgentRepositoryProvider> agentRepositoryProviderHolder;
    private TenancyConfiguration tenancyConfiguration;
    private final Map<String, TenantDelegate> tenantDelegates = new LinkedHashMap<String, TenantDelegate>();
    private OutboxPollingSearchMappingImpl outboxPollingSearchMapping;

    public void configure(CoordinationConfigurationContext context) {
        context.mappingProducer((HibernateSearchOrmMappingProducer)new OutboxPollingOutboxEventAdditionalJaxbMappingProducer());
        context.mappingProducer((HibernateSearchOrmMappingProducer)new OutboxPollingAgentAdditionalJaxbMappingProducer());
        context.sendIndexingEventsTo(ctx -> new OutboxPollingOutboxEventSendingPlan(ctx.session()), true);
    }

    public CompletableFuture<?> start(CoordinationStrategyStartContext context) {
        Optional finderProviderHolderOptional;
        Optional agentRepositoryProviderHolderOptional = AGENT_REPOSITORY_PROVIDER.getAndMap(context.configurationPropertySource(), arg_0 -> ((BeanResolver)context.beanResolver()).resolve(arg_0));
        if (agentRepositoryProviderHolderOptional.isPresent()) {
            this.agentRepositoryProviderHolder = (BeanHolder)agentRepositoryProviderHolderOptional.get();
            log.debugf("Outbox processing will use custom agent repository provider '%s'.", this.agentRepositoryProviderHolder.get());
        } else {
            this.agentRepositoryProviderHolder = BeanHolder.of((Object)new DefaultAgentRepository.Provider());
        }
        if ((finderProviderHolderOptional = OUTBOX_EVENT_FINDER_PROVIDER.getAndMap(context.configurationPropertySource(), arg_0 -> ((BeanResolver)context.beanResolver()).resolve(arg_0))).isPresent()) {
            this.finderProviderHolder = (BeanHolder)finderProviderHolderOptional.get();
            log.debugf("Outbox processing will use custom outbox event finder provider '%s'.", this.finderProviderHolder.get());
        } else {
            this.finderProviderHolder = BeanHolder.of((Object)new DefaultOutboxEventFinder.Provider());
        }
        this.tenancyConfiguration = context.tenancyConfiguration();
        Set tenantIds = this.tenancyConfiguration.tenantIdsOrFail();
        if (tenantIds.isEmpty()) {
            TenantDelegate tenantDelegate = new TenantDelegate(null);
            this.tenantDelegates.put(null, tenantDelegate);
            tenantDelegate.start(context, context.configurationPropertySource());
        } else {
            for (String tenantId : tenantIds) {
                TenantDelegate tenantDelegate = new TenantDelegate(tenantId);
                this.tenantDelegates.put(tenantId, tenantDelegate);
                ConfigurationPropertySource configurationSource = context.configurationPropertySource();
                configurationSource = configurationSource.withMask("tenants").withMask(tenantId).withFallback(configurationSource);
                tenantDelegate.start(context, configurationSource);
            }
        }
        this.outboxPollingSearchMapping = new OutboxPollingSearchMappingImpl(context, this.tenancyConfiguration);
        return CompletableFuture.completedFuture(null);
    }

    public PojoMassIndexerAgent createMassIndexerAgent(PojoMassIndexerAgentCreateContext context) {
        return this.tenantDelegate(context.tenantIdentifier()).massIndexerAgentFactory.create(context, (AgentRepositoryProvider)this.agentRepositoryProviderHolder.get());
    }

    private TenantDelegate tenantDelegate(String tenantId) {
        TenantDelegate tenantDelegate = this.tenantDelegates.get(tenantId);
        if (tenantDelegate == null) {
            throw this.tenancyConfiguration.invalidTenantId(tenantId);
        }
        return tenantDelegate;
    }

    public CompletableFuture<?> completion() {
        ArrayList futures = new ArrayList();
        for (TenantDelegate tenantDelegate : this.tenantDelegates.values()) {
            if (tenantDelegate.eventProcessors == null) continue;
            for (OutboxPollingEventProcessor eventProcessor : tenantDelegate.eventProcessors) {
                futures.add(eventProcessor.completion());
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public CompletableFuture<?> preStop(CoordinationStrategyPreStopContext context) {
        ArrayList futures = new ArrayList();
        for (TenantDelegate tenantDelegate : this.tenantDelegates.values()) {
            if (tenantDelegate.eventProcessors == null) continue;
            for (OutboxPollingEventProcessor eventProcessor : tenantDelegate.eventProcessors) {
                futures.add(eventProcessor.preStop());
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public void stop() {
        try (Closer closer = new Closer();){
            for (TenantDelegate tenantDelegate : this.tenantDelegates.values()) {
                closer.pushAll(OutboxPollingEventProcessor::stop, (Iterable)tenantDelegate.eventProcessors);
                closer.push(ExecutorService::shutdownNow, (Object)tenantDelegate.eventProcessorExecutor);
            }
            closer.push(BeanHolder::close, this.finderProviderHolder);
            closer.push(BeanHolder::close, this.agentRepositoryProviderHolder);
        }
    }

    public OutboxPollingSearchMappingImpl outboxPollingSearchMapping() {
        return this.outboxPollingSearchMapping;
    }

    private class TenantDelegate {
        private final String tenantId;
        private ScheduledExecutorService eventProcessorExecutor;
        private List<OutboxPollingEventProcessor> eventProcessors;
        private OutboxPollingMassIndexerAgent.Factory massIndexerAgentFactory;

        private TenantDelegate(String tenantId) {
            this.tenantId = tenantId;
        }

        void start(CoordinationStrategyStartContext context, ConfigurationPropertySource configurationSource) {
            if (((Boolean)EVENT_PROCESSOR_ENABLED.get(configurationSource)).booleanValue()) {
                this.initializeEventProcessors(context, configurationSource);
            } else {
                log.eventProcessorDisabled(this.tenantId);
            }
            this.massIndexerAgentFactory = OutboxPollingMassIndexerAgent.factory(context.mapping(), context.clock(), this.tenantId, configurationSource);
        }

        private void initializeEventProcessors(CoordinationStrategyStartContext context, ConfigurationPropertySource configurationSource) {
            List shardAssignmentOrNulls;
            boolean shardsStatic;
            OutboxPollingEventProcessor.Factory factory = OutboxPollingEventProcessor.factory(context.mapping(), context.clock(), this.tenantId, configurationSource);
            boolean bl = shardsStatic = ((Optional)EVENT_PROCESSOR_SHARDS_TOTAL_COUNT.get(configurationSource)).isPresent() || ((Optional)EVENT_PROCESSOR_SHARDS_ASSIGNED.get(configurationSource)).isPresent();
            if (shardsStatic) {
                int totalShardCount = (Integer)EVENT_PROCESSOR_SHARDS_TOTAL_COUNT.getAndMapOrThrow(configurationSource, this::checkTotalShardCount, () -> log.missingPropertyForStaticSharding(EVENT_PROCESSOR_SHARDS_ASSIGNED.resolveOrRaw(configurationSource)));
                shardAssignmentOrNulls = (List)EVENT_PROCESSOR_SHARDS_ASSIGNED.getAndMapOrThrow(configurationSource, shardIndices -> this.toStaticShardAssignments(configurationSource, totalShardCount, (List<Integer>)shardIndices), () -> log.missingPropertyForStaticSharding(EVENT_PROCESSOR_SHARDS_TOTAL_COUNT.resolveOrRaw(configurationSource)));
            } else {
                shardAssignmentOrNulls = Collections.singletonList(null);
            }
            this.eventProcessorExecutor = context.threadPoolProvider().newScheduledExecutor(shardAssignmentOrNulls.size(), OutboxPollingEventProcessor.namePrefix(this.tenantId));
            this.eventProcessors = new ArrayList<OutboxPollingEventProcessor>();
            for (ShardAssignmentDescriptor shardAssignmentOrNull : shardAssignmentOrNulls) {
                this.eventProcessors.add(factory.create(this.eventProcessorExecutor, (OutboxEventFinderProvider)OutboxPollingCoordinationStrategy.this.finderProviderHolder.get(), (AgentRepositoryProvider)OutboxPollingCoordinationStrategy.this.agentRepositoryProviderHolder.get(), shardAssignmentOrNull));
            }
            for (OutboxPollingEventProcessor eventProcessor : this.eventProcessors) {
                eventProcessor.start();
            }
        }

        private Integer checkTotalShardCount(Integer totalShardCount) {
            if (totalShardCount <= 0) {
                throw log.invalidTotalShardCount();
            }
            return totalShardCount;
        }

        private List<ShardAssignmentDescriptor> toStaticShardAssignments(ConfigurationPropertySource configurationPropertySource, int totalShardCount, List<Integer> shardIndices) {
            HashSet<Integer> uniqueShardIndices = new HashSet<Integer>(shardIndices);
            for (Integer shardIndex : uniqueShardIndices) {
                if (0 <= shardIndex && shardIndex < totalShardCount) continue;
                throw log.invalidShardIndex(totalShardCount, EVENT_PROCESSOR_SHARDS_TOTAL_COUNT.resolveOrRaw(configurationPropertySource));
            }
            ArrayList<ShardAssignmentDescriptor> shardAssignment = new ArrayList<ShardAssignmentDescriptor>();
            for (Integer shardIndex : uniqueShardIndices) {
                shardAssignment.add(new ShardAssignmentDescriptor(totalShardCount, shardIndex));
            }
            return shardAssignment;
        }
    }
}

