/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context.flash;

import com.sun.faces.context.flash.ELFlash;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.Flash;
import jakarta.faces.context.FlashFactory;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class FlashELResolver
extends ELResolver {
    private static final String FLASH_VARIABLE_NAME = "flash";
    private static final String FLASH_NOW_VARIABLE_NAME = "now";
    private static final String FLASH_KEEP_VARIABLE_NAME = "keep";

    public Object getValue(ELContext elContext, Object base, Object property) {
        if (null == property) {
            return null;
        }
        Object result = null;
        if (null == base) {
            return null;
        }
        if (base instanceof Flash) {
            FacesContext facesContext = (FacesContext)elContext.getContext(FacesContext.class);
            ExternalContext extCtx = facesContext.getExternalContext();
            switch (property.toString()) {
                case "keep": {
                    elContext.setPropertyResolved(true);
                    result = base;
                    FlashFactory ff = (FlashFactory)FactoryFinder.getFactory((String)"jakarta.faces.context.FlashFactory");
                    ff.getFlash(true);
                    ELFlash.setKeepFlag(facesContext);
                    break;
                }
                case "now": {
                    Map requestMap = extCtx.getRequestMap();
                    requestMap.put("csfcffn", property);
                    elContext.setPropertyResolved(true);
                    result = requestMap;
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    public Class<?> getType(ELContext elContext, Object base, Object property) {
        if (null != base) {
            return null;
        }
        if (null == property) {
            String message = " base " + base + " property " + property;
            throw new PropertyNotFoundException(message);
        }
        if (property.toString().equals(FLASH_VARIABLE_NAME)) {
            elContext.setPropertyResolved(true);
        }
        return null;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value) {
        if (base != null) {
            return;
        }
        if (property == null) {
            String message = " base " + base + " property " + property;
            throw new PropertyNotFoundException(message);
        }
        if (property.toString().equals(FLASH_VARIABLE_NAME)) {
            elContext.setPropertyResolved(true);
            throw new PropertyNotWritableException(property.toString());
        }
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) {
        if (base != null) {
            return false;
        }
        if (property == null) {
            String message = " base " + base + " property " + property;
            throw new PropertyNotFoundException(message);
        }
        if (property.toString().equals(FLASH_VARIABLE_NAME)) {
            elContext.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object base) {
        Iterator iter;
        if (null != base) {
            return null;
        }
        Iterator result = null;
        FacesContext facesContext = (FacesContext)elContext.getContext(FacesContext.class);
        ExternalContext extCtx = facesContext.getExternalContext();
        Flash flash = extCtx.getFlash();
        if (null != flash && (iter = flash.entrySet().iterator()).hasNext()) {
            ArrayList<FeatureDescriptor> fds = new ArrayList<FeatureDescriptor>(flash.size());
            while (iter.hasNext()) {
                Map.Entry cur = iter.next();
                FeatureDescriptor fd = new FeatureDescriptor();
                fd.setName((String)cur.getKey());
                fds.add(fd);
            }
            result = fds.iterator();
        }
        return result;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        Class<Object> result = null;
        if (null != base && FLASH_VARIABLE_NAME.equals(base.toString())) {
            result = Object.class;
        }
        return result;
    }
}

