/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing.contrib.web.servlet.filter.decorator;

import io.opentracing.Span;
import io.opentracing.tag.StringTag;
import io.smallrye.opentracing.contrib.web.servlet.filter.ServletFilterSpanDecorator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

public class ServletFilterHeaderSpanDecorator
implements ServletFilterSpanDecorator {
    private final String prefix;
    private final List<HeaderEntry> allowedHeaders;

    public ServletFilterHeaderSpanDecorator(List<HeaderEntry> allowedHeaders) {
        this(allowedHeaders, "http.header.");
    }

    public ServletFilterHeaderSpanDecorator(List<HeaderEntry> allowedHeaders, String prefix) {
        this.allowedHeaders = new ArrayList<HeaderEntry>(allowedHeaders);
        this.prefix = prefix != null && !prefix.isEmpty() ? prefix : null;
    }

    @Override
    public void onRequest(HttpServletRequest httpServletRequest, Span span) {
        for (HeaderEntry headerEntry : this.allowedHeaders) {
            String headerValue = httpServletRequest.getHeader(headerEntry.getHeader());
            if (headerValue == null || headerValue.isEmpty()) continue;
            this.buildTag(headerEntry.getTag()).set(span, headerValue);
        }
    }

    @Override
    public void onResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Span span) {
    }

    @Override
    public void onError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable exception, Span span) {
    }

    @Override
    public void onTimeout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long timeout, Span span) {
    }

    private StringTag buildTag(String tag) {
        if (this.prefix == null) {
            return new StringTag(tag);
        }
        return new StringTag(this.prefix + tag);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public List<HeaderEntry> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public static class HeaderEntry {
        private final String header;
        private final String tag;

        public HeaderEntry(String header, String tag) {
            this.header = header;
            this.tag = tag;
        }

        public String getHeader() {
            return this.header;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

