/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.Optional;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.ConfigurationPropertySourceExtractor;

public final class EngineConfigurationUtils {
    private EngineConfigurationUtils() {
    }

    public static ConfigurationPropertySourceExtractor extractorForBackend(Optional<String> backendNameOptional) {
        if (!backendNameOptional.isPresent()) {
            return engineSource -> engineSource.withMask("backend");
        }
        return engineSource -> engineSource.withMask("backends").withMask((String)backendNameOptional.get());
    }

    public static ConfigurationPropertySourceExtractor extractorForIndex(ConfigurationPropertySourceExtractor extractorForBackend, String indexName) {
        return engineSource -> {
            ConfigurationPropertySource backendSource = extractorForBackend.extract(engineSource);
            return backendSource.withMask("indexes").withMask(indexName).withFallback(backendSource);
        };
    }
}

