/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.time.Duration;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class UniFailOnTimeout<I>
extends UniOperator<I, I> {
    private final Duration timeout;
    private final Supplier<? extends Throwable> supplier;
    private final ScheduledExecutorService executor;

    public UniFailOnTimeout(Uni<I> upstream, Duration timeout, Supplier<? extends Throwable> supplier, ScheduledExecutorService executor) {
        super(upstream);
        this.timeout = timeout;
        this.supplier = supplier;
        this.executor = executor == null ? Infrastructure.getDefaultWorkerPool() : executor;
    }

    @Override
    public void subscribe(UniSubscriber<? super I> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniFailOnTimeoutProcessor(subscriber));
    }

    private class UniFailOnTimeoutProcessor
    extends UniOperatorProcessor<I, I> {
        private volatile ScheduledFuture<?> timeoutFuture;

        public UniFailOnTimeoutProcessor(UniSubscriber<? super I> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            try {
                this.timeoutFuture = UniFailOnTimeout.this.executor.schedule(this::doTimeout, UniFailOnTimeout.this.timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                this.getAndSetUpstreamSubscription(EmptyUniSubscription.CANCELLED);
                subscription.cancel();
                this.downstream.onSubscribe(EmptyUniSubscription.DONE);
                this.downstream.onFailure(e);
                return;
            }
            super.onSubscribe(subscription);
        }

        @Override
        public void onItem(I item) {
            UniSubscription sub = this.getAndSetUpstreamSubscription(EmptyUniSubscription.CANCELLED);
            if (sub != EmptyUniSubscription.CANCELLED) {
                if (this.timeoutFuture != null) {
                    this.timeoutFuture.cancel(false);
                }
                this.downstream.onItem(item);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            UniSubscription sub = this.getAndSetUpstreamSubscription(EmptyUniSubscription.CANCELLED);
            if (sub != EmptyUniSubscription.CANCELLED) {
                if (this.timeoutFuture != null) {
                    this.timeoutFuture.cancel(false);
                }
                this.downstream.onFailure(failure);
            } else {
                Infrastructure.handleDroppedException(failure);
            }
        }

        @Override
        public void cancel() {
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
            }
            super.cancel();
        }

        private void doTimeout() {
            Throwable throwable;
            if (this.isCancelled()) {
                return;
            }
            super.cancel();
            try {
                throwable = (Throwable)UniFailOnTimeout.this.supplier.get();
            }
            catch (Throwable e) {
                this.downstream.onFailure(e);
                return;
            }
            if (throwable == null) {
                this.downstream.onFailure(new NullPointerException("The supplier returned `null`"));
            } else {
                this.downstream.onFailure(throwable);
            }
        }
    }
}

