/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.DropAggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface Aggregator<T> {
    public static Aggregator<Object> drop() {
        return DropAggregator.INSTANCE;
    }

    public AggregatorHandle<T> createHandle();

    @Nullable
    default public T accumulateLongMeasurement(long value, Attributes attributes, Context context) {
        AggregatorHandle<T> handle = this.createHandle();
        handle.recordLong(value, attributes, context);
        return handle.accumulateThenReset(attributes);
    }

    @Nullable
    default public T accumulateDoubleMeasurement(double value, Attributes attributes, Context context) {
        AggregatorHandle<T> handle = this.createHandle();
        handle.recordDouble(value, attributes, context);
        return handle.accumulateThenReset(attributes);
    }

    public T merge(T var1, T var2);

    public T diff(T var1, T var2);

    public MetricData toMetricData(Resource var1, InstrumentationLibraryInfo var2, MetricDescriptor var3, Map<Attributes, T> var4, AggregationTemporality var5, long var6, long var8, long var10);
}

