/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.convert.internal;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedMember;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.convert.internal.ConverterHelper;
import org.hibernate.boot.model.convert.spi.AutoApplicableConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;

public class AutoApplicableConverterDescriptorStandardImpl
implements AutoApplicableConverterDescriptor {
    private final ConverterDescriptor linkedConverterDescriptor;

    public AutoApplicableConverterDescriptorStandardImpl(ConverterDescriptor linkedConverterDescriptor) {
        this.linkedConverterDescriptor = linkedConverterDescriptor;
    }

    @Override
    public ConverterDescriptor getAutoAppliedConverterDescriptorForAttribute(XProperty xProperty, MetadataBuildingContext context) {
        ResolvedType attributeType = ConverterHelper.resolveAttributeType(xProperty, context);
        return ConverterHelper.typesMatch(this.linkedConverterDescriptor.getDomainValueResolvedType(), attributeType) ? this.linkedConverterDescriptor : null;
    }

    @Override
    public ConverterDescriptor getAutoAppliedConverterDescriptorForCollectionElement(XProperty xProperty, MetadataBuildingContext context) {
        ResolvedType elementType;
        ResolvedMember<? extends Member> collectionMember = ConverterHelper.resolveMember(xProperty, context);
        if (Map.class.isAssignableFrom(collectionMember.getType().getErasedType())) {
            elementType = (ResolvedType)collectionMember.getType().typeParametersFor(Map.class).get(1);
        } else if (Collection.class.isAssignableFrom(collectionMember.getType().getErasedType())) {
            elementType = (ResolvedType)collectionMember.getType().typeParametersFor(Collection.class).get(0);
        } else {
            throw new HibernateException("Attribute was neither a Collection nor a Map : " + collectionMember.getType().getErasedType());
        }
        return ConverterHelper.typesMatch(this.linkedConverterDescriptor.getDomainValueResolvedType(), elementType) ? this.linkedConverterDescriptor : null;
    }

    @Override
    public ConverterDescriptor getAutoAppliedConverterDescriptorForMapKey(XProperty xProperty, MetadataBuildingContext context) {
        ResolvedMember<? extends Member> collectionMember = ConverterHelper.resolveMember(xProperty, context);
        if (!Map.class.isAssignableFrom(collectionMember.getType().getErasedType())) {
            throw new HibernateException("Attribute was not a Map : " + collectionMember.getType().getErasedType());
        }
        ResolvedType keyType = (ResolvedType)collectionMember.getType().typeParametersFor(Map.class).get(0);
        return ConverterHelper.typesMatch(this.linkedConverterDescriptor.getDomainValueResolvedType(), keyType) ? this.linkedConverterDescriptor : null;
    }
}

