/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;

public class DomainModelHelper {
    public static <T, S extends T> ManagedDomainType<S> resolveSubType(ManagedDomainType<T> baseType, String subTypeName, JpaMetamodel jpaMetamodel) {
        if (baseType instanceof EmbeddableDomainType) {
            return baseType;
        }
        EntityDomainType subManagedType = jpaMetamodel.resolveHqlEntityReference(subTypeName);
        if (subManagedType != null) {
            return subManagedType;
        }
        try {
            Class javaType = jpaMetamodel.getServiceRegistry().getService(ClassLoaderService.class).classForName(subTypeName);
            return jpaMetamodel.managedType(javaType);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown sub-type name (" + baseType.getTypeName() + ") : " + subTypeName);
        }
    }

    public static <S> ManagedDomainType<S> resolveSubType(ManagedDomainType<? super S> baseType, Class<S> subTypeClass, JpaMetamodel jpaMetamodel) {
        return jpaMetamodel.managedType(subTypeClass);
    }
}

