/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.schema.spi.Exporter;

public class StandardTableExporter
implements Exporter<Table> {
    protected final Dialect dialect;

    public StandardTableExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String[] getSqlCreateStrings(Table table, Metadata metadata, SqlStringGenerationContext context) {
        QualifiedNameParser.NameParts tableName = new QualifiedNameParser.NameParts(Identifier.toIdentifier(table.getCatalog(), table.isCatalogQuoted()), Identifier.toIdentifier(table.getSchema(), table.isSchemaQuoted()), table.getNameIdentifier());
        try {
            String formattedTableName = context.format(tableName);
            StringBuilder buf = new StringBuilder(this.tableCreateString(table.hasPrimaryKey())).append(' ').append(formattedTableName).append(" (");
            boolean isPrimaryKeyIdentity = table.hasPrimaryKey() && table.getIdentifierValue() != null && table.getIdentifierValue().isIdentityColumn(((MetadataImplementor)metadata).getMetadataBuildingOptions().getIdentifierGeneratorFactory(), this.dialect);
            String pkColName = null;
            if (table.hasPrimaryKey()) {
                Column pkColumn = table.getPrimaryKey().getColumns().iterator().next();
                pkColName = pkColumn.getQuotedName(this.dialect);
            }
            boolean isFirst = true;
            for (Column col : table.getColumns()) {
                String columnComment;
                String checkConstraint;
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                String colName = col.getQuotedName(this.dialect);
                buf.append(colName);
                if (isPrimaryKeyIdentity && colName.equals(pkColName)) {
                    if (this.dialect.getIdentityColumnSupport().hasDataTypeInIdentityColumn()) {
                        buf.append(' ').append(col.getSqlType(metadata.getDatabase().getTypeConfiguration(), this.dialect, metadata));
                    }
                    String identityColumnString = this.dialect.getIdentityColumnSupport().getIdentityColumnString(col.getSqlTypeCode(metadata));
                    buf.append(' ').append(identityColumnString);
                } else {
                    String generatedAs;
                    String defaultValue;
                    String columnType = col.getSqlType(metadata.getDatabase().getTypeConfiguration(), this.dialect, metadata);
                    if (col.getGeneratedAs() == null || this.dialect.hasDataTypeBeforeGeneratedAs()) {
                        buf.append(' ').append(columnType);
                    }
                    if ((defaultValue = col.getDefaultValue()) != null) {
                        buf.append(" default ").append(defaultValue);
                    }
                    if ((generatedAs = col.getGeneratedAs()) != null) {
                        buf.append(this.dialect.generatedAs(generatedAs));
                    }
                    if (col.isNullable()) {
                        buf.append(this.dialect.getNullColumnString(columnType));
                    } else {
                        buf.append(" not null");
                    }
                }
                if (col.isUnique()) {
                    String keyName = Constraint.generateName("UK_", table, col);
                    UniqueKey uk = table.getOrCreateUniqueKey(keyName);
                    uk.addColumn(col);
                    buf.append(this.dialect.getUniqueDelegate().getColumnDefinitionUniquenessFragment(col, context));
                }
                if ((checkConstraint = col.checkConstraint()) != null && this.dialect.supportsColumnCheck()) {
                    buf.append(checkConstraint);
                }
                if ((columnComment = col.getComment()) == null) continue;
                buf.append(this.dialect.getColumnComment(columnComment));
            }
            if (table.hasPrimaryKey()) {
                buf.append(", ").append(table.getPrimaryKey().sqlConstraintString(this.dialect));
            }
            buf.append(this.dialect.getUniqueDelegate().getTableCreationUniqueConstraintsFragment(table, context));
            this.applyTableCheck(table, buf);
            buf.append(')');
            if (table.getComment() != null) {
                buf.append(this.dialect.getTableComment(table.getComment()));
            }
            this.applyTableTypeString(buf);
            ArrayList<String> sqlStrings = new ArrayList<String>();
            sqlStrings.add(buf.toString());
            this.applyComments(table, formattedTableName, sqlStrings);
            this.applyInitCommands(table, sqlStrings, context);
            return sqlStrings.toArray(StringHelper.EMPTY_STRINGS);
        }
        catch (Exception e) {
            throw new MappingException("Error creating SQL create commands for table : " + tableName, e);
        }
    }

    @Deprecated
    protected void applyComments(Table table, QualifiedTableName tableName, List<String> sqlStrings) {
        this.applyComments(table, tableName.toString(), sqlStrings);
    }

    protected void applyComments(Table table, String formattedTableName, List<String> sqlStrings) {
        if (this.dialect.supportsCommentOn()) {
            if (table.getComment() != null) {
                sqlStrings.add("comment on table " + formattedTableName + " is '" + table.getComment() + "'");
            }
            for (Column column : table.getColumns()) {
                String columnComment = column.getComment();
                if (columnComment == null) continue;
                sqlStrings.add("comment on column " + formattedTableName + "." + column.getQuotedName(this.dialect) + " is '" + columnComment + "'");
            }
        }
    }

    protected void applyInitCommands(Table table, List<String> sqlStrings, SqlStringGenerationContext context) {
        for (InitCommand initCommand : table.getInitCommands(context)) {
            Collections.addAll(sqlStrings, initCommand.getInitCommands());
        }
    }

    protected void applyTableTypeString(StringBuilder buf) {
        buf.append(this.dialect.getTableTypeString());
    }

    protected void applyTableCheck(Table table, StringBuilder buf) {
        if (this.dialect.supportsTableCheck()) {
            for (String constraint : table.getCheckConstraints()) {
                buf.append(", check (").append(constraint).append(')');
            }
        }
    }

    protected String tableCreateString(boolean hasPrimaryKey) {
        return hasPrimaryKey ? this.dialect.getCreateTableString() : this.dialect.getCreateMultisetTableString();
    }

    @Override
    public String[] getSqlDropStrings(Table table, Metadata metadata, SqlStringGenerationContext context) {
        StringBuilder buf = new StringBuilder("drop table ");
        if (this.dialect.supportsIfExistsBeforeTableName()) {
            buf.append("if exists ");
        }
        QualifiedNameParser.NameParts tableName = new QualifiedNameParser.NameParts(Identifier.toIdentifier(table.getCatalog(), table.isCatalogQuoted()), Identifier.toIdentifier(table.getSchema(), table.isSchemaQuoted()), table.getNameIdentifier());
        buf.append(context.format(tableName)).append(this.dialect.getCascadeConstraintsString());
        if (this.dialect.supportsIfExistsAfterTableName()) {
            buf.append(" if exists");
        }
        return new String[]{buf.toString()};
    }
}

