/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.listener;

import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;

public class NonBlockingCacheEventListener<K, V>
implements Function<CacheEntryEvent<K, V>, CompletionStage<Void>>,
Consumer<CacheEntryEvent<K, V>> {
    private final BiConsumer<K, V> consumer;

    public NonBlockingCacheEventListener(Consumer<K> consumer) {
        this((K key, V value) -> consumer.accept(key));
    }

    public NonBlockingCacheEventListener(BiConsumer<K, V> consumer) {
        this.consumer = consumer;
    }

    @Override
    public CompletionStage<Void> apply(CacheEntryEvent<K, V> event) {
        this.accept(event);
        return CompletableFutures.completedNull();
    }

    @Override
    public void accept(CacheEntryEvent<K, V> event) {
        this.consumer.accept(event.getKey(), event.getValue());
    }
}

