/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.addressing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class AddressingTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSessionFactory sessionFactory;

    @Before
    public void setup() throws Exception {
        this.server = this.createServer(true);
        this.server.start();
        this.server.waitForActivation(10L, TimeUnit.SECONDS);
        ServerLocator sl = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        this.sessionFactory = sl.createSessionFactory();
        this.addSessionFactory(this.sessionFactory);
    }

    @Test
    public void testMulticastRouting() throws Exception {
        SimpleString sendAddress = new SimpleString("test.address");
        List<String> testAddresses = Arrays.asList("test.address", "test.#", "test.*");
        for (String consumeAddress : testAddresses) {
            AddressInfo addressInfo = new AddressInfo(new SimpleString(consumeAddress));
            addressInfo.addRoutingType(RoutingType.MULTICAST);
            this.server.addOrUpdateAddressInfo(addressInfo);
            Queue q1 = this.server.createQueue(new QueueConfiguration(new SimpleString(consumeAddress + ".1")).setAddress(new SimpleString(consumeAddress)).setRoutingType(RoutingType.MULTICAST));
            Queue q2 = this.server.createQueue(new QueueConfiguration(new SimpleString(consumeAddress + ".2")).setAddress(new SimpleString(consumeAddress)).setRoutingType(RoutingType.MULTICAST));
            ClientSession session = this.sessionFactory.createSession();
            session.start();
            ClientConsumer consumer1 = session.createConsumer(q1.getName());
            ClientConsumer consumer2 = session.createConsumer(q2.getName());
            ClientProducer producer = session.createProducer(sendAddress);
            ClientMessage m = session.createMessage((byte)3, true);
            m.getBodyBuffer().writeString("TestMessage");
            producer.send((Message)m);
            AddressingTest.assertNotNull((Object)consumer1.receive(2000L));
            AddressingTest.assertNotNull((Object)consumer2.receive(2000L));
            q1.deleteQueue();
            q2.deleteQueue();
        }
    }

    @Test
    public void testDynamicMulticastRouting() throws Exception {
        SimpleString sendAddress = new SimpleString("test.address");
        AddressInfo addressInfo = new AddressInfo(sendAddress);
        addressInfo.addRoutingType(RoutingType.MULTICAST);
        this.server.addOrUpdateAddressInfo(addressInfo);
        Queue q1 = this.server.createQueue(new QueueConfiguration(new SimpleString("1.test.address")).setAddress("test.address").setRoutingType(RoutingType.MULTICAST));
        Queue q2 = this.server.createQueue(new QueueConfiguration(new SimpleString("2.test.#")).setAddress("test.#").setRoutingType(RoutingType.MULTICAST));
        ClientSession session = this.sessionFactory.createSession();
        session.start();
        ClientConsumer consumer1 = session.createConsumer(q1.getName());
        ClientConsumer consumer2 = session.createConsumer(q2.getName());
        ClientProducer producer = session.createProducer(sendAddress);
        ClientMessage m = session.createMessage((byte)3, true);
        m.getBodyBuffer().writeString("TestMessage");
        producer.send((Message)m);
        AddressingTest.assertNotNull((Object)consumer1.receive(2000L));
        AddressingTest.assertNotNull((Object)consumer2.receive(2000L));
        Queue q3 = this.server.createQueue(new QueueConfiguration(new SimpleString("3.test.*")).setAddress("test.*").setRoutingType(RoutingType.MULTICAST));
        ClientConsumer consumer3 = session.createConsumer(q3.getName());
        producer.send((Message)m);
        AddressingTest.assertNotNull((Object)consumer1.receive(2000L));
        AddressingTest.assertNotNull((Object)consumer2.receive(2000L));
        AddressingTest.assertNotNull((Object)consumer3.receive(2000L));
        q1.deleteQueue();
        q2.deleteQueue();
        q3.deleteQueue();
    }

    @Test
    public void testAnycastRouting() throws Exception {
        SimpleString sendAddress = new SimpleString("test.address");
        List<String> testAddresses = Arrays.asList("test.address", "test.#", "test.*");
        for (String consumeAddress : testAddresses) {
            AddressInfo addressInfo = new AddressInfo(new SimpleString(consumeAddress));
            addressInfo.addRoutingType(RoutingType.ANYCAST);
            this.server.addOrUpdateAddressInfo(addressInfo);
            Queue q1 = this.server.createQueue(new QueueConfiguration(new SimpleString(consumeAddress + ".1")).setAddress(new SimpleString(consumeAddress)).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(-1)));
            Queue q2 = this.server.createQueue(new QueueConfiguration(new SimpleString(consumeAddress + ".2")).setAddress(new SimpleString(consumeAddress)).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(-1)));
            ClientSession session = this.sessionFactory.createSession();
            session.start();
            ClientConsumer consumer1 = session.createConsumer(q1.getName());
            ClientConsumer consumer2 = session.createConsumer(q2.getName());
            ClientProducer producer = session.createProducer(sendAddress);
            ClientMessage m = session.createMessage((byte)3, true);
            m.getBodyBuffer().writeString("TestMessage");
            producer.send((Message)m);
            int count = 0;
            count = consumer1.receive(1000L) == null ? count : count + 1;
            count = consumer2.receive(1000L) == null ? count : count + 1;
            AddressingTest.assertEquals((long)1L, (long)count);
            q1.deleteQueue();
            q2.deleteQueue();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAnycastRoutingRoundRobin() throws Exception {
        void var15_18;
        ClientMessage clientMessage;
        SimpleString address = new SimpleString("test.address");
        AddressInfo addressInfo = new AddressInfo(address);
        addressInfo.addRoutingType(RoutingType.ANYCAST);
        this.server.addOrUpdateAddressInfo(addressInfo);
        Queue q1 = this.server.createQueue(new QueueConfiguration(address.concat(".1")).setAddress(address).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(-1)));
        Queue q2 = this.server.createQueue(new QueueConfiguration(address.concat(".2")).setAddress(address).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(-1)));
        Queue q3 = this.server.createQueue(new QueueConfiguration(address.concat(".3")).setAddress(address).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(-1)));
        ClientSession session = this.sessionFactory.createSession();
        session.start();
        ClientProducer producer = session.createProducer(address);
        ClientConsumer consumer1 = session.createConsumer(q1.getName());
        ClientConsumer consumer2 = session.createConsumer(q2.getName());
        ClientConsumer consumer3 = session.createConsumer(q3.getName());
        ArrayList<ClientConsumer> consumers = new ArrayList<ClientConsumer>(Arrays.asList(consumer1, consumer2, consumer3));
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("Message1");
        messages.add("Message2");
        messages.add("Message3");
        for (String string : messages) {
            clientMessage = session.createMessage(true);
            clientMessage.getBodyBuffer().writeString(string);
            producer.send((Message)clientMessage);
        }
        for (ClientConsumer consumer : consumers) {
            clientMessage = consumer.receive(1000L);
            String m = clientMessage.getBodyBuffer().readString();
            messages.remove(m);
        }
        AddressingTest.assertTrue((boolean)messages.isEmpty());
        boolean bl = false;
        for (ClientConsumer consumer : consumers) {
            var15_18 = consumer.receive(1000L) == null ? var15_18 : var15_18 + true;
        }
        AddressingTest.assertEquals((long)0L, (long)((long)var15_18));
    }

    @Test
    public void testMulticastRoutingBackwardsCompat() throws Exception {
        SimpleString sendAddress = new SimpleString("test.address");
        List<String> testAddresses = Arrays.asList("test.address", "test.#", "test.*");
        for (String consumeAddress : testAddresses) {
            Queue q1 = this.server.createQueue(new QueueConfiguration(new SimpleString(consumeAddress + ".1")).setAddress(new SimpleString(consumeAddress)).setRoutingType(RoutingType.MULTICAST));
            Queue q2 = this.server.createQueue(new QueueConfiguration(new SimpleString(consumeAddress + ".2")).setAddress(new SimpleString(consumeAddress)).setRoutingType(RoutingType.MULTICAST));
            ClientSession session = this.sessionFactory.createSession();
            session.start();
            ClientConsumer consumer1 = session.createConsumer(q1.getName());
            ClientConsumer consumer2 = session.createConsumer(q2.getName());
            ClientProducer producer = session.createProducer(sendAddress);
            ClientMessage m = session.createMessage((byte)3, true);
            m.getBodyBuffer().writeString("TestMessage");
            producer.send((Message)m);
            AddressingTest.assertNotNull((Object)consumer1.receive(2000L));
            AddressingTest.assertNotNull((Object)consumer2.receive(2000L));
            q1.deleteQueue();
            q2.deleteQueue();
        }
    }

    @Test
    public void testPurgeOnNoConsumersTrue() throws Exception {
        SimpleString address = new SimpleString("test.address");
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        this.server.createQueue(new QueueConfiguration(queueName).setAddress(address).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).setPurgeOnNoConsumers(Boolean.valueOf(true)));
        Queue queue = this.server.locateQueue(queueName);
        AddressingTest.assertNotNull((Object)queue);
        ClientSession session = this.sessionFactory.createSession();
        ClientProducer producer = session.createProducer(address);
        producer.send((Message)session.createMessage(true));
        AddressingTest.assertEquals((long)0L, (long)queue.getMessageCount());
        ClientConsumer consumer = session.createConsumer(queueName);
        producer.send((Message)session.createMessage(true));
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        consumer.close();
        AddressingTest.assertNotNull((Object)this.server.locateQueue(queueName));
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
        producer.send((Message)session.createMessage(true));
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    public void testPurgeOnNoConsumersFalse() throws Exception {
        SimpleString address = new SimpleString("test.address");
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        this.server.createQueue(new QueueConfiguration(queueName).setAddress(address).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)));
        AddressingTest.assertNotNull((Object)this.server.locateQueue(queueName));
        ClientSession session = this.sessionFactory.createSession();
        ClientProducer producer = session.createProducer(address);
        producer.send((Message)session.createMessage(true));
        session.createConsumer(queueName).close();
        AddressingTest.assertNotNull((Object)this.server.locateQueue(queueName));
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(queueName)).getMessageCount());
    }

    @Test
    public void testQueueEnabledDisabled() throws Exception {
        SimpleString address = new SimpleString("test.address");
        SimpleString defaultQueue = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString enabledQueue = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString disabledQueue = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        this.server.createQueue(new QueueConfiguration(defaultQueue).setAddress(address).setRoutingType(RoutingType.MULTICAST));
        this.server.createQueue(new QueueConfiguration(enabledQueue).setAddress(address).setRoutingType(RoutingType.MULTICAST).setEnabled(Boolean.valueOf(true)));
        this.server.createQueue(new QueueConfiguration(disabledQueue).setAddress(address).setRoutingType(RoutingType.MULTICAST).setEnabled(Boolean.valueOf(false)));
        AddressingTest.assertNotNull((Object)this.server.locateQueue(defaultQueue));
        AddressingTest.assertNotNull((Object)this.server.locateQueue(enabledQueue));
        AddressingTest.assertNotNull((Object)this.server.locateQueue(disabledQueue));
        ClientSession session = this.sessionFactory.createSession();
        ClientProducer producer = session.createProducer(address);
        producer.send((Message)session.createMessage(true));
        AddressingTest.assertNotNull((Object)this.server.locateQueue(defaultQueue));
        AddressingTest.assertNotNull((Object)this.server.locateQueue(enabledQueue));
        AddressingTest.assertNotNull((Object)this.server.locateQueue(disabledQueue));
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(defaultQueue)).getMessageCount());
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(enabledQueue)).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)this.server.locateQueue(disabledQueue)).getMessageCount());
        this.server.updateQueue(new QueueConfiguration(defaultQueue).setAddress(address).setRoutingType(RoutingType.MULTICAST).setEnabled(Boolean.valueOf(false)));
        this.server.updateQueue(new QueueConfiguration(enabledQueue).setAddress(address).setRoutingType(RoutingType.MULTICAST).setEnabled(Boolean.valueOf(false)));
        this.server.updateQueue(new QueueConfiguration(disabledQueue).setAddress(address).setRoutingType(RoutingType.MULTICAST).setEnabled(Boolean.valueOf(false)));
        producer.send((Message)session.createMessage(true));
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(defaultQueue)).getMessageCount());
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(enabledQueue)).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)this.server.locateQueue(disabledQueue)).getMessageCount());
        this.server.updateQueue(new QueueConfiguration(defaultQueue).setAddress(address).setRoutingType(RoutingType.MULTICAST).setEnabled(Boolean.valueOf(true)));
        this.server.updateQueue(new QueueConfiguration(enabledQueue).setAddress(address).setRoutingType(RoutingType.MULTICAST).setEnabled(Boolean.valueOf(true)));
        this.server.updateQueue(new QueueConfiguration(disabledQueue).setAddress(address).setRoutingType(RoutingType.MULTICAST).setEnabled(Boolean.valueOf(true)));
        producer.send((Message)session.createMessage(true));
        Wait.assertEquals((long)2L, () -> ((Queue)this.server.locateQueue(defaultQueue)).getMessageCount());
        Wait.assertEquals((long)2L, () -> ((Queue)this.server.locateQueue(enabledQueue)).getMessageCount());
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(disabledQueue)).getMessageCount());
    }

    @Test
    public void testLimitOnMaxConsumers() throws Exception {
        SimpleString address = new SimpleString("test.address");
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        boolean purgeOnNoConsumers = false;
        Queue q1 = this.server.createQueue(new QueueConfiguration(queueName).setAddress(address).setMaxConsumers(Integer.valueOf(0)).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)));
        ActiveMQQueueMaxConsumerLimitReached expectedException = null;
        String expectedMessage = "Maximum Consumer Limit Reached on Queue";
        try {
            ClientSession session = this.sessionFactory.createSession();
            session.start();
            session.createConsumer(q1.getName());
        }
        catch (ActiveMQQueueMaxConsumerLimitReached e) {
            expectedException = e;
        }
        AddressingTest.assertNotNull((Object)((Object)expectedException));
        AddressingTest.assertTrue((boolean)expectedException.getMessage().contains(expectedMessage));
        AddressingTest.assertTrue((boolean)expectedException.getMessage().contains((CharSequence)address));
        AddressingTest.assertTrue((boolean)expectedException.getMessage().contains((CharSequence)queueName));
    }

    @Test
    public void testUnlimitedMaxConsumers() throws Exception {
        int noConsumers = 50;
        SimpleString address = new SimpleString("test.address");
        SimpleString queueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        boolean purgeOnNoConsumers = false;
        Queue q1 = this.server.createQueue(new QueueConfiguration(queueName).setAddress(address).setMaxConsumers(Integer.valueOf(-1)).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)));
        ClientSession session = this.sessionFactory.createSession();
        session.start();
        for (int i = 0; i < noConsumers; ++i) {
            session.createConsumer(q1.getName());
        }
    }

    @Test
    public void testEmptyRoutingTypes() throws Exception {
        this.server.addOrUpdateAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"xy")));
        this.server.stop();
        this.server.start();
        this.server.addOrUpdateAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"xy")));
        this.server.stop();
    }
}

