/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.queue.CreateQueue;
import org.apache.activemq.artemis.cli.commands.queue.DeleteQueue;
import org.apache.activemq.artemis.cli.commands.queue.PurgeQueue;
import org.apache.activemq.artemis.cli.commands.queue.UpdateQueue;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.cli.DummyServerConsumer;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class QueueCommandTest
extends JMSTestBase {
    private ByteArrayOutputStream output;
    private ByteArrayOutputStream error;

    @Override
    protected void extraServerConfig(ActiveMQServer server) {
        super.extraServerConfig(server);
        server.getConfiguration().setAddressQueueScanPeriod(100L);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.output = new ByteArrayOutputStream(1024);
        this.error = new ByteArrayOutputStream(1024);
    }

    @Test
    public void testCreateCoreQueueShowsErrorWhenAddressDoesNotExists() throws Exception {
        String queueName = "queue1";
        CreateQueue command = new CreateQueue();
        command.setName(queueName);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)command, "AMQ229203");
        QueueCommandTest.assertFalse((boolean)this.server.queueQuery(new SimpleString(queueName)).isExists());
    }

    @Test
    public void testCreateCoreQueueAutoCreateAddressDefaultAddress() throws Exception {
        String queueName = UUID.randomUUID().toString();
        CreateQueue command = new CreateQueue();
        command.setName(queueName);
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)command);
        QueueCommandTest.assertNotNull((Object)this.server.getAddressInfo(new SimpleString(queueName)));
        Queue queue = this.server.locateQueue(new SimpleString(queueName));
        QueueCommandTest.assertEquals((long)-1L, (long)queue.getMaxConsumers());
        QueueCommandTest.assertEquals((Object)false, (Object)queue.isPurgeOnNoConsumers());
        QueueCommandTest.assertTrue((boolean)this.server.queueQuery(new SimpleString(queueName)).isExists());
    }

    @Test
    public void testCreateCoreQueueAddressExists() throws Exception {
        String queueName = "queue";
        String address = "address";
        CreateQueue command = new CreateQueue();
        command.setName(queueName);
        command.setAutoCreateAddress(false);
        command.setMulticast(true);
        command.setAnycast(false);
        command.setAddress(address);
        this.server.addOrUpdateAddressInfo(new AddressInfo(new SimpleString(address), RoutingType.MULTICAST));
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)command);
        QueueCommandTest.assertNotNull((Object)this.server.getAddressInfo(new SimpleString(address)));
        Queue queue = this.server.locateQueue(new SimpleString(queueName));
        QueueCommandTest.assertEquals((long)-1L, (long)queue.getMaxConsumers());
        QueueCommandTest.assertEquals((Object)false, (Object)queue.isPurgeOnNoConsumers());
        QueueCommandTest.assertTrue((boolean)this.server.queueQuery(new SimpleString(queueName)).isExists());
    }

    @Test
    public void testCreateCoreQueueWithFilter() throws Exception {
        String queueName = "queue2";
        String filerString = "color='green'";
        CreateQueue command = new CreateQueue();
        command.setName(queueName);
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)command);
        Queue queue = this.server.locateQueue(new SimpleString(queueName));
        QueueCommandTest.assertNotNull((Object)queue);
        QueueCommandTest.assertEquals((Object)new SimpleString(filerString), (Object)queue.getFilter().getFilterString());
    }

    @Test
    public void testCreateQueueAlreadyExists() throws Exception {
        String queueName = "queue2";
        String filerString = "color='green'";
        CreateQueue command = new CreateQueue();
        command.setName(queueName);
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext());
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)command, "AMQ229019");
    }

    @Test
    public void testDeleteCoreQueue() throws Exception {
        SimpleString queueName = new SimpleString("deleteQueue");
        CreateQueue command = new CreateQueue();
        command.setName(queueName.toString());
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext());
        DeleteQueue delete = new DeleteQueue();
        delete.setName(queueName.toString());
        delete.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)delete);
        QueueCommandTest.assertFalse((boolean)this.server.queueQuery(queueName).isExists());
    }

    @Test
    public void testDeleteQueueDoesNotExist() throws Exception {
        SimpleString queueName = new SimpleString("deleteQueue");
        DeleteQueue delete = new DeleteQueue();
        delete.setName(queueName.toString());
        delete.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)delete, "AMQ229017");
        QueueCommandTest.assertFalse((boolean)this.server.queueQuery(queueName).isExists());
    }

    @Test
    public void testDeleteQueueWithConsumersFails() throws Exception {
        SimpleString queueName = new SimpleString("deleteQueue");
        CreateQueue command = new CreateQueue();
        command.setName(queueName.toString());
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext());
        this.server.locateQueue(queueName).addConsumer((Consumer)new DummyServerConsumer());
        DeleteQueue delete = new DeleteQueue();
        delete.setName(queueName.toString());
        delete.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)delete, "AMQ229025");
    }

    @Test
    public void testDeleteQueueWithConsumersFailsAndRemoveConsumersTrue() throws Exception {
        SimpleString queueName = new SimpleString("deleteQueue");
        CreateQueue command = new CreateQueue();
        command.setName(queueName.toString());
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext());
        this.server.locateQueue(queueName).addConsumer((Consumer)new DummyServerConsumer());
        DeleteQueue delete = new DeleteQueue();
        delete.setName(queueName.toString());
        delete.setRemoveConsumers(true);
        delete.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)command);
    }

    @Test
    public void testAutoDeleteAddress() throws Exception {
        SimpleString queueName = new SimpleString("deleteQueue");
        CreateQueue command = new CreateQueue();
        command.setName(queueName.toString());
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext());
        QueueCommandTest.assertNotNull((Object)this.server.getAddressInfo(queueName));
        this.server.locateQueue(queueName).addConsumer((Consumer)new DummyServerConsumer());
        DeleteQueue delete = new DeleteQueue();
        delete.setName(queueName.toString());
        delete.setRemoveConsumers(true);
        delete.setAutoDeleteAddress(true);
        delete.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)command);
        Wait.assertTrue(() -> this.server.getAddressInfo(queueName) == null, (long)2000L, (long)10L);
    }

    @Test
    public void testUpdateCoreQueue() throws Exception {
        String queueName = "updateQueue";
        SimpleString queueNameString = new SimpleString("updateQueue");
        String addressName = "address";
        SimpleString addressSimpleString = new SimpleString("address");
        int oldMaxConsumers = -1;
        RoutingType oldRoutingType = RoutingType.MULTICAST;
        boolean oldPurgeOnNoConsumers = false;
        AddressInfo addressInfo = new AddressInfo(addressSimpleString, EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST));
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(new QueueConfiguration(queueNameString).setAddress(addressSimpleString).setRoutingType(oldRoutingType).setMaxConsumers(Integer.valueOf(-1)).setPurgeOnNoConsumers(Boolean.valueOf(false)).setAutoCreateAddress(Boolean.valueOf(false)));
        boolean newMaxConsumers = true;
        RoutingType newRoutingType = RoutingType.ANYCAST;
        boolean newPurgeOnNoConsumers = true;
        UpdateQueue updateQueue = new UpdateQueue();
        updateQueue.setName("updateQueue");
        updateQueue.setPurgeOnNoConsumers(true);
        updateQueue.setAnycast(true);
        updateQueue.setMulticast(false);
        updateQueue.setMaxConsumers(1);
        updateQueue.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)updateQueue);
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueNameString);
        QueueCommandTest.assertEquals((String)"maxConsumers", (long)1L, (long)queueQueryResult.getMaxConsumers());
        QueueCommandTest.assertEquals((String)"routingType", (Object)newRoutingType, (Object)queueQueryResult.getRoutingType());
        QueueCommandTest.assertTrue((String)"purgeOnNoConsumers", (true == queueQueryResult.isPurgeOnNoConsumers() ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateCoreQueueCannotChangeRoutingType() throws Exception {
        String queueName = "updateQueue";
        SimpleString queueNameString = new SimpleString("updateQueue");
        String addressName = "address";
        SimpleString addressSimpleString = new SimpleString("address");
        int oldMaxConsumers = 10;
        RoutingType oldRoutingType = RoutingType.MULTICAST;
        boolean oldPurgeOnNoConsumers = false;
        EnumSet<RoutingType> supportedRoutingTypes = EnumSet.of(oldRoutingType);
        AddressInfo addressInfo = new AddressInfo(addressSimpleString, EnumSet.copyOf(supportedRoutingTypes));
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(new QueueConfiguration(queueNameString).setAddress(addressSimpleString).setRoutingType(oldRoutingType).setMaxConsumers(Integer.valueOf(10)).setPurgeOnNoConsumers(Boolean.valueOf(false)).setAutoCreateAddress(Boolean.valueOf(false)));
        RoutingType newRoutingType = RoutingType.ANYCAST;
        UpdateQueue updateQueue = new UpdateQueue();
        updateQueue.setName("updateQueue");
        updateQueue.setAnycast(true);
        updateQueue.setMulticast(false);
        updateQueue.setMaxConsumers(-1);
        updateQueue.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)updateQueue, "AMQ229211");
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueNameString);
        QueueCommandTest.assertEquals((String)"maxConsumers", (long)10L, (long)queueQueryResult.getMaxConsumers());
        QueueCommandTest.assertEquals((String)"routingType", (Object)oldRoutingType, (Object)queueQueryResult.getRoutingType());
        QueueCommandTest.assertTrue((String)"purgeOnNoConsumers", (false == queueQueryResult.isPurgeOnNoConsumers() ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateCoreQueueCannotLowerMaxConsumers() throws Exception {
        String queueName = "updateQueue";
        SimpleString queueNameString = new SimpleString("updateQueue");
        String addressName = "address";
        SimpleString addressSimpleString = new SimpleString("address");
        int oldMaxConsumers = 2;
        RoutingType oldRoutingType = RoutingType.MULTICAST;
        boolean oldPurgeOnNoConsumers = false;
        AddressInfo addressInfo = new AddressInfo(addressSimpleString, oldRoutingType);
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(new QueueConfiguration(queueNameString).setAddress(addressSimpleString).setRoutingType(oldRoutingType).setMaxConsumers(Integer.valueOf(2)).setPurgeOnNoConsumers(Boolean.valueOf(false)).setAutoCreateAddress(Boolean.valueOf(false)));
        this.server.locateQueue(queueNameString).addConsumer((Consumer)new DummyServerConsumer());
        this.server.locateQueue(queueNameString).addConsumer((Consumer)new DummyServerConsumer());
        boolean newMaxConsumers = true;
        UpdateQueue updateQueue = new UpdateQueue();
        updateQueue.setName("updateQueue");
        updateQueue.setMaxConsumers(1);
        updateQueue.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)updateQueue, "AMQ229210");
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueNameString);
        QueueCommandTest.assertEquals((String)"maxConsumers", (long)2L, (long)queueQueryResult.getMaxConsumers());
    }

    @Test
    public void testUpdateCoreQueueDoesNotExist() throws Exception {
        SimpleString queueName = new SimpleString("updateQueue");
        UpdateQueue updateQueue = new UpdateQueue();
        updateQueue.setName(queueName.toString());
        updateQueue.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)updateQueue, "AMQ229017: Queue " + queueName + " does not exist");
        QueueCommandTest.assertFalse((boolean)this.server.queueQuery(queueName).isExists());
    }

    @Test
    public void testPurgeQueue() throws Exception {
        SimpleString queueName = new SimpleString("purgeQueue");
        CreateQueue command = new CreateQueue();
        command.setName(queueName.toString());
        command.setAutoCreateAddress(true);
        command.setAnycast(true);
        command.execute(new ActionContext());
        PurgeQueue purge = new PurgeQueue();
        purge.setName(queueName.toString());
        purge.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((AbstractAction)purge);
    }

    @Test
    public void testPurgeQueueDoesNotExist() throws Exception {
        SimpleString queueName = new SimpleString("purgeQueue");
        PurgeQueue purge = new PurgeQueue();
        purge.setName(queueName.toString());
        purge.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((AbstractAction)purge, "AMQ229067: Cannot find resource with name queue." + queueName);
        QueueCommandTest.assertFalse((boolean)this.server.queueQuery(queueName).isExists());
    }

    private void checkExecutionPassed(AbstractAction command) throws Exception {
        String fullMessage = this.output.toString();
        this.instanceLog.debug((Object)("output: " + fullMessage));
        QueueCommandTest.assertTrue((String)fullMessage, (boolean)fullMessage.contains("successfully"));
    }

    private void checkExecutionFailure(AbstractAction command, String message) throws Exception {
        String fullMessage = this.error.toString();
        this.instanceLog.debug((Object)("error: " + fullMessage));
        QueueCommandTest.assertTrue((String)fullMessage, (boolean)fullMessage.contains(message));
    }
}

