/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.JMSContext;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class ProgrammaticRedeployTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeployAddressQueue() throws Exception {
        Path brokerXML = this.getTestDirfile().toPath().resolve("broker.xml");
        URL url1 = ProgrammaticRedeployTest.class.getClassLoader().getResource("reload-address-queues-programmatic.xml");
        URL url2 = ProgrammaticRedeployTest.class.getClassLoader().getResource("reload-address-queues-updated-programmatic.xml");
        Files.copy(url1.openStream(), brokerXML, new CopyOption[0]);
        EmbeddedActiveMQ embeddedActiveMQ = new EmbeddedActiveMQ();
        embeddedActiveMQ.setConfigResourcePath(brokerXML.toUri().toString());
        embeddedActiveMQ.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        try (JMSContext jmsContext = connectionFactory.createContext();){
            jmsContext.createSharedDurableConsumer(jmsContext.createTopic("config_test_consumer_created_queues"), "mySub").receive(100L);
        }
        try {
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_consumer_created_queues").contains("mySub"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_address_removal"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_queue_removal"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_1"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_2"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assert.assertEquals((long)10L, (long)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assert.assertEquals((Object)false, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Files.copy(url2.openStream(), brokerXML, StandardCopyOption.REPLACE_EXISTING);
            brokerXML.toFile().setLastModified(System.currentTimeMillis() + 1000L);
            embeddedActiveMQ.getActiveMQServer().reloadConfigurationFile();
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_consumer_created_queues").contains("mySub"));
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal_no_queue"));
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_address_removal"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_1"));
            Assert.assertFalse((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_removal").contains("config_test_queue_removal_queue_2"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_address_removal"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "permanent_test_queue_removal"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_1"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "permanent_test_queue_removal").contains("permanent_test_queue_removal_queue_2"));
            Assert.assertNotNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change"));
            Assert.assertTrue((boolean)this.listQueuesNamesForAddress(embeddedActiveMQ, "config_test_queue_change").contains("config_test_queue_change_queue"));
            Assert.assertEquals((long)1L, (long)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").getMaxConsumers());
            Assert.assertEquals((Object)true, (Object)this.getQueue(embeddedActiveMQ, "config_test_queue_change_queue").isPurgeOnNoConsumers());
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_change_queue"));
            Assert.assertNull((Object)this.getAddressInfo(embeddedActiveMQ, "config_test_queue_removal_queue_1"));
        }
        finally {
            embeddedActiveMQ.stop();
        }
    }

    private AddressInfo getAddressInfo(EmbeddedActiveMQ embeddedActiveMQ, String address) {
        return embeddedActiveMQ.getActiveMQServer().getPostOffice().getAddressInfo(SimpleString.toSimpleString((String)address));
    }

    private Queue getQueue(EmbeddedActiveMQ embeddedActiveMQ, String queueName) throws Exception {
        QueueBinding queueBinding = (QueueBinding)embeddedActiveMQ.getActiveMQServer().getPostOffice().getBinding(SimpleString.toSimpleString((String)queueName));
        return queueBinding == null ? null : queueBinding.getQueue();
    }

    private List<String> listQueuesNamesForAddress(EmbeddedActiveMQ embeddedActiveMQ, String address) throws Exception {
        return embeddedActiveMQ.getActiveMQServer().getPostOffice().listQueuesForAddress(SimpleString.toSimpleString((String)address)).stream().map(Queue::getName).map(SimpleString::toString).collect(Collectors.toList());
    }
}

