/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import java.util.HashSet;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Before;
import org.junit.Test;

public class TemporaryDestinationTest
extends JMSTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected boolean usePersistence() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryQueueLeak() throws Exception {
        try (ActiveMQConnection conn = null;){
            conn = (ActiveMQConnection)this.createConnection();
            Session producerSession = conn.createSession(false, 1);
            Session consumerSession = conn.createSession(false, 1);
            TemporaryQueue tempQueue = producerSession.createTemporaryQueue();
            MessageProducer producer = producerSession.createProducer((Destination)tempQueue);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)tempQueue);
            conn.start();
            String messageText = "This is a message";
            TextMessage m = producerSession.createTextMessage("This is a message");
            producer.send((Message)m);
            TextMessage m2 = (TextMessage)consumer.receive(2000L);
            TemporaryDestinationTest.assertNotNull((Object)m2);
            TemporaryDestinationTest.assertEquals((Object)"This is a message", (Object)m2.getText());
            consumer.close();
            TemporaryDestinationTest.assertTrue((boolean)((ActiveMQDestination)tempQueue).isCreated());
            tempQueue.delete();
            TemporaryDestinationTest.assertFalse((boolean)((ActiveMQDestination)tempQueue).isCreated());
            TemporaryDestinationTest.assertFalse((boolean)conn.containsTemporaryQueue(SimpleString.toSimpleString((String)tempQueue.getQueueName())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryQueueDeletedAfterSessionClosed() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)));
        try (Connection conn = null;){
            conn = this.createConnection();
            Session producerSession = conn.createSession(false, 1);
            Session consumerSession = conn.createSession(false, 1);
            TemporaryQueue tempQueue = producerSession.createTemporaryQueue();
            MessageProducer producer = producerSession.createProducer((Destination)tempQueue);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)tempQueue);
            conn.start();
            String messageText = "This is a message";
            TextMessage m = producerSession.createTextMessage("This is a message");
            producer.send((Message)m);
            TextMessage m2 = (TextMessage)consumer.receive(2000L);
            TemporaryDestinationTest.assertNotNull((Object)m2);
            TemporaryDestinationTest.assertEquals((Object)"This is a message", (Object)m2.getText());
            consumer.close();
            consumerSession.close();
            producer.close();
            producerSession.close();
            tempQueue.delete();
            producerSession = conn.createSession(false, 1);
            try {
                producer = producerSession.createProducer((Destination)tempQueue);
                producer.send((Message)m);
                TemporaryDestinationTest.fail();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryTopicDeletedAfterSessionClosed() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)));
        try (Connection conn = null;){
            conn = this.createConnection();
            Session producerSession = conn.createSession(false, 1);
            Session consumerSession = conn.createSession(false, 1);
            TemporaryTopic tempTopic = producerSession.createTemporaryTopic();
            MessageProducer producer = producerSession.createProducer((Destination)tempTopic);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)tempTopic);
            conn.start();
            String messageText = "This is a message";
            TextMessage m = producerSession.createTextMessage("This is a message");
            producer.send((Message)m);
            TextMessage m2 = (TextMessage)consumer.receive(2000L);
            TemporaryDestinationTest.assertNotNull((Object)m2);
            TemporaryDestinationTest.assertEquals((Object)"This is a message", (Object)m2.getText());
            consumer.close();
            consumerSession.close();
            producer.close();
            producerSession.close();
            tempTopic.delete();
            producerSession = conn.createSession(false, 1);
            try {
                producer = producerSession.createProducer((Destination)tempTopic);
                producer.send((Message)m);
                TemporaryDestinationTest.fail();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryResourcesDeletedAfterServerRestart() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)));
        try (Connection conn = null;){
            conn = this.createConnection();
            Session producerSession = conn.createSession(false, 1);
            TemporaryQueue tempQueue = producerSession.createTemporaryQueue();
            TemporaryDestinationTest.assertNotNull((Object)this.server.getAddressInfo(SimpleString.toSimpleString((String)tempQueue.getQueueName())));
            this.server.stop();
            conn.close();
            this.server.start();
            this.waitForServerToStart(this.server);
            TemporaryDestinationTest.assertNull((Object)this.server.getAddressInfo(SimpleString.toSimpleString((String)tempQueue.getQueueName())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForTempQueueCleanerUpperLeak() throws Exception {
        try {
            this.conn = this.createConnection();
            Session s = this.conn.createSession(false, 1);
            TemporaryQueue temporaryQueue = s.createTemporaryQueue();
            temporaryQueue.delete();
            for (ServerSession serverSession : this.server.getSessions()) {
                TemporaryDestinationTest.assertEquals((long)0L, (long)((ServerSessionImpl)serverSession).getTempQueueCleanUppers().size());
            }
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForTempQueueTargetInfosLeak() throws Exception {
        try {
            this.conn = this.createConnection();
            Session s = this.conn.createSession(false, 1);
            TemporaryQueue temporaryQueue = s.createTemporaryQueue();
            MessageProducer producer = s.createProducer((Destination)temporaryQueue);
            producer.send(s.createMessage());
            temporaryQueue.delete();
            for (ServerSession serverSession : this.server.getSessions()) {
                TemporaryDestinationTest.assertFalse((boolean)((ServerSessionImpl)serverSession).cloneTargetAddresses().containsKey(SimpleString.toSimpleString((String)temporaryQueue.getQueueName())));
            }
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForTempQueueTargetInfosSizeLimit() throws Exception {
        try {
            this.conn = this.createConnection();
            Session s = this.conn.createSession(false, 1);
            for (int i = 0; i < 200; ++i) {
                TemporaryQueue temporaryQueue = s.createTemporaryQueue();
                MessageProducer producer = s.createProducer((Destination)temporaryQueue);
                producer.send(s.createMessage());
            }
            for (ServerSession serverSession : this.server.getSessions()) {
                TemporaryDestinationTest.assertTrue((((ServerSessionImpl)serverSession).cloneTargetAddresses().size() <= 100 ? 1 : 0) != 0);
            }
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForSecurityCacheLeak() throws Exception {
        this.server.getSecurityStore().setSecurityEnabled(true);
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("IDo", "Exist");
        securityManager.getConfiguration().addRole("IDo", "myrole");
        Role myRole = new Role("myrole", true, true, true, true, true, true, true, true, true, true);
        HashSet<Role> anySet = new HashSet<Role>();
        anySet.add(myRole);
        this.server.getSecurityRepository().addMatch("#", anySet);
        try {
            this.conn = this.addConnection(this.cf.createConnection("IDo", "Exist"));
            Session s = this.conn.createSession(false, 1);
            for (int i = 0; i < 10; ++i) {
                TemporaryQueue temporaryQueue = s.createTemporaryQueue();
                temporaryQueue.delete();
            }
            TemporaryDestinationTest.assertEquals((long)0L, (long)this.server.getSecurityRepository().getCacheSize());
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }
}

