/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.Test;

public class TimeStampTest
extends BasicOpenWireTest {
    @Test
    public void testTimestamp() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue destination = session.createQueue("TEST.FOO");
        this.makeSureCoreQueueExist("TEST.FOO");
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setDeliveryMode(1);
        Message sentMessage = session.createMessage();
        long beforeSend = System.currentTimeMillis();
        producer.send(sentMessage);
        long afterSend = System.currentTimeMillis();
        TimeStampTest.assertTrue((beforeSend <= sentMessage.getJMSTimestamp() && sentMessage.getJMSTimestamp() <= afterSend ? 1 : 0) != 0);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Message receivedMessage = consumer.receive(1000L);
        TimeStampTest.assertEquals((Object)sentMessage.getJMSMessageID(), (Object)receivedMessage.getJMSMessageID());
        TimeStampTest.assertTrue((String)("JMS Message Timestamp should be set during the send method: \n        beforeSend = " + beforeSend + "\n   getJMSTimestamp = " + receivedMessage.getJMSTimestamp() + "\n         afterSend = " + afterSend + "\n"), (beforeSend <= receivedMessage.getJMSTimestamp() && receivedMessage.getJMSTimestamp() <= afterSend ? 1 : 0) != 0);
        TimeStampTest.assertEquals((String)"JMS Message Timestamp of received message should be the same as the sent message\n        ", (long)sentMessage.getJMSTimestamp(), (long)receivedMessage.getJMSTimestamp());
        producer.close();
        consumer.close();
        session.close();
        this.connection.close();
    }
}

