/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.interop;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.Before;
import org.junit.Test;

public class CompressedInteropTest
extends BasicOpenWireTest {
    private static final String TEXT;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.connection.start();
        CompressedInteropTest.assertTrue((boolean)this.connection.isUseCompression());
    }

    @Override
    protected void createFactories() {
        super.createFactories();
        this.factory.setUseCompression(true);
        this.xaFactory.setUseCompression(true);
    }

    @Test
    public void testCoreReceiveOpenWireCompressedMessages() throws Exception {
        this.testCompressedMessageSendReceive(true);
    }

    @Test
    public void testOpenWireReceiveOpenWireCompressedMessages() throws Exception {
        this.testCompressedMessageSendReceive(false);
    }

    private void testCompressedMessageSendReceive(boolean useCore) throws Exception {
        this.sendCompressedTextMessageUsingOpenWire();
        this.receiveTextMessage(useCore);
        this.sendCompressedBytesMessageUsingOpenWire();
        this.receiveBytesMessage(useCore);
        this.sendCompressedMapMessageUsingOpenWire();
        this.receiveMapMessage(useCore);
        this.sendCompressedStreamMessageUsingOpenWire();
        this.receiveStreamMessage(useCore);
        this.sendCompressedObjectMessageUsingOpenWire();
        this.receiveObjectMessage(useCore);
    }

    private void sendCompressedStreamMessageUsingOpenWire() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        StreamMessage streamMessage = session.createStreamMessage();
        streamMessage.writeBoolean(true);
        streamMessage.writeByte((byte)10);
        streamMessage.writeBytes(TEXT.getBytes());
        streamMessage.writeChar('A');
        streamMessage.writeDouble(55.3);
        streamMessage.writeFloat(79.1f);
        streamMessage.writeInt(37);
        streamMessage.writeLong(56652L);
        streamMessage.writeObject((Object)new String("VVVV"));
        streamMessage.writeShort((short)333);
        streamMessage.writeString(TEXT);
        producer.send((Message)streamMessage);
    }

    private void receiveStreamMessage(boolean useCore) throws Exception {
        StreamMessage streamMessage = (StreamMessage)this.receiveMessage(useCore);
        boolean booleanVal = streamMessage.readBoolean();
        CompressedInteropTest.assertTrue((boolean)booleanVal);
        byte byteVal = streamMessage.readByte();
        CompressedInteropTest.assertEquals((long)10L, (long)byteVal);
        byte[] originVal = TEXT.getBytes();
        byte[] bytesVal = new byte[originVal.length];
        streamMessage.readBytes(bytesVal);
        for (int i = 0; i < bytesVal.length; ++i) {
            CompressedInteropTest.assertTrue((bytesVal[i] == originVal[i] ? 1 : 0) != 0);
        }
        char charVal = streamMessage.readChar();
        CompressedInteropTest.assertEquals((long)65L, (long)charVal);
        double doubleVal = streamMessage.readDouble();
        CompressedInteropTest.assertEquals((double)55.3, (double)doubleVal, (double)0.1);
        float floatVal = streamMessage.readFloat();
        CompressedInteropTest.assertEquals((float)79.1f, (float)floatVal, (float)0.1f);
        int intVal = streamMessage.readInt();
        CompressedInteropTest.assertEquals((long)37L, (long)intVal);
        long longVal = streamMessage.readLong();
        CompressedInteropTest.assertEquals((long)56652L, (long)longVal);
        Object objectVal = streamMessage.readObject();
        String origVal = new String("VVVV");
        CompressedInteropTest.assertTrue((boolean)objectVal.equals(origVal));
        short shortVal = streamMessage.readShort();
        CompressedInteropTest.assertEquals((long)333L, (long)shortVal);
        String strVal = streamMessage.readString();
        CompressedInteropTest.assertEquals((Object)TEXT, (Object)strVal);
    }

    private void sendCompressedObjectMessageUsingOpenWire() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        ObjectMessage objectMessage = session.createObjectMessage();
        objectMessage.setObject((Serializable)((Object)TEXT));
        producer.send((Message)objectMessage);
    }

    private void receiveObjectMessage(boolean useCore) throws Exception {
        ObjectMessage objectMessage = (ObjectMessage)this.receiveMessage(useCore);
        Serializable objectVal = objectMessage.getObject();
        CompressedInteropTest.assertEquals((Object)TEXT, (Object)objectVal);
    }

    private void sendCompressedMapMessageUsingOpenWire() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        MapMessage mapMessage = session.createMapMessage();
        mapMessage.setBoolean("boolean-type", true);
        mapMessage.setByte("byte-type", (byte)10);
        mapMessage.setBytes("bytes-type", TEXT.getBytes());
        mapMessage.setChar("char-type", 'A');
        mapMessage.setDouble("double-type", 55.3);
        mapMessage.setFloat("float-type", 79.1f);
        mapMessage.setInt("int-type", 37);
        mapMessage.setLong("long-type", 56652L);
        mapMessage.setObject("object-type", (Object)new String("VVVV"));
        mapMessage.setShort("short-type", (short)333);
        mapMessage.setString("string-type", TEXT);
        producer.send((Message)mapMessage);
    }

    private void receiveMapMessage(boolean useCore) throws Exception {
        MapMessage mapMessage = (MapMessage)this.receiveMessage(useCore);
        boolean booleanVal = mapMessage.getBoolean("boolean-type");
        CompressedInteropTest.assertTrue((boolean)booleanVal);
        byte byteVal = mapMessage.getByte("byte-type");
        CompressedInteropTest.assertEquals((long)10L, (long)byteVal);
        byte[] bytesVal = mapMessage.getBytes("bytes-type");
        byte[] originVal = TEXT.getBytes();
        CompressedInteropTest.assertEquals((long)originVal.length, (long)bytesVal.length);
        for (int i = 0; i < bytesVal.length; ++i) {
            CompressedInteropTest.assertTrue((bytesVal[i] == originVal[i] ? 1 : 0) != 0);
        }
        char charVal = mapMessage.getChar("char-type");
        CompressedInteropTest.assertEquals((long)65L, (long)charVal);
        double doubleVal = mapMessage.getDouble("double-type");
        CompressedInteropTest.assertEquals((double)55.3, (double)doubleVal, (double)0.1);
        float floatVal = mapMessage.getFloat("float-type");
        CompressedInteropTest.assertEquals((float)79.1f, (float)floatVal, (float)0.1f);
        int intVal = mapMessage.getInt("int-type");
        CompressedInteropTest.assertEquals((long)37L, (long)intVal);
        long longVal = mapMessage.getLong("long-type");
        CompressedInteropTest.assertEquals((long)56652L, (long)longVal);
        Object objectVal = mapMessage.getObject("object-type");
        String origVal = new String("VVVV");
        CompressedInteropTest.assertTrue((boolean)objectVal.equals(origVal));
        short shortVal = mapMessage.getShort("short-type");
        CompressedInteropTest.assertEquals((long)333L, (long)shortVal);
        String strVal = mapMessage.getString("string-type");
        CompressedInteropTest.assertEquals((Object)TEXT, (Object)strVal);
    }

    private void sendCompressedBytesMessageUsingOpenWire() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        BytesMessage bytesMessage = session.createBytesMessage();
        bytesMessage.writeBytes(TEXT.getBytes());
        producer.send((Message)bytesMessage);
    }

    private void receiveBytesMessage(boolean useCore) throws Exception {
        BytesMessage bytesMessage = (BytesMessage)this.receiveMessage(useCore);
        byte[] bytes = new byte[TEXT.getBytes(StandardCharsets.UTF_8).length];
        bytesMessage.readBytes(bytes);
        CompressedInteropTest.assertTrue((bytesMessage.readBytes(new byte[255]) == -1 ? 1 : 0) != 0);
        String rcvString = new String(bytes, StandardCharsets.UTF_8);
        CompressedInteropTest.assertEquals((Object)TEXT, (Object)rcvString);
    }

    private void receiveTextMessage(boolean useCore) throws Exception {
        TextMessage txtMessage = (TextMessage)this.receiveMessage(useCore);
        CompressedInteropTest.assertEquals((Object)TEXT, (Object)txtMessage.getText());
    }

    private void sendCompressedTextMessageUsingOpenWire() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        TextMessage textMessage = session.createTextMessage(TEXT);
        producer.send((Message)textMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveMessage(boolean useCore) throws Exception {
        ConnectionFactory factoryToUse = useCore ? this.coreCf : this.factory;
        Message message = null;
        try (Connection jmsConn = null;){
            jmsConn = factoryToUse.createConnection();
            jmsConn.start();
            Session session = jmsConn.createSession(false, 1);
            Queue queue = session.createQueue(this.queueName);
            MessageConsumer coreConsumer = session.createConsumer((Destination)queue);
            message = coreConsumer.receive(5000L);
        }
        return message;
    }

    static {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 20; ++i) {
            builder.append("The quick red fox jumped over the lazy brown dog. ");
        }
        TEXT = builder.toString();
    }
}

