/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PagingSendTest
extends ActiveMQTestBase {
    public static final SimpleString ADDRESS = new SimpleString("SimpleAddress");
    private ServerLocator locator;
    private ActiveMQServer server;

    protected boolean isNetty() {
        return false;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ConfigurationImpl config = new ConfigurationImpl();
        this.server = this.newActiveMQServer();
        this.server.start();
        this.waitForServerToStart(this.server);
        this.locator = this.createFactory(this.isNetty());
    }

    private ActiveMQServer newActiveMQServer() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty());
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        return server;
    }

    @Test
    public void testSameMessageOverAndOverBlocking() throws Exception {
        this.dotestSameMessageOverAndOver(true);
    }

    @Test
    public void testSameMessageOverAndOverNonBlocking() throws Exception {
        this.dotestSameMessageOverAndOver(false);
    }

    public void dotestSameMessageOverAndOver(boolean blocking) throws Exception {
        this.locator.setBlockOnNonDurableSend(blocking).setBlockOnDurableSend(blocking).setBlockOnAcknowledge(blocking);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        message = session.createMessage(true);
        message.getBodyBuffer().writeBytes(new byte[1024]);
        for (int i = 0; i < 200; ++i) {
            producer.send((Message)message);
        }
        session.close();
        session = sf.createSession(null, null, false, true, true, false, 0);
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 200; ++i) {
            ClientMessage message2 = consumer.receive(10000L);
            Assert.assertNotNull((Object)message2);
            if (i == 100) {
                session.commit();
            }
            message2.acknowledge();
        }
        consumer.close();
        session.close();
    }

    @Test
    public void testOrderOverTX() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession sessionConsumer = sf.createSession(true, true, 0);
        sessionConsumer.createQueue(new QueueConfiguration(ADDRESS));
        final ClientSession sessionProducer = sf.createSession(false, false);
        final ClientProducer producer = sessionProducer.createProducer(ADDRESS);
        final AtomicInteger errors = new AtomicInteger(0);
        int TOTAL_MESSAGES = 1000;
        final CountDownLatch ready = new CountDownLatch(1);
        Thread tProducer = new Thread(){

            @Override
            public void run() {
                try {
                    int commit = 0;
                    for (int i = 0; i < 1000; ++i) {
                        ClientMessage msg = sessionProducer.createMessage(true);
                        msg.getBodyBuffer().writeBytes(new byte[1024]);
                        msg.putIntProperty("count", i);
                        producer.send((Message)msg);
                        if (i % 100 != 0 || i <= 0) continue;
                        sessionProducer.commit();
                        if (commit++ <= 2) continue;
                        ready.countDown();
                    }
                    sessionProducer.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
        };
        ClientConsumer consumer = sessionConsumer.createConsumer(ADDRESS);
        sessionConsumer.start();
        tProducer.start();
        PagingSendTest.assertTrue((boolean)ready.await(10L, TimeUnit.SECONDS));
        for (int i = 0; i < 1000; ++i) {
            ClientMessage msg = consumer.receive(10000L);
            Assert.assertNotNull((Object)msg);
            PagingSendTest.assertEquals((long)i, (long)msg.getIntProperty("count").intValue());
            msg.acknowledge();
        }
        tProducer.join();
        sessionConsumer.close();
        sessionProducer.close();
        PagingSendTest.assertEquals((long)0L, (long)errors.get());
    }

    @Test
    public void testPagingDoesNotDuplicateBatchMessages() throws Exception {
        int batchSize = 20;
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, false);
        SimpleString queueAddr = new SimpleString("testQueue");
        session.createQueue(new QueueConfiguration(queueAddr));
        AddressSettings addressSettings = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(16384L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.sendMessageBatch(batchSize, session, queueAddr);
        Queue queue = this.server.locateQueue(queueAddr);
        Assert.assertTrue((String)"Messages were not propagated to internal structures.", (boolean)this.waitForMessages(queue, batchSize, 3000L));
        this.checkBatchMessagesAreNotPagedTwice(queue);
        for (int i = 0; i < 10; ++i) {
            PagingSendTest.assertEquals((long)batchSize, (long)this.processCountThroughIterator(queue));
        }
    }

    @Test
    public void testPagingDoesNotDuplicateBatchMessagesAfterPagingStarted() throws Exception {
        int batchSize = 20;
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, false);
        SimpleString queueAddr = new SimpleString("testQueue");
        session.createQueue(new QueueConfiguration(queueAddr));
        AddressSettings addressSettings = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(16384L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        int numberOfMessages = 0;
        while (!this.server.getPagingManager().getPageStore(queueAddr).isPaging()) {
            this.sendMessageBatch(batchSize, session, queueAddr);
            numberOfMessages += batchSize;
        }
        this.sendMessageBatch(batchSize, session, queueAddr);
        numberOfMessages += batchSize;
        Queue queue = this.server.locateQueue(queueAddr);
        this.checkBatchMessagesAreNotPagedTwice(queue);
        for (int i = 0; i < 10; ++i) {
            PagingSendTest.assertEquals((long)numberOfMessages, (long)this.processCountThroughIterator(queue));
        }
    }

    public List<String> sendMessageBatch(int batchSize, ClientSession session, SimpleString queueAddr) throws ActiveMQException {
        ArrayList<String> messageIds = new ArrayList<String>();
        ClientProducer producer = session.createProducer(queueAddr);
        for (int i = 0; i < batchSize; ++i) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(new byte[1024]);
            String id = UUID.randomUUID().toString();
            message.putStringProperty("id", id);
            message.putIntProperty("seq", i);
            messageIds.add(id);
            producer.send((Message)message);
        }
        session.commit();
        return messageIds;
    }

    public void checkBatchMessagesAreNotPagedTwice(Queue queue) throws Exception {
        LinkedListIterator pageIterator = queue.browserIterator();
        HashSet<String> messageOrderSet = new HashSet<String>();
        int duplicates = 0;
        while (pageIterator.hasNext()) {
            MessageReference reference = (MessageReference)pageIterator.next();
            String id = reference.getMessage().getStringProperty("id");
            if (messageOrderSet.add(id)) continue;
            ++duplicates;
        }
        PagingSendTest.assertTrue((duplicates == 0 ? 1 : 0) != 0);
    }

    public boolean waitForMessages(Queue queue, int count, long timeout) throws Exception {
        long timeToWait = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < timeToWait) {
            if (queue.getMessageCount() >= (long)count) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    protected int processCountThroughIterator(Queue queue) throws Exception {
        LinkedListIterator pageIterator = queue.browserIterator();
        int count = 0;
        while (pageIterator.hasNext()) {
            MessageReference reference = (MessageReference)pageIterator.next();
            ++count;
        }
        return count;
    }
}

