/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.FakeSequentialFileFactory;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.SimpleEncoding;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JournalAsyncTest
extends ActiveMQTestBase {
    private FakeSequentialFileFactory factory;
    private JournalImpl journalImpl = null;
    private ArrayList<RecordInfo> records = null;
    private ArrayList<PreparedTransactionInfo> transactions = null;

    @Test
    public void testAsynchronousCommit() throws Exception {
        this.doAsynchronousTest(true);
    }

    @Test
    public void testAsynchronousRollback() throws Exception {
        this.doAsynchronousTest(false);
    }

    public void doAsynchronousTest(final boolean isCommit) throws Exception {
        int JOURNAL_SIZE = 20000;
        this.setupJournal(20000, 100, 5);
        this.factory.setHoldCallbacks(true, null);
        final CountDownLatch latch = new CountDownLatch(1);
        class LocalThread
        extends Thread {
            Exception e;

            LocalThread() {
            }

            @Override
            public void run() {
                try {
                    for (int i = 0; i < 10; ++i) {
                        JournalAsyncTest.this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)1, (EncodingSupport)new SimpleEncoding(1, 0));
                    }
                    JournalAsyncTest.this.journalImpl.debugWait();
                    latch.countDown();
                    JournalAsyncTest.this.factory.setHoldCallbacks(false, null);
                    if (isCommit) {
                        JournalAsyncTest.this.journalImpl.appendCommitRecord(1L, true);
                    } else {
                        JournalAsyncTest.this.journalImpl.appendRollbackRecord(1L, true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.e = e;
                }
            }
        }
        LocalThread t = new LocalThread();
        t.start();
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Thread.yield();
        Thread.sleep(100L);
        Assert.assertTrue((boolean)t.isAlive());
        this.factory.flushAllCallbacks();
        t.join();
        if (t.e != null) {
            throw t.e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncAppendRecord1() throws Exception {
        int JOURNAL_SIZE = 20000;
        this.setupJournal(20000, 100, 5);
        final CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch latchHoldDirect = new CountDownLatch(1);
        try {
            this.factory.setWriteDirectCallback(() -> {
                try {
                    latchHoldDirect.await(10L, TimeUnit.MINUTES);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            class LocalThread
            extends Thread {
                Exception e;

                LocalThread() {
                }

                @Override
                public void run() {
                    try {
                        JournalAsyncTest.this.journalImpl.appendAddRecord(1L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 0), true, null);
                        latch.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.e = e;
                    }
                }
            }
            LocalThread t = new LocalThread();
            t.start();
            Assert.assertFalse((String)"journal.append with sync true should hold until the write is done", (boolean)latch.await(100L, TimeUnit.MILLISECONDS));
            Thread.yield();
            Assert.assertTrue((boolean)t.isAlive());
            latchHoldDirect.countDown();
            Assert.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS));
            t.join();
            Assert.assertFalse((boolean)t.isAlive());
            if (t.e != null) {
                throw t.e;
            }
        }
        finally {
            latchHoldDirect.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncAppendRecord2() throws Exception {
        int JOURNAL_SIZE = 20000;
        this.setupJournal(20000, 100, 5);
        final CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch latchHoldDirect = new CountDownLatch(1);
        try {
            this.factory.setWriteDirectCallback(() -> {
                try {
                    latchHoldDirect.await(10L, TimeUnit.MINUTES);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            class LocalThread
            extends Thread {
                Exception e;

                LocalThread() {
                }

                @Override
                public void run() {
                    try {
                        JournalAsyncTest.this.journalImpl.appendAddRecord(1L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 0), true, new IOCompletion(){

                            public void storeLineUp() {
                            }

                            public void done() {
                            }

                            public void onError(int errorCode, String errorMessage) {
                            }
                        });
                        latch.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.e = e;
                    }
                }
            }
            LocalThread t = new LocalThread();
            t.start();
            Assert.assertTrue((String)"journal.append with sync true and IOContext should not hold thread", (boolean)latch.await(10L, TimeUnit.SECONDS));
            latchHoldDirect.countDown();
            Assert.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS));
            t.join();
            Assert.assertFalse((boolean)t.isAlive());
            if (t.e != null) {
                throw t.e;
            }
        }
        finally {
            latchHoldDirect.countDown();
        }
    }

    @Test
    public void testPreviousError() throws Exception {
        int JOURNAL_SIZE = 20000;
        this.setupJournal(20000, 100, 5);
        this.factory.setHoldCallbacks(true, null);
        this.factory.setGenerateErrors(true);
        this.journalImpl.appendAddRecordTransactional(1L, 1L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 0));
        this.journalImpl.debugWait();
        this.factory.flushAllCallbacks();
        this.factory.setGenerateErrors(false);
        this.factory.setHoldCallbacks(false, null);
        try {
            this.journalImpl.appendAddRecordTransactional(1L, 2L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 0));
            this.journalImpl.appendCommitRecord(1L, true);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSyncNonTransaction() throws Exception {
        int JOURNAL_SIZE = 20000;
        this.setupJournal(20000, 100, 5);
        this.factory.setGenerateErrors(true);
        try {
            this.journalImpl.appendAddRecord(1L, (byte)0, (EncodingSupport)new SimpleEncoding(1, 0), true);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.records = new ArrayList();
        this.transactions = new ArrayList();
        this.factory = null;
        this.journalImpl = null;
    }

    @After
    public void tearDown() throws Exception {
        if (this.journalImpl != null) {
            try {
                this.journalImpl.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.tearDown();
    }

    private void setupJournal(int journalSize, int alignment, int numberOfMinimalFiles) throws Exception {
        if (this.factory == null) {
            this.factory = new FakeSequentialFileFactory(alignment, true);
        }
        if (this.journalImpl != null) {
            this.journalImpl.stop();
        }
        this.journalImpl = new JournalImpl(journalSize, numberOfMinimalFiles, numberOfMinimalFiles, 0, 0, (SequentialFileFactory)this.factory, "tt", "tt", 1000);
        this.journalImpl.start();
        this.records.clear();
        this.transactions.clear();
        this.journalImpl.load(this.records, this.transactions, null);
    }
}

